/*
 * Decompiled with CFR 0.152.
 */
package org.frankframework.frankdoc.wrapper;

import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.Tag;
import java.util.Map;
import org.frankframework.frankdoc.wrapper.FrankAnnotation;
import org.frankframework.frankdoc.wrapper.FrankDocletUtils;
import org.frankframework.frankdoc.wrapper.FrankEnumConstant;

class FrankEnumConstantDoclet
implements FrankEnumConstant {
    private FieldDoc fieldDoc;
    private String name;
    private boolean isPublic;
    private String javaDoc;
    private Map<String, FrankAnnotation> annotationsByName;

    FrankEnumConstantDoclet(FieldDoc fieldDoc) {
        this.fieldDoc = fieldDoc;
        this.name = fieldDoc.name();
        this.isPublic = fieldDoc.isPublic();
        this.javaDoc = fieldDoc.commentText();
        AnnotationDesc[] javaDocAnnotations = fieldDoc.annotations();
        this.annotationsByName = FrankDocletUtils.getFrankAnnotationsByName(javaDocAnnotations);
    }

    @Override
    public boolean isPublic() {
        return this.isPublic;
    }

    @Override
    public FrankAnnotation getAnnotation(String name) {
        return this.annotationsByName.get(name);
    }

    @Override
    public String getJavaDocTag(String tagName) {
        Tag[] tags = this.fieldDoc.tags(tagName);
        if (tags == null || tags.length == 0) {
            return null;
        }
        return tags[0].text();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getJavaDoc() {
        return this.javaDoc;
    }
}

