/*
 * Decompiled with CFR 0.152.
 */
package org.frankframework.frankdoc.wrapper;

import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.Tag;
import com.sun.javadoc.Type;
import java.util.ArrayList;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Logger;
import org.frankframework.frankdoc.util.LogUtil;
import org.frankframework.frankdoc.wrapper.FrankAnnotation;
import org.frankframework.frankdoc.wrapper.FrankClass;
import org.frankframework.frankdoc.wrapper.FrankClassDoclet;
import org.frankframework.frankdoc.wrapper.FrankDocException;
import org.frankframework.frankdoc.wrapper.FrankDocletUtils;
import org.frankframework.frankdoc.wrapper.FrankMethod;
import org.frankframework.frankdoc.wrapper.FrankMethodDocletBase;
import org.frankframework.frankdoc.wrapper.FrankNonCompiledClassDoclet;
import org.frankframework.frankdoc.wrapper.FrankPrimitiveType;
import org.frankframework.frankdoc.wrapper.FrankType;

class FrankMethodDoclet
extends FrankMethodDocletBase {
    private static Logger log = LogUtil.getLogger(FrankMethodDoclet.class);
    final MethodDoc method;
    private final Map<String, FrankAnnotation> frankAnnotationsByName;

    FrankMethodDoclet(MethodDoc method, FrankClassDoclet declaringClass) {
        super(declaringClass);
        this.method = method;
        AnnotationDesc[] annotationDescs = method.annotations();
        this.frankAnnotationsByName = FrankDocletUtils.getFrankAnnotationsByName(annotationDescs);
    }

    @Override
    public boolean isMultiplyInheritedPlaceholder() {
        return false;
    }

    @Override
    public String getName() {
        return this.method.name();
    }

    @Override
    public boolean isPublic() {
        return this.method.isPublic();
    }

    @Override
    public FrankAnnotation[] getAnnotations() {
        return this.frankAnnotationsByName.values().toArray(new FrankAnnotation[0]);
    }

    @Override
    public FrankAnnotation getAnnotation(String name) {
        return this.frankAnnotationsByName.get(name);
    }

    @Override
    public String getJavaDoc() {
        String result = this.method.commentText();
        if (StringUtils.isBlank(result)) {
            return null;
        }
        return result;
    }

    @Override
    public FrankType getReturnType() {
        Type docletType = this.method.returnType();
        return this.typeOf(docletType);
    }

    private FrankType typeOf(Type docletType) {
        if (docletType.isPrimitive()) {
            return new FrankPrimitiveType(docletType.simpleTypeName());
        }
        String typeName = docletType.qualifiedTypeName();
        try {
            FrankClass clazz = ((FrankClassDoclet)this.getDeclaringClass()).getRepository().findClass(typeName);
            if (clazz == null) {
                return new FrankNonCompiledClassDoclet(typeName);
            }
            return clazz;
        }
        catch (FrankDocException e) {
            log.error("Failed to search for class with name {}", (Object)typeName, (Object)e);
            return new FrankNonCompiledClassDoclet(typeName);
        }
    }

    @Override
    public int getParameterCount() {
        return this.method.parameters().length;
    }

    @Override
    public boolean isVarargs() {
        return this.method.isVarArgs();
    }

    @Override
    public FrankType[] getParameterTypes() {
        Parameter[] parametersDoclet = this.method.parameters();
        FrankType[] result = new FrankType[parametersDoclet.length];
        for (int i = 0; i < parametersDoclet.length; ++i) {
            result[i] = this.typeOf(parametersDoclet[i].type());
        }
        return result;
    }

    @Override
    public String getSignature() {
        ArrayList<String> components = new ArrayList<String>();
        components.add(this.getName());
        for (FrankType type : this.getParameterTypes()) {
            components.add(type.getName());
        }
        return components.stream().collect(Collectors.joining(", "));
    }

    void removeOverriddenFrom(Map<MethodDoc, FrankMethod> methodRepository) {
        MethodDoc toRemove = this.method.overriddenMethod();
        methodRepository.remove(toRemove);
    }

    void addToRepository(Map<MethodDoc, FrankMethod> methodRepository) {
        methodRepository.put(this.method, this);
    }

    @Override
    public String getJavaDocTag(String tagName) {
        Tag[] tags = this.method.tags(tagName);
        if (tags == null || tags.length == 0) {
            return null;
        }
        return tags[0].text();
    }

    public String toString() {
        return this.toStringImpl();
    }

    @Override
    MethodDoc getOverriddenMethodDoc() {
        return this.method.overriddenMethod();
    }
}

