/*
 * Decompiled with CFR 0.152.
 */
package org.frankframework.frankdoc.wrapper;

import com.sun.javadoc.MethodDoc;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import org.apache.logging.log4j.Logger;
import org.frankframework.frankdoc.util.LogUtil;
import org.frankframework.frankdoc.wrapper.FrankAnnotation;
import org.frankframework.frankdoc.wrapper.FrankClass;
import org.frankframework.frankdoc.wrapper.FrankClassDoclet;
import org.frankframework.frankdoc.wrapper.FrankDocException;
import org.frankframework.frankdoc.wrapper.FrankMethod;
import org.frankframework.frankdoc.wrapper.TransitiveImplementedInterfaceBrowser;

abstract class FrankMethodDocletBase
implements FrankMethod {
    private static Logger log = LogUtil.getLogger(FrankMethodDocletBase.class);
    private final FrankClassDoclet declaringClass;
    private final Set<MethodDoc> warnedMethodsNotInJavaDoc = new HashSet<MethodDoc>();

    FrankMethodDocletBase(FrankClassDoclet declaringClass) {
        this.declaringClass = declaringClass;
    }

    @Override
    public FrankClass getDeclaringClass() {
        return this.declaringClass;
    }

    @Override
    public FrankAnnotation getAnnotationIncludingInherited(String name) throws FrankDocException {
        Function<FrankMethodDocletBase, FrankAnnotation> getter = m -> m.getAnnotation(name);
        return this.searchIncludingInherited(getter);
    }

    @Override
    public String getJavaDocIncludingInherited() throws FrankDocException {
        Function<FrankMethodDocletBase, String> getter = m -> m.getJavaDoc();
        return this.searchIncludingInherited(getter);
    }

    @Override
    public String getJavaDocTagIncludingInherited(String tagName) throws FrankDocException {
        Function<FrankMethodDocletBase, String> getter = m -> m.getJavaDocTag(tagName);
        return this.searchIncludingInherited(getter);
    }

    private <T> T searchIncludingInherited(Function<FrankMethodDocletBase, T> getter) throws FrankDocException {
        T result = this.searchExcludingImplementedInterfaces(getter);
        if (result == null) {
            result = this.searchImplementedInterfaces(this.getDeclaringClass(), this.getSignature(), getter);
        }
        return result;
    }

    private <T> T searchExcludingImplementedInterfaces(Function<FrankMethodDocletBase, T> getter) throws FrankDocException {
        T result = getter.apply(this);
        if (result != null) {
            return result;
        }
        MethodDoc overriddenMethodDoc = this.getOverriddenMethodDoc();
        if (overriddenMethodDoc != null) {
            FrankMethodDocletBase overriddenMethod = (FrankMethodDocletBase)this.declaringClass.recursivelyFindFrankMethod(overriddenMethodDoc);
            if (overriddenMethod != null) {
                return overriddenMethod.searchExcludingImplementedInterfaces(getter);
            }
            if (!this.warnedMethodsNotInJavaDoc.contains(overriddenMethodDoc)) {
                this.warnedMethodsNotInJavaDoc.add(overriddenMethodDoc);
                log.warn("Class {} inherits method {}, but no annotations or JavaDocs are known because the overridden method is not public.", () -> this.declaringClass.getName(), () -> overriddenMethodDoc.qualifiedName());
            }
        }
        return null;
    }

    abstract MethodDoc getOverriddenMethodDoc();

    private <T> T searchImplementedInterfaces(FrankClass clazz, String methodSignature, Function<FrankMethodDocletBase, T> getter) throws FrankDocException {
        TransitiveImplementedInterfaceBrowser<Object> interfaceBrowser = new TransitiveImplementedInterfaceBrowser<Object>((FrankClassDoclet)clazz);
        Function<FrankClass, Object> classGetter = interfaze -> ((FrankClassDoclet)interfaze).getMethodItemFromSignature(methodSignature, getter);
        Object result = interfaceBrowser.search(classGetter);
        if (result != null) {
            return (T)result;
        }
        if (clazz.getSuperclass() == null) {
            return null;
        }
        return this.searchImplementedInterfaces(clazz.getSuperclass(), methodSignature, getter);
    }
}

