/*
 * Decompiled with CFR 0.152.
 */
package org.frankframework.frankdoc.wrapper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.frankframework.frankdoc.wrapper.FrankClass;
import org.frankframework.frankdoc.wrapper.FrankDocException;

class TransitiveImplementedInterfaceBrowser<T> {
    final List<FrankClass> interfaces = new ArrayList<FrankClass>();
    final Set<String> interfaceNamesDone = new HashSet<String>();

    TransitiveImplementedInterfaceBrowser(FrankClass clazz) throws FrankDocException {
        this.uniquelyEnqueueSuperInterfaces(clazz);
    }

    private void uniquelyEnqueueSuperInterfaces(FrankClass clazz) {
        this.uniquelyEnqueueInterfacesOf(clazz);
        if (!this.interfaces.isEmpty()) {
            for (int index = 0; index < this.interfaces.size(); ++index) {
                this.uniquelyEnqueueInterfacesOf(this.interfaces.get(index));
            }
        }
    }

    private void uniquelyEnqueueInterfacesOf(FrankClass clazz) {
        Arrays.asList(clazz.getInterfaces()).forEach(this::enqueueUniquely);
    }

    private void enqueueUniquely(FrankClass clazz) {
        if (!this.interfaceNamesDone.contains(clazz.getName())) {
            this.interfaceNamesDone.add(clazz.getName());
            this.interfaces.add(clazz);
        }
    }

    List<FrankClass> getInterfacesAndTheirAncestors() {
        return this.interfaces;
    }

    T search(Function<FrankClass, T> testFunction) throws FrankDocException {
        for (FrankClass intf : this.interfaces) {
            T result = testFunction.apply(intf);
            if (result == null) continue;
            return result;
        }
        return null;
    }
}

