/*
 * Decompiled with CFR 0.152.
 */
package org.ibissource.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.plugins.war.WarMojo;
import org.apache.maven.project.MavenProject;

@Mojo(name="war", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class IbisWarPluginMojo
extends WarMojo {
    @Parameter(defaultValue="${project.build.sourceDirectory}", required=true)
    private String sourceDirectory;
    @Parameter(property="war.enableSecurityConstraints", defaultValue="true")
    private boolean enableSecurityConstraints;
    @Parameter(property="war.packageJavaClasses", defaultValue="true")
    private boolean packageJavaClasses;

    public void buildExplodedWebapp(File webapplicationDirectory) throws MojoExecutionException, MojoFailureException {
        this.setFailOnMissingWebXml(false);
        if (this.packageJavaClasses) {
            this.addJavaClassesToWar();
        }
        if (this.getPackagingExcludes().length == 0) {
            this.setPackagingExcludes(".gitignore");
        }
        super.buildExplodedWebapp(webapplicationDirectory);
        if (this.enableSecurityConstraints) {
            this.getLog().info((CharSequence)"Enabling security constraints");
            File webXmlFile = new File(webapplicationDirectory, "WEB-INF/web.xml");
            if (webXmlFile.exists()) {
                this.enableSecurityConstraints(webXmlFile);
            } else {
                if (this.isFailOnMissingWebXml()) {
                    throw new MojoExecutionException("webXml does not exist!?");
                }
                this.getLog().warn((CharSequence)"no web.xml found, skipping...");
            }
        } else {
            this.getLog().warn((CharSequence)"Skipping security constraints in web.xml");
        }
    }

    public void addJavaClassesToWar() {
        Resource[] webResources = this.getWebResources();
        LinkedList<Resource> resources = new LinkedList<Resource>();
        if (webResources != null) {
            resources.addAll(Arrays.asList(webResources));
            for (Resource resource : resources) {
                this.getLog().info((CharSequence)("Copying custom webResource [" + resource.getDirectory() + "] to [" + resource.getTargetPath() + "]"));
            }
        }
        Resource resource = new Resource();
        resource.setDirectory(this.sourceDirectory);
        resource.setTargetPath("WEB-INF/classes");
        resources.add(resource);
        this.getLog().info((CharSequence)("Copying java webResources [" + this.sourceDirectory + "] to [WEB-INF\\classes]"));
        webResources = resources.toArray(new Resource[resources.size()]);
        this.setWebResources(webResources);
    }

    public MavenArchiveConfiguration getArchive() {
        MavenProject project = this.getProject();
        MavenArchiveConfiguration archive = super.getArchive();
        if (archive == null) {
            archive = new MavenArchiveConfiguration();
        }
        SimpleDateFormat dt = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        archive.addManifestEntry("Project", project.getName());
        if (project.getDescription() != null) {
            archive.addManifestEntry("Description", project.getDescription());
        }
        archive.addManifestEntry("Created-Time", dt.format(new Date()));
        archive.addManifestEntry("Build-Version", project.getVersion());
        archive.addManifestEntry("Build-Artifact", project.getArtifactId());
        archive.setAddMavenDescriptor(false);
        return archive;
    }

    private void enableSecurityConstraints(File webXml) throws MojoExecutionException {
        try {
            String xml = this.getFileContent(webXml);
            xml = xml.replace("<!-- security-constraint>", "<security-constraint>");
            xml = xml.replace("</security-role -->", "</security-role>");
            FileOutputStream fop = new FileOutputStream(webXml);
            byte[] contentInBytes = xml.getBytes();
            fop.write(contentInBytes);
            fop.flush();
            fop.close();
        }
        catch (IOException e) {
            throw new MojoExecutionException("failed enabling web.xml security constraints", (Exception)e);
        }
    }

    public String getFileContent(File file) throws IOException {
        return this.getFileContent(new FileInputStream(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFileContent(InputStream fis) throws IOException {
        try (Reader r = null;){
            StringBuilder sb = new StringBuilder();
            r = new InputStreamReader(fis, "UTF-8");
            char[] buf = new char[1024];
            int amt = r.read(buf);
            while (amt > 0) {
                sb.append(buf, 0, amt);
                amt = r.read(buf);
            }
            String string = sb.toString();
            return string;
        }
    }
}

