/*
 * Decompiled with CFR 0.152.
 */
package org.ic4j.candid.gson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.math.BigInteger;
import java.util.Base64;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import org.ic4j.candid.CandidError;
import org.ic4j.candid.ObjectDeserializer;
import org.ic4j.candid.parser.IDLType;
import org.ic4j.candid.parser.IDLValue;
import org.ic4j.candid.types.Label;
import org.ic4j.candid.types.Type;
import org.ic4j.types.Principal;

public class GsonDeserializer
implements ObjectDeserializer {
    Optional<IDLType> idlType = Optional.empty();
    Gson gson = new GsonBuilder().create();

    public static GsonDeserializer create(IDLType idlType) {
        GsonDeserializer deserializer = new GsonDeserializer();
        deserializer.idlType = Optional.ofNullable(idlType);
        return deserializer;
    }

    public static GsonDeserializer create() {
        GsonDeserializer deserializer = new GsonDeserializer();
        return deserializer;
    }

    public <T> T deserialize(IDLValue value, Class<T> clazz) {
        if (clazz != null) {
            JsonElement jsonElement = this.getValue(value.getIDLType(), this.idlType, value.getValue());
            if (JsonElement.class.isAssignableFrom(clazz)) {
                return (T)jsonElement;
            }
            return (T)this.gson.fromJson(jsonElement, clazz);
        }
        throw CandidError.create((CandidError.CandidErrorCode)CandidError.CandidErrorCode.CUSTOM, (Object[])new Object[]{"Class is not defined"});
    }

    JsonElement getPrimitiveValue(Type type, Object value) {
        JsonNull result = JsonNull.INSTANCE;
        if (value == null) {
            return result;
        }
        switch (type) {
            case BOOL: {
                result = new JsonPrimitive((Boolean)value);
                break;
            }
            case INT: {
                result = new JsonPrimitive((Number)((BigInteger)value));
                break;
            }
            case INT8: {
                result = new JsonPrimitive((Number)((Byte)value));
                break;
            }
            case INT16: {
                result = new JsonPrimitive((Number)((Short)value));
                break;
            }
            case INT32: {
                result = new JsonPrimitive((Number)((Integer)value));
                break;
            }
            case INT64: {
                result = new JsonPrimitive((Number)((Long)value));
            }
            case NAT: {
                result = new JsonPrimitive((Number)((BigInteger)value));
                break;
            }
            case NAT8: {
                result = new JsonPrimitive((Number)((Byte)value));
                break;
            }
            case NAT16: {
                result = new JsonPrimitive((Number)((Short)value));
                break;
            }
            case NAT32: {
                result = new JsonPrimitive((Number)((Integer)value));
                break;
            }
            case NAT64: {
                result = new JsonPrimitive((Number)((Long)value));
                break;
            }
            case FLOAT32: {
                result = new JsonPrimitive((Number)((Float)value));
                break;
            }
            case FLOAT64: {
                result = new JsonPrimitive((Number)((Double)value));
                break;
            }
            case TEXT: {
                result = new JsonPrimitive((String)value);
                break;
            }
            case EMPTY: {
                result = new JsonObject();
                break;
            }
            case PRINCIPAL: {
                Principal principal = (Principal)value;
                result = new JsonPrimitive(principal.toString());
            }
        }
        return result;
    }

    JsonElement getValue(IDLType idlType, Optional<IDLType> expectedIdlType, Object value) {
        JsonNull result = JsonNull.INSTANCE;
        if (value == null) {
            return result;
        }
        Type type = Type.NULL;
        if (expectedIdlType.isPresent()) {
            type = expectedIdlType.get().getType();
            if (idlType != null) {
                idlType = expectedIdlType.get();
            }
        }
        if (type.isPrimitive()) {
            return this.getPrimitiveValue(type, value);
        }
        if (type == Type.VEC) {
            Object[] arrayValue;
            IDLType expectedInnerIDLType = null;
            IDLType innerIdlType = idlType.getInnerType();
            if (expectedIdlType.isPresent()) {
                innerIdlType = expectedInnerIDLType = expectedIdlType.get().getInnerType();
            }
            if (innerIdlType.getType() == Type.INT8 || innerIdlType.getType() == Type.NAT8) {
                return new JsonPrimitive(Base64.getEncoder().encodeToString((byte[])value));
            }
            JsonArray arrayNode = new JsonArray();
            for (Object item : arrayValue = (Object[])value) {
                arrayNode.add(this.getValue(idlType.getInnerType(), Optional.ofNullable(expectedInnerIDLType), item));
            }
            return arrayNode;
        }
        if (type == Type.OPT) {
            Optional optionalValue = (Optional)value;
            if (optionalValue.isPresent()) {
                IDLType expectedInnerIDLType = null;
                if (expectedIdlType.isPresent()) {
                    expectedInnerIDLType = expectedIdlType.get().getInnerType();
                }
                return this.getValue(idlType.getInnerType(), Optional.ofNullable(expectedInnerIDLType), optionalValue.get());
            }
            return result;
        }
        if (type == Type.RECORD || type == Type.VARIANT) {
            JsonObject treeNode = new JsonObject();
            Map valueMap = (Map)value;
            Map typeMap = idlType.getTypeMap();
            Map expectedTypeMap = new TreeMap();
            if (expectedIdlType.isPresent() && expectedIdlType.get().getTypeMap() != null) {
                expectedTypeMap = expectedIdlType.get().getTypeMap();
            }
            Set hashes = valueMap.keySet();
            TreeMap<Integer, Label> expectedLabels = new TreeMap<Integer, Label>();
            for (Label entry : expectedTypeMap.keySet()) {
                expectedLabels.put(entry.getId(), entry);
            }
            for (Integer hash : hashes) {
                String fieldName;
                Label hashLabel = Label.createIdLabel((Integer)hash);
                IDLType itemIdlType = (IDLType)typeMap.get(hashLabel);
                IDLType expectedItemIdlType = null;
                if (expectedTypeMap.containsKey(Label.createIdLabel((Integer)hash))) {
                    expectedItemIdlType = (IDLType)expectedTypeMap.get(hashLabel);
                    Label expectedLabel = (Label)expectedLabels.get(hash);
                    fieldName = expectedLabel.getValue().toString();
                } else {
                    fieldName = hashLabel.toString();
                }
                JsonElement itemNode = this.getValue(itemIdlType, Optional.ofNullable(expectedItemIdlType), valueMap.get(hash));
                treeNode.add(fieldName, itemNode);
            }
            return treeNode;
        }
        throw CandidError.create((CandidError.CandidErrorCode)CandidError.CandidErrorCode.CUSTOM, (Object[])new Object[]{"Cannot convert type " + type.name()});
    }
}

