/*
 * Decompiled with CFR 0.152.
 */
package org.ic4j.candid.gson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.ic4j.candid.CandidError;
import org.ic4j.candid.ObjectSerializer;
import org.ic4j.candid.parser.IDLType;
import org.ic4j.candid.parser.IDLValue;
import org.ic4j.candid.types.Label;
import org.ic4j.candid.types.Type;
import org.ic4j.types.Principal;

public class GsonSerializer
implements ObjectSerializer {
    Optional<IDLType> idlType = Optional.empty();
    Gson gson = new GsonBuilder().create();

    public static GsonSerializer create(IDLType idlType) {
        GsonSerializer deserializer = new GsonSerializer();
        deserializer.idlType = Optional.ofNullable(idlType);
        return deserializer;
    }

    public static GsonSerializer create() {
        GsonSerializer deserializer = new GsonSerializer();
        return deserializer;
    }

    public void setIDLType(IDLType idlType) {
        this.idlType = Optional.ofNullable(idlType);
    }

    public IDLValue serialize(Object value) {
        if (value == null) {
            return IDLValue.create((Object)value);
        }
        if (JsonElement.class.isAssignableFrom(value.getClass())) {
            return this.getIDLValue(this.idlType, (JsonElement)value);
        }
        try {
            JsonElement jsonElement = this.gson.toJsonTree(value);
            return this.getIDLValue(this.idlType, jsonElement);
        }
        catch (Exception e) {
            throw CandidError.create((CandidError.CandidErrorCode)CandidError.CandidErrorCode.CUSTOM, (Throwable)e, (Object[])new Object[]{e.getLocalizedMessage()});
        }
    }

    IDLValue getPrimitiveIDLValue(Type type, JsonPrimitive value) {
        IDLValue result = IDLValue.create(null);
        if (value == null) {
            return result;
        }
        switch (type) {
            case BOOL: {
                result = IDLValue.create((Object)value.getAsBoolean(), (Type)type);
                break;
            }
            case INT: {
                result = IDLValue.create((Object)value.getAsBigInteger(), (Type)type);
                break;
            }
            case INT8: {
                result = IDLValue.create((Object)value.getAsByte(), (Type)type);
                break;
            }
            case INT16: {
                result = IDLValue.create((Object)value.getAsShort(), (Type)type);
                break;
            }
            case INT32: {
                result = IDLValue.create((Object)value.getAsInt(), (Type)type);
                break;
            }
            case INT64: {
                result = IDLValue.create((Object)value.getAsLong(), (Type)type);
                break;
            }
            case NAT: {
                result = IDLValue.create((Object)value.getAsBigInteger(), (Type)type);
                break;
            }
            case NAT8: {
                result = IDLValue.create((Object)value.getAsByte(), (Type)type);
                break;
            }
            case NAT16: {
                result = IDLValue.create((Object)value.getAsShort(), (Type)type);
                break;
            }
            case NAT32: {
                result = IDLValue.create((Object)value.getAsInt(), (Type)type);
                break;
            }
            case NAT64: {
                result = IDLValue.create((Object)value.getAsLong(), (Type)type);
                break;
            }
            case FLOAT32: {
                result = IDLValue.create((Object)Float.valueOf(value.getAsFloat()), (Type)type);
                break;
            }
            case FLOAT64: {
                result = IDLValue.create((Object)value.getAsDouble(), (Type)type);
                break;
            }
            case TEXT: {
                result = IDLValue.create((Object)value.getAsString(), (Type)type);
                break;
            }
            case PRINCIPAL: {
                result = IDLValue.create((Object)Principal.fromString((String)value.getAsString()));
                break;
            }
            case EMPTY: {
                result = IDLValue.create(null, (Type)type);
            }
            case NULL: {
                result = IDLValue.create(null, (Type)type);
            }
        }
        return result;
    }

    Type getType(JsonElement value) {
        if (value == null || value.isJsonNull()) {
            return Type.NULL;
        }
        if (value.isJsonPrimitive()) {
            JsonPrimitive primitiveValue = (JsonPrimitive)value;
            if (primitiveValue.isBoolean()) {
                return Type.BOOL;
            }
            if (primitiveValue.isString()) {
                return Type.TEXT;
            }
            if (primitiveValue.isNumber()) {
                return IDLType.createType((Object)primitiveValue.getAsNumber()).getType();
            }
            return Type.NULL;
        }
        if (value.isJsonArray()) {
            return Type.VEC;
        }
        if (value.isJsonObject()) {
            return Type.RECORD;
        }
        return Type.NULL;
    }

    IDLValue getIDLValue(Optional<IDLType> expectedIdlType, JsonElement value) {
        if (value == null) {
            return IDLValue.create((Object)value, (Type)Type.NULL);
        }
        Type type = expectedIdlType.isPresent() ? expectedIdlType.get().getType() : this.getType(value);
        if (type == Type.NULL || type == Type.EMPTY) {
            return IDLValue.create(null, (Type)type);
        }
        if (value.isJsonPrimitive()) {
            return this.getPrimitiveIDLValue(type, (JsonPrimitive)value);
        }
        if (type == Type.VEC) {
            IDLType innerIdlType = IDLType.createType((Type)Type.NULL);
            if (expectedIdlType.isPresent()) {
                innerIdlType = expectedIdlType.get().getInnerType();
            }
            if (innerIdlType != null && (innerIdlType.getType() == Type.INT8 || innerIdlType.getType() == Type.NAT8)) {
                return IDLValue.create((Object)value, (IDLType)IDLType.createType((Type)type, (IDLType)innerIdlType));
            }
            if (value.isJsonArray()) {
                JsonArray arrayNode = (JsonArray)value;
                Object[] arrayValue = new Object[arrayNode.size()];
                for (int i = 0; i < arrayNode.size(); ++i) {
                    IDLValue item = this.getIDLValue(Optional.ofNullable(innerIdlType), arrayNode.get(i));
                    arrayValue[i] = item.getValue();
                    if (expectedIdlType.isPresent()) continue;
                    innerIdlType = item.getIDLType();
                }
                IDLType idlType = expectedIdlType.isPresent() ? expectedIdlType.get() : IDLType.createType((Type)Type.VEC, (IDLType)innerIdlType);
                return IDLValue.create((Object)arrayValue, (IDLType)idlType);
            }
            throw CandidError.create((CandidError.CandidErrorCode)CandidError.CandidErrorCode.CUSTOM, (Object[])new Object[]{"Cannot convert class " + value.getClass().getName() + " to VEC"});
        }
        if (type == Type.RECORD || type == Type.VARIANT) {
            TreeMap<Label, Object> valueMap = new TreeMap<Label, Object>();
            TreeMap<Label, IDLType> typeMap = new TreeMap<Label, IDLType>();
            Map expectedTypeMap = new TreeMap();
            if (expectedIdlType.isPresent()) {
                expectedTypeMap = expectedIdlType.get().getTypeMap();
            }
            if (value.isJsonArray()) {
                JsonArray arrayNode = (JsonArray)value;
                for (int i = 0; i < arrayNode.size(); ++i) {
                    JsonElement item = arrayNode.get(i);
                    IDLType expectedItemIdlType = expectedTypeMap != null && expectedIdlType.isPresent() ? (IDLType)expectedTypeMap.get(Label.createUnnamedLabel((Long)Long.valueOf(i))) : IDLType.createType((Type)this.getType(item));
                    if (expectedItemIdlType == null) continue;
                    IDLValue itemIdlValue = this.getIDLValue(Optional.ofNullable(expectedItemIdlType), item);
                    typeMap.put(Label.createUnnamedLabel((Long)Long.valueOf(i)), itemIdlValue.getIDLType());
                    valueMap.put(Label.createUnnamedLabel((Long)Long.valueOf(i)), itemIdlValue.getValue());
                }
            } else {
                JsonObject objectNode = (JsonObject)value;
                for (String name : objectNode.keySet()) {
                    JsonElement item = objectNode.get(name);
                    IDLType expectedItemIdlType = expectedTypeMap != null && expectedIdlType.isPresent() ? (IDLType)expectedTypeMap.get(Label.createNamedLabel((String)name)) : IDLType.createType((Type)this.getType(item));
                    if (expectedItemIdlType == null) continue;
                    IDLValue itemIdlValue = this.getIDLValue(Optional.ofNullable(expectedItemIdlType), item);
                    typeMap.put(Label.createNamedLabel((String)name), itemIdlValue.getIDLType());
                    valueMap.put(Label.createNamedLabel((String)name), itemIdlValue.getValue());
                }
            }
            IDLType idlType = IDLType.createType((Type)type, typeMap);
            IDLValue idlValue = IDLValue.create(valueMap, (IDLType)idlType);
            return idlValue;
        }
        if (type == Type.OPT) {
            if (expectedIdlType.isPresent()) {
                if (value.isJsonArray() && value.getAsJsonArray().isEmpty()) {
                    return IDLValue.create(Optional.empty(), (IDLType)expectedIdlType.get());
                }
                IDLValue itemIdlValue = this.getIDLValue(Optional.ofNullable(expectedIdlType.get().getInnerType()), value);
                return IDLValue.create(Optional.ofNullable(itemIdlValue.getValue()), (IDLType)expectedIdlType.get());
            }
            if (value.isJsonNull()) {
                return IDLValue.create(Optional.empty(), (IDLType)IDLType.createType((Type)Type.OPT));
            }
            if (value.isJsonArray() && value.getAsJsonArray().isEmpty()) {
                return IDLValue.create(Optional.empty(), (IDLType)IDLType.createType((Type)Type.OPT));
            }
            IDLValue itemIdlValue = this.getIDLValue(Optional.ofNullable(IDLType.createType((Type)Type.OPT)), value);
            return IDLValue.create(Optional.ofNullable(itemIdlValue.getValue()), (IDLType)IDLType.createType((Type)Type.OPT));
        }
        throw CandidError.create((CandidError.CandidErrorCode)CandidError.CandidErrorCode.CUSTOM, (Object[])new Object[]{"Cannot convert type " + type.name()});
    }

    public static IDLType getIDLType(Class valueClass) {
        IDLType idlType;
        Field[] fields;
        if (valueClass == null) {
            return IDLType.createType((Type)Type.NULL);
        }
        if (IDLType.isDefaultType((Class)valueClass)) {
            return IDLType.createType((Class)valueClass);
        }
        if (Optional.class.isAssignableFrom(valueClass)) {
            return IDLType.createType((Type)Type.OPT);
        }
        if (List.class.isAssignableFrom(valueClass)) {
            return IDLType.createType((Type)Type.VEC);
        }
        if (GregorianCalendar.class.isAssignableFrom(valueClass)) {
            return IDLType.createType((Type)Type.INT);
        }
        if (Date.class.isAssignableFrom(valueClass)) {
            return IDLType.createType((Type)Type.INT);
        }
        TreeMap<Label, IDLType> typeMap = new TreeMap<Label, IDLType>();
        for (Field field : fields = valueClass.getDeclaredFields()) {
            String name;
            Expose expose;
            if (field.isAnnotationPresent(Expose.class) && !(expose = field.getAnnotation(Expose.class)).deserialize() || field.isEnumConstant() || (name = field.getName()).startsWith("this$") || name.startsWith("$VALUES") || name.startsWith("ENUM$VALUES")) continue;
            Class typeClass = field.getType();
            IDLType fieldType = GsonSerializer.getIDLType(typeClass);
            if (field.isAnnotationPresent(SerializedName.class)) {
                name = field.getAnnotation(SerializedName.class).value();
            }
            Label label = Label.createNamedLabel((String)name);
            boolean isArray = typeClass.isArray();
            boolean isOptional = Optional.class.isAssignableFrom(typeClass);
            if (IDLType.isDefaultType(typeClass) || GregorianCalendar.class.isAssignableFrom(typeClass) || Date.class.isAssignableFrom(typeClass)) {
                typeMap.put(label, fieldType);
                continue;
            }
            if (List.class.isAssignableFrom(typeClass)) {
                isArray = true;
                typeClass = (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
                fieldType = GsonSerializer.getIDLType(typeClass);
            }
            if (fieldType.getType() == Type.RECORD || fieldType.getType() == Type.VARIANT) {
                String className = typeClass.getSimpleName();
                if (isArray) {
                    fieldType.setName(className);
                    fieldType = IDLType.createType((Type)Type.VEC, (IDLType)fieldType);
                } else {
                    fieldType.setName(className);
                }
            } else if (isArray) {
                fieldType = IDLType.createType((Type)Type.VEC, (IDLType)fieldType);
            } else if (isOptional) {
                fieldType = IDLType.createType((Type)Type.OPT, (IDLType)fieldType);
            }
            typeMap.put(label, fieldType);
        }
        if (valueClass.isEnum()) {
            Enum[] constants;
            Class enumClass = valueClass;
            for (Enum constant : constants = (Enum[])enumClass.getEnumConstants()) {
                String name;
                block22: {
                    name = constant.name();
                    try {
                        if (!enumClass.getField(name).isAnnotationPresent(SerializedName.class)) break block22;
                        name = enumClass.getField(name).getAnnotation(SerializedName.class).value();
                    }
                    catch (NoSuchFieldException | SecurityException e) {
                        continue;
                    }
                }
                Label namedLabel = Label.createNamedLabel((String)name);
                if (typeMap.containsKey(namedLabel)) continue;
                typeMap.put(namedLabel, null);
            }
            idlType = IDLType.createType((Type)Type.VARIANT, typeMap);
        } else {
            idlType = IDLType.createType((Type)Type.RECORD, typeMap);
        }
        idlType.setName(valueClass.getSimpleName());
        return idlType;
    }
}

