/*
 * Decompiled with CFR 0.152.
 */
package org.ic4j.candid.gson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.ic4j.candid.CandidError;
import org.ic4j.candid.ObjectSerializer;
import org.ic4j.candid.parser.IDLType;
import org.ic4j.candid.parser.IDLValue;
import org.ic4j.candid.types.Label;
import org.ic4j.candid.types.Type;
import org.ic4j.types.Principal;

public class GsonSerializer
implements ObjectSerializer {
    Optional<IDLType> idlType = Optional.empty();
    Gson gson = new GsonBuilder().create();

    public static GsonSerializer create(IDLType idlType) {
        GsonSerializer deserializer = new GsonSerializer();
        deserializer.idlType = Optional.ofNullable(idlType);
        return deserializer;
    }

    public static GsonSerializer create() {
        GsonSerializer deserializer = new GsonSerializer();
        return deserializer;
    }

    public IDLValue serialize(Object value) {
        if (value == null) {
            return IDLValue.create((Object)value);
        }
        if (JsonElement.class.isAssignableFrom(value.getClass())) {
            return this.getIDLValue(this.idlType, (JsonElement)value);
        }
        try {
            JsonElement jsonElement = this.gson.toJsonTree(value);
            return this.getIDLValue(this.idlType, jsonElement);
        }
        catch (Exception e) {
            throw CandidError.create((CandidError.CandidErrorCode)CandidError.CandidErrorCode.CUSTOM, (Throwable)e, (Object[])new Object[]{e.getLocalizedMessage()});
        }
    }

    IDLValue getPrimitiveIDLValue(Type type, JsonPrimitive value) {
        IDLValue result = IDLValue.create(null);
        if (value == null) {
            return result;
        }
        switch (type) {
            case BOOL: {
                result = IDLValue.create((Object)value.getAsBoolean(), (Type)type);
                break;
            }
            case INT: {
                result = IDLValue.create((Object)value.getAsBigInteger(), (Type)type);
                break;
            }
            case INT8: {
                result = IDLValue.create((Object)value.getAsByte(), (Type)type);
                break;
            }
            case INT16: {
                result = IDLValue.create((Object)value.getAsShort(), (Type)type);
                break;
            }
            case INT32: {
                result = IDLValue.create((Object)value.getAsInt(), (Type)type);
                break;
            }
            case INT64: {
                result = IDLValue.create((Object)value.getAsLong(), (Type)type);
                break;
            }
            case NAT: {
                result = IDLValue.create((Object)value.getAsBigInteger(), (Type)type);
                break;
            }
            case NAT8: {
                result = IDLValue.create((Object)value.getAsByte(), (Type)type);
                break;
            }
            case NAT16: {
                result = IDLValue.create((Object)value.getAsShort(), (Type)type);
                break;
            }
            case NAT32: {
                result = IDLValue.create((Object)value.getAsInt(), (Type)type);
                break;
            }
            case NAT64: {
                result = IDLValue.create((Object)value.getAsLong(), (Type)type);
                break;
            }
            case FLOAT32: {
                result = IDLValue.create((Object)Float.valueOf(value.getAsFloat()), (Type)type);
                break;
            }
            case FLOAT64: {
                result = IDLValue.create((Object)value.getAsDouble(), (Type)type);
                break;
            }
            case TEXT: {
                result = IDLValue.create((Object)value.getAsString(), (Type)type);
                break;
            }
            case PRINCIPAL: {
                result = IDLValue.create((Object)Principal.fromString((String)value.getAsString()));
                break;
            }
            case EMPTY: {
                result = IDLValue.create(null, (Type)type);
            }
            case NULL: {
                result = IDLValue.create(null, (Type)type);
            }
        }
        return result;
    }

    Type getType(JsonElement value) {
        if (value == null || value.isJsonNull()) {
            return Type.NULL;
        }
        if (value.isJsonPrimitive()) {
            JsonPrimitive primitiveValue = (JsonPrimitive)value;
            if (primitiveValue.isBoolean()) {
                return Type.BOOL;
            }
            if (primitiveValue.isString()) {
                return Type.TEXT;
            }
            if (primitiveValue.isNumber()) {
                return IDLType.createType((Object)primitiveValue.getAsNumber()).getType();
            }
            return Type.NULL;
        }
        if (value.isJsonArray()) {
            return Type.VEC;
        }
        if (value.isJsonObject()) {
            return Type.RECORD;
        }
        return Type.NULL;
    }

    IDLValue getIDLValue(Optional<IDLType> expectedIdlType, JsonElement value) {
        if (value == null) {
            return IDLValue.create((Object)value, (Type)Type.NULL);
        }
        Type type = expectedIdlType.isPresent() ? expectedIdlType.get().getType() : this.getType(value);
        if (value.isJsonPrimitive()) {
            return this.getPrimitiveIDLValue(type, (JsonPrimitive)value);
        }
        if (type == Type.VEC) {
            IDLType innerIdlType = IDLType.createType((Type)Type.NULL);
            if (expectedIdlType.isPresent()) {
                innerIdlType = expectedIdlType.get().getInnerType();
            }
            if (innerIdlType != null && (innerIdlType.getType() == Type.INT8 || innerIdlType.getType() == Type.NAT8)) {
                return IDLValue.create((Object)value, (IDLType)IDLType.createType((Type)type, (IDLType)innerIdlType));
            }
            if (value.isJsonArray()) {
                JsonArray arrayNode = (JsonArray)value;
                Object[] arrayValue = new Object[arrayNode.size()];
                for (int i = 0; i < arrayNode.size(); ++i) {
                    IDLValue item = this.getIDLValue(Optional.ofNullable(innerIdlType), arrayNode.get(i));
                    arrayValue[i] = item.getValue();
                    if (expectedIdlType.isPresent()) continue;
                    innerIdlType = item.getIDLType();
                }
                IDLType idlType = expectedIdlType.isPresent() ? expectedIdlType.get() : IDLType.createType((Type)Type.VEC, (IDLType)innerIdlType);
                return IDLValue.create((Object)arrayValue, (IDLType)idlType);
            }
            throw CandidError.create((CandidError.CandidErrorCode)CandidError.CandidErrorCode.CUSTOM, (Object[])new Object[]{"Cannot convert class " + value.getClass().getName() + " to VEC"});
        }
        if (type == Type.RECORD || type == Type.VARIANT) {
            JsonObject objectNode = (JsonObject)value;
            TreeMap<Label, Object> valueMap = new TreeMap<Label, Object>();
            TreeMap<Label, IDLType> typeMap = new TreeMap<Label, IDLType>();
            Map expectedTypeMap = new TreeMap();
            if (expectedIdlType.isPresent()) {
                expectedTypeMap = expectedIdlType.get().getTypeMap();
            }
            for (String name : objectNode.keySet()) {
                JsonElement item = objectNode.get(name);
                IDLType expectedItemIdlType = expectedIdlType.isPresent() && expectedTypeMap != null ? (IDLType)expectedTypeMap.get(Label.createNamedLabel((String)name)) : IDLType.createType((Type)this.getType(item));
                if (expectedItemIdlType == null) continue;
                IDLValue itemIdlValue = this.getIDLValue(Optional.ofNullable(expectedItemIdlType), item);
                typeMap.put(Label.createNamedLabel((String)name), itemIdlValue.getIDLType());
                valueMap.put(Label.createNamedLabel((String)name), itemIdlValue.getValue());
            }
            IDLType idlType = IDLType.createType((Type)Type.RECORD, typeMap);
            IDLValue idlValue = IDLValue.create(valueMap, (IDLType)idlType);
            return idlValue;
        }
        throw CandidError.create((CandidError.CandidErrorCode)CandidError.CandidErrorCode.CUSTOM, (Object[])new Object[]{"Cannot convert type " + type.name()});
    }
}

