package org.ice1000.jimgui;

import org.ice1000.jimgui.*;
import org.ice1000.jimgui.flag.*;
import org.ice1000.jimgui.cpp.*;
import org.intellij.lang.annotations.*;
import org.jetbrains.annotations.*;
import java.nio.charset.StandardCharsets;

import static org.ice1000.jimgui.util.JImGuiUtil.*;

/**
 * @author ice1000
 * @since v0.1
 */
@SuppressWarnings("ALL")

public class JImGuiIOGen {
  @Contract(pure = true)
  public static @NotNull JImGuiIOGen getInstance(@NotNull JImGui owner) {
    return owner.getIO();
  }

  /** package-private by design */
  JImGuiIOGen() { }

  public static native float getDisplayFramebufferScaleX();
  public static native void setDisplayFramebufferScaleX(float newValue);
  public static native float getDisplayFramebufferScaleY();
  public static native void setDisplayFramebufferScaleY(float newValue);
  public static native float getDisplaySizeX();
  public static native void setDisplaySizeX(float newValue);
  public static native float getDisplaySizeY();
  public static native void setDisplaySizeY(float newValue);
  /**Mouse+position%2C+in+pixels.+Set+to+ImVec2%28-FLT_MAX%2C+-FLT_MAX%29+if+mouse+is+unavailable+%28on+another+screen%2C+etc.%29*/
  public static native float getMousePosX();
  /**Mouse+position%2C+in+pixels.+Set+to+ImVec2%28-FLT_MAX%2C+-FLT_MAX%29+if+mouse+is+unavailable+%28on+another+screen%2C+etc.%29*/
  public static native void setMousePosX(float newValue);
  /**Mouse+position%2C+in+pixels.+Set+to+ImVec2%28-FLT_MAX%2C+-FLT_MAX%29+if+mouse+is+unavailable+%28on+another+screen%2C+etc.%29*/
  public static native float getMousePosY();
  /**Mouse+position%2C+in+pixels.+Set+to+ImVec2%28-FLT_MAX%2C+-FLT_MAX%29+if+mouse+is+unavailable+%28on+another+screen%2C+etc.%29*/
  public static native void setMousePosY(float newValue);
  /**Mouse+delta.+Note+that+this+is+zero+if+either+current+or+previous+position+are+invalid+%28-FLT_MAX%2C-FLT_MAX%29%2C+so+a+disappearing%7Creappearing+mouse+won%27t+have+a+huge+delta.*/
  public static native float getMouseDeltaX();
  /**Mouse+delta.+Note+that+this+is+zero+if+either+current+or+previous+position+are+invalid+%28-FLT_MAX%2C-FLT_MAX%29%2C+so+a+disappearing%7Creappearing+mouse+won%27t+have+a+huge+delta.*/
  public static native void setMouseDeltaX(float newValue);
  /**Mouse+delta.+Note+that+this+is+zero+if+either+current+or+previous+position+are+invalid+%28-FLT_MAX%2C-FLT_MAX%29%2C+so+a+disappearing%7Creappearing+mouse+won%27t+have+a+huge+delta.*/
  public static native float getMouseDeltaY();
  /**Mouse+delta.+Note+that+this+is+zero+if+either+current+or+previous+position+are+invalid+%28-FLT_MAX%2C-FLT_MAX%29%2C+so+a+disappearing%7Creappearing+mouse+won%27t+have+a+huge+delta.*/
  public static native void setMouseDeltaY(float newValue);
  public static native float getMousePosPrevX();
  public static native void setMousePosPrevX(float newValue);
  public static native float getMousePosPrevY();
  public static native void setMousePosPrevY(float newValue);
  /**Queue+new+characters+input+from+an+UTF-8+string*/
  public final void addInputCharactersUTF8(@NotNull String characters){addInputCharactersUTF8(getBytes(characters));}
  /**Queue+new+characters+input+from+an+UTF-8+string*/
  public final void addInputCharactersUTF8(@NotNull JImStr characters){addInputCharactersUTF8(characters.bytes);}
  protected static native void addInputCharactersUTF8(byte[] characters);
  /**Clear+the+text+input+buffer+manually*/
  public static native void clearInputCharacters();
  /**Queue+new+character+input*/
  public static native void addInputCharacter(int character);
  /**Queue+of+_characters_+input+%28obtained+by+platform+backend%29.+Fill+using+AddInputCharacter%28%29+helper.*/
  public static native int inputQueueCharacterAt(int index);
  /**Queue+of+_characters_+input+%28obtained+by+platform+backend%29.+Fill+using+AddInputCharacter%28%29+helper.*/
  public static native void inputQueueCharacter(int index,int newValue);
  /**Gamepad+inputs.+Cleared+back+to+zero+by+EndFrame%28%29.+Keyboard+keys+will+be+auto-mapped+and+be+written+here+by+NewFrame%28%29.*/
  public static native float navInputAt(int index);
  /**Gamepad+inputs.+Cleared+back+to+zero+by+EndFrame%28%29.+Keyboard+keys+will+be+auto-mapped+and+be+written+here+by+NewFrame%28%29.*/
  public static native void navInput(int index,float newValue);
  /**Time+of+last+click+%28used+to+figure+out+double-click%29*/
  public static native @MagicConstant(valuesFromClass = JImMouseButton.class)float mouseClickedTimeAt(@MagicConstant(valuesFromClass = JImMouseButton.class)int index);
  /**Time+of+last+click+%28used+to+figure+out+double-click%29*/
  public static native void mouseClickedTime(@MagicConstant(valuesFromClass = JImMouseButton.class)int index,@MagicConstant(valuesFromClass = JImMouseButton.class)float newValue);
  /**Duration+the+mouse+button+has+been+down+%280.0f+%3D%3D+just+clicked%29*/
  public static native @MagicConstant(valuesFromClass = JImMouseButton.class)float mouseDownDurationAt(@MagicConstant(valuesFromClass = JImMouseButton.class)int index);
  /**Duration+the+mouse+button+has+been+down+%280.0f+%3D%3D+just+clicked%29*/
  public static native void mouseDownDuration(@MagicConstant(valuesFromClass = JImMouseButton.class)int index,@MagicConstant(valuesFromClass = JImMouseButton.class)float newValue);
  /**Previous+time+the+mouse+button+has+been+down*/
  public static native @MagicConstant(valuesFromClass = JImMouseButton.class)float mouseDownDurationPrevAt(@MagicConstant(valuesFromClass = JImMouseButton.class)int index);
  /**Previous+time+the+mouse+button+has+been+down*/
  public static native void mouseDownDurationPrev(@MagicConstant(valuesFromClass = JImMouseButton.class)int index,@MagicConstant(valuesFromClass = JImMouseButton.class)float newValue);
  /**Squared+maximum+distance+of+how+much+mouse+has+traveled+from+the+clicking+point*/
  public static native @MagicConstant(valuesFromClass = JImMouseButton.class)float mouseDragMaxDistanceSqrAt(@MagicConstant(valuesFromClass = JImMouseButton.class)int index);
  /**Squared+maximum+distance+of+how+much+mouse+has+traveled+from+the+clicking+point*/
  public static native void mouseDragMaxDistanceSqr(@MagicConstant(valuesFromClass = JImMouseButton.class)int index,@MagicConstant(valuesFromClass = JImMouseButton.class)float newValue);
  /**Duration+the+keyboard+key+has+been+down+%280.0f+%3D%3D+just+pressed%29*/
  public static native float keysDownDurationAt(int index);
  /**Duration+the+keyboard+key+has+been+down+%280.0f+%3D%3D+just+pressed%29*/
  public static native void keysDownDuration(int index,float newValue);
  /**Previous+duration+the+key+has+been+down*/
  public static native float keysDownDurationPrevAt(int index);
  /**Previous+duration+the+key+has+been+down*/
  public static native void keysDownDurationPrev(int index,float newValue);
  public static native float navInputsDownDurationAt(int index);
  public static native void navInputsDownDuration(int index,float newValue);
  public static native float navInputsDownDurationPrevAt(int index);
  public static native void navInputsDownDurationPrev(int index,float newValue);
  /**Vertices+output+during+last+call+to+Render%28%29*/
  public static native int getMetricsRenderVertices();
  /**Vertices+output+during+last+call+to+Render%28%29*/
  public static native void setMetricsRenderVertices(int newValue);
  public static native int getMetricsRenderIndices();
  public static native void setMetricsRenderIndices(int newValue);
  /**Number+of+active+windows*/
  public static native int getMetricsActiveWindows();
  /**Number+of+active+windows*/
  public static native void setMetricsActiveWindows(int newValue);
  /**%3Cunset%3E++++++++++%7C%7C+Map+of+indices+into+the+KeysDown%5B512%5D+entries+array+which+represent+your+%22native%22+keyboard+state.*/
  public static native int keyMapAt(int index);
  /**%3Cunset%3E++++++++++%7C%7C+Map+of+indices+into+the+KeysDown%5B512%5D+entries+array+which+represent+your+%22native%22+keyboard+state.*/
  public static native void keyMap(int index,int newValue);
  public static native @MagicConstant(flagsFromClass = JImConfigFlags.class)int getConfigFlags();
  public static native void setConfigFlags(@MagicConstant(flagsFromClass = JImConfigFlags.class)int newValue);
  public static native @MagicConstant(flagsFromClass = JImBackendFlags.class)int getBackendFlags();
  public static native void setBackendFlags(@MagicConstant(flagsFromClass = JImBackendFlags.class)int newValue);
  public static native float getConfigMemoryCompactTimer();
  public static native void setConfigMemoryCompactTimer(float newValue);
  public static native float getMouseDoubleClickTime();
  public static native void setMouseDoubleClickTime(float newValue);
  public static native float getMouseDoubleClickMaxDist();
  public static native void setMouseDoubleClickMaxDist(float newValue);
  public static native float getKeyRepeatDelay();
  public static native void setKeyRepeatDelay(float newValue);
  public static native float getKeyRepeatRate();
  public static native void setKeyRepeatRate(float newValue);
  public static native float getFontGlobalScale();
  public static native void setFontGlobalScale(float newValue);
  /**Mouse+wheel+Vertical%3A+1+unit+scrolls+about+5+lines+text.*/
  public static native float getMouseWheel();
  /**Mouse+wheel+Vertical%3A+1+unit+scrolls+about+5+lines+text.*/
  public static native void setMouseWheel(float newValue);
  /**Mouse+wheel+Horizontal.+Most+users+don%27t+have+a+mouse+with+an+horizontal+wheel%2C+may+not+be+filled+by+all+backends.*/
  public static native float getMouseWheelH();
  /**Mouse+wheel+Horizontal.+Most+users+don%27t+have+a+mouse+with+an+horizontal+wheel%2C+may+not+be+filled+by+all+backends.*/
  public static native void setMouseWheelH(float newValue);
  /**Application+framerate+estimate%2C+in+frame+per+second.+Solely+for+convenience.+Rolling+average+estimation+based+on+io.DeltaTime+over+120+frames.*/
  public static native float getFramerate();
  /**Application+framerate+estimate%2C+in+frame+per+second.+Solely+for+convenience.+Rolling+average+estimation+based+on+io.DeltaTime+over+120+frames.*/
  public static native void setFramerate(float newValue);
  public static native float getDeltaTime();
  public static native void setDeltaTime(float newValue);
  public static native float getIniSavingRate();
  public static native void setIniSavingRate(float newValue);
  /**Keyboard+keys+that+are+pressed+%28ideally+left+in+the+%22native%22+order+your+engine+has+access+to+keyboard+keys%2C+so+you+can+use+your+own+defines%7Cenums+for+keys%29.*/
  public static native boolean keyDownAt(int index);
  /**Keyboard+keys+that+are+pressed+%28ideally+left+in+the+%22native%22+order+your+engine+has+access+to+keyboard+keys%2C+so+you+can+use+your+own+defines%7Cenums+for+keys%29.*/
  public static native void keyDown(int index,boolean newValue);
  /**Mouse+button+went+from+%21Down+to+Down*/
  public static native boolean mouseClickedAt(@MagicConstant(valuesFromClass = JImMouseButton.class)int index);
  /**Mouse+button+went+from+%21Down+to+Down*/
  public static native void mouseClicked(@MagicConstant(valuesFromClass = JImMouseButton.class)int index,boolean newValue);
  /**Has+mouse+button+been+double-clicked%3F*/
  public static native boolean mouseDoubleClickedAt(@MagicConstant(valuesFromClass = JImMouseButton.class)int index);
  /**Has+mouse+button+been+double-clicked%3F*/
  public static native void mouseDoubleClicked(@MagicConstant(valuesFromClass = JImMouseButton.class)int index,boolean newValue);
  /**Mouse+button+went+from+Down+to+%21Down*/
  public static native boolean mouseReleasedAt(@MagicConstant(valuesFromClass = JImMouseButton.class)int index);
  /**Mouse+button+went+from+Down+to+%21Down*/
  public static native void mouseReleased(@MagicConstant(valuesFromClass = JImMouseButton.class)int index,boolean newValue);
  /**Track+if+button+was+clicked+inside+a+dear+imgui+window.+We+don%27t+request+mouse+capture+from+the+application+if+click+started+outside+ImGui+bounds.*/
  public static native boolean mouseDownOwnedAt(@MagicConstant(valuesFromClass = JImMouseButton.class)int index);
  /**Track+if+button+was+clicked+inside+a+dear+imgui+window.+We+don%27t+request+mouse+capture+from+the+application+if+click+started+outside+ImGui+bounds.*/
  public static native void mouseDownOwned(@MagicConstant(valuesFromClass = JImMouseButton.class)int index,boolean newValue);
  public static native boolean isFontAllowUserScaling();
  public static native void setFontAllowUserScaling(boolean newValue);
  public static native boolean isConfigMacOSXBehaviors();
  public static native void setConfigMacOSXBehaviors(boolean newValue);
  public static native boolean isConfigInputTextCursorBlink();
  public static native void setConfigInputTextCursorBlink(boolean newValue);
  public static native boolean isConfigDragClickToInputText();
  public static native void setConfigDragClickToInputText(boolean newValue);
  public static native boolean isConfigWindowsResizeFromEdges();
  public static native void setConfigWindowsResizeFromEdges(boolean newValue);
  public static native boolean isConfigWindowsMoveFromTitleBarOnly();
  public static native void setConfigWindowsMoveFromTitleBarOnly(boolean newValue);
  public static native boolean isMouseDrawCursor();
  public static native void setMouseDrawCursor(boolean newValue);
  /**Keyboard+modifier+pressed%3A+Control*/
  public static native boolean isKeyCtrl();
  /**Keyboard+modifier+pressed%3A+Control*/
  public static native void setKeyCtrl(boolean newValue);
  /**Keyboard+modifier+pressed%3A+Shift*/
  public static native boolean isKeyShift();
  /**Keyboard+modifier+pressed%3A+Shift*/
  public static native void setKeyShift(boolean newValue);
  /**Keyboard+modifier+pressed%3A+Alt*/
  public static native boolean isKeyAlt();
  /**Keyboard+modifier+pressed%3A+Alt*/
  public static native void setKeyAlt(boolean newValue);
  /**Keyboard+modifier+pressed%3A+Cmd%7CSuper%7CWindows*/
  public static native boolean isKeySuper();
  /**Keyboard+modifier+pressed%3A+Cmd%7CSuper%7CWindows*/
  public static native void setKeySuper(boolean newValue);
  /**Set+when+Dear+ImGui+will+use+mouse+inputs%2C+in+this+case+do+not+dispatch+them+to+your+main+game%7Capplication+%28either+way%2C+always+pass+on+mouse+inputs+to+imgui%29.+%28e.g.+unclicked+mouse+is+hovering+over+an+imgui+window%2C+widget+is+active%2C+mouse+was+clicked+over+an+imgui+window%2C+etc.%29.*/
  public static native boolean isWantCaptureMouse();
  /**Set+when+Dear+ImGui+will+use+mouse+inputs%2C+in+this+case+do+not+dispatch+them+to+your+main+game%7Capplication+%28either+way%2C+always+pass+on+mouse+inputs+to+imgui%29.+%28e.g.+unclicked+mouse+is+hovering+over+an+imgui+window%2C+widget+is+active%2C+mouse+was+clicked+over+an+imgui+window%2C+etc.%29.*/
  public static native void setWantCaptureMouse(boolean newValue);
  /**Set+when+Dear+ImGui+will+use+keyboard+inputs%2C+in+this+case+do+not+dispatch+them+to+your+main+game%7Capplication+%28either+way%2C+always+pass+keyboard+inputs+to+imgui%29.+%28e.g.+InputText+active%2C+or+an+imgui+window+is+focused+and+navigation+is+enabled%2C+etc.%29.*/
  public static native boolean isWantCaptureKeyboard();
  /**Set+when+Dear+ImGui+will+use+keyboard+inputs%2C+in+this+case+do+not+dispatch+them+to+your+main+game%7Capplication+%28either+way%2C+always+pass+keyboard+inputs+to+imgui%29.+%28e.g.+InputText+active%2C+or+an+imgui+window+is+focused+and+navigation+is+enabled%2C+etc.%29.*/
  public static native void setWantCaptureKeyboard(boolean newValue);
  /**Mobile%7Cconsole%3A+when+set%2C+you+may+display+an+on-screen+keyboard.+This+is+set+by+Dear+ImGui+when+it+wants+textual+keyboard+input+to+happen+%28e.g.+when+a+InputText+widget+is+active%29.*/
  public static native boolean isWantTextInput();
  /**Mobile%7Cconsole%3A+when+set%2C+you+may+display+an+on-screen+keyboard.+This+is+set+by+Dear+ImGui+when+it+wants+textual+keyboard+input+to+happen+%28e.g.+when+a+InputText+widget+is+active%29.*/
  public static native void setWantTextInput(boolean newValue);
  /**MousePos+has+been+altered%2C+backend+should+reposition+mouse+on+next+frame.+Rarely+used%21+Set+only+when+ImGuiConfigFlags_NavEnableSetMousePos+flag+is+enabled.*/
  public static native boolean isWantSetMousePos();
  /**MousePos+has+been+altered%2C+backend+should+reposition+mouse+on+next+frame.+Rarely+used%21+Set+only+when+ImGuiConfigFlags_NavEnableSetMousePos+flag+is+enabled.*/
  public static native void setWantSetMousePos(boolean newValue);
  public static native boolean isWantSaveIniSettings();
  public static native void setWantSaveIniSettings(boolean newValue);
  public static native boolean isNavActive();
  public static native void setNavActive(boolean newValue);
  /**Keyboard%7CGamepad+navigation+is+visible+and+allowed+%28will+handle+ImGuiKey_NavXXX+events%29.*/
  public static native boolean isNavVisible();
  /**Keyboard%7CGamepad+navigation+is+visible+and+allowed+%28will+handle+ImGuiKey_NavXXX+events%29.*/
  public static native void setNavVisible(boolean newValue);
  private static native void setIniFilename(byte[]newValue);
  public void setIniFilename(@NotNull String newValue){setIniFilename(getBytes(newValue));}
  private static native void setLogFilename(byte[]newValue);
  public void setLogFilename(@NotNull String newValue){setLogFilename(getBytes(newValue));}

}