
package org.ice1000.jimgui;
import org.ice1000.jimgui.cpp.*;
import org.jetbrains.annotations.*;

/**
 * @author ice1000
 * @since v0.1
 */
@SuppressWarnings("ALL")
public final class NativeShort extends Number implements DeallocatableObject, Cloneable {
  /** package-private by design */
  long nativeObjectPtr;
  @Contract public NativeShort() { nativeObjectPtr = allocateNativeObject(); }
  @Contract(pure = true) public NativeShort(long nativeObjectPtr) { this.nativeObjectPtr = nativeObjectPtr; }

  @Override @Contract
  public void deallocateNativeObject() { deallocateNativeObject0(nativeObjectPtr); nativeObjectPtr = 0; }
  @Contract(pure = true) public short accessValue() { return accessValue(nativeObjectPtr); }
  @Contract public void increaseValue(short increment) { increaseValue(nativeObjectPtr, increment); }
  @Contract public void modifyValue(short newValue) { modifyValue(nativeObjectPtr, newValue); }

  @Override @Contract(pure = true) public int intValue() { return (int) accessValue(); }
  @Override @Contract(pure = true) public long longValue() { return (long) accessValue(); }
  @Override @Contract(pure = true) public float floatValue() { return (float) accessValue(); }
  @Override @Contract(pure = true) public double doubleValue() { return (double) accessValue(); }

  private static native short accessValue(long nativeObjectPtr);
  private static native void modifyValue(long nativeObjectPtr, short newValue);
  private static native void increaseValue(long nativeObjectPtr, short increment);
  private static native long allocateNativeObject();
  private static native void deallocateNativeObject0(long nativeObjectPtr);

  @Override @Contract(value = "null -> false", pure = true)
  public boolean equals(@Nullable Object o) {
    return this == o || o instanceof NativeShort && nativeObjectPtr == ((NativeShort) o).nativeObjectPtr;
  }
  @Override @Contract(pure = true)
  public int hashCode() { return Long.hashCode(nativeObjectPtr); }
  @Override public @NotNull String toString() { return String.valueOf(accessValue()); }
  @Override @Contract public @NotNull NativeShort clone() {
    NativeShort newInstance = new NativeShort();
    newInstance.modifyValue(accessValue());
    return newInstance;
  }
}
