package org.ice1000.jimgui.flag;

import org.ice1000.jimgui.*;
import org.ice1000.jimgui.flag.*;
import org.ice1000.jimgui.cpp.*;
import org.intellij.lang.annotations.*;
import org.jetbrains.annotations.*;
import java.nio.charset.StandardCharsets;

import static org.ice1000.jimgui.util.JImGuiUtil.*;

/**
 * @author ice1000
 * @since undecidable
 */
@SuppressWarnings("ALL")

public interface JImColorEditFlags {
  int None = 0;
  /**ColorEdit%2C+ColorPicker%2C+ColorButton%3A+ignore+Alpha+component+%28will+only+read+3+components+from+the+input+pointer%29.*/
  int NoAlpha = 1 << 1;
  /**ColorEdit%3A+disable+picker+when+clicking+on+color+square.*/
  int NoPicker = 1 << 2;
  /**ColorEdit%3A+disable+toggling+options+menu+when+right-clicking+on+inputs%7Csmall+preview.*/
  int NoOptions = 1 << 3;
  /**ColorEdit%2C+ColorPicker%3A+disable+color+square+preview+next+to+the+inputs.+%28e.g.+to+show+only+the+inputs%29*/
  int NoSmallPreview = 1 << 4;
  /**ColorEdit%2C+ColorPicker%3A+disable+inputs+sliders%7Ctext+widgets+%28e.g.+to+show+only+the+small+preview+color+square%29.*/
  int NoInputs = 1 << 5;
  /**ColorEdit%2C+ColorPicker%2C+ColorButton%3A+disable+tooltip+when+hovering+the+preview.*/
  int NoTooltip = 1 << 6;
  /**ColorEdit%2C+ColorPicker%3A+disable+display+of+inline+text+label+%28the+label+is+still+forwarded+to+the+tooltip+and+picker%29.*/
  int NoLabel = 1 << 7;
  /**ColorPicker%3A+disable+bigger+color+preview+on+right+side+of+the+picker%2C+use+small+color+square+preview+instead.*/
  int NoSidePreview = 1 << 8;
  /**ColorEdit%3A+disable+drag+and+drop+target.+ColorButton%3A+disable+drag+and+drop+source.*/
  int NoDragDrop = 1 << 9;
  /**ColorButton%3A+disable+border+%28which+is+enforced+by+default%29*/
  int NoBorder = 1 << 10;
  /**ColorEdit%2C+ColorPicker%3A+show+vertical+alpha+bar%7Cgradient+in+picker.*/
  int AlphaBar = 1 << 16;
  /**ColorEdit%2C+ColorPicker%2C+ColorButton%3A+display+preview+as+a+transparent+color+over+a+checkerboard%2C+instead+of+opaque.*/
  int AlphaPreview = 1 << 17;
  /**ColorEdit%2C+ColorPicker%2C+ColorButton%3A+display+half+opaque+%7C+half+checkerboard%2C+instead+of+opaque.*/
  int AlphaPreviewHalf = 1 << 18;
  /**%28WIP%29+ColorEdit%3A+Currently+only+disable+0.0f..1.0f+limits+in+RGBA+edition+%28note%3A+you+probably+want+to+use+ImGuiColorEditFlags_Float+flag+as+well%29.*/
  int HDR = 1 << 19;
  /**%5BDisplay%5D++++%7C%7C+ColorEdit%3A+override+_display_+type+among+RGB%7CHSV%7CHex.+ColorPicker%3A+select+any+combination+using+one+or+more+of+RGB%7CHSV%7CHex.*/
  int DisplayRGB = 1 << 20;
  /**%5BDisplay%5D++++%7C%7C+%22*/
  int DisplayHSV = 1 << 21;
  /**%5BDisplay%5D++++%7C%7C+%22*/
  int DisplayHex = 1 << 22;
  /**%5BDataType%5D+++%7C%7C+ColorEdit%2C+ColorPicker%2C+ColorButton%3A+_display_+values+formatted+as+0..255.*/
  int Uint8 = 1 << 23;
  /**%5BDataType%5D+++%7C%7C+ColorEdit%2C+ColorPicker%2C+ColorButton%3A+_display_+values+formatted+as+0.0f..1.0f+floats+instead+of+0..255+integers.+No+round-trip+of+value+via+integers.*/
  int Float = 1 << 24;
  /**%5BPicker%5D+++++%7C%7C+ColorPicker%3A+bar+for+Hue%2C+rectangle+for+Sat%7CValue.*/
  int PickerHueBar = 1 << 25;
  /**%5BPicker%5D+++++%7C%7C+ColorPicker%3A+wheel+for+Hue%2C+triangle+for+Sat%7CValue.*/
  int PickerHueWheel = 1 << 26;
  /**%5BInput%5D++++++%7C%7C+ColorEdit%2C+ColorPicker%3A+input+and+output+data+in+RGB+format.*/
  int InputRGB = 1 << 27;
  /**%5BInput%5D++++++%7C%7C+ColorEdit%2C+ColorPicker%3A+input+and+output+data+in+HSV+format.*/
  int InputHSV = 1 << 28;
  int OptionsDefault = Uint8 | InputRGB | PickerHueBar;
  int _DisplayMask = DisplayRGB | DisplayHSV | DisplayHex;
  int _DataTypeMask = Uint8 | Float;
  int _PickerMask = PickerHueWheel | PickerHueBar;
  int _InputMask = InputRGB | InputHSV;
  enum Type implements Flag {
    None(JImColorEditFlags.None),
    NoAlpha(JImColorEditFlags.NoAlpha),
    NoPicker(JImColorEditFlags.NoPicker),
    NoOptions(JImColorEditFlags.NoOptions),
    NoSmallPreview(JImColorEditFlags.NoSmallPreview),
    NoInputs(JImColorEditFlags.NoInputs),
    NoTooltip(JImColorEditFlags.NoTooltip),
    NoLabel(JImColorEditFlags.NoLabel),
    NoSidePreview(JImColorEditFlags.NoSidePreview),
    NoDragDrop(JImColorEditFlags.NoDragDrop),
    NoBorder(JImColorEditFlags.NoBorder),
    AlphaBar(JImColorEditFlags.AlphaBar),
    AlphaPreview(JImColorEditFlags.AlphaPreview),
    AlphaPreviewHalf(JImColorEditFlags.AlphaPreviewHalf),
    HDR(JImColorEditFlags.HDR),
    DisplayRGB(JImColorEditFlags.DisplayRGB),
    DisplayHSV(JImColorEditFlags.DisplayHSV),
    DisplayHex(JImColorEditFlags.DisplayHex),
    Uint8(JImColorEditFlags.Uint8),
    Float(JImColorEditFlags.Float),
    PickerHueBar(JImColorEditFlags.PickerHueBar),
    PickerHueWheel(JImColorEditFlags.PickerHueWheel),
    InputRGB(JImColorEditFlags.InputRGB),
    InputHSV(JImColorEditFlags.InputHSV),
    OptionsDefault(JImColorEditFlags.OptionsDefault),
    _DisplayMask(JImColorEditFlags._DisplayMask),
    _DataTypeMask(JImColorEditFlags._DataTypeMask),
    _PickerMask(JImColorEditFlags._PickerMask),
    _InputMask(JImColorEditFlags._InputMask),
    ;
    public final int flag;
    Type(int flag) { this.flag = flag; }
    @Override public int get() { return flag; }
  }
}
