package org.ice1000.jimgui.flag;

import org.ice1000.jimgui.*;
import org.ice1000.jimgui.flag.*;
import org.ice1000.jimgui.cpp.*;
import org.intellij.lang.annotations.*;
import org.jetbrains.annotations.*;
import java.nio.charset.StandardCharsets;

import static org.ice1000.jimgui.util.JImGuiUtil.*;

/**
 * @author ice1000
 * @since undecidable
 */
@SuppressWarnings("ALL")

public interface JImHoveredFlags {
  /**Return+true+if+directly+over+the+item%7Cwindow%2C+not+obstructed+by+another+window%2C+not+obstructed+by+an+active+popup+or+modal+blocking+inputs+under+them.*/
  int None = 0;
  /**IsWindowHovered%28%29+only%3A+Return+true+if+any+children+of+the+window+is+hovered*/
  int ChildWindows = 1 << 0;
  /**IsWindowHovered%28%29+only%3A+Test+from+root+window+%28top+most+parent+of+the+current+hierarchy%29*/
  int RootWindow = 1 << 1;
  /**IsWindowHovered%28%29+only%3A+Return+true+if+any+window+is+hovered*/
  int AnyWindow = 1 << 2;
  /**Return+true+even+if+a+popup+window+is+normally+blocking+access+to+this+item%7Cwindow*/
  int AllowWhenBlockedByPopup = 1 << 3;
  /**Return+true+even+if+an+active+item+is+blocking+access+to+this+item%7Cwindow.+Useful+for+Drag+and+Drop+patterns.*/
  int AllowWhenBlockedByActiveItem = 1 << 5;
  /**Return+true+even+if+the+position+is+obstructed+or+overlapped+by+another+window*/
  int AllowWhenOverlapped = 1 << 6;
  /**Return+true+even+if+the+item+is+disabled*/
  int AllowWhenDisabled = 1 << 7;
  int RectOnly = AllowWhenBlockedByPopup | AllowWhenBlockedByActiveItem | AllowWhenOverlapped;
  int RootAndChildWindows = RootWindow | ChildWindows;
  enum Type implements Flag {
    None(JImHoveredFlags.None),
    ChildWindows(JImHoveredFlags.ChildWindows),
    RootWindow(JImHoveredFlags.RootWindow),
    AnyWindow(JImHoveredFlags.AnyWindow),
    AllowWhenBlockedByPopup(JImHoveredFlags.AllowWhenBlockedByPopup),
    AllowWhenBlockedByActiveItem(JImHoveredFlags.AllowWhenBlockedByActiveItem),
    AllowWhenOverlapped(JImHoveredFlags.AllowWhenOverlapped),
    AllowWhenDisabled(JImHoveredFlags.AllowWhenDisabled),
    RectOnly(JImHoveredFlags.RectOnly),
    RootAndChildWindows(JImHoveredFlags.RootAndChildWindows),
    ;
    public final int flag;
    Type(int flag) { this.flag = flag; }
    @Override public int get() { return flag; }
  }
}
