package org.ice1000.jimgui.flag;

import org.ice1000.jimgui.*;
import org.ice1000.jimgui.flag.*;
import org.ice1000.jimgui.cpp.*;
import org.intellij.lang.annotations.*;
import org.jetbrains.annotations.*;
import java.nio.charset.StandardCharsets;

import static org.ice1000.jimgui.util.JImGuiUtil.*;

/**
 * @author ice1000
 * @since undecidable
 */
@SuppressWarnings("ALL")

public interface JImPopupFlags {
  int None = 0;
  /**For+BeginPopupContext*%28%29%3A+open+on+Left+Mouse+release.+Guaranteed+to+always+be+%3D%3D+0+%28same+as+ImGuiMouseButton_Left%29*/
  int MouseButtonLeft = 0;
  /**For+BeginPopupContext*%28%29%3A+open+on+Right+Mouse+release.+Guaranteed+to+always+be+%3D%3D+1+%28same+as+ImGuiMouseButton_Right%29*/
  int MouseButtonRight = 1;
  /**For+BeginPopupContext*%28%29%3A+open+on+Middle+Mouse+release.+Guaranteed+to+always+be+%3D%3D+2+%28same+as+ImGuiMouseButton_Middle%29*/
  int MouseButtonMiddle = 2;
  int MouseButtonMask = 0x1F;
  int MouseButtonDefault = 1;
  /**For+OpenPopup*%28%29%2C+BeginPopupContext*%28%29%3A+don%27t+open+if+there%27s+already+a+popup+at+the+same+level+of+the+popup+stack*/
  int NoOpenOverExistingPopup = 1 << 5;
  /**For+BeginPopupContextWindow%28%29%3A+don%27t+return+true+when+hovering+items%2C+only+when+hovering+empty+space*/
  int NoOpenOverItems = 1 << 6;
  /**For+IsPopupOpen%28%29%3A+ignore+the+ImGuiID+parameter+and+test+for+any+popup.*/
  int AnyPopupId = 1 << 7;
  /**For+IsPopupOpen%28%29%3A+search%7Ctest+at+any+level+of+the+popup+stack+%28default+test+in+the+current+level%29*/
  int AnyPopupLevel = 1 << 8;
  int AnyPopup = AnyPopupId | AnyPopupLevel;
  enum Type implements Flag {
    None(JImPopupFlags.None),
    MouseButtonLeft(JImPopupFlags.MouseButtonLeft),
    MouseButtonRight(JImPopupFlags.MouseButtonRight),
    MouseButtonMiddle(JImPopupFlags.MouseButtonMiddle),
    MouseButtonMask(JImPopupFlags.MouseButtonMask),
    MouseButtonDefault(JImPopupFlags.MouseButtonDefault),
    NoOpenOverExistingPopup(JImPopupFlags.NoOpenOverExistingPopup),
    NoOpenOverItems(JImPopupFlags.NoOpenOverItems),
    AnyPopupId(JImPopupFlags.AnyPopupId),
    AnyPopupLevel(JImPopupFlags.AnyPopupLevel),
    AnyPopup(JImPopupFlags.AnyPopup),
    ;
    public final int flag;
    Type(int flag) { this.flag = flag; }
    @Override public int get() { return flag; }
  }
}
