package org.ice1000.jimgui.flag;

import org.ice1000.jimgui.*;
import org.ice1000.jimgui.flag.*;
import org.ice1000.jimgui.cpp.*;
import org.intellij.lang.annotations.*;
import org.jetbrains.annotations.*;
import java.nio.charset.StandardCharsets;

import static org.ice1000.jimgui.util.JImGuiUtil.*;

/**
 * @author ice1000
 * @since undecidable
 */
@SuppressWarnings("ALL")

public interface JImTabBarFlags {
  int None = 0;
  /**Allow+manually+dragging+tabs+to+re-order+them+%2B+New+tabs+are+appended+at+the+end+of+list*/
  int Reorderable = 1;
  /**Automatically+select+new+tabs+when+they+appear*/
  int AutoSelectNewTabs = 1 << 1;
  /**Disable+buttons+to+open+the+tab+list+popup*/
  int TabListPopupButton = 1 << 2;
  /**Disable+behavior+of+closing+tabs+%28that+are+submitted+with+p_open+%21%3D+NULL%29+with+middle+mouse+button.+You+can+still+repro+this+behavior+on+user%27s+side+with+if+%28IsItemHovered%28%29+%26%26+IsMouseClicked%282%29%29+*p_open+%3D+false.*/
  int NoCloseWithMiddleMouseButton = 1 << 3;
  /**Disable+scrolling+buttons+%28apply+when+fitting+policy+is+ImGuiTabBarFlags_FittingPolicyScroll%29*/
  int NoTabListScrollingButtons = 1 << 4;
  /**Disable+tooltips+when+hovering+a+tab*/
  int NoTooltip = 1 << 5;
  /**Resize+tabs+when+they+don%27t+fit*/
  int FittingPolicyResizeDown = 1 << 6;
  /**Add+scroll+buttons+when+tabs+don%27t+fit*/
  int FittingPolicyScroll = 1 << 7;
  int FittingPolicyMask = FittingPolicyResizeDown | FittingPolicyScroll;
  int FittingPolicyDefault = FittingPolicyResizeDown;
  enum Type implements Flag {
    None(JImTabBarFlags.None),
    Reorderable(JImTabBarFlags.Reorderable),
    AutoSelectNewTabs(JImTabBarFlags.AutoSelectNewTabs),
    TabListPopupButton(JImTabBarFlags.TabListPopupButton),
    NoCloseWithMiddleMouseButton(JImTabBarFlags.NoCloseWithMiddleMouseButton),
    NoTabListScrollingButtons(JImTabBarFlags.NoTabListScrollingButtons),
    NoTooltip(JImTabBarFlags.NoTooltip),
    FittingPolicyResizeDown(JImTabBarFlags.FittingPolicyResizeDown),
    FittingPolicyScroll(JImTabBarFlags.FittingPolicyScroll),
    FittingPolicyMask(JImTabBarFlags.FittingPolicyMask),
    FittingPolicyDefault(JImTabBarFlags.FittingPolicyDefault),
    ;
    public final int flag;
    Type(int flag) { this.flag = flag; }
    @Override public int get() { return flag; }
  }
}
