package org.ice1000.jimgui.flag;

import org.ice1000.jimgui.*;
import org.ice1000.jimgui.flag.*;
import org.ice1000.jimgui.cpp.*;
import org.intellij.lang.annotations.*;
import org.jetbrains.annotations.*;
import java.nio.charset.StandardCharsets;

import static org.ice1000.jimgui.util.JImGuiUtil.*;

/**
 * @author ice1000
 * @since undecidable
 */
@SuppressWarnings("ALL")

public interface JImTabItemFlags {
  int None = 0;
  /**Append+%27*%27+to+title+without+affecting+the+ID%2C+as+a+convenience+to+avoid+using+the+%23%23%23+operator.+Also%3A+tab+is+selected+on+closure+and+closure+is+deferred+by+one+frame+to+allow+code+to+undo+it+without+flicker.*/
  int UnsavedDocument = 1 << 0;
  /**Trigger+flag+to+programmatically+make+the+tab+selected+when+calling+BeginTabItem%28%29*/
  int SetSelected = 1 << 1;
  /**Disable+behavior+of+closing+tabs+%28that+are+submitted+with+p_open+%21%3D+NULL%29+with+middle+mouse+button.+You+can+still+repro+this+behavior+on+user%27s+side+with+if+%28IsItemHovered%28%29+%26%26+IsMouseClicked%282%29%29+*p_open+%3D+false.*/
  int NoCloseWithMiddleMouseButton = 1 << 2;
  /**Don%27t+call+PushID%28tab-%3EID%29%7CPopID%28%29+on+BeginTabItem%28%29%7CEndTabItem%28%29*/
  int NoPushId = 1 << 3;
  /**Disable+tooltip+for+the+given+tab*/
  int NoTooltip = 1 << 4;
  /**Disable+reordering+this+tab+or+having+another+tab+cross+over+this+tab*/
  int NoReorder = 1 << 5;
  /**Enforce+the+tab+position+to+the+left+of+the+tab+bar+%28after+the+tab+list+popup+button%29*/
  int Leading = 1 << 6;
  /**Enforce+the+tab+position+to+the+right+of+the+tab+bar+%28before+the+scrolling+buttons%29*/
  int Trailing = 1 << 7;
  enum Type implements Flag {
    None(JImTabItemFlags.None),
    UnsavedDocument(JImTabItemFlags.UnsavedDocument),
    SetSelected(JImTabItemFlags.SetSelected),
    NoCloseWithMiddleMouseButton(JImTabItemFlags.NoCloseWithMiddleMouseButton),
    NoPushId(JImTabItemFlags.NoPushId),
    NoTooltip(JImTabItemFlags.NoTooltip),
    NoReorder(JImTabItemFlags.NoReorder),
    Leading(JImTabItemFlags.Leading),
    Trailing(JImTabItemFlags.Trailing),
    ;
    public final int flag;
    Type(int flag) { this.flag = flag; }
    @Override public int get() { return flag; }
  }
}
