package org.ice1000.jimgui.flag;

import org.ice1000.jimgui.*;
import org.ice1000.jimgui.flag.*;
import org.ice1000.jimgui.cpp.*;
import org.intellij.lang.annotations.*;
import org.jetbrains.annotations.*;
import java.nio.charset.StandardCharsets;

import static org.ice1000.jimgui.util.JImGuiUtil.*;

/**
 * @author ice1000
 * @since undecidable
 */
@SuppressWarnings("ALL")

public interface JImTreeNodeFlags {
  int None = 0;
  /**Draw+as+selected*/
  int Selected = 1 << 0;
  /**Draw+frame+with+background+%28e.g.+for+CollapsingHeader%29*/
  int Framed = 1 << 1;
  /**Hit+testing+to+allow+subsequent+widgets+to+overlap+this+one*/
  int AllowItemOverlap = 1 << 2;
  /**Don%27t+do+a+TreePush%28%29+when+open+%28e.g.+for+CollapsingHeader%29+%3D+no+extra+indent+nor+pushing+on+ID+stack*/
  int NoTreePushOnOpen = 1 << 3;
  /**Don%27t+automatically+and+temporarily+open+node+when+Logging+is+active+%28by+default+logging+will+automatically+open+tree+nodes%29*/
  int NoAutoOpenOnLog = 1 << 4;
  /**Default+node+to+be+open*/
  int DefaultOpen = 1 << 5;
  /**Need+double-click+to+open+node*/
  int OpenOnDoubleClick = 1 << 6;
  /**Only+open+when+clicking+on+the+arrow+part.+If+ImGuiTreeNodeFlags_OpenOnDoubleClick+is+also+set%2C+single-click+arrow+or+double-click+all+box+to+open.*/
  int OpenOnArrow = 1 << 7;
  /**No+collapsing%2C+no+arrow+%28use+as+a+convenience+for+leaf+nodes%29.*/
  int Leaf = 1 << 8;
  /**Display+a+bullet+instead+of+arrow*/
  int Bullet = 1 << 9;
  /**Use+FramePadding+%28even+for+an+unframed+text+node%29+to+vertically+align+text+baseline+to+regular+widget+height.+Equivalent+to+calling+AlignTextToFramePadding%28%29.*/
  int FramePadding = 1 << 10;
  /**Extend+hit+box+to+the+right-most+edge%2C+even+if+not+framed.+This+is+not+the+default+in+order+to+allow+adding+other+items+on+the+same+line.+In+the+future+we+may+refactor+the+hit+system+to+be+front-to-back%2C+allowing+natural+overlaps+and+then+this+can+become+the+default.*/
  int SpanAvailWidth = 1 << 11;
  /**Extend+hit+box+to+the+left-most+and+right-most+edges+%28bypass+the+indented+area%29.*/
  int SpanFullWidth = 1 << 12;
  /**%28WIP%29+Nav%3A+left+direction+may+move+to+this+TreeNode%28%29+from+any+of+its+child+%28items+submitted+between+TreeNode+and+TreePop%29*/
  int NavLeftJumpsBackHere = 1 << 13;
  int CollapsingHeader = Framed | NoTreePushOnOpen | NoAutoOpenOnLog;
  enum Type implements Flag {
    None(JImTreeNodeFlags.None),
    Selected(JImTreeNodeFlags.Selected),
    Framed(JImTreeNodeFlags.Framed),
    AllowItemOverlap(JImTreeNodeFlags.AllowItemOverlap),
    NoTreePushOnOpen(JImTreeNodeFlags.NoTreePushOnOpen),
    NoAutoOpenOnLog(JImTreeNodeFlags.NoAutoOpenOnLog),
    DefaultOpen(JImTreeNodeFlags.DefaultOpen),
    OpenOnDoubleClick(JImTreeNodeFlags.OpenOnDoubleClick),
    OpenOnArrow(JImTreeNodeFlags.OpenOnArrow),
    Leaf(JImTreeNodeFlags.Leaf),
    Bullet(JImTreeNodeFlags.Bullet),
    FramePadding(JImTreeNodeFlags.FramePadding),
    SpanAvailWidth(JImTreeNodeFlags.SpanAvailWidth),
    SpanFullWidth(JImTreeNodeFlags.SpanFullWidth),
    NavLeftJumpsBackHere(JImTreeNodeFlags.NavLeftJumpsBackHere),
    CollapsingHeader(JImTreeNodeFlags.CollapsingHeader),
    ;
    public final int flag;
    Type(int flag) { this.flag = flag; }
    @Override public int get() { return flag; }
  }
}
