/*
 * Decompiled with CFR 0.152.
 */
package org.ice1000.jimgui.flag;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public interface Flag {
    public int get();

    public static boolean hasFlag(int flag, Flag ... flags) {
        return Arrays.stream(flags).anyMatch(value -> value.get() == flag);
    }

    @NotNull
    public static <E extends Flag> E reverseLookup(@NotNull @NotNull Class<@NotNull E> enumType, int flag) {
        Flag[] enumConstants = (Flag[])enumType.getEnumConstants();
        for (int i = 1; i < enumConstants.length; ++i) {
            Flag enumConstant = enumConstants[i];
            int flagConstant = enumConstant.get();
            if (flagConstant != flag) continue;
            return (E)enumConstant;
        }
        return (E)enumConstants[0];
    }

    @NotNull
    public static <E extends Flag> @NotNull E @NotNull [] getAsFlags(@NotNull @NotNull Class<@NotNull E> enumType, int flags) {
        ArrayList<Flag> setFlags = new ArrayList<Flag>();
        Flag[] enumConstants = (Flag[])enumType.getEnumConstants();
        for (int i = 1; i < enumConstants.length; ++i) {
            boolean flagSet;
            Flag enumConstant = enumConstants[i];
            int flagConstant = enumConstant.get();
            boolean bl = flagSet = (flags & flagConstant) != 0;
            if (!flagSet) continue;
            setFlags.add(enumConstant);
        }
        Flag[] a = (Flag[])Array.newInstance(enumType, setFlags.size());
        setFlags.toArray(a);
        return a;
    }

    public static int getAsValue(Flag ... flagSelection) {
        int flags = 0;
        for (Flag flag : flagSelection) {
            flags |= flag.get();
        }
        return flags;
    }
}

