/*
 * Decompiled with CFR 0.152.
 */
package org.ice1000.jimgui.util;

import java.util.WeakHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.LongSupplier;
import org.ice1000.jimgui.JImGui;
import org.ice1000.jimgui.util.SharedState;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public interface JImGuiUtil {
    public static final byte @NotNull [] EMPTY_BYTES = new byte[0];
    public static final float FLT_MAX = Float.MAX_VALUE;

    @TestOnly
    public static void runWithin(long millis, @NotNull @NotNull Consumer<@NotNull JImGui> runnable) {
        try (JImGui imGui = new JImGui();){
            long end = System.currentTimeMillis() + millis;
            while (!imGui.windowShouldClose() && System.currentTimeMillis() < end) {
                imGui.initNewFrame();
                runnable.accept(imGui);
                imGui.render();
            }
        }
    }

    public static void run(@NotNull @NotNull Consumer<@NotNull JImGui> runnable) {
        try (JImGui imGui = new JImGui();){
            while (!imGui.windowShouldClose()) {
                imGui.initNewFrame();
                runnable.accept(imGui);
                imGui.render();
            }
        }
    }

    public static void runPer(long millis, @NotNull @NotNull Consumer<@NotNull JImGui> runnable) {
        try (JImGui imGui = new JImGui();){
            long latestRefresh = System.currentTimeMillis();
            while (!imGui.windowShouldClose()) {
                long currentTimeMillis = System.currentTimeMillis();
                long deltaTime = currentTimeMillis - latestRefresh;
                Thread.sleep(deltaTime / 2L);
                if (deltaTime <= millis) continue;
                imGui.initNewFrame();
                runnable.accept(imGui);
                imGui.render();
                latestRefresh = currentTimeMillis;
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @TestOnly
    @ApiStatus.Internal
    public static void runWithinPer(long limit, long millis, @NotNull @NotNull Consumer<@NotNull JImGui> runnable) {
        try (JImGui imGui = new JImGui();){
            long latestRefresh = System.currentTimeMillis();
            long end = System.currentTimeMillis() + limit;
            while (!imGui.windowShouldClose() && System.currentTimeMillis() < end) {
                long currentTimeMillis = System.currentTimeMillis();
                long deltaTime = currentTimeMillis - latestRefresh;
                Thread.sleep(deltaTime * 2L / 3L);
                if (deltaTime <= millis) continue;
                imGui.initNewFrame();
                runnable.accept(imGui);
                imGui.render();
                latestRefresh = currentTimeMillis;
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static void runPer(@NotNull LongSupplier millisSupplier, @NotNull @NotNull Consumer<@NotNull JImGui> runnable) {
        try (JImGui imGui = new JImGui();){
            long latestRefresh = System.currentTimeMillis();
            long millis = millisSupplier.getAsLong();
            while (!imGui.windowShouldClose()) {
                long currentTimeMillis = System.currentTimeMillis();
                long deltaTime = currentTimeMillis - latestRefresh;
                Thread.sleep(deltaTime / 2L);
                if (deltaTime <= millis) continue;
                imGui.initNewFrame();
                runnable.accept(imGui);
                imGui.render();
                latestRefresh = currentTimeMillis;
                millis = millisSupplier.getAsLong();
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setStringToBytes(@NotNull Function<@Nullable String, byte @Nullable []> stringToBytes) {
        SharedState.STRING_TO_BYTES = stringToBytes;
    }

    public static void cacheStringToBytes() {
        WeakHashMap cachedBytes = new WeakHashMap();
        JImGuiUtil.setStringToBytes(s -> cachedBytes.computeIfAbsent(s, SharedState::getBytesDefaultImpl));
    }

    @Contract(value="!null -> !null; null -> null", pure=true)
    public static byte @Nullable [] getBytes(@Nullable String text) {
        return SharedState.STRING_TO_BYTES != null ? SharedState.STRING_TO_BYTES.apply(text) : SharedState.getBytesDefaultImpl(text);
    }
}

