package org.ice1000.jimgui;

import org.ice1000.jimgui.*;
import org.ice1000.jimgui.flag.*;
import org.ice1000.jimgui.cpp.*;
import org.intellij.lang.annotations.*;
import org.jetbrains.annotations.*;
import java.nio.charset.StandardCharsets;

import static org.ice1000.jimgui.util.JImGuiUtil.*;

/**
 * @author ice1000
 * @since v0.13
 */
@SuppressWarnings("ALL")

public class JImFileDialogGen {
  /** package-private by design */
  JImFileDialogGen(long nativeObjectPtr) {
    this.nativeObjectPtr = nativeObjectPtr;
  }

  protected long nativeObjectPtr;

  public final boolean display(@NotNull String key, @MagicConstant(flagsFromClass = JImWindowFlags.class)int flags, float widthMin, float heightMin, float widthMax, float heightMax, long nativeObjectPtr){return display(getBytes(key), flags, widthMin, heightMin, widthMax, heightMax, nativeObjectPtr);}
  public final boolean display(@NotNull JImStr key, @MagicConstant(flagsFromClass = JImWindowFlags.class)int flags, float widthMin, float heightMin, float widthMax, float heightMax, long nativeObjectPtr){return display(key.bytes, flags, widthMin, heightMin, widthMax, heightMax, nativeObjectPtr);}
  protected static native boolean display(byte[] key, @MagicConstant(flagsFromClass = JImWindowFlags.class)int flags, float widthMin, float heightMin, float widthMax, float heightMax, long nativeObjectPtr);
  public final boolean display(@NotNull String key, @MagicConstant(flagsFromClass = JImWindowFlags.class)int flags, float widthMin, float heightMin, float widthMax, float heightMax){return display(getBytes(key), flags, widthMin, heightMin, widthMax, heightMax,this.nativeObjectPtr);}
  public final boolean display(@NotNull JImStr key, @MagicConstant(flagsFromClass = JImWindowFlags.class)int flags, float widthMin, float heightMin, float widthMax, float heightMax){return display(key.bytes, flags, widthMin, heightMin, widthMax, heightMax,this.nativeObjectPtr);}
  public final boolean display(@NotNull String key, @MagicConstant(flagsFromClass = JImWindowFlags.class)int flags, float widthMin, float heightMin){return display(getBytes(key), flags, widthMin, heightMin,FLT_MAX, FLT_MAX, this.nativeObjectPtr);}
  public final boolean display(@NotNull JImStr key, @MagicConstant(flagsFromClass = JImWindowFlags.class)int flags, float widthMin, float heightMin){return display(key.bytes, flags, widthMin, heightMin,FLT_MAX, FLT_MAX, this.nativeObjectPtr);}
  public final boolean display(@NotNull String key, @MagicConstant(flagsFromClass = JImWindowFlags.class)int flags){return display(getBytes(key), flags,0, 0, FLT_MAX, FLT_MAX, this.nativeObjectPtr);}
  public final boolean display(@NotNull JImStr key, @MagicConstant(flagsFromClass = JImWindowFlags.class)int flags){return display(key.bytes, flags,0, 0, FLT_MAX, FLT_MAX, this.nativeObjectPtr);}
  public final boolean display(@NotNull String key){return display(getBytes(key),JImWindowFlags.None, 0, 0, FLT_MAX, FLT_MAX, this.nativeObjectPtr);}
  public final boolean display(@NotNull JImStr key){return display(key.bytes,JImWindowFlags.None, 0, 0, FLT_MAX, FLT_MAX, this.nativeObjectPtr);}
  public final void openDialog(@NotNull String key, @NotNull String title, @NotNull String filters, @NotNull String basePath, int maxSelection, long nativeObjectPtr){openDialog(getBytes(key), getBytes(title), getBytes(filters), getBytes(basePath), maxSelection, nativeObjectPtr);}
  public final void openDialog(@NotNull JImStr key, @NotNull JImStr title, @NotNull JImStr filters, @NotNull JImStr basePath, int maxSelection, long nativeObjectPtr){openDialog(key.bytes, title.bytes, filters.bytes, basePath.bytes, maxSelection, nativeObjectPtr);}
  protected static native void openDialog(byte[] key, byte[] title, byte[] filters, byte[] basePath, int maxSelection, long nativeObjectPtr);
  public final void openDialog(@NotNull String key, @NotNull String title, @NotNull String filters, @NotNull String basePath, int maxSelection){openDialog(getBytes(key), getBytes(title), getBytes(filters), getBytes(basePath), maxSelection,this.nativeObjectPtr);}
  public final void openDialog(@NotNull JImStr key, @NotNull JImStr title, @NotNull JImStr filters, @NotNull JImStr basePath, int maxSelection){openDialog(key.bytes, title.bytes, filters.bytes, basePath.bytes, maxSelection,this.nativeObjectPtr);}
  public final void openDialog(@NotNull String key, @NotNull String title, @NotNull String filters, @NotNull String basePath){openDialog(getBytes(key), getBytes(title), getBytes(filters), getBytes(basePath),1, this.nativeObjectPtr);}
  public final void openDialog(@NotNull JImStr key, @NotNull JImStr title, @NotNull JImStr filters, @NotNull JImStr basePath){openDialog(key.bytes, title.bytes, filters.bytes, basePath.bytes,1, this.nativeObjectPtr);}
  public final void openModal(@NotNull String key, @NotNull String title, @NotNull String filters, @NotNull String basePath, int maxSelection, long nativeObjectPtr){openModal(getBytes(key), getBytes(title), getBytes(filters), getBytes(basePath), maxSelection, nativeObjectPtr);}
  public final void openModal(@NotNull JImStr key, @NotNull JImStr title, @NotNull JImStr filters, @NotNull JImStr basePath, int maxSelection, long nativeObjectPtr){openModal(key.bytes, title.bytes, filters.bytes, basePath.bytes, maxSelection, nativeObjectPtr);}
  protected static native void openModal(byte[] key, byte[] title, byte[] filters, byte[] basePath, int maxSelection, long nativeObjectPtr);
  public final void openModal(@NotNull String key, @NotNull String title, @NotNull String filters, @NotNull String basePath, int maxSelection){openModal(getBytes(key), getBytes(title), getBytes(filters), getBytes(basePath), maxSelection,this.nativeObjectPtr);}
  public final void openModal(@NotNull JImStr key, @NotNull JImStr title, @NotNull JImStr filters, @NotNull JImStr basePath, int maxSelection){openModal(key.bytes, title.bytes, filters.bytes, basePath.bytes, maxSelection,this.nativeObjectPtr);}
  public final void openModal(@NotNull String key, @NotNull String title, @NotNull String filters, @NotNull String basePath){openModal(getBytes(key), getBytes(title), getBytes(filters), getBytes(basePath),1, this.nativeObjectPtr);}
  public final void openModal(@NotNull JImStr key, @NotNull JImStr title, @NotNull JImStr filters, @NotNull JImStr basePath){openModal(key.bytes, title.bytes, filters.bytes, basePath.bytes,1, this.nativeObjectPtr);}
  public static native void close(long nativeObjectPtr);
  public final void close(){close(this.nativeObjectPtr);}
  public static native boolean isOk(long nativeObjectPtr);
  public final boolean isOk(){return isOk(this.nativeObjectPtr);}
  public final boolean wasOpenedThisFrame(@NotNull String key, long nativeObjectPtr){return wasOpenedThisFrame(getBytes(key), nativeObjectPtr);}
  public final boolean wasOpenedThisFrame(@NotNull JImStr key, long nativeObjectPtr){return wasOpenedThisFrame(key.bytes, nativeObjectPtr);}
  protected static native boolean wasOpenedThisFrame(byte[] key, long nativeObjectPtr);
  public final boolean wasOpenedThisFrame(@NotNull String key){return wasOpenedThisFrame(getBytes(key),this.nativeObjectPtr);}
  public final boolean wasOpenedThisFrame(@NotNull JImStr key){return wasOpenedThisFrame(key.bytes,this.nativeObjectPtr);}
  public final boolean isOpened(@NotNull String text, long nativeObjectPtr){return isOpened(getBytes(text), nativeObjectPtr);}
  public final boolean isOpened(@NotNull JImStr text, long nativeObjectPtr){return isOpened(text.bytes, nativeObjectPtr);}
  protected static native boolean isOpened(byte[] text, long nativeObjectPtr);
  public final boolean isOpened(@NotNull String text){return isOpened(getBytes(text),this.nativeObjectPtr);}
  public final boolean isOpened(@NotNull JImStr text){return isOpened(text.bytes,this.nativeObjectPtr);}
  public final void setExtensionInfo(@NotNull String filters, @NotNull JImVec4 color, @NotNull String text, long nativeObjectPtr){setExtensionInfo(getBytes(filters), color.nativeObjectPtr, getBytes(text), nativeObjectPtr);}
  public final void setExtensionInfo(@NotNull JImStr filters, @NotNull JImVec4 color, @NotNull JImStr text, long nativeObjectPtr){setExtensionInfo(filters.bytes, color.nativeObjectPtr, text.bytes, nativeObjectPtr);}
  protected static native void setExtensionInfo(byte[] filters, long color, byte[] text, long nativeObjectPtr);
  public final void setExtensionInfo(@NotNull String filters, @NotNull JImVec4 color, @NotNull String text){setExtensionInfo(getBytes(filters), color.nativeObjectPtr, getBytes(text),this.nativeObjectPtr);}
  public final void setExtensionInfo(@NotNull JImStr filters, @NotNull JImVec4 color, @NotNull JImStr text){setExtensionInfo(filters.bytes, color.nativeObjectPtr, text.bytes,this.nativeObjectPtr);}
  public final boolean getExtensionInfo(@NotNull String filters, @NotNull JImVec4 color, @NotNull NativeString text, long nativeObjectPtr){return getExtensionInfo(getBytes(filters), color.nativeObjectPtr, text.nativeObjectPtr, nativeObjectPtr);}
  public final boolean getExtensionInfo(@NotNull JImStr filters, @NotNull JImVec4 color, @NotNull NativeString text, long nativeObjectPtr){return getExtensionInfo(filters.bytes, color.nativeObjectPtr, text.nativeObjectPtr, nativeObjectPtr);}
  protected static native boolean getExtensionInfo(byte[] filters, long color, long text, long nativeObjectPtr);
  public final boolean getExtensionInfo(@NotNull String filters, @NotNull JImVec4 color, @NotNull NativeString text){return getExtensionInfo(getBytes(filters), color.nativeObjectPtr, text.nativeObjectPtr,this.nativeObjectPtr);}
  public final boolean getExtensionInfo(@NotNull JImStr filters, @NotNull JImVec4 color, @NotNull NativeString text){return getExtensionInfo(filters.bytes, color.nativeObjectPtr, text.nativeObjectPtr,this.nativeObjectPtr);}
  public static native void clearExtensionInfo(long nativeObjectPtr);
  public final void clearExtensionInfo(){clearExtensionInfo(this.nativeObjectPtr);}

}