package org.ice1000.jimgui;

import org.ice1000.jimgui.*;
import org.ice1000.jimgui.flag.*;
import org.ice1000.jimgui.cpp.*;
import org.intellij.lang.annotations.*;
import org.jetbrains.annotations.*;
import java.nio.charset.StandardCharsets;

import static org.ice1000.jimgui.util.JImGuiUtil.*;

/**
 * @author ice1000
 * @since v0.1
 */
@SuppressWarnings("ALL")

public class JImGuiDrawListGen {
  /** subclass-private by design */
  protected long nativeObjectPtr;

  /** package-private by design */
  JImGuiDrawListGen(long nativeObjectPtr) {
    this.nativeObjectPtr = nativeObjectPtr;
  }

  public @MagicConstant(flagsFromClass = JImDrawListFlags.class)int getFlags(){return getFlags(nativeObjectPtr);}
  protected static native @MagicConstant(flagsFromClass = JImDrawListFlags.class)int getFlags(long nativeObjectPtr);
  public void setFlags(@MagicConstant(flagsFromClass = JImDrawListFlags.class)int newValue) {setFlags(nativeObjectPtr, newValue);}
  protected static native void setFlags(long nativeObjectPtr, @MagicConstant(flagsFromClass = JImDrawListFlags.class)int newValue);
  private static native void pushClipRect(float widthclipRectMin, float heightclipRectMin, float widthclipRectMax, float heightclipRectMax, boolean intersectWithCurrentClipRect, long nativeObjectPtr);
  public final void pushClipRect(float widthclipRectMin, float heightclipRectMin, float widthclipRectMax, float heightclipRectMax, boolean intersectWithCurrentClipRect){pushClipRect(widthclipRectMin, heightclipRectMin, widthclipRectMax, heightclipRectMax, intersectWithCurrentClipRect,this.nativeObjectPtr);}
  public final void pushClipRect(float widthclipRectMin, float heightclipRectMin, float widthclipRectMax, float heightclipRectMax){pushClipRect(widthclipRectMin, heightclipRectMin, widthclipRectMax, heightclipRectMax,false, this.nativeObjectPtr);}
  private static native void pushClipRectFullScreen(long nativeObjectPtr);
  public final void pushClipRectFullScreen(){pushClipRectFullScreen(this.nativeObjectPtr);}
  private static native void popClipRect(long nativeObjectPtr);
  public final void popClipRect(){popClipRect(this.nativeObjectPtr);}
  private final void pushTextureID(@NotNull JImTextureID textureID, long nativeObjectPtr){pushTextureID(textureID.nativeObjectPtr, nativeObjectPtr);}
  protected static native void pushTextureID(long textureID, long nativeObjectPtr);
  public final void pushTextureID(@NotNull JImTextureID textureID){pushTextureID(textureID.nativeObjectPtr,this.nativeObjectPtr);}
  private static native void popTextureID(long nativeObjectPtr);
  public final void popTextureID(){popTextureID(this.nativeObjectPtr);}
  protected static native void addLine(float aX, float aY, float bX, float bY, int u32Color, float thickness, long nativeObjectPtr);
  public final void addLine(float aX, float aY, float bX, float bY, int u32Color, float thickness){addLine(aX, aY, bX, bY, u32Color, thickness,this.nativeObjectPtr);}
  public final void addLine(float aX, float aY, float bX, float bY, int u32Color){addLine(aX, aY, bX, bY, u32Color,1, this.nativeObjectPtr);}
  private static native void addRect(float aX, float aY, float bX, float bY, int u32Color, float rounding, @MagicConstant(flagsFromClass = JImDrawCornerFlags.class)int roundingCornersFlags, float thickness, long nativeObjectPtr);
  public final void addRect(float aX, float aY, float bX, float bY, int u32Color, float rounding, @MagicConstant(flagsFromClass = JImDrawCornerFlags.class)int roundingCornersFlags, float thickness){addRect(aX, aY, bX, bY, u32Color, rounding, roundingCornersFlags, thickness,this.nativeObjectPtr);}
  public final void addRect(float aX, float aY, float bX, float bY, int u32Color, float rounding, @MagicConstant(flagsFromClass = JImDrawCornerFlags.class)int roundingCornersFlags){addRect(aX, aY, bX, bY, u32Color, rounding, roundingCornersFlags,1, this.nativeObjectPtr);}
  public final void addRect(float aX, float aY, float bX, float bY, int u32Color, float rounding){addRect(aX, aY, bX, bY, u32Color, rounding,JImDrawCornerFlags.All, 1, this.nativeObjectPtr);}
  public final void addRect(float aX, float aY, float bX, float bY, int u32Color){addRect(aX, aY, bX, bY, u32Color,0, JImDrawCornerFlags.All, 1, this.nativeObjectPtr);}
  private static native void addRectFilled(float aX, float aY, float bX, float bY, int u32Color, float rounding, @MagicConstant(flagsFromClass = JImDrawCornerFlags.class)int roundingCornersFlags, long nativeObjectPtr);
  public final void addRectFilled(float aX, float aY, float bX, float bY, int u32Color, float rounding, @MagicConstant(flagsFromClass = JImDrawCornerFlags.class)int roundingCornersFlags){addRectFilled(aX, aY, bX, bY, u32Color, rounding, roundingCornersFlags,this.nativeObjectPtr);}
  public final void addRectFilled(float aX, float aY, float bX, float bY, int u32Color, float rounding){addRectFilled(aX, aY, bX, bY, u32Color, rounding,JImDrawCornerFlags.All, this.nativeObjectPtr);}
  public final void addRectFilled(float aX, float aY, float bX, float bY, int u32Color){addRectFilled(aX, aY, bX, bY, u32Color,0, JImDrawCornerFlags.All, this.nativeObjectPtr);}
  private static native void addRectFilledMultiColor(float aX, float aY, float bX, float bY, int colorUpperLeft, int colorUpperRight, int colorBottomRight, int colorBottomLeft, long nativeObjectPtr);
  public final void addRectFilledMultiColor(float aX, float aY, float bX, float bY, int colorUpperLeft, int colorUpperRight, int colorBottomRight, int colorBottomLeft){addRectFilledMultiColor(aX, aY, bX, bY, colorUpperLeft, colorUpperRight, colorBottomRight, colorBottomLeft,this.nativeObjectPtr);}
  private static native void addQuad(float aX, float aY, float bX, float bY, float cX, float cY, float dX, float dY, int u32Color, float thickness, long nativeObjectPtr);
  public final void addQuad(float aX, float aY, float bX, float bY, float cX, float cY, float dX, float dY, int u32Color, float thickness){addQuad(aX, aY, bX, bY, cX, cY, dX, dY, u32Color, thickness,this.nativeObjectPtr);}
  public final void addQuad(float aX, float aY, float bX, float bY, float cX, float cY, float dX, float dY, int u32Color){addQuad(aX, aY, bX, bY, cX, cY, dX, dY, u32Color,1, this.nativeObjectPtr);}
  private static native void addQuadFilled(float aX, float aY, float bX, float bY, float cX, float cY, float dX, float dY, int u32Color, long nativeObjectPtr);
  public final void addQuadFilled(float aX, float aY, float bX, float bY, float cX, float cY, float dX, float dY, int u32Color){addQuadFilled(aX, aY, bX, bY, cX, cY, dX, dY, u32Color,this.nativeObjectPtr);}
  private static native void addTriangle(float aX, float aY, float bX, float bY, float cX, float cY, int u32Color, float thickness, long nativeObjectPtr);
  public final void addTriangle(float aX, float aY, float bX, float bY, float cX, float cY, int u32Color, float thickness){addTriangle(aX, aY, bX, bY, cX, cY, u32Color, thickness,this.nativeObjectPtr);}
  public final void addTriangle(float aX, float aY, float bX, float bY, float cX, float cY, int u32Color){addTriangle(aX, aY, bX, bY, cX, cY, u32Color,1, this.nativeObjectPtr);}
  private static native void addTriangleFilled(float aX, float aY, float bX, float bY, float cX, float cY, int u32Color, long nativeObjectPtr);
  public final void addTriangleFilled(float aX, float aY, float bX, float bY, float cX, float cY, int u32Color){addTriangleFilled(aX, aY, bX, bY, cX, cY, u32Color,this.nativeObjectPtr);}
  private static native void addCircle(float centreX, float centreY, float radius, int u32Color, int numSegments, float thickness, long nativeObjectPtr);
  public final void addCircle(float centreX, float centreY, float radius, int u32Color, int numSegments, float thickness){addCircle(centreX, centreY, radius, u32Color, numSegments, thickness,this.nativeObjectPtr);}
  public final void addCircle(float centreX, float centreY, float radius, int u32Color, int numSegments){addCircle(centreX, centreY, radius, u32Color, numSegments,1, this.nativeObjectPtr);}
  public final void addCircle(float centreX, float centreY, float radius, int u32Color){addCircle(centreX, centreY, radius, u32Color,12, 1, this.nativeObjectPtr);}
  private static native void addCircleFilled(float centreX, float centreY, float radius, int u32Color, int numSegments, long nativeObjectPtr);
  public final void addCircleFilled(float centreX, float centreY, float radius, int u32Color, int numSegments){addCircleFilled(centreX, centreY, radius, u32Color, numSegments,this.nativeObjectPtr);}
  public final void addCircleFilled(float centreX, float centreY, float radius, int u32Color){addCircleFilled(centreX, centreY, radius, u32Color,12, this.nativeObjectPtr);}
  private static native void addNgon(float centreX, float centreY, float radius, int u32Color, int numSegments, float thickness, long nativeObjectPtr);
  public final void addNgon(float centreX, float centreY, float radius, int u32Color, int numSegments, float thickness){addNgon(centreX, centreY, radius, u32Color, numSegments, thickness,this.nativeObjectPtr);}
  public final void addNgon(float centreX, float centreY, float radius, int u32Color, int numSegments){addNgon(centreX, centreY, radius, u32Color, numSegments,1, this.nativeObjectPtr);}
  public final void addNgon(float centreX, float centreY, float radius, int u32Color){addNgon(centreX, centreY, radius, u32Color,12, 1, this.nativeObjectPtr);}
  private static native void addNgonFilled(float centreX, float centreY, float radius, int u32Color, int numSegments, long nativeObjectPtr);
  public final void addNgonFilled(float centreX, float centreY, float radius, int u32Color, int numSegments){addNgonFilled(centreX, centreY, radius, u32Color, numSegments,this.nativeObjectPtr);}
  public final void addNgonFilled(float centreX, float centreY, float radius, int u32Color){addNgonFilled(centreX, centreY, radius, u32Color,12, this.nativeObjectPtr);}
  protected final void addText(@NotNull JImFont font, float fontSize, float posX, float posY, int u32Color, @NotNull String text, float wrapWidth, @NotNull JImVec4 cpuFineClipRect, long nativeObjectPtr){addText(font.nativeObjectPtr, fontSize, posX, posY, u32Color, text.getBytes(StandardCharsets.UTF_8), wrapWidth, cpuFineClipRect.nativeObjectPtr, nativeObjectPtr);}
  protected static native void addText(long font, float fontSize, float posX, float posY, int u32Color, byte[] text, float wrapWidth, long cpuFineClipRect, long nativeObjectPtr);
  public final void addText(@NotNull JImFont font, float fontSize, float posX, float posY, int u32Color, @NotNull String text, float wrapWidth, @NotNull JImVec4 cpuFineClipRect){addText(font.nativeObjectPtr, fontSize, posX, posY, u32Color, text.getBytes(StandardCharsets.UTF_8), wrapWidth, cpuFineClipRect.nativeObjectPtr,this.nativeObjectPtr);}
  public final void addText(@NotNull JImFont font, float fontSize, float posX, float posY, int u32Color, @NotNull String text, float wrapWidth){addText(font.nativeObjectPtr, fontSize, posX, posY, u32Color, text.getBytes(StandardCharsets.UTF_8), wrapWidth,0, this.nativeObjectPtr);}
  public final void addText(@NotNull JImFont font, float fontSize, float posX, float posY, int u32Color, @NotNull String text){addText(font.nativeObjectPtr, fontSize, posX, posY, u32Color, text.getBytes(StandardCharsets.UTF_8),0, 0, this.nativeObjectPtr);}
  private final void addImage(@NotNull JImTextureID userTextureID, float aX, float aY, float bX, float bY, float uvAX, float uvAY, float uvBX, float uvBY, int color, long nativeObjectPtr){addImage(userTextureID.nativeObjectPtr, aX, aY, bX, bY, uvAX, uvAY, uvBX, uvBY, color, nativeObjectPtr);}
  protected static native void addImage(long userTextureID, float aX, float aY, float bX, float bY, float uvAX, float uvAY, float uvBX, float uvBY, int color, long nativeObjectPtr);
  public final void addImage(@NotNull JImTextureID userTextureID, float aX, float aY, float bX, float bY, float uvAX, float uvAY, float uvBX, float uvBY, int color){addImage(userTextureID.nativeObjectPtr, aX, aY, bX, bY, uvAX, uvAY, uvBX, uvBY, color,this.nativeObjectPtr);}
  public final void addImage(@NotNull JImTextureID userTextureID, float aX, float aY, float bX, float bY, float uvAX, float uvAY, float uvBX, float uvBY){addImage(userTextureID.nativeObjectPtr, aX, aY, bX, bY, uvAX, uvAY, uvBX, uvBY,-1, this.nativeObjectPtr);}
  public final void addImage(@NotNull JImTextureID userTextureID, float aX, float aY, float bX, float bY, float uvAX, float uvAY){addImage(userTextureID.nativeObjectPtr, aX, aY, bX, bY, uvAX, uvAY,1,1, -1, this.nativeObjectPtr);}
  public final void addImage(@NotNull JImTextureID userTextureID, float aX, float aY, float bX, float bY){addImage(userTextureID.nativeObjectPtr, aX, aY, bX, bY,0,0, 1,1, -1, this.nativeObjectPtr);}
  private final void addImageQuad(@NotNull JImTextureID userTextureID, float aX, float aY, float bX, float bY, float cX, float cY, float dX, float dY, float uvAX, float uvAY, float uvBX, float uvBY, float uvCX, float uvCY, float uvDX, float uvDY, int color, long nativeObjectPtr){addImageQuad(userTextureID.nativeObjectPtr, aX, aY, bX, bY, cX, cY, dX, dY, uvAX, uvAY, uvBX, uvBY, uvCX, uvCY, uvDX, uvDY, color, nativeObjectPtr);}
  protected static native void addImageQuad(long userTextureID, float aX, float aY, float bX, float bY, float cX, float cY, float dX, float dY, float uvAX, float uvAY, float uvBX, float uvBY, float uvCX, float uvCY, float uvDX, float uvDY, int color, long nativeObjectPtr);
  public final void addImageQuad(@NotNull JImTextureID userTextureID, float aX, float aY, float bX, float bY, float cX, float cY, float dX, float dY, float uvAX, float uvAY, float uvBX, float uvBY, float uvCX, float uvCY, float uvDX, float uvDY, int color){addImageQuad(userTextureID.nativeObjectPtr, aX, aY, bX, bY, cX, cY, dX, dY, uvAX, uvAY, uvBX, uvBY, uvCX, uvCY, uvDX, uvDY, color,this.nativeObjectPtr);}
  public final void addImageQuad(@NotNull JImTextureID userTextureID, float aX, float aY, float bX, float bY, float cX, float cY, float dX, float dY, float uvAX, float uvAY, float uvBX, float uvBY, float uvCX, float uvCY, float uvDX, float uvDY){addImageQuad(userTextureID.nativeObjectPtr, aX, aY, bX, bY, cX, cY, dX, dY, uvAX, uvAY, uvBX, uvBY, uvCX, uvCY, uvDX, uvDY,-1, this.nativeObjectPtr);}
  public final void addImageQuad(@NotNull JImTextureID userTextureID, float aX, float aY, float bX, float bY, float cX, float cY, float dX, float dY, float uvAX, float uvAY, float uvBX, float uvBY, float uvCX, float uvCY){addImageQuad(userTextureID.nativeObjectPtr, aX, aY, bX, bY, cX, cY, dX, dY, uvAX, uvAY, uvBX, uvBY, uvCX, uvCY,0,1, -1, this.nativeObjectPtr);}
  public final void addImageQuad(@NotNull JImTextureID userTextureID, float aX, float aY, float bX, float bY, float cX, float cY, float dX, float dY, float uvAX, float uvAY, float uvBX, float uvBY){addImageQuad(userTextureID.nativeObjectPtr, aX, aY, bX, bY, cX, cY, dX, dY, uvAX, uvAY, uvBX, uvBY,1,1, 0,1, -1, this.nativeObjectPtr);}
  public final void addImageQuad(@NotNull JImTextureID userTextureID, float aX, float aY, float bX, float bY, float cX, float cY, float dX, float dY, float uvAX, float uvAY){addImageQuad(userTextureID.nativeObjectPtr, aX, aY, bX, bY, cX, cY, dX, dY, uvAX, uvAY,1,0, 1,1, 0,1, -1, this.nativeObjectPtr);}
  public final void addImageQuad(@NotNull JImTextureID userTextureID, float aX, float aY, float bX, float bY, float cX, float cY, float dX, float dY){addImageQuad(userTextureID.nativeObjectPtr, aX, aY, bX, bY, cX, cY, dX, dY,0,0, 1,0, 1,1, 0,1, -1, this.nativeObjectPtr);}
  private final void addImageRounded(@NotNull JImTextureID userTextureID, float aX, float aY, float bX, float bY, float uvAX, float uvAY, float uvBX, float uvBY, int color, float rounding, @MagicConstant(flagsFromClass = JImDrawCornerFlags.class)int roundingCornersFlags, long nativeObjectPtr){addImageRounded(userTextureID.nativeObjectPtr, aX, aY, bX, bY, uvAX, uvAY, uvBX, uvBY, color, rounding, roundingCornersFlags, nativeObjectPtr);}
  protected static native void addImageRounded(long userTextureID, float aX, float aY, float bX, float bY, float uvAX, float uvAY, float uvBX, float uvBY, int color, float rounding, @MagicConstant(flagsFromClass = JImDrawCornerFlags.class)int roundingCornersFlags, long nativeObjectPtr);
  public final void addImageRounded(@NotNull JImTextureID userTextureID, float aX, float aY, float bX, float bY, float uvAX, float uvAY, float uvBX, float uvBY, int color, float rounding, @MagicConstant(flagsFromClass = JImDrawCornerFlags.class)int roundingCornersFlags){addImageRounded(userTextureID.nativeObjectPtr, aX, aY, bX, bY, uvAX, uvAY, uvBX, uvBY, color, rounding, roundingCornersFlags,this.nativeObjectPtr);}
  public final void addImageRounded(@NotNull JImTextureID userTextureID, float aX, float aY, float bX, float bY, float uvAX, float uvAY, float uvBX, float uvBY, int color, float rounding){addImageRounded(userTextureID.nativeObjectPtr, aX, aY, bX, bY, uvAX, uvAY, uvBX, uvBY, color, rounding,JImDrawCornerFlags.All, this.nativeObjectPtr);}
  private static native void addBezierCubic(float p1X, float p1Y, float p2X, float p2Y, float p3X, float p3Y, float p4X, float p4Y, int u32Color, float thickness, int numSegments, long nativeObjectPtr);
  public final void addBezierCubic(float p1X, float p1Y, float p2X, float p2Y, float p3X, float p3Y, float p4X, float p4Y, int u32Color, float thickness, int numSegments){addBezierCubic(p1X, p1Y, p2X, p2Y, p3X, p3Y, p4X, p4Y, u32Color, thickness, numSegments,this.nativeObjectPtr);}
  public final void addBezierCubic(float p1X, float p1Y, float p2X, float p2Y, float p3X, float p3Y, float p4X, float p4Y, int u32Color, float thickness){addBezierCubic(p1X, p1Y, p2X, p2Y, p3X, p3Y, p4X, p4Y, u32Color, thickness,0, this.nativeObjectPtr);}
  public final void addBezierCubic(float p1X, float p1Y, float p2X, float p2Y, float p3X, float p3Y, float p4X, float p4Y, int u32Color){addBezierCubic(p1X, p1Y, p2X, p2Y, p3X, p3Y, p4X, p4Y, u32Color,1, 0, this.nativeObjectPtr);}
  private static native void addBezierQuadratic(float p1X, float p1Y, float p2X, float p2Y, float p3X, float p3Y, int u32Color, float thickness, int numSegments, long nativeObjectPtr);
  public final void addBezierQuadratic(float p1X, float p1Y, float p2X, float p2Y, float p3X, float p3Y, int u32Color, float thickness, int numSegments){addBezierQuadratic(p1X, p1Y, p2X, p2Y, p3X, p3Y, u32Color, thickness, numSegments,this.nativeObjectPtr);}
  public final void addBezierQuadratic(float p1X, float p1Y, float p2X, float p2Y, float p3X, float p3Y, int u32Color, float thickness){addBezierQuadratic(p1X, p1Y, p2X, p2Y, p3X, p3Y, u32Color, thickness,0, this.nativeObjectPtr);}
  public final void addBezierQuadratic(float p1X, float p1Y, float p2X, float p2Y, float p3X, float p3Y, int u32Color){addBezierQuadratic(p1X, p1Y, p2X, p2Y, p3X, p3Y, u32Color,1, 0, this.nativeObjectPtr);}
  private static native void pathClear(long nativeObjectPtr);
  public final void pathClear(){pathClear(this.nativeObjectPtr);}
  private static native void pathLineTo(float posX, float posY, long nativeObjectPtr);
  public final void pathLineTo(float posX, float posY){pathLineTo(posX, posY,this.nativeObjectPtr);}
  private static native void pathLineToMergeDuplicate(float posX, float posY, long nativeObjectPtr);
  public final void pathLineToMergeDuplicate(float posX, float posY){pathLineToMergeDuplicate(posX, posY,this.nativeObjectPtr);}
  private static native void pathFillConvex(int u32Color, long nativeObjectPtr);
  public final void pathFillConvex(int u32Color){pathFillConvex(u32Color,this.nativeObjectPtr);}
  private static native void pathStroke(int u32Color, boolean closed, float thickness, long nativeObjectPtr);
  public final void pathStroke(int u32Color, boolean closed, float thickness){pathStroke(u32Color, closed, thickness,this.nativeObjectPtr);}
  public final void pathStroke(int u32Color, boolean closed){pathStroke(u32Color, closed,1, this.nativeObjectPtr);}
  private static native void pathArcTo(float centreX, float centreY, float radius, float aMin, float aMax, int numSegments, long nativeObjectPtr);
  public final void pathArcTo(float centreX, float centreY, float radius, float aMin, float aMax, int numSegments){pathArcTo(centreX, centreY, radius, aMin, aMax, numSegments,this.nativeObjectPtr);}
  public final void pathArcTo(float centreX, float centreY, float radius, float aMin, float aMax){pathArcTo(centreX, centreY, radius, aMin, aMax,10, this.nativeObjectPtr);}
  private static native void pathArcToFast(float centreX, float centreY, float radius, int aMinOf12, int aMaxOf12, long nativeObjectPtr);
  public final void pathArcToFast(float centreX, float centreY, float radius, int aMinOf12, int aMaxOf12){pathArcToFast(centreX, centreY, radius, aMinOf12, aMaxOf12,this.nativeObjectPtr);}
  private static native void pathBezierCubicCurveTo(float p2X, float p2Y, float p3X, float p3Y, float p4X, float p4Y, int numSegments, long nativeObjectPtr);
  public final void pathBezierCubicCurveTo(float p2X, float p2Y, float p3X, float p3Y, float p4X, float p4Y, int numSegments){pathBezierCubicCurveTo(p2X, p2Y, p3X, p3Y, p4X, p4Y, numSegments,this.nativeObjectPtr);}
  public final void pathBezierCubicCurveTo(float p2X, float p2Y, float p3X, float p3Y, float p4X, float p4Y){pathBezierCubicCurveTo(p2X, p2Y, p3X, p3Y, p4X, p4Y,0, this.nativeObjectPtr);}
  private static native void pathBezierQuadraticCurveTo(float p2X, float p2Y, float p3X, float p3Y, int numSegments, long nativeObjectPtr);
  public final void pathBezierQuadraticCurveTo(float p2X, float p2Y, float p3X, float p3Y, int numSegments){pathBezierQuadraticCurveTo(p2X, p2Y, p3X, p3Y, numSegments,this.nativeObjectPtr);}
  public final void pathBezierQuadraticCurveTo(float p2X, float p2Y, float p3X, float p3Y){pathBezierQuadraticCurveTo(p2X, p2Y, p3X, p3Y,0, this.nativeObjectPtr);}
  private static native void pathRect(float rectMinX, float rectMinY, float rectMaxX, float rectMaxY, float rounding, @MagicConstant(flagsFromClass = JImDrawCornerFlags.class)int roundingCornersFlags, long nativeObjectPtr);
  public final void pathRect(float rectMinX, float rectMinY, float rectMaxX, float rectMaxY, float rounding, @MagicConstant(flagsFromClass = JImDrawCornerFlags.class)int roundingCornersFlags){pathRect(rectMinX, rectMinY, rectMaxX, rectMaxY, rounding, roundingCornersFlags,this.nativeObjectPtr);}
  public final void pathRect(float rectMinX, float rectMinY, float rectMaxX, float rectMaxY, float rounding){pathRect(rectMinX, rectMinY, rectMaxX, rectMaxY, rounding,JImDrawCornerFlags.All, this.nativeObjectPtr);}
  public final void pathRect(float rectMinX, float rectMinY, float rectMaxX, float rectMaxY){pathRect(rectMinX, rectMinY, rectMaxX, rectMaxY,0, JImDrawCornerFlags.All, this.nativeObjectPtr);}
  private static native void addDrawCmd(long nativeObjectPtr);
  public final void addDrawCmd(){addDrawCmd(this.nativeObjectPtr);}
  private static native void channelsSplit(int channelsCount, long nativeObjectPtr);
  public final void channelsSplit(int channelsCount){channelsSplit(channelsCount,this.nativeObjectPtr);}
  private static native void channelsMerge(long nativeObjectPtr);
  public final void channelsMerge(){channelsMerge(this.nativeObjectPtr);}
  private static native void channelsSetCurrent(int channelsIndex, long nativeObjectPtr);
  public final void channelsSetCurrent(int channelsIndex){channelsSetCurrent(channelsIndex,this.nativeObjectPtr);}
  private static native void primReserve(int idxCount, int vtxCount, long nativeObjectPtr);
  public final void primReserve(int idxCount, int vtxCount){primReserve(idxCount, vtxCount,this.nativeObjectPtr);}
  private static native void primRect(float aX, float aY, float bX, float bY, int u32Color, long nativeObjectPtr);
  public final void primRect(float aX, float aY, float bX, float bY, int u32Color){primRect(aX, aY, bX, bY, u32Color,this.nativeObjectPtr);}
  private static native void primRectUV(float aX, float aY, float bX, float bY, float uvAX, float uvAY, float uvBX, float uvBY, int u32Color, long nativeObjectPtr);
  public final void primRectUV(float aX, float aY, float bX, float bY, float uvAX, float uvAY, float uvBX, float uvBY, int u32Color){primRectUV(aX, aY, bX, bY, uvAX, uvAY, uvBX, uvBY, u32Color,this.nativeObjectPtr);}
  private static native void primQuadUV(float aX, float aY, float bX, float bY, float cX, float cY, float dX, float dY, float uvAX, float uvAY, float uvBX, float uvBY, float uvCX, float uvCY, float uvDX, float uvDY, int u32Color, long nativeObjectPtr);
  public final void primQuadUV(float aX, float aY, float bX, float bY, float cX, float cY, float dX, float dY, float uvAX, float uvAY, float uvBX, float uvBY, float uvCX, float uvCY, float uvDX, float uvDY, int u32Color){primQuadUV(aX, aY, bX, bY, cX, cY, dX, dY, uvAX, uvAY, uvBX, uvBY, uvCX, uvCY, uvDX, uvDY, u32Color,this.nativeObjectPtr);}
  private static native void primWriteVtx(float posX, float posY, float uvX, float uvY, int u32Color, long nativeObjectPtr);
  public final void primWriteVtx(float posX, float posY, float uvX, float uvY, int u32Color){primWriteVtx(posX, posY, uvX, uvY, u32Color,this.nativeObjectPtr);}
  private static native void primWriteIdx(int idx, long nativeObjectPtr);
  public final void primWriteIdx(int idx){primWriteIdx(idx,this.nativeObjectPtr);}
  private static native void primVtx(float posX, float posY, float uvX, float uvY, int u32Color, long nativeObjectPtr);
  public final void primVtx(float posX, float posY, float uvX, float uvY, int u32Color){primVtx(posX, posY, uvX, uvY, u32Color,this.nativeObjectPtr);}

}