package org.ice1000.jimgui;

import org.ice1000.jimgui.*;
import org.ice1000.jimgui.flag.*;
import org.ice1000.jimgui.cpp.*;
import org.intellij.lang.annotations.*;
import org.jetbrains.annotations.*;
import java.nio.charset.StandardCharsets;

import static org.ice1000.jimgui.util.JImGuiUtil.*;

/**
 * @author ice1000
 * @since v0.1
 */
@SuppressWarnings("ALL")

public class JImGuiFontAtlasGen {
protected long nativeObjectPtr;

  /** package-private by design */
  JImGuiFontAtlasGen(long nativeObjectPtr) {
    this.nativeObjectPtr = nativeObjectPtr;
  }

  private static native void setTexUvScaleX(long nativeObjectPtr,float newValue);
  public void setTexUvScaleX(float newValue){setTexUvScaleX(nativeObjectPtr, newValue); }
  private static native float getTexUvScaleX(long nativeObjectPtr);
  public float getTexUvScaleX(){return getTexUvScaleX(nativeObjectPtr);}
  private static native void setTexUvScaleY(long nativeObjectPtr,float newValue);
  public void setTexUvScaleY(float newValue){setTexUvScaleY(nativeObjectPtr, newValue); }
  private static native float getTexUvScaleY(long nativeObjectPtr);
  public float getTexUvScaleY(){return getTexUvScaleY(nativeObjectPtr);}
  private static native void setTexUvWhitePixelX(long nativeObjectPtr,float newValue);
  public void setTexUvWhitePixelX(float newValue){setTexUvWhitePixelX(nativeObjectPtr, newValue); }
  private static native float getTexUvWhitePixelX(long nativeObjectPtr);
  public float getTexUvWhitePixelX(){return getTexUvWhitePixelX(nativeObjectPtr);}
  private static native void setTexUvWhitePixelY(long nativeObjectPtr,float newValue);
  public void setTexUvWhitePixelY(float newValue){setTexUvWhitePixelY(nativeObjectPtr, newValue); }
  private static native float getTexUvWhitePixelY(long nativeObjectPtr);
  public float getTexUvWhitePixelY(){return getTexUvWhitePixelY(nativeObjectPtr);}
  public @MagicConstant(flagsFromClass = JImFontAtlasFlags.class)int getFlags(){return getFlags(nativeObjectPtr);}
  protected static native @MagicConstant(flagsFromClass = JImFontAtlasFlags.class)int getFlags(long nativeObjectPtr);
  public void setFlags(@MagicConstant(flagsFromClass = JImFontAtlasFlags.class)int newValue) {setFlags(nativeObjectPtr, newValue);}
  protected static native void setFlags(long nativeObjectPtr, @MagicConstant(flagsFromClass = JImFontAtlasFlags.class)int newValue);
  public int getTexWidth(){return getTexWidth(nativeObjectPtr);}
  protected static native int getTexWidth(long nativeObjectPtr);
  public void setTexWidth(int newValue) {setTexWidth(nativeObjectPtr, newValue);}
  protected static native void setTexWidth(long nativeObjectPtr, int newValue);
  public int getTexHeight(){return getTexHeight(nativeObjectPtr);}
  protected static native int getTexHeight(long nativeObjectPtr);
  public void setTexHeight(int newValue) {setTexHeight(nativeObjectPtr, newValue);}
  protected static native void setTexHeight(long nativeObjectPtr, int newValue);
  public int getTexDesiredWidth(){return getTexDesiredWidth(nativeObjectPtr);}
  protected static native int getTexDesiredWidth(long nativeObjectPtr);
  public void setTexDesiredWidth(int newValue) {setTexDesiredWidth(nativeObjectPtr, newValue);}
  protected static native void setTexDesiredWidth(long nativeObjectPtr, int newValue);
  public int getTexGlyphPadding(){return getTexGlyphPadding(nativeObjectPtr);}
  protected static native int getTexGlyphPadding(long nativeObjectPtr);
  public void setTexGlyphPadding(int newValue) {setTexGlyphPadding(nativeObjectPtr, newValue);}
  protected static native void setTexGlyphPadding(long nativeObjectPtr, int newValue);
  protected final long addFont(@NotNull JImFontConfig fontConfig, long nativeObjectPtr){return addFont(fontConfig.nativeObjectPtr, nativeObjectPtr);}
  protected static native long addFont(long fontConfig, long nativeObjectPtr);
  public final long addFont(@NotNull JImFontConfig fontConfig){return addFont(fontConfig.nativeObjectPtr,this.nativeObjectPtr);}
  protected final long addFontDefault(@NotNull JImFontConfig fontConfig, long nativeObjectPtr){return addFontDefault(fontConfig.nativeObjectPtr, nativeObjectPtr);}
  protected static native long addFontDefault(long fontConfig, long nativeObjectPtr);
  public final long addFontDefault(@NotNull JImFontConfig fontConfig){return addFontDefault(fontConfig.nativeObjectPtr,this.nativeObjectPtr);}
  public final long addFontDefault(){return addFontDefault(0, this.nativeObjectPtr);}
  protected final long addFontFromMemoryCompressedBase85TTF(@NotNull String compressedFontDataBase85, float sizePixels, long nativeObjectPtr){return addFontFromMemoryCompressedBase85TTF(getBytes(compressedFontDataBase85), sizePixels, nativeObjectPtr);}
  public final long addFontFromMemoryCompressedBase85TTF(@NotNull JImStr compressedFontDataBase85, float sizePixels, long nativeObjectPtr){return addFontFromMemoryCompressedBase85TTF(compressedFontDataBase85.bytes, sizePixels, nativeObjectPtr);}
  protected static native long addFontFromMemoryCompressedBase85TTF(byte[] compressedFontDataBase85, float sizePixels, long nativeObjectPtr);
  public final long addFontFromMemoryCompressedBase85TTF(@NotNull String compressedFontDataBase85, float sizePixels){return addFontFromMemoryCompressedBase85TTF(getBytes(compressedFontDataBase85), sizePixels,this.nativeObjectPtr);}
  public final long addFontFromMemoryCompressedBase85TTF(@NotNull JImStr compressedFontDataBase85, float sizePixels){return addFontFromMemoryCompressedBase85TTF(compressedFontDataBase85.bytes, sizePixels,this.nativeObjectPtr);}
  private static native boolean build(long nativeObjectPtr);
  public final boolean build(){return build(this.nativeObjectPtr);}
  private static native boolean isBuilt(long nativeObjectPtr);
  public final boolean isBuilt(){return isBuilt(this.nativeObjectPtr);}
  private static native void clearInputData(long nativeObjectPtr);
  public final void clearInputData(){clearInputData(this.nativeObjectPtr);}
  private static native void clearTexData(long nativeObjectPtr);
  public final void clearTexData(){clearTexData(this.nativeObjectPtr);}
  private static native void clearFonts(long nativeObjectPtr);
  public final void clearFonts(){clearFonts(this.nativeObjectPtr);}
  private static native void clear(long nativeObjectPtr);
  public final void clear(){clear(this.nativeObjectPtr);}
  private final void setTexID(@NotNull JImTextureID id, long nativeObjectPtr){setTexID(id.nativeObjectPtr, nativeObjectPtr);}
  protected static native void setTexID(long id, long nativeObjectPtr);
  public final void setTexID(@NotNull JImTextureID id){setTexID(id.nativeObjectPtr,this.nativeObjectPtr);}
  protected static native long getGlyphRangesDefault(long nativeObjectPtr);
  public final long getGlyphRangesDefault(){return getGlyphRangesDefault(this.nativeObjectPtr);}
  protected static native long getGlyphRangesKorean(long nativeObjectPtr);
  public final long getGlyphRangesKorean(){return getGlyphRangesKorean(this.nativeObjectPtr);}
  protected static native long getGlyphRangesJapanese(long nativeObjectPtr);
  public final long getGlyphRangesJapanese(){return getGlyphRangesJapanese(this.nativeObjectPtr);}
  protected static native long getGlyphRangesChineseFull(long nativeObjectPtr);
  public final long getGlyphRangesChineseFull(){return getGlyphRangesChineseFull(this.nativeObjectPtr);}
  protected static native long getGlyphRangesChineseSimplifiedCommon(long nativeObjectPtr);
  public final long getGlyphRangesChineseSimplifiedCommon(){return getGlyphRangesChineseSimplifiedCommon(this.nativeObjectPtr);}
  protected static native long getGlyphRangesCyrillic(long nativeObjectPtr);
  public final long getGlyphRangesCyrillic(){return getGlyphRangesCyrillic(this.nativeObjectPtr);}
  protected static native long getGlyphRangesVietnamese(long nativeObjectPtr);
  public final long getGlyphRangesVietnamese(){return getGlyphRangesVietnamese(this.nativeObjectPtr);}
  protected static native long getGlyphRangesThai(long nativeObjectPtr);
  public final long getGlyphRangesThai(){return getGlyphRangesThai(this.nativeObjectPtr);}
  private static native void addCustomRectRegular(int width, int height, long nativeObjectPtr);
  public final void addCustomRectRegular(int width, int height){addCustomRectRegular(width, height,this.nativeObjectPtr);}
  protected final void addCustomRectFontGlyph(@NotNull JImFont font, short id, int width, int height, float advanceX, float offsetX, float offsetY, long nativeObjectPtr){addCustomRectFontGlyph(font.nativeObjectPtr, id, width, height, advanceX, offsetX, offsetY, nativeObjectPtr);}
  protected static native void addCustomRectFontGlyph(long font, short id, int width, int height, float advanceX, float offsetX, float offsetY, long nativeObjectPtr);
  public final void addCustomRectFontGlyph(@NotNull JImFont font, short id, int width, int height, float advanceX, float offsetX, float offsetY){addCustomRectFontGlyph(font.nativeObjectPtr, id, width, height, advanceX, offsetX, offsetY,this.nativeObjectPtr);}
  public final void addCustomRectFontGlyph(@NotNull JImFont font, short id, int width, int height, float advanceX){addCustomRectFontGlyph(font.nativeObjectPtr, id, width, height, advanceX,0,0, this.nativeObjectPtr);}

}