package org.ice1000.jimgui;

import org.ice1000.jimgui.*;
import org.ice1000.jimgui.flag.*;
import org.ice1000.jimgui.cpp.*;
import org.intellij.lang.annotations.*;
import org.jetbrains.annotations.*;
import java.nio.charset.StandardCharsets;

import static org.ice1000.jimgui.util.JImGuiUtil.*;

/**
 * @author ice1000
 * @since v0.1
 */
@SuppressWarnings("ALL")

public class JImGuiFontGen {
  @Contract(pure = true)
  public static @NotNull JImFont getInstance(@NotNull JImGui owner) {
    return owner.getFont();
  }

  /** package-private by design */
  protected long nativeObjectPtr;

  /** package-private by design */
  JImGuiFontGen(long nativeObjectPtr) {
    this.nativeObjectPtr = nativeObjectPtr;
  }

  public float getFontSize(){return getFontSize(nativeObjectPtr);}
  protected static native float getFontSize(long nativeObjectPtr);
  public void setFontSize(float newValue) {setFontSize(nativeObjectPtr, newValue);}
  protected static native void setFontSize(long nativeObjectPtr, float newValue);
  public float getScale(){return getScale(nativeObjectPtr);}
  protected static native float getScale(long nativeObjectPtr);
  public void setScale(float newValue) {setScale(nativeObjectPtr, newValue);}
  protected static native void setScale(long nativeObjectPtr, float newValue);
  public float getFallbackAdvanceX(){return getFallbackAdvanceX(nativeObjectPtr);}
  protected static native float getFallbackAdvanceX(long nativeObjectPtr);
  public void setFallbackAdvanceX(float newValue) {setFallbackAdvanceX(nativeObjectPtr, newValue);}
  protected static native void setFallbackAdvanceX(long nativeObjectPtr, float newValue);
  public short getConfigDataCount(){return getConfigDataCount(nativeObjectPtr);}
  protected static native short getConfigDataCount(long nativeObjectPtr);
  public void setConfigDataCount(short newValue) {setConfigDataCount(nativeObjectPtr, newValue);}
  protected static native void setConfigDataCount(long nativeObjectPtr, short newValue);
  public float getAscent(){return getAscent(nativeObjectPtr);}
  protected static native float getAscent(long nativeObjectPtr);
  public void setAscent(float newValue) {setAscent(nativeObjectPtr, newValue);}
  protected static native void setAscent(long nativeObjectPtr, float newValue);
  public float getDescent(){return getDescent(nativeObjectPtr);}
  protected static native float getDescent(long nativeObjectPtr);
  public void setDescent(float newValue) {setDescent(nativeObjectPtr, newValue);}
  protected static native void setDescent(long nativeObjectPtr, float newValue);
  public int getMetricsTotalSurface(){return getMetricsTotalSurface(nativeObjectPtr);}
  protected static native int getMetricsTotalSurface(long nativeObjectPtr);
  public void setMetricsTotalSurface(int newValue) {setMetricsTotalSurface(nativeObjectPtr, newValue);}
  protected static native void setMetricsTotalSurface(long nativeObjectPtr, int newValue);
  public boolean isDirtyLookupTables(){return isDirtyLookupTables(this.nativeObjectPtr);}
  public static native boolean isDirtyLookupTables(long nativeObjectPtr);
  public void setDirtyLookupTables(boolean newValue){setDirtyLookupTables(this.nativeObjectPtr,newValue);}
  public static native void setDirtyLookupTables(long nativeObjectPtr, boolean newValue);
  private static native void clearOutputData(long nativeObjectPtr);
  public final void clearOutputData(){clearOutputData(this.nativeObjectPtr);}
  private static native void setFallbackChar(int wChar, long nativeObjectPtr);
  public final void setFallbackChar(int wChar){setFallbackChar(wChar,this.nativeObjectPtr);}
  private static native boolean isLoaded(long nativeObjectPtr);
  public final boolean isLoaded(){return isLoaded(this.nativeObjectPtr);}
  private static native long getDebugName(long nativeObjectPtr);
  public final long getDebugName(){return getDebugName(this.nativeObjectPtr);}
  private static native void growIndex(int newSize, long nativeObjectPtr);
  public final void growIndex(int newSize){growIndex(newSize,this.nativeObjectPtr);}
  private static native void addRemapChar(int dst, int src, boolean overwriteDst, long nativeObjectPtr);
  public final void addRemapChar(int dst, int src, boolean overwriteDst){addRemapChar(dst, src, overwriteDst,this.nativeObjectPtr);}
  public final void addRemapChar(int dst, int src){addRemapChar(dst, src,true, this.nativeObjectPtr);}
  private static native void buildLookupTable(long nativeObjectPtr);
  public final void buildLookupTable(){buildLookupTable(this.nativeObjectPtr);}
  private final void renderChar(@NotNull JImDrawList drawList, float size, float posX, float posY, int u32Color, short c, long nativeObjectPtr){renderChar(drawList.nativeObjectPtr, size, posX, posY, u32Color, c, nativeObjectPtr);}
  protected static native void renderChar(long drawList, float size, float posX, float posY, int u32Color, short c, long nativeObjectPtr);
  public final void renderChar(@NotNull JImDrawList drawList, float size, float posX, float posY, int u32Color, short c){renderChar(drawList.nativeObjectPtr, size, posX, posY, u32Color, c,this.nativeObjectPtr);}

}