package org.ice1000.jimgui;

import org.ice1000.jimgui.*;
import org.ice1000.jimgui.flag.*;
import org.ice1000.jimgui.cpp.*;
import org.intellij.lang.annotations.*;
import org.jetbrains.annotations.*;
import java.nio.charset.StandardCharsets;

import static org.ice1000.jimgui.util.JImGuiUtil.*;

/**
 * @author ice1000
 * @since v0.1
 */
@SuppressWarnings("ALL")

public class JImGuiGen {

  public static final byte@NotNull[] FLOAT_FMT = new byte[]{37, 46, 51, 102, 0};
  public static final byte@NotNull[] DOUBLE_FMT = new byte[]{37, 46, 54, 102, 0};
  public static final byte@NotNull[] INT_FMT = new byte[]{37, 100, 0};
  public static final byte@NotNull[] TIME_FMT = new byte[]{37, 100, 47, 37, 109, 47, 37, 89, 0};
  public static final byte@NotNull[] LEFT_ARROW = new byte[]{60, 0};
  public static final byte@NotNull[] RIGHT_ARROW = new byte[]{62, 0};
  public static final byte@NotNull[] UP_ARROW = new byte[]{32, 32, 32, 94, 32, 32, 32, 0};
  public static final byte@NotNull[] DOWN_ARROW = new byte[]{32, 32, 32, 118, 32, 32, 32, 0};

  public static native void popItemFlag();
  public static native void pushItemFlag(@MagicConstant(flagsFromClass = JImItemFlags.class)int flags, boolean enabled);
  public final void styleColorsDark(@NotNull JImStyle style){styleColorsDark(style.nativeObjectPtr);}
  protected static native void styleColorsDark(long style);
  public final void styleColorsDark(){styleColorsDark(0);}
  public final void styleColorsClassic(@NotNull JImStyle style){styleColorsClassic(style.nativeObjectPtr);}
  protected static native void styleColorsClassic(long style);
  public final void styleColorsClassic(){styleColorsClassic(0);}
  public final void styleColorsLight(@NotNull JImStyle style){styleColorsLight(style.nativeObjectPtr);}
  protected static native void styleColorsLight(long style);
  public final void styleColorsLight(){styleColorsLight(0);}
  public final boolean emptyButton(@NotNull JImVec4 bounds){return emptyButton(bounds.nativeObjectPtr);}
  protected static native boolean emptyButton(long bounds);
  public static native void setDisableHighlight(boolean newValue);
  public static native boolean getDisableHighlight();
  public final void dragVec4(@NotNull String label, @NotNull JImVec4 bounds, float speed, float min, float max, @MagicConstant(flagsFromClass = JImSliderFlags.class)int flags){dragVec4(getBytes(label), bounds.nativeObjectPtr, speed, min, max, flags);}
  public final void dragVec4(@NotNull JImStr label, @NotNull JImVec4 bounds, float speed, float min, float max, @MagicConstant(flagsFromClass = JImSliderFlags.class)int flags){dragVec4(label.bytes, bounds.nativeObjectPtr, speed, min, max, flags);}
  protected static native void dragVec4(byte[] label, long bounds, float speed, float min, float max, @MagicConstant(flagsFromClass = JImSliderFlags.class)int flags);
  public final void dragVec4(@NotNull String label, @NotNull JImVec4 bounds, float speed, float min, float max){dragVec4(getBytes(label), bounds.nativeObjectPtr, speed, min, max,JImSliderFlags.None);}
  public final void dragVec4(@NotNull JImStr label, @NotNull JImVec4 bounds, float speed, float min, float max){dragVec4(label.bytes, bounds.nativeObjectPtr, speed, min, max,JImSliderFlags.None);}
  public final void dragVec4(@NotNull String label, @NotNull JImVec4 bounds, float speed, float min){dragVec4(getBytes(label), bounds.nativeObjectPtr, speed, min,0, JImSliderFlags.None);}
  public final void dragVec4(@NotNull JImStr label, @NotNull JImVec4 bounds, float speed, float min){dragVec4(label.bytes, bounds.nativeObjectPtr, speed, min,0, JImSliderFlags.None);}
  public final void dragVec4(@NotNull String label, @NotNull JImVec4 bounds, float speed){dragVec4(getBytes(label), bounds.nativeObjectPtr, speed,0, 0, JImSliderFlags.None);}
  public final void dragVec4(@NotNull JImStr label, @NotNull JImVec4 bounds, float speed){dragVec4(label.bytes, bounds.nativeObjectPtr, speed,0, 0, JImSliderFlags.None);}
  public final void dragVec4(@NotNull String label, @NotNull JImVec4 bounds){dragVec4(getBytes(label), bounds.nativeObjectPtr,1, 0, 0, JImSliderFlags.None);}
  public final void dragVec4(@NotNull JImStr label, @NotNull JImVec4 bounds){dragVec4(label.bytes, bounds.nativeObjectPtr,1, 0, 0, JImSliderFlags.None);}
  public final void sliderVec4(@NotNull String label, @NotNull JImVec4 bounds, float min, float max, @MagicConstant(flagsFromClass = JImSliderFlags.class)int flags){sliderVec4(getBytes(label), bounds.nativeObjectPtr, min, max, flags);}
  public final void sliderVec4(@NotNull JImStr label, @NotNull JImVec4 bounds, float min, float max, @MagicConstant(flagsFromClass = JImSliderFlags.class)int flags){sliderVec4(label.bytes, bounds.nativeObjectPtr, min, max, flags);}
  protected static native void sliderVec4(byte[] label, long bounds, float min, float max, @MagicConstant(flagsFromClass = JImSliderFlags.class)int flags);
  public final void sliderVec4(@NotNull String label, @NotNull JImVec4 bounds, float min, float max){sliderVec4(getBytes(label), bounds.nativeObjectPtr, min, max,JImSliderFlags.None);}
  public final void sliderVec4(@NotNull JImStr label, @NotNull JImVec4 bounds, float min, float max){sliderVec4(label.bytes, bounds.nativeObjectPtr, min, max,JImSliderFlags.None);}
  public final void sliderVec4(@NotNull String label, @NotNull JImVec4 bounds, float min){sliderVec4(getBytes(label), bounds.nativeObjectPtr, min,100, JImSliderFlags.None);}
  public final void sliderVec4(@NotNull JImStr label, @NotNull JImVec4 bounds, float min){sliderVec4(label.bytes, bounds.nativeObjectPtr, min,100, JImSliderFlags.None);}
  public final void sliderVec4(@NotNull String label, @NotNull JImVec4 bounds){sliderVec4(getBytes(label), bounds.nativeObjectPtr,0, 100, JImSliderFlags.None);}
  public final void sliderVec4(@NotNull JImStr label, @NotNull JImVec4 bounds){sliderVec4(label.bytes, bounds.nativeObjectPtr,0, 100, JImSliderFlags.None);}
  public final void lineTo(float deltaX, float deltaY, @NotNull JImVec4 color, float thickness){lineTo(deltaX, deltaY, color.nativeObjectPtr, thickness);}
  protected static native void lineTo(float deltaX, float deltaY, long color, float thickness);
  public final void lineTo(float deltaX, float deltaY, @NotNull JImVec4 color){lineTo(deltaX, deltaY, color.nativeObjectPtr,1);}
  /**%40param+thickness+if+%3C+0%2C+circle+will+be+filled*/
  public final void circle(float radius, @NotNull JImVec4 color, int numSegments, float thickness){circle(radius, color.nativeObjectPtr, numSegments, thickness);}
  protected static native void circle(float radius, long color, int numSegments, float thickness);
  /**%40param+thickness+if+%3C+0%2C+circle+will+be+filled*/
  public final void circle(float radius, @NotNull JImVec4 color, int numSegments){circle(radius, color.nativeObjectPtr, numSegments,1);}
  /**%40param+thickness+if+%3C+0%2C+circle+will+be+filled*/
  public final void circle(float radius, @NotNull JImVec4 color){circle(radius, color.nativeObjectPtr,12, 1);}
  /**%40param+thickness+if+%3C+0%2C+circle+will+be+filled*/
  public final void rect(float width, float height, @NotNull JImVec4 color, float rounding, float thickness, @MagicConstant(flagsFromClass = JImDrawCornerFlags.class)int roundingCornersFlags){rect(width, height, color.nativeObjectPtr, rounding, thickness, roundingCornersFlags);}
  protected static native void rect(float width, float height, long color, float rounding, float thickness, @MagicConstant(flagsFromClass = JImDrawCornerFlags.class)int roundingCornersFlags);
  /**%40param+thickness+if+%3C+0%2C+circle+will+be+filled*/
  public final void rect(float width, float height, @NotNull JImVec4 color, float rounding, float thickness){rect(width, height, color.nativeObjectPtr, rounding, thickness,JImDrawCornerFlags.All);}
  /**%40param+thickness+if+%3C+0%2C+circle+will+be+filled*/
  public final void rect(float width, float height, @NotNull JImVec4 color, float rounding){rect(width, height, color.nativeObjectPtr, rounding,1, JImDrawCornerFlags.All);}
  /**%40param+thickness+if+%3C+0%2C+circle+will+be+filled*/
  public final void rect(float width, float height, @NotNull JImVec4 color){rect(width, height, color.nativeObjectPtr,0, 1, JImDrawCornerFlags.All);}
  public final void dialogBox(@NotNull String title, @NotNull String text, float widthWindow, float heightWindow, @NotNull NativeBool openPtr, float percentageOnScreen){dialogBox(getBytes(title), getBytes(text), widthWindow, heightWindow, openPtr.nativeObjectPtr, percentageOnScreen);}
  public final void dialogBox(@NotNull JImStr title, @NotNull JImStr text, float widthWindow, float heightWindow, @NotNull NativeBool openPtr, float percentageOnScreen){dialogBox(title.bytes, text.bytes, widthWindow, heightWindow, openPtr.nativeObjectPtr, percentageOnScreen);}
  protected static native void dialogBox(byte[] title, byte[] text, float widthWindow, float heightWindow, long openPtr, float percentageOnScreen);
  public final void dialogBox(@NotNull String title, @NotNull String text, float widthWindow, float heightWindow, @NotNull NativeBool openPtr){dialogBox(getBytes(title), getBytes(text), widthWindow, heightWindow, openPtr.nativeObjectPtr,0.2f);}
  public final void dialogBox(@NotNull JImStr title, @NotNull JImStr text, float widthWindow, float heightWindow, @NotNull NativeBool openPtr){dialogBox(title.bytes, text.bytes, widthWindow, heightWindow, openPtr.nativeObjectPtr,0.2f);}
  public final void bufferingBar(float value, float width, float height, @NotNull JImVec4 backgroundColor, @NotNull JImVec4 foregroundColor){bufferingBar(value, width, height, backgroundColor.nativeObjectPtr, foregroundColor.nativeObjectPtr);}
  protected static native void bufferingBar(float value, float width, float height, long backgroundColor, long foregroundColor);
  public final void spinner(float radius, float thickness, int numSegments, @NotNull JImVec4 color){spinner(radius, thickness, numSegments, color.nativeObjectPtr);}
  protected static native void spinner(float radius, float thickness, int numSegments, long color);
  public final void toggleButton(@NotNull String stringID, @NotNull NativeBool openPtr){toggleButton(getBytes(stringID), openPtr.nativeObjectPtr);}
  public final void toggleButton(@NotNull JImStr stringID, @NotNull NativeBool openPtr){toggleButton(stringID.bytes, openPtr.nativeObjectPtr);}
  protected static native void toggleButton(byte[] stringID, long openPtr);
  public final boolean dateChooser(@NotNull String label, @NotNull NativeTime time, @NotNull String dateFormat, boolean closeWhenMouseLeavesIt, @NotNull NativeBool pSetStartDateToDateOutThisFrame, @NotNull String leftArrow, @NotNull String rightArrow, @NotNull String upArrow, @NotNull String downArrow){return dateChooser(getBytes(label), time.nativeObjectPtr, getBytes(dateFormat), closeWhenMouseLeavesIt, pSetStartDateToDateOutThisFrame.nativeObjectPtr, getBytes(leftArrow), getBytes(rightArrow), getBytes(upArrow), getBytes(downArrow));}
  public final boolean dateChooser(@NotNull JImStr label, @NotNull NativeTime time, @NotNull JImStr dateFormat, boolean closeWhenMouseLeavesIt, @NotNull NativeBool pSetStartDateToDateOutThisFrame, @NotNull JImStr leftArrow, @NotNull JImStr rightArrow, @NotNull JImStr upArrow, @NotNull JImStr downArrow){return dateChooser(label.bytes, time.nativeObjectPtr, dateFormat.bytes, closeWhenMouseLeavesIt, pSetStartDateToDateOutThisFrame.nativeObjectPtr, leftArrow.bytes, rightArrow.bytes, upArrow.bytes, downArrow.bytes);}
  protected static native boolean dateChooser(byte[] label, long time, byte[] dateFormat, boolean closeWhenMouseLeavesIt, long pSetStartDateToDateOutThisFrame, byte[] leftArrow, byte[] rightArrow, byte[] upArrow, byte[] downArrow);
  public final boolean dateChooser(@NotNull String label, @NotNull NativeTime time, @NotNull String dateFormat, boolean closeWhenMouseLeavesIt, @NotNull NativeBool pSetStartDateToDateOutThisFrame, @NotNull String leftArrow, @NotNull String rightArrow, @NotNull String upArrow){return dateChooser(getBytes(label), time.nativeObjectPtr, getBytes(dateFormat), closeWhenMouseLeavesIt, pSetStartDateToDateOutThisFrame.nativeObjectPtr, getBytes(leftArrow), getBytes(rightArrow), getBytes(upArrow),DOWN_ARROW);}
  public final boolean dateChooser(@NotNull JImStr label, @NotNull NativeTime time, @NotNull JImStr dateFormat, boolean closeWhenMouseLeavesIt, @NotNull NativeBool pSetStartDateToDateOutThisFrame, @NotNull JImStr leftArrow, @NotNull JImStr rightArrow, @NotNull JImStr upArrow){return dateChooser(label.bytes, time.nativeObjectPtr, dateFormat.bytes, closeWhenMouseLeavesIt, pSetStartDateToDateOutThisFrame.nativeObjectPtr, leftArrow.bytes, rightArrow.bytes, upArrow.bytes,DOWN_ARROW);}
  public final boolean dateChooser(@NotNull String label, @NotNull NativeTime time, @NotNull String dateFormat, boolean closeWhenMouseLeavesIt, @NotNull NativeBool pSetStartDateToDateOutThisFrame, @NotNull String leftArrow, @NotNull String rightArrow){return dateChooser(getBytes(label), time.nativeObjectPtr, getBytes(dateFormat), closeWhenMouseLeavesIt, pSetStartDateToDateOutThisFrame.nativeObjectPtr, getBytes(leftArrow), getBytes(rightArrow),UP_ARROW, DOWN_ARROW);}
  public final boolean dateChooser(@NotNull JImStr label, @NotNull NativeTime time, @NotNull JImStr dateFormat, boolean closeWhenMouseLeavesIt, @NotNull NativeBool pSetStartDateToDateOutThisFrame, @NotNull JImStr leftArrow, @NotNull JImStr rightArrow){return dateChooser(label.bytes, time.nativeObjectPtr, dateFormat.bytes, closeWhenMouseLeavesIt, pSetStartDateToDateOutThisFrame.nativeObjectPtr, leftArrow.bytes, rightArrow.bytes,UP_ARROW, DOWN_ARROW);}
  public final boolean dateChooser(@NotNull String label, @NotNull NativeTime time, @NotNull String dateFormat, boolean closeWhenMouseLeavesIt, @NotNull NativeBool pSetStartDateToDateOutThisFrame, @NotNull String leftArrow){return dateChooser(getBytes(label), time.nativeObjectPtr, getBytes(dateFormat), closeWhenMouseLeavesIt, pSetStartDateToDateOutThisFrame.nativeObjectPtr, getBytes(leftArrow),RIGHT_ARROW, UP_ARROW, DOWN_ARROW);}
  public final boolean dateChooser(@NotNull JImStr label, @NotNull NativeTime time, @NotNull JImStr dateFormat, boolean closeWhenMouseLeavesIt, @NotNull NativeBool pSetStartDateToDateOutThisFrame, @NotNull JImStr leftArrow){return dateChooser(label.bytes, time.nativeObjectPtr, dateFormat.bytes, closeWhenMouseLeavesIt, pSetStartDateToDateOutThisFrame.nativeObjectPtr, leftArrow.bytes,RIGHT_ARROW, UP_ARROW, DOWN_ARROW);}
  public final boolean dateChooser(@NotNull String label, @NotNull NativeTime time, @NotNull String dateFormat, boolean closeWhenMouseLeavesIt, @NotNull NativeBool pSetStartDateToDateOutThisFrame){return dateChooser(getBytes(label), time.nativeObjectPtr, getBytes(dateFormat), closeWhenMouseLeavesIt, pSetStartDateToDateOutThisFrame.nativeObjectPtr,LEFT_ARROW, RIGHT_ARROW, UP_ARROW, DOWN_ARROW);}
  public final boolean dateChooser(@NotNull JImStr label, @NotNull NativeTime time, @NotNull JImStr dateFormat, boolean closeWhenMouseLeavesIt, @NotNull NativeBool pSetStartDateToDateOutThisFrame){return dateChooser(label.bytes, time.nativeObjectPtr, dateFormat.bytes, closeWhenMouseLeavesIt, pSetStartDateToDateOutThisFrame.nativeObjectPtr,LEFT_ARROW, RIGHT_ARROW, UP_ARROW, DOWN_ARROW);}
  public final boolean dateChooser(@NotNull String label, @NotNull NativeTime time, @NotNull String dateFormat, boolean closeWhenMouseLeavesIt){return dateChooser(getBytes(label), time.nativeObjectPtr, getBytes(dateFormat), closeWhenMouseLeavesIt,0, LEFT_ARROW, RIGHT_ARROW, UP_ARROW, DOWN_ARROW);}
  public final boolean dateChooser(@NotNull JImStr label, @NotNull NativeTime time, @NotNull JImStr dateFormat, boolean closeWhenMouseLeavesIt){return dateChooser(label.bytes, time.nativeObjectPtr, dateFormat.bytes, closeWhenMouseLeavesIt,0, LEFT_ARROW, RIGHT_ARROW, UP_ARROW, DOWN_ARROW);}
  public final boolean dateChooser(@NotNull String label, @NotNull NativeTime time, @NotNull String dateFormat){return dateChooser(getBytes(label), time.nativeObjectPtr, getBytes(dateFormat),true, 0, LEFT_ARROW, RIGHT_ARROW, UP_ARROW, DOWN_ARROW);}
  public final boolean dateChooser(@NotNull JImStr label, @NotNull NativeTime time, @NotNull JImStr dateFormat){return dateChooser(label.bytes, time.nativeObjectPtr, dateFormat.bytes,true, 0, LEFT_ARROW, RIGHT_ARROW, UP_ARROW, DOWN_ARROW);}
  public final boolean dateChooser(@NotNull String label, @NotNull NativeTime time){return dateChooser(getBytes(label), time.nativeObjectPtr,TIME_FMT, true, 0, LEFT_ARROW, RIGHT_ARROW, UP_ARROW, DOWN_ARROW);}
  public final boolean dateChooser(@NotNull JImStr label, @NotNull NativeTime time){return dateChooser(label.bytes, time.nativeObjectPtr,TIME_FMT, true, 0, LEFT_ARROW, RIGHT_ARROW, UP_ARROW, DOWN_ARROW);}
  public static native void separator();
  public static native void sameLine(float posX, float spacingW);
  public final void sameLine(float posX){sameLine(posX,-1);}
  public final void sameLine(){sameLine(0, -1);}
  public static native void newLine();
  public static native void spacing();
  public static native void dummy(float width, float height);
  public static native void indent(float indentW);
  public final void indent(){indent(0);}
  public static native void unindent(float indentW);
  public final void unindent(){unindent(0);}
  public static native void beginGroup();
  public static native void endGroup();
  public static native float getCursorPosX();
  public static native float getCursorPosY();
  public static native void setCursorPos(float posX, float spacingW);
  public static native void setCursorScreenPos(float screenPosX, float screenPosY);
  public static native void setCursorPosX(float newValue);
  public static native void setCursorPosY(float newValue);
  public static native void alignTextToFramePadding();
  public static native float getTextLineHeight();
  public static native float getTextLineHeightWithSpacing();
  public static native float getFrameHeight();
  public static native float getFrameHeightWithSpacing();
  public static native void showUserGuide();
  public final void showDemoWindow(@NotNull NativeBool openPtr){showDemoWindow(openPtr.nativeObjectPtr);}
  protected static native void showDemoWindow(long openPtr);
  public final void showDemoWindow(){showDemoWindow(0);}
  public final void showAboutWindow(@NotNull NativeBool openPtr){showAboutWindow(openPtr.nativeObjectPtr);}
  protected static native void showAboutWindow(long openPtr);
  public final void showAboutWindow(){showAboutWindow(0);}
  public final void showMetricsWindow(@NotNull NativeBool openPtr){showMetricsWindow(openPtr.nativeObjectPtr);}
  protected static native void showMetricsWindow(long openPtr);
  public final void showMetricsWindow(){showMetricsWindow(0);}
  public final void showFontSelector(@NotNull String label){showFontSelector(getBytes(label));}
  public final void showFontSelector(@NotNull JImStr label){showFontSelector(label.bytes);}
  protected static native void showFontSelector(byte[] label);
  public final void showStyleSelector(@NotNull String label){showStyleSelector(getBytes(label));}
  public final void showStyleSelector(@NotNull JImStr label){showStyleSelector(label.bytes);}
  protected static native void showStyleSelector(byte[] label);
  public final void showStyleEditor(@NotNull JImStyle ref){showStyleEditor(ref.nativeObjectPtr);}
  protected static native void showStyleEditor(long ref);
  public final void showStyleEditor(){showStyleEditor(0);}
  public static native boolean isWindowAppearing();
  public static native boolean isWindowCollapsed();
  public static native boolean isWindowFocused(@MagicConstant(flagsFromClass = JImFocusedFlags.class)int flags);
  public final boolean isWindowFocused(){return isWindowFocused(JImFocusedFlags.None);}
  public static native boolean isWindowHovered(@MagicConstant(flagsFromClass = JImHoveredFlags.class)int flags);
  public final boolean isWindowHovered(){return isWindowHovered(JImHoveredFlags.None);}
  public static native float getWindowWidth();
  public static native float getWindowHeight();
  public static native float getWindowContentRegionWidth();
  public static native void setNextWindowPos(float posX, float posY, @MagicConstant(valuesFromClass = JImCond.class)int condition, float windowPosPivotX, float windowPosPivotY);
  public final void setNextWindowPos(float posX, float posY, @MagicConstant(valuesFromClass = JImCond.class)int condition){setNextWindowPos(posX, posY, condition,0,0);}
  public final void setNextWindowPos(float posX, float posY){setNextWindowPos(posX, posY,JImCond.Always, 0,0);}
  public static native void setNextWindowSize(float width, float height, @MagicConstant(valuesFromClass = JImCond.class)int condition);
  public final void setNextWindowSize(float width, float height){setNextWindowSize(width, height,JImCond.Always);}
  public static native void setNextWindowSizeConstraints(float widthMin, float heightMin, float widthMax, float heightMax);
  public static native void setNextWindowContentSize(float width, float height);
  public static native void setNextWindowCollapsed(boolean collapsed, @MagicConstant(valuesFromClass = JImCond.class)int condition);
  public final void setNextWindowCollapsed(boolean collapsed){setNextWindowCollapsed(collapsed,JImCond.Always);}
  public static native void setNextWindowFocus();
  public static native void setNextWindowBgAlpha(float alpha);
  public static native void setWindowFontScale(float scale);
  public final void setWindowPos(@NotNull String name, float windowPosX, float windowPosY, @MagicConstant(valuesFromClass = JImCond.class)int condition){setWindowPos(getBytes(name), windowPosX, windowPosY, condition);}
  public final void setWindowPos(@NotNull JImStr name, float windowPosX, float windowPosY, @MagicConstant(valuesFromClass = JImCond.class)int condition){setWindowPos(name.bytes, windowPosX, windowPosY, condition);}
  protected static native void setWindowPos(byte[] name, float windowPosX, float windowPosY, @MagicConstant(valuesFromClass = JImCond.class)int condition);
  public final void setWindowPos(@NotNull String name, float windowPosX, float windowPosY){setWindowPos(getBytes(name), windowPosX, windowPosY,JImCond.Always);}
  public final void setWindowPos(@NotNull JImStr name, float windowPosX, float windowPosY){setWindowPos(name.bytes, windowPosX, windowPosY,JImCond.Always);}
  public final void setWindowSize(@NotNull String name, float width, float height, @MagicConstant(valuesFromClass = JImCond.class)int condition){setWindowSize(getBytes(name), width, height, condition);}
  public final void setWindowSize(@NotNull JImStr name, float width, float height, @MagicConstant(valuesFromClass = JImCond.class)int condition){setWindowSize(name.bytes, width, height, condition);}
  protected static native void setWindowSize(byte[] name, float width, float height, @MagicConstant(valuesFromClass = JImCond.class)int condition);
  public final void setWindowSize(@NotNull String name, float width, float height){setWindowSize(getBytes(name), width, height,JImCond.Always);}
  public final void setWindowSize(@NotNull JImStr name, float width, float height){setWindowSize(name.bytes, width, height,JImCond.Always);}
  public final void setWindowCollapsed(@NotNull String name, boolean collapsed, @MagicConstant(valuesFromClass = JImCond.class)int condition){setWindowCollapsed(getBytes(name), collapsed, condition);}
  public final void setWindowCollapsed(@NotNull JImStr name, boolean collapsed, @MagicConstant(valuesFromClass = JImCond.class)int condition){setWindowCollapsed(name.bytes, collapsed, condition);}
  protected static native void setWindowCollapsed(byte[] name, boolean collapsed, @MagicConstant(valuesFromClass = JImCond.class)int condition);
  public final void setWindowCollapsed(@NotNull String name, boolean collapsed){setWindowCollapsed(getBytes(name), collapsed,JImCond.Always);}
  public final void setWindowCollapsed(@NotNull JImStr name, boolean collapsed){setWindowCollapsed(name.bytes, collapsed,JImCond.Always);}
  public final void setWindowFocus(@NotNull String name){setWindowFocus(getBytes(name));}
  public final void setWindowFocus(@NotNull JImStr name){setWindowFocus(name.bytes);}
  protected static native void setWindowFocus(byte[] name);
  public static native int getKeyIndex(int imguiKey);
  public static native boolean isKeyDown(int userKeyIndex);
  public static native boolean isKeyPressed(int userKeyIndex, boolean repeat);
  public final boolean isKeyPressed(int userKeyIndex){return isKeyPressed(userKeyIndex,true);}
  public static native boolean isKeyReleased(int userKeyIndex);
  public static native int getKeyPressedAmount(int keyIndex, float repeatDelay, float rate);
  public static native boolean isMouseDown(@MagicConstant(valuesFromClass = JImMouseButton.class)int button);
  public final boolean isMouseDown(){return isMouseDown(JImMouseButton.Left);}
  public static native boolean isAnyMouseDown();
  public static native boolean isMouseClicked(@MagicConstant(valuesFromClass = JImMouseButton.class)int button, boolean repeat);
  public final boolean isMouseClicked(@MagicConstant(valuesFromClass = JImMouseButton.class)int button){return isMouseClicked(button,false);}
  public final boolean isMouseClicked(){return isMouseClicked(JImMouseButton.Left, false);}
  public static native boolean isMouseDoubleClicked(@MagicConstant(valuesFromClass = JImMouseButton.class)int button);
  public final boolean isMouseDoubleClicked(){return isMouseDoubleClicked(JImMouseButton.Left);}
  public static native boolean isMouseReleased(@MagicConstant(valuesFromClass = JImMouseButton.class)int button);
  public final boolean isMouseReleased(){return isMouseReleased(JImMouseButton.Left);}
  public static native boolean isMouseDragging(@MagicConstant(valuesFromClass = JImMouseButton.class)int button, float lockThreshold);
  public final boolean isMouseDragging(@MagicConstant(valuesFromClass = JImMouseButton.class)int button){return isMouseDragging(button,-1);}
  public final boolean isMouseDragging(){return isMouseDragging(JImMouseButton.Left, -1);}
  public static native boolean isMouseHoveringRect(float widthRMin, float heightRMin, float widthRMax, float heightRMax, boolean clip);
  public final boolean isMouseHoveringRect(float widthRMin, float heightRMin, float widthRMax, float heightRMax){return isMouseHoveringRect(widthRMin, heightRMin, widthRMax, heightRMax,true);}
  public static native boolean isMousePosValid();
  public static native void captureKeyboardFromApp(boolean capture);
  public final void captureKeyboardFromApp(){captureKeyboardFromApp(true);}
  public static native void captureMouseFromApp(boolean capture);
  public final void captureMouseFromApp(){captureMouseFromApp(true);}
  public final void setClipboardText(@NotNull String text){setClipboardText(getBytes(text));}
  public final void setClipboardText(@NotNull JImStr text){setClipboardText(text.bytes);}
  protected static native void setClipboardText(byte[] text);
  public static native void popID();
  public final void pushID(@NotNull String stringID){pushID(stringID.getBytes(StandardCharsets.UTF_8));}
  protected static native void pushID(byte[] stringID);
  public final int getID(@NotNull String stringID){return getID(stringID.getBytes(StandardCharsets.UTF_8));}
  protected static native int getID(byte[] stringID);
  public final boolean begin(@NotNull String name, @NotNull NativeBool openPtr, @MagicConstant(flagsFromClass = JImWindowFlags.class)int flags){return begin(getBytes(name), openPtr.nativeObjectPtr, flags);}
  public final boolean begin(@NotNull JImStr name, @NotNull NativeBool openPtr, @MagicConstant(flagsFromClass = JImWindowFlags.class)int flags){return begin(name.bytes, openPtr.nativeObjectPtr, flags);}
  protected static native boolean begin(byte[] name, long openPtr, @MagicConstant(flagsFromClass = JImWindowFlags.class)int flags);
  public final boolean begin(@NotNull String name, @NotNull NativeBool openPtr){return begin(getBytes(name), openPtr.nativeObjectPtr,JImWindowFlags.None);}
  public final boolean begin(@NotNull JImStr name, @NotNull NativeBool openPtr){return begin(name.bytes, openPtr.nativeObjectPtr,JImWindowFlags.None);}
  public final boolean begin(@NotNull String name){return begin(getBytes(name),0, JImWindowFlags.None);}
  public final boolean begin(@NotNull JImStr name){return begin(name.bytes,0, JImWindowFlags.None);}
  public static native void end();
  public static native boolean beginChild(int id, float width, float height, boolean border, @MagicConstant(flagsFromClass = JImWindowFlags.class)int flags);
  public final boolean beginChild(int id, float width, float height, boolean border){return beginChild(id, width, height, border,JImWindowFlags.None);}
  public final boolean beginChild(int id, float width, float height){return beginChild(id, width, height,false, JImWindowFlags.None);}
  public final boolean beginChild(int id){return beginChild(id,0,0, false, JImWindowFlags.None);}
  public final boolean beginChild0(@NotNull String stringID, float width, float height, boolean border, @MagicConstant(flagsFromClass = JImWindowFlags.class)int flags){return beginChild0(getBytes(stringID), width, height, border, flags);}
  public final boolean beginChild0(@NotNull JImStr stringID, float width, float height, boolean border, @MagicConstant(flagsFromClass = JImWindowFlags.class)int flags){return beginChild0(stringID.bytes, width, height, border, flags);}
  protected static native boolean beginChild0(byte[] stringID, float width, float height, boolean border, @MagicConstant(flagsFromClass = JImWindowFlags.class)int flags);
  public final boolean beginChild0(@NotNull String stringID, float width, float height, boolean border){return beginChild0(getBytes(stringID), width, height, border,JImWindowFlags.None);}
  public final boolean beginChild0(@NotNull JImStr stringID, float width, float height, boolean border){return beginChild0(stringID.bytes, width, height, border,JImWindowFlags.None);}
  public final boolean beginChild0(@NotNull String stringID, float width, float height){return beginChild0(getBytes(stringID), width, height,false, JImWindowFlags.None);}
  public final boolean beginChild0(@NotNull JImStr stringID, float width, float height){return beginChild0(stringID.bytes, width, height,false, JImWindowFlags.None);}
  public final boolean beginChild0(@NotNull String stringID){return beginChild0(getBytes(stringID),0,0, false, JImWindowFlags.None);}
  public final boolean beginChild0(@NotNull JImStr stringID){return beginChild0(stringID.bytes,0,0, false, JImWindowFlags.None);}
  public static native void endChild();
  public final void bulletText(@NotNull String text){bulletText(getBytes(text));}
  public final void bulletText(@NotNull JImStr text){bulletText(text.bytes);}
  protected static native void bulletText(byte[] text);
  public final void labelText(@NotNull String label, @NotNull String text){labelText(getBytes(label), getBytes(text));}
  public final void labelText(@NotNull JImStr label, @NotNull JImStr text){labelText(label.bytes, text.bytes);}
  protected static native void labelText(byte[] label, byte[] text);
  public final void textWrapped(@NotNull String text){textWrapped(getBytes(text));}
  public final void textWrapped(@NotNull JImStr text){textWrapped(text.bytes);}
  protected static native void textWrapped(byte[] text);
  public final void textUnformatted(@NotNull String text){textUnformatted(text.getBytes(StandardCharsets.UTF_8));}
  protected static native void textUnformatted(byte[] text);
  public final void textDisabled(@NotNull String text){textDisabled(getBytes(text));}
  public final void textDisabled(@NotNull JImStr text){textDisabled(text.bytes);}
  protected static native void textDisabled(byte[] text);
  public final void textColored(@NotNull JImVec4 color, @NotNull String text){textColored(color.nativeObjectPtr, getBytes(text));}
  public final void textColored(@NotNull JImVec4 color, @NotNull JImStr text){textColored(color.nativeObjectPtr, text.bytes);}
  protected static native void textColored(long color, byte[] text);
  public final void text(@NotNull String text){text(getBytes(text));}
  public final void text(@NotNull JImStr text){text(text.bytes);}
  protected static native void text(byte[] text);
  public final boolean button(@NotNull String text, float width, float height){return button(getBytes(text), width, height);}
  public final boolean button(@NotNull JImStr text, float width, float height){return button(text.bytes, width, height);}
  protected static native boolean button(byte[] text, float width, float height);
  public final boolean button(@NotNull String text){return button(getBytes(text),0,0);}
  public final boolean button(@NotNull JImStr text){return button(text.bytes,0,0);}
  public final boolean smallButton(@NotNull String text){return smallButton(getBytes(text));}
  public final boolean smallButton(@NotNull JImStr text){return smallButton(text.bytes);}
  protected static native boolean smallButton(byte[] text);
  public final boolean invisibleButton(@NotNull String text, float width, float height, @MagicConstant(flagsFromClass = JImButtonFlags.class)int flags){return invisibleButton(getBytes(text), width, height, flags);}
  public final boolean invisibleButton(@NotNull JImStr text, float width, float height, @MagicConstant(flagsFromClass = JImButtonFlags.class)int flags){return invisibleButton(text.bytes, width, height, flags);}
  protected static native boolean invisibleButton(byte[] text, float width, float height, @MagicConstant(flagsFromClass = JImButtonFlags.class)int flags);
  public final boolean invisibleButton(@NotNull String text, float width, float height){return invisibleButton(getBytes(text), width, height,JImButtonFlags.None);}
  public final boolean invisibleButton(@NotNull JImStr text, float width, float height){return invisibleButton(text.bytes, width, height,JImButtonFlags.None);}
  public final boolean invisibleButton(@NotNull String text){return invisibleButton(getBytes(text),0,0, JImButtonFlags.None);}
  public final boolean invisibleButton(@NotNull JImStr text){return invisibleButton(text.bytes,0,0, JImButtonFlags.None);}
  public final boolean arrowButton(@NotNull String text, @MagicConstant(valuesFromClass = JImDirection.class)int direction){return arrowButton(getBytes(text), direction);}
  public final boolean arrowButton(@NotNull JImStr text, @MagicConstant(valuesFromClass = JImDirection.class)int direction){return arrowButton(text.bytes, direction);}
  protected static native boolean arrowButton(byte[] text, @MagicConstant(valuesFromClass = JImDirection.class)int direction);
  public final void image(@NotNull JImTextureID userTextureID, float width, float height, float uv0X, float uv0Y, float uv1X, float uv1Y){image(userTextureID.nativeObjectPtr, width, height, uv0X, uv0Y, uv1X, uv1Y);}
  protected static native void image(long userTextureID, float width, float height, float uv0X, float uv0Y, float uv1X, float uv1Y);
  public final void image(@NotNull JImTextureID userTextureID, float width, float height, float uv0X, float uv0Y){image(userTextureID.nativeObjectPtr, width, height, uv0X, uv0Y,1,1);}
  public final void image(@NotNull JImTextureID userTextureID, float width, float height){image(userTextureID.nativeObjectPtr, width, height,0,0, 1,1);}
  public final boolean imageButton(@NotNull JImTextureID userTextureID, float width, float height, float uv0X, float uv0Y, float uv1X, float uv1Y, int framePadding){return imageButton(userTextureID.nativeObjectPtr, width, height, uv0X, uv0Y, uv1X, uv1Y, framePadding);}
  protected static native boolean imageButton(long userTextureID, float width, float height, float uv0X, float uv0Y, float uv1X, float uv1Y, int framePadding);
  public final boolean imageButton(@NotNull JImTextureID userTextureID, float width, float height, float uv0X, float uv0Y, float uv1X, float uv1Y){return imageButton(userTextureID.nativeObjectPtr, width, height, uv0X, uv0Y, uv1X, uv1Y,-1);}
  public final boolean imageButton(@NotNull JImTextureID userTextureID, float width, float height, float uv0X, float uv0Y){return imageButton(userTextureID.nativeObjectPtr, width, height, uv0X, uv0Y,1,1, -1);}
  public final boolean imageButton(@NotNull JImTextureID userTextureID, float width, float height){return imageButton(userTextureID.nativeObjectPtr, width, height,0,0, 1,1, -1);}
  public final boolean checkbox(@NotNull String label, @NotNull NativeBool v){return checkbox(getBytes(label), v.nativeObjectPtr);}
  public final boolean checkbox(@NotNull JImStr label, @NotNull NativeBool v){return checkbox(label.bytes, v.nativeObjectPtr);}
  protected static native boolean checkbox(byte[] label, long v);
  public final boolean radioButton(@NotNull String text, @NotNull NativeInt v, int v_button){return radioButton(getBytes(text), v.nativeObjectPtr, v_button);}
  public final boolean radioButton(@NotNull JImStr text, @NotNull NativeInt v, int v_button){return radioButton(text.bytes, v.nativeObjectPtr, v_button);}
  protected static native boolean radioButton(byte[] text, long v, int v_button);
  public final boolean radioButton0(@NotNull String text, boolean active){return radioButton0(getBytes(text), active);}
  public final boolean radioButton0(@NotNull JImStr text, boolean active){return radioButton0(text.bytes, active);}
  protected static native boolean radioButton0(byte[] text, boolean active);
  public static native void bullet();
  public final void progressBar(float fraction, float width, float height, @Nullable String overlay){progressBar(fraction, width, height, getBytes(overlay));}
  protected static native void progressBar(float fraction, float width, float height, byte[] overlay);
  public final void progressBar(float fraction, float width, float height){progressBar(fraction, width, height,(byte[]) null);}
  public final void progressBar(float fraction){progressBar(fraction,-1,0, (byte[]) null);}
  public final boolean beginCombo(@NotNull String label, @NotNull String previewValue, @MagicConstant(flagsFromClass = JImComboFlags.class)int flags){return beginCombo(getBytes(label), getBytes(previewValue), flags);}
  public final boolean beginCombo(@NotNull JImStr label, @NotNull JImStr previewValue, @MagicConstant(flagsFromClass = JImComboFlags.class)int flags){return beginCombo(label.bytes, previewValue.bytes, flags);}
  protected static native boolean beginCombo(byte[] label, byte[] previewValue, @MagicConstant(flagsFromClass = JImComboFlags.class)int flags);
  public final boolean beginCombo(@NotNull String label, @NotNull String previewValue){return beginCombo(getBytes(label), getBytes(previewValue),JImComboFlags.PopupAlignLeft);}
  public final boolean beginCombo(@NotNull JImStr label, @NotNull JImStr previewValue){return beginCombo(label.bytes, previewValue.bytes,JImComboFlags.PopupAlignLeft);}
  public static native void endCombo();
  public final void combo(@NotNull String label, @NotNull NativeInt currentItem, @NotNull String itemsSeparatedByZeros, int popupMaxHeightInItems){combo(getBytes(label), currentItem.nativeObjectPtr, getBytes(itemsSeparatedByZeros), popupMaxHeightInItems);}
  public final void combo(@NotNull JImStr label, @NotNull NativeInt currentItem, @NotNull JImStr itemsSeparatedByZeros, int popupMaxHeightInItems){combo(label.bytes, currentItem.nativeObjectPtr, itemsSeparatedByZeros.bytes, popupMaxHeightInItems);}
  protected static native void combo(byte[] label, long currentItem, byte[] itemsSeparatedByZeros, int popupMaxHeightInItems);
  public final void combo(@NotNull String label, @NotNull NativeInt currentItem, @NotNull String itemsSeparatedByZeros){combo(getBytes(label), currentItem.nativeObjectPtr, getBytes(itemsSeparatedByZeros),-1);}
  public final void combo(@NotNull JImStr label, @NotNull NativeInt currentItem, @NotNull JImStr itemsSeparatedByZeros){combo(label.bytes, currentItem.nativeObjectPtr, itemsSeparatedByZeros.bytes,-1);}
  public final boolean beginListBox(@NotNull String label, float width, float height){return beginListBox(getBytes(label), width, height);}
  public final boolean beginListBox(@NotNull JImStr label, float width, float height){return beginListBox(label.bytes, width, height);}
  protected static native boolean beginListBox(byte[] label, float width, float height);
  public static native void endListBox();
  public final boolean dragFloat(@NotNull String label, @NotNull NativeFloat value, float valueSpeed, float valueMin, float valueMax, @NotNull String format, @MagicConstant(flagsFromClass = JImSliderFlags.class)int flags){return dragFloat(getBytes(label), value.nativeObjectPtr, valueSpeed, valueMin, valueMax, getBytes(format), flags);}
  public final boolean dragFloat(@NotNull JImStr label, @NotNull NativeFloat value, float valueSpeed, float valueMin, float valueMax, @NotNull JImStr format, @MagicConstant(flagsFromClass = JImSliderFlags.class)int flags){return dragFloat(label.bytes, value.nativeObjectPtr, valueSpeed, valueMin, valueMax, format.bytes, flags);}
  protected static native boolean dragFloat(byte[] label, long value, float valueSpeed, float valueMin, float valueMax, byte[] format, @MagicConstant(flagsFromClass = JImSliderFlags.class)int flags);
  public final boolean dragFloat(@NotNull String label, @NotNull NativeFloat value, float valueSpeed, float valueMin, float valueMax, @NotNull String format){return dragFloat(getBytes(label), value.nativeObjectPtr, valueSpeed, valueMin, valueMax, getBytes(format),JImSliderFlags.None);}
  public final boolean dragFloat(@NotNull JImStr label, @NotNull NativeFloat value, float valueSpeed, float valueMin, float valueMax, @NotNull JImStr format){return dragFloat(label.bytes, value.nativeObjectPtr, valueSpeed, valueMin, valueMax, format.bytes,JImSliderFlags.None);}
  public final boolean dragFloat(@NotNull String label, @NotNull NativeFloat value, float valueSpeed, float valueMin, float valueMax){return dragFloat(getBytes(label), value.nativeObjectPtr, valueSpeed, valueMin, valueMax,FLOAT_FMT, JImSliderFlags.None);}
  public final boolean dragFloat(@NotNull JImStr label, @NotNull NativeFloat value, float valueSpeed, float valueMin, float valueMax){return dragFloat(label.bytes, value.nativeObjectPtr, valueSpeed, valueMin, valueMax,FLOAT_FMT, JImSliderFlags.None);}
  public final boolean dragFloat(@NotNull String label, @NotNull NativeFloat value, float valueSpeed, float valueMin){return dragFloat(getBytes(label), value.nativeObjectPtr, valueSpeed, valueMin,0, FLOAT_FMT, JImSliderFlags.None);}
  public final boolean dragFloat(@NotNull JImStr label, @NotNull NativeFloat value, float valueSpeed, float valueMin){return dragFloat(label.bytes, value.nativeObjectPtr, valueSpeed, valueMin,0, FLOAT_FMT, JImSliderFlags.None);}
  public final boolean dragFloat(@NotNull String label, @NotNull NativeFloat value, float valueSpeed){return dragFloat(getBytes(label), value.nativeObjectPtr, valueSpeed,0, 0, FLOAT_FMT, JImSliderFlags.None);}
  public final boolean dragFloat(@NotNull JImStr label, @NotNull NativeFloat value, float valueSpeed){return dragFloat(label.bytes, value.nativeObjectPtr, valueSpeed,0, 0, FLOAT_FMT, JImSliderFlags.None);}
  public final boolean dragFloat(@NotNull String label, @NotNull NativeFloat value){return dragFloat(getBytes(label), value.nativeObjectPtr,1, 0, 0, FLOAT_FMT, JImSliderFlags.None);}
  public final boolean dragFloat(@NotNull JImStr label, @NotNull NativeFloat value){return dragFloat(label.bytes, value.nativeObjectPtr,1, 0, 0, FLOAT_FMT, JImSliderFlags.None);}
  public final boolean dragFloatRange2(@NotNull String label, @NotNull NativeFloat valueCurrentMin, @NotNull NativeFloat valueCurrentMax, float valueSpeed, float valueMin, float valueMax, @NotNull String format, @Nullable String formatMax, @MagicConstant(flagsFromClass = JImSliderFlags.class)int flags){return dragFloatRange2(getBytes(label), valueCurrentMin.nativeObjectPtr, valueCurrentMax.nativeObjectPtr, valueSpeed, valueMin, valueMax, getBytes(format), getBytes(formatMax), flags);}
  public final boolean dragFloatRange2(@NotNull JImStr label, @NotNull NativeFloat valueCurrentMin, @NotNull NativeFloat valueCurrentMax, float valueSpeed, float valueMin, float valueMax, @NotNull JImStr format, @Nullable JImStr formatMax, @MagicConstant(flagsFromClass = JImSliderFlags.class)int flags){return dragFloatRange2(label.bytes, valueCurrentMin.nativeObjectPtr, valueCurrentMax.nativeObjectPtr, valueSpeed, valueMin, valueMax, format.bytes, formatMax.bytes, flags);}
  protected static native boolean dragFloatRange2(byte[] label, long valueCurrentMin, long valueCurrentMax, float valueSpeed, float valueMin, float valueMax, byte[] format, byte[] formatMax, @MagicConstant(flagsFromClass = JImSliderFlags.class)int flags);
  public final boolean dragFloatRange2(@NotNull String label, @NotNull NativeFloat valueCurrentMin, @NotNull NativeFloat valueCurrentMax, float valueSpeed, float valueMin, float valueMax, @NotNull String format, @Nullable String formatMax){return dragFloatRange2(getBytes(label), valueCurrentMin.nativeObjectPtr, valueCurrentMax.nativeObjectPtr, valueSpeed, valueMin, valueMax, getBytes(format), getBytes(formatMax),JImSliderFlags.None);}
  public final boolean dragFloatRange2(@NotNull JImStr label, @NotNull NativeFloat valueCurrentMin, @NotNull NativeFloat valueCurrentMax, float valueSpeed, float valueMin, float valueMax, @NotNull JImStr format, @Nullable JImStr formatMax){return dragFloatRange2(label.bytes, valueCurrentMin.nativeObjectPtr, valueCurrentMax.nativeObjectPtr, valueSpeed, valueMin, valueMax, format.bytes, formatMax.bytes,JImSliderFlags.None);}
  public final boolean dragFloatRange2(@NotNull String label, @NotNull NativeFloat valueCurrentMin, @NotNull NativeFloat valueCurrentMax, float valueSpeed, float valueMin, float valueMax, @NotNull String format){return dragFloatRange2(getBytes(label), valueCurrentMin.nativeObjectPtr, valueCurrentMax.nativeObjectPtr, valueSpeed, valueMin, valueMax, getBytes(format),(byte[]) null, JImSliderFlags.None);}
  public final boolean dragFloatRange2(@NotNull JImStr label, @NotNull NativeFloat valueCurrentMin, @NotNull NativeFloat valueCurrentMax, float valueSpeed, float valueMin, float valueMax, @NotNull JImStr format){return dragFloatRange2(label.bytes, valueCurrentMin.nativeObjectPtr, valueCurrentMax.nativeObjectPtr, valueSpeed, valueMin, valueMax, format.bytes,(byte[]) null, JImSliderFlags.None);}
  public final boolean dragFloatRange2(@NotNull String label, @NotNull NativeFloat valueCurrentMin, @NotNull NativeFloat valueCurrentMax, float valueSpeed, float valueMin, float valueMax){return dragFloatRange2(getBytes(label), valueCurrentMin.nativeObjectPtr, valueCurrentMax.nativeObjectPtr, valueSpeed, valueMin, valueMax,FLOAT_FMT, (byte[]) null, JImSliderFlags.None);}
  public final boolean dragFloatRange2(@NotNull JImStr label, @NotNull NativeFloat valueCurrentMin, @NotNull NativeFloat valueCurrentMax, float valueSpeed, float valueMin, float valueMax){return dragFloatRange2(label.bytes, valueCurrentMin.nativeObjectPtr, valueCurrentMax.nativeObjectPtr, valueSpeed, valueMin, valueMax,FLOAT_FMT, (byte[]) null, JImSliderFlags.None);}
  public final boolean dragFloatRange2(@NotNull String label, @NotNull NativeFloat valueCurrentMin, @NotNull NativeFloat valueCurrentMax, float valueSpeed, float valueMin){return dragFloatRange2(getBytes(label), valueCurrentMin.nativeObjectPtr, valueCurrentMax.nativeObjectPtr, valueSpeed, valueMin,0, FLOAT_FMT, (byte[]) null, JImSliderFlags.None);}
  public final boolean dragFloatRange2(@NotNull JImStr label, @NotNull NativeFloat valueCurrentMin, @NotNull NativeFloat valueCurrentMax, float valueSpeed, float valueMin){return dragFloatRange2(label.bytes, valueCurrentMin.nativeObjectPtr, valueCurrentMax.nativeObjectPtr, valueSpeed, valueMin,0, FLOAT_FMT, (byte[]) null, JImSliderFlags.None);}
  public final boolean dragFloatRange2(@NotNull String label, @NotNull NativeFloat valueCurrentMin, @NotNull NativeFloat valueCurrentMax, float valueSpeed){return dragFloatRange2(getBytes(label), valueCurrentMin.nativeObjectPtr, valueCurrentMax.nativeObjectPtr, valueSpeed,0, 0, FLOAT_FMT, (byte[]) null, JImSliderFlags.None);}
  public final boolean dragFloatRange2(@NotNull JImStr label, @NotNull NativeFloat valueCurrentMin, @NotNull NativeFloat valueCurrentMax, float valueSpeed){return dragFloatRange2(label.bytes, valueCurrentMin.nativeObjectPtr, valueCurrentMax.nativeObjectPtr, valueSpeed,0, 0, FLOAT_FMT, (byte[]) null, JImSliderFlags.None);}
  public final boolean dragFloatRange2(@NotNull String label, @NotNull NativeFloat valueCurrentMin, @NotNull NativeFloat valueCurrentMax){return dragFloatRange2(getBytes(label), valueCurrentMin.nativeObjectPtr, valueCurrentMax.nativeObjectPtr,1, 0, 0, FLOAT_FMT, (byte[]) null, JImSliderFlags.None);}
  public final boolean dragFloatRange2(@NotNull JImStr label, @NotNull NativeFloat valueCurrentMin, @NotNull NativeFloat valueCurrentMax){return dragFloatRange2(label.bytes, valueCurrentMin.nativeObjectPtr, valueCurrentMax.nativeObjectPtr,1, 0, 0, FLOAT_FMT, (byte[]) null, JImSliderFlags.None);}
  public final boolean dragInt(@NotNull String label, @NotNull NativeInt value, float valueSpeed, int valueMin, int valueMax, @NotNull String format, @MagicConstant(flagsFromClass = JImSliderFlags.class)int flags){return dragInt(getBytes(label), value.nativeObjectPtr, valueSpeed, valueMin, valueMax, getBytes(format), flags);}
  public final boolean dragInt(@NotNull JImStr label, @NotNull NativeInt value, float valueSpeed, int valueMin, int valueMax, @NotNull JImStr format, @MagicConstant(flagsFromClass = JImSliderFlags.class)int flags){return dragInt(label.bytes, value.nativeObjectPtr, valueSpeed, valueMin, valueMax, format.bytes, flags);}
  protected static native boolean dragInt(byte[] label, long value, float valueSpeed, int valueMin, int valueMax, byte[] format, @MagicConstant(flagsFromClass = JImSliderFlags.class)int flags);
  public final boolean dragInt(@NotNull String label, @NotNull NativeInt value, float valueSpeed, int valueMin, int valueMax, @NotNull String format){return dragInt(getBytes(label), value.nativeObjectPtr, valueSpeed, valueMin, valueMax, getBytes(format),JImSliderFlags.None);}
  public final boolean dragInt(@NotNull JImStr label, @NotNull NativeInt value, float valueSpeed, int valueMin, int valueMax, @NotNull JImStr format){return dragInt(label.bytes, value.nativeObjectPtr, valueSpeed, valueMin, valueMax, format.bytes,JImSliderFlags.None);}
  public final boolean dragInt(@NotNull String label, @NotNull NativeInt value, float valueSpeed, int valueMin, int valueMax){return dragInt(getBytes(label), value.nativeObjectPtr, valueSpeed, valueMin, valueMax,INT_FMT, JImSliderFlags.None);}
  public final boolean dragInt(@NotNull JImStr label, @NotNull NativeInt value, float valueSpeed, int valueMin, int valueMax){return dragInt(label.bytes, value.nativeObjectPtr, valueSpeed, valueMin, valueMax,INT_FMT, JImSliderFlags.None);}
  public final boolean dragInt(@NotNull String label, @NotNull NativeInt value, float valueSpeed, int valueMin){return dragInt(getBytes(label), value.nativeObjectPtr, valueSpeed, valueMin,0, INT_FMT, JImSliderFlags.None);}
  public final boolean dragInt(@NotNull JImStr label, @NotNull NativeInt value, float valueSpeed, int valueMin){return dragInt(label.bytes, value.nativeObjectPtr, valueSpeed, valueMin,0, INT_FMT, JImSliderFlags.None);}
  public final boolean dragInt(@NotNull String label, @NotNull NativeInt value, float valueSpeed){return dragInt(getBytes(label), value.nativeObjectPtr, valueSpeed,0, 0, INT_FMT, JImSliderFlags.None);}
  public final boolean dragInt(@NotNull JImStr label, @NotNull NativeInt value, float valueSpeed){return dragInt(label.bytes, value.nativeObjectPtr, valueSpeed,0, 0, INT_FMT, JImSliderFlags.None);}
  public final boolean dragInt(@NotNull String label, @NotNull NativeInt value){return dragInt(getBytes(label), value.nativeObjectPtr,1, 0, 0, INT_FMT, JImSliderFlags.None);}
  public final boolean dragInt(@NotNull JImStr label, @NotNull NativeInt value){return dragInt(label.bytes, value.nativeObjectPtr,1, 0, 0, INT_FMT, JImSliderFlags.None);}
  public final boolean dragIntRange2(@NotNull String label, @NotNull NativeInt valueCurrentMin, @NotNull NativeInt valueCurrentMax, float valueSpeed, int valueMin, int valueMax, @NotNull String format, @NotNull String formatMax, @MagicConstant(flagsFromClass = JImSliderFlags.class)int flags){return dragIntRange2(getBytes(label), valueCurrentMin.nativeObjectPtr, valueCurrentMax.nativeObjectPtr, valueSpeed, valueMin, valueMax, getBytes(format), getBytes(formatMax), flags);}
  public final boolean dragIntRange2(@NotNull JImStr label, @NotNull NativeInt valueCurrentMin, @NotNull NativeInt valueCurrentMax, float valueSpeed, int valueMin, int valueMax, @NotNull JImStr format, @NotNull JImStr formatMax, @MagicConstant(flagsFromClass = JImSliderFlags.class)int flags){return dragIntRange2(label.bytes, valueCurrentMin.nativeObjectPtr, valueCurrentMax.nativeObjectPtr, valueSpeed, valueMin, valueMax, format.bytes, formatMax.bytes, flags);}
  protected static native boolean dragIntRange2(byte[] label, long valueCurrentMin, long valueCurrentMax, float valueSpeed, int valueMin, int valueMax, byte[] format, byte[] formatMax, @MagicConstant(flagsFromClass = JImSliderFlags.class)int flags);
  public final boolean dragIntRange2(@NotNull String label, @NotNull NativeInt valueCurrentMin, @NotNull NativeInt valueCurrentMax, float valueSpeed, int valueMin, int valueMax, @NotNull String format, @NotNull String formatMax){return dragIntRange2(getBytes(label), valueCurrentMin.nativeObjectPtr, valueCurrentMax.nativeObjectPtr, valueSpeed, valueMin, valueMax, getBytes(format), getBytes(formatMax),JImSliderFlags.None);}
  public final boolean dragIntRange2(@NotNull JImStr label, @NotNull NativeInt valueCurrentMin, @NotNull NativeInt valueCurrentMax, float valueSpeed, int valueMin, int valueMax, @NotNull JImStr format, @NotNull JImStr formatMax){return dragIntRange2(label.bytes, valueCurrentMin.nativeObjectPtr, valueCurrentMax.nativeObjectPtr, valueSpeed, valueMin, valueMax, format.bytes, formatMax.bytes,JImSliderFlags.None);}
  public final boolean dragIntRange2(@NotNull String label, @NotNull NativeInt valueCurrentMin, @NotNull NativeInt valueCurrentMax, float valueSpeed, int valueMin, int valueMax, @NotNull String format){return dragIntRange2(getBytes(label), valueCurrentMin.nativeObjectPtr, valueCurrentMax.nativeObjectPtr, valueSpeed, valueMin, valueMax, getBytes(format),INT_FMT, JImSliderFlags.None);}
  public final boolean dragIntRange2(@NotNull JImStr label, @NotNull NativeInt valueCurrentMin, @NotNull NativeInt valueCurrentMax, float valueSpeed, int valueMin, int valueMax, @NotNull JImStr format){return dragIntRange2(label.bytes, valueCurrentMin.nativeObjectPtr, valueCurrentMax.nativeObjectPtr, valueSpeed, valueMin, valueMax, format.bytes,INT_FMT, JImSliderFlags.None);}
  public final boolean dragIntRange2(@NotNull String label, @NotNull NativeInt valueCurrentMin, @NotNull NativeInt valueCurrentMax, float valueSpeed, int valueMin, int valueMax){return dragIntRange2(getBytes(label), valueCurrentMin.nativeObjectPtr, valueCurrentMax.nativeObjectPtr, valueSpeed, valueMin, valueMax,INT_FMT, INT_FMT, JImSliderFlags.None);}
  public final boolean dragIntRange2(@NotNull JImStr label, @NotNull NativeInt valueCurrentMin, @NotNull NativeInt valueCurrentMax, float valueSpeed, int valueMin, int valueMax){return dragIntRange2(label.bytes, valueCurrentMin.nativeObjectPtr, valueCurrentMax.nativeObjectPtr, valueSpeed, valueMin, valueMax,INT_FMT, INT_FMT, JImSliderFlags.None);}
  public final boolean dragIntRange2(@NotNull String label, @NotNull NativeInt valueCurrentMin, @NotNull NativeInt valueCurrentMax, float valueSpeed, int valueMin){return dragIntRange2(getBytes(label), valueCurrentMin.nativeObjectPtr, valueCurrentMax.nativeObjectPtr, valueSpeed, valueMin,0, INT_FMT, INT_FMT, JImSliderFlags.None);}
  public final boolean dragIntRange2(@NotNull JImStr label, @NotNull NativeInt valueCurrentMin, @NotNull NativeInt valueCurrentMax, float valueSpeed, int valueMin){return dragIntRange2(label.bytes, valueCurrentMin.nativeObjectPtr, valueCurrentMax.nativeObjectPtr, valueSpeed, valueMin,0, INT_FMT, INT_FMT, JImSliderFlags.None);}
  public final boolean dragIntRange2(@NotNull String label, @NotNull NativeInt valueCurrentMin, @NotNull NativeInt valueCurrentMax, float valueSpeed){return dragIntRange2(getBytes(label), valueCurrentMin.nativeObjectPtr, valueCurrentMax.nativeObjectPtr, valueSpeed,0, 0, INT_FMT, INT_FMT, JImSliderFlags.None);}
  public final boolean dragIntRange2(@NotNull JImStr label, @NotNull NativeInt valueCurrentMin, @NotNull NativeInt valueCurrentMax, float valueSpeed){return dragIntRange2(label.bytes, valueCurrentMin.nativeObjectPtr, valueCurrentMax.nativeObjectPtr, valueSpeed,0, 0, INT_FMT, INT_FMT, JImSliderFlags.None);}
  public final boolean dragIntRange2(@NotNull String label, @NotNull NativeInt valueCurrentMin, @NotNull NativeInt valueCurrentMax){return dragIntRange2(getBytes(label), valueCurrentMin.nativeObjectPtr, valueCurrentMax.nativeObjectPtr,1, 0, 0, INT_FMT, INT_FMT, JImSliderFlags.None);}
  public final boolean dragIntRange2(@NotNull JImStr label, @NotNull NativeInt valueCurrentMin, @NotNull NativeInt valueCurrentMax){return dragIntRange2(label.bytes, valueCurrentMin.nativeObjectPtr, valueCurrentMax.nativeObjectPtr,1, 0, 0, INT_FMT, INT_FMT, JImSliderFlags.None);}
  public final boolean inputFloat(@NotNull String label, @NotNull NativeFloat value, float step, float stepFast, @NotNull String format, @MagicConstant(flagsFromClass = JImInputTextFlags.class)int flags){return inputFloat(getBytes(label), value.nativeObjectPtr, step, stepFast, getBytes(format), flags);}
  public final boolean inputFloat(@NotNull JImStr label, @NotNull NativeFloat value, float step, float stepFast, @NotNull JImStr format, @MagicConstant(flagsFromClass = JImInputTextFlags.class)int flags){return inputFloat(label.bytes, value.nativeObjectPtr, step, stepFast, format.bytes, flags);}
  protected static native boolean inputFloat(byte[] label, long value, float step, float stepFast, byte[] format, @MagicConstant(flagsFromClass = JImInputTextFlags.class)int flags);
  public final boolean inputFloat(@NotNull String label, @NotNull NativeFloat value, float step, float stepFast, @NotNull String format){return inputFloat(getBytes(label), value.nativeObjectPtr, step, stepFast, getBytes(format),JImInputTextFlags.None);}
  public final boolean inputFloat(@NotNull JImStr label, @NotNull NativeFloat value, float step, float stepFast, @NotNull JImStr format){return inputFloat(label.bytes, value.nativeObjectPtr, step, stepFast, format.bytes,JImInputTextFlags.None);}
  public final boolean inputFloat(@NotNull String label, @NotNull NativeFloat value, float step, float stepFast){return inputFloat(getBytes(label), value.nativeObjectPtr, step, stepFast,FLOAT_FMT, JImInputTextFlags.None);}
  public final boolean inputFloat(@NotNull JImStr label, @NotNull NativeFloat value, float step, float stepFast){return inputFloat(label.bytes, value.nativeObjectPtr, step, stepFast,FLOAT_FMT, JImInputTextFlags.None);}
  public final boolean inputFloat(@NotNull String label, @NotNull NativeFloat value, float step){return inputFloat(getBytes(label), value.nativeObjectPtr, step,0, FLOAT_FMT, JImInputTextFlags.None);}
  public final boolean inputFloat(@NotNull JImStr label, @NotNull NativeFloat value, float step){return inputFloat(label.bytes, value.nativeObjectPtr, step,0, FLOAT_FMT, JImInputTextFlags.None);}
  public final boolean inputFloat(@NotNull String label, @NotNull NativeFloat value){return inputFloat(getBytes(label), value.nativeObjectPtr,0, 0, FLOAT_FMT, JImInputTextFlags.None);}
  public final boolean inputFloat(@NotNull JImStr label, @NotNull NativeFloat value){return inputFloat(label.bytes, value.nativeObjectPtr,0, 0, FLOAT_FMT, JImInputTextFlags.None);}
  public final boolean inputInt(@NotNull String label, @NotNull NativeInt value, int step, int stepFast, @MagicConstant(flagsFromClass = JImInputTextFlags.class)int flags){return inputInt(getBytes(label), value.nativeObjectPtr, step, stepFast, flags);}
  public final boolean inputInt(@NotNull JImStr label, @NotNull NativeInt value, int step, int stepFast, @MagicConstant(flagsFromClass = JImInputTextFlags.class)int flags){return inputInt(label.bytes, value.nativeObjectPtr, step, stepFast, flags);}
  protected static native boolean inputInt(byte[] label, long value, int step, int stepFast, @MagicConstant(flagsFromClass = JImInputTextFlags.class)int flags);
  public final boolean inputInt(@NotNull String label, @NotNull NativeInt value, int step, int stepFast){return inputInt(getBytes(label), value.nativeObjectPtr, step, stepFast,JImInputTextFlags.None);}
  public final boolean inputInt(@NotNull JImStr label, @NotNull NativeInt value, int step, int stepFast){return inputInt(label.bytes, value.nativeObjectPtr, step, stepFast,JImInputTextFlags.None);}
  public final boolean inputInt(@NotNull String label, @NotNull NativeInt value, int step){return inputInt(getBytes(label), value.nativeObjectPtr, step,100, JImInputTextFlags.None);}
  public final boolean inputInt(@NotNull JImStr label, @NotNull NativeInt value, int step){return inputInt(label.bytes, value.nativeObjectPtr, step,100, JImInputTextFlags.None);}
  public final boolean inputInt(@NotNull String label, @NotNull NativeInt value){return inputInt(getBytes(label), value.nativeObjectPtr,1, 100, JImInputTextFlags.None);}
  public final boolean inputInt(@NotNull JImStr label, @NotNull NativeInt value){return inputInt(label.bytes, value.nativeObjectPtr,1, 100, JImInputTextFlags.None);}
  public final boolean inputDouble(@NotNull String label, @NotNull NativeDouble value, double step, double stepFast, @NotNull String format, @MagicConstant(flagsFromClass = JImInputTextFlags.class)int flags){return inputDouble(getBytes(label), value.nativeObjectPtr, step, stepFast, getBytes(format), flags);}
  public final boolean inputDouble(@NotNull JImStr label, @NotNull NativeDouble value, double step, double stepFast, @NotNull JImStr format, @MagicConstant(flagsFromClass = JImInputTextFlags.class)int flags){return inputDouble(label.bytes, value.nativeObjectPtr, step, stepFast, format.bytes, flags);}
  protected static native boolean inputDouble(byte[] label, long value, double step, double stepFast, byte[] format, @MagicConstant(flagsFromClass = JImInputTextFlags.class)int flags);
  public final boolean inputDouble(@NotNull String label, @NotNull NativeDouble value, double step, double stepFast, @NotNull String format){return inputDouble(getBytes(label), value.nativeObjectPtr, step, stepFast, getBytes(format),JImInputTextFlags.None);}
  public final boolean inputDouble(@NotNull JImStr label, @NotNull NativeDouble value, double step, double stepFast, @NotNull JImStr format){return inputDouble(label.bytes, value.nativeObjectPtr, step, stepFast, format.bytes,JImInputTextFlags.None);}
  public final boolean inputDouble(@NotNull String label, @NotNull NativeDouble value, double step, double stepFast){return inputDouble(getBytes(label), value.nativeObjectPtr, step, stepFast,DOUBLE_FMT, JImInputTextFlags.None);}
  public final boolean inputDouble(@NotNull JImStr label, @NotNull NativeDouble value, double step, double stepFast){return inputDouble(label.bytes, value.nativeObjectPtr, step, stepFast,DOUBLE_FMT, JImInputTextFlags.None);}
  public final boolean inputDouble(@NotNull String label, @NotNull NativeDouble value, double step){return inputDouble(getBytes(label), value.nativeObjectPtr, step,0, DOUBLE_FMT, JImInputTextFlags.None);}
  public final boolean inputDouble(@NotNull JImStr label, @NotNull NativeDouble value, double step){return inputDouble(label.bytes, value.nativeObjectPtr, step,0, DOUBLE_FMT, JImInputTextFlags.None);}
  public final boolean inputDouble(@NotNull String label, @NotNull NativeDouble value){return inputDouble(getBytes(label), value.nativeObjectPtr,0, 0, DOUBLE_FMT, JImInputTextFlags.None);}
  public final boolean inputDouble(@NotNull JImStr label, @NotNull NativeDouble value){return inputDouble(label.bytes, value.nativeObjectPtr,0, 0, DOUBLE_FMT, JImInputTextFlags.None);}
  public final boolean inputText(@NotNull String label, @NotNull NativeString value, @MagicConstant(flagsFromClass = JImInputTextFlags.class)int flags){return inputText(getBytes(label), value.nativeObjectPtr, flags);}
  public final boolean inputText(@NotNull JImStr label, @NotNull NativeString value, @MagicConstant(flagsFromClass = JImInputTextFlags.class)int flags){return inputText(label.bytes, value.nativeObjectPtr, flags);}
  protected static native boolean inputText(byte[] label, long value, @MagicConstant(flagsFromClass = JImInputTextFlags.class)int flags);
  public final boolean inputText(@NotNull String label, @NotNull NativeString value){return inputText(getBytes(label), value.nativeObjectPtr,JImInputTextFlags.None);}
  public final boolean inputText(@NotNull JImStr label, @NotNull NativeString value){return inputText(label.bytes, value.nativeObjectPtr,JImInputTextFlags.None);}
  public final boolean inputTextMultiline(@NotNull String label, @NotNull NativeString value, float width, float height, @MagicConstant(flagsFromClass = JImInputTextFlags.class)int flags){return inputTextMultiline(getBytes(label), value.nativeObjectPtr, width, height, flags);}
  public final boolean inputTextMultiline(@NotNull JImStr label, @NotNull NativeString value, float width, float height, @MagicConstant(flagsFromClass = JImInputTextFlags.class)int flags){return inputTextMultiline(label.bytes, value.nativeObjectPtr, width, height, flags);}
  protected static native boolean inputTextMultiline(byte[] label, long value, float width, float height, @MagicConstant(flagsFromClass = JImInputTextFlags.class)int flags);
  public final boolean inputTextMultiline(@NotNull String label, @NotNull NativeString value, float width, float height){return inputTextMultiline(getBytes(label), value.nativeObjectPtr, width, height,JImInputTextFlags.None);}
  public final boolean inputTextMultiline(@NotNull JImStr label, @NotNull NativeString value, float width, float height){return inputTextMultiline(label.bytes, value.nativeObjectPtr, width, height,JImInputTextFlags.None);}
  public final boolean inputTextMultiline(@NotNull String label, @NotNull NativeString value){return inputTextMultiline(getBytes(label), value.nativeObjectPtr,0,0, JImInputTextFlags.None);}
  public final boolean inputTextMultiline(@NotNull JImStr label, @NotNull NativeString value){return inputTextMultiline(label.bytes, value.nativeObjectPtr,0,0, JImInputTextFlags.None);}
  public final boolean inputTextWithHint(@NotNull String label, @NotNull String hint, @NotNull NativeString value, @MagicConstant(flagsFromClass = JImInputTextFlags.class)int flags){return inputTextWithHint(getBytes(label), getBytes(hint), value.nativeObjectPtr, flags);}
  public final boolean inputTextWithHint(@NotNull JImStr label, @NotNull JImStr hint, @NotNull NativeString value, @MagicConstant(flagsFromClass = JImInputTextFlags.class)int flags){return inputTextWithHint(label.bytes, hint.bytes, value.nativeObjectPtr, flags);}
  protected static native boolean inputTextWithHint(byte[] label, byte[] hint, long value, @MagicConstant(flagsFromClass = JImInputTextFlags.class)int flags);
  public final boolean inputTextWithHint(@NotNull String label, @NotNull String hint, @NotNull NativeString value){return inputTextWithHint(getBytes(label), getBytes(hint), value.nativeObjectPtr,JImInputTextFlags.None);}
  public final boolean inputTextWithHint(@NotNull JImStr label, @NotNull JImStr hint, @NotNull NativeString value){return inputTextWithHint(label.bytes, hint.bytes, value.nativeObjectPtr,JImInputTextFlags.None);}
  public final boolean sliderFloat(@NotNull String label, @NotNull NativeFloat value, float valueMin, float valueMax, @NotNull String format, @MagicConstant(flagsFromClass = JImSliderFlags.class)int flags){return sliderFloat(getBytes(label), value.nativeObjectPtr, valueMin, valueMax, getBytes(format), flags);}
  public final boolean sliderFloat(@NotNull JImStr label, @NotNull NativeFloat value, float valueMin, float valueMax, @NotNull JImStr format, @MagicConstant(flagsFromClass = JImSliderFlags.class)int flags){return sliderFloat(label.bytes, value.nativeObjectPtr, valueMin, valueMax, format.bytes, flags);}
  protected static native boolean sliderFloat(byte[] label, long value, float valueMin, float valueMax, byte[] format, @MagicConstant(flagsFromClass = JImSliderFlags.class)int flags);
  public final boolean sliderFloat(@NotNull String label, @NotNull NativeFloat value, float valueMin, float valueMax, @NotNull String format){return sliderFloat(getBytes(label), value.nativeObjectPtr, valueMin, valueMax, getBytes(format),JImSliderFlags.None);}
  public final boolean sliderFloat(@NotNull JImStr label, @NotNull NativeFloat value, float valueMin, float valueMax, @NotNull JImStr format){return sliderFloat(label.bytes, value.nativeObjectPtr, valueMin, valueMax, format.bytes,JImSliderFlags.None);}
  public final boolean sliderFloat(@NotNull String label, @NotNull NativeFloat value, float valueMin, float valueMax){return sliderFloat(getBytes(label), value.nativeObjectPtr, valueMin, valueMax,FLOAT_FMT, JImSliderFlags.None);}
  public final boolean sliderFloat(@NotNull JImStr label, @NotNull NativeFloat value, float valueMin, float valueMax){return sliderFloat(label.bytes, value.nativeObjectPtr, valueMin, valueMax,FLOAT_FMT, JImSliderFlags.None);}
  public final boolean sliderFloat(@NotNull String label, @NotNull NativeFloat value, float valueMin){return sliderFloat(getBytes(label), value.nativeObjectPtr, valueMin,0, FLOAT_FMT, JImSliderFlags.None);}
  public final boolean sliderFloat(@NotNull JImStr label, @NotNull NativeFloat value, float valueMin){return sliderFloat(label.bytes, value.nativeObjectPtr, valueMin,0, FLOAT_FMT, JImSliderFlags.None);}
  public final boolean sliderFloat(@NotNull String label, @NotNull NativeFloat value){return sliderFloat(getBytes(label), value.nativeObjectPtr,0, 0, FLOAT_FMT, JImSliderFlags.None);}
  public final boolean sliderFloat(@NotNull JImStr label, @NotNull NativeFloat value){return sliderFloat(label.bytes, value.nativeObjectPtr,0, 0, FLOAT_FMT, JImSliderFlags.None);}
  public final boolean sliderAngle(@NotNull String label, @NotNull NativeFloat valueRad, float valueDegreeMin, float valueDegreeMax, @NotNull String format, @MagicConstant(flagsFromClass = JImSliderFlags.class)int flags){return sliderAngle(getBytes(label), valueRad.nativeObjectPtr, valueDegreeMin, valueDegreeMax, getBytes(format), flags);}
  public final boolean sliderAngle(@NotNull JImStr label, @NotNull NativeFloat valueRad, float valueDegreeMin, float valueDegreeMax, @NotNull JImStr format, @MagicConstant(flagsFromClass = JImSliderFlags.class)int flags){return sliderAngle(label.bytes, valueRad.nativeObjectPtr, valueDegreeMin, valueDegreeMax, format.bytes, flags);}
  protected static native boolean sliderAngle(byte[] label, long valueRad, float valueDegreeMin, float valueDegreeMax, byte[] format, @MagicConstant(flagsFromClass = JImSliderFlags.class)int flags);
  public final boolean sliderAngle(@NotNull String label, @NotNull NativeFloat valueRad, float valueDegreeMin, float valueDegreeMax, @NotNull String format){return sliderAngle(getBytes(label), valueRad.nativeObjectPtr, valueDegreeMin, valueDegreeMax, getBytes(format),JImSliderFlags.None);}
  public final boolean sliderAngle(@NotNull JImStr label, @NotNull NativeFloat valueRad, float valueDegreeMin, float valueDegreeMax, @NotNull JImStr format){return sliderAngle(label.bytes, valueRad.nativeObjectPtr, valueDegreeMin, valueDegreeMax, format.bytes,JImSliderFlags.None);}
  public final boolean sliderAngle(@NotNull String label, @NotNull NativeFloat valueRad, float valueDegreeMin, float valueDegreeMax){return sliderAngle(getBytes(label), valueRad.nativeObjectPtr, valueDegreeMin, valueDegreeMax,FLOAT_FMT, JImSliderFlags.None);}
  public final boolean sliderAngle(@NotNull JImStr label, @NotNull NativeFloat valueRad, float valueDegreeMin, float valueDegreeMax){return sliderAngle(label.bytes, valueRad.nativeObjectPtr, valueDegreeMin, valueDegreeMax,FLOAT_FMT, JImSliderFlags.None);}
  public final boolean sliderAngle(@NotNull String label, @NotNull NativeFloat valueRad, float valueDegreeMin){return sliderAngle(getBytes(label), valueRad.nativeObjectPtr, valueDegreeMin,360, FLOAT_FMT, JImSliderFlags.None);}
  public final boolean sliderAngle(@NotNull JImStr label, @NotNull NativeFloat valueRad, float valueDegreeMin){return sliderAngle(label.bytes, valueRad.nativeObjectPtr, valueDegreeMin,360, FLOAT_FMT, JImSliderFlags.None);}
  public final boolean sliderAngle(@NotNull String label, @NotNull NativeFloat valueRad){return sliderAngle(getBytes(label), valueRad.nativeObjectPtr,-360, 360, FLOAT_FMT, JImSliderFlags.None);}
  public final boolean sliderAngle(@NotNull JImStr label, @NotNull NativeFloat valueRad){return sliderAngle(label.bytes, valueRad.nativeObjectPtr,-360, 360, FLOAT_FMT, JImSliderFlags.None);}
  public final boolean sliderInt(@NotNull String label, @NotNull NativeInt value, int valueMin, int valueMax, @NotNull String format, @MagicConstant(flagsFromClass = JImSliderFlags.class)int flags){return sliderInt(getBytes(label), value.nativeObjectPtr, valueMin, valueMax, getBytes(format), flags);}
  public final boolean sliderInt(@NotNull JImStr label, @NotNull NativeInt value, int valueMin, int valueMax, @NotNull JImStr format, @MagicConstant(flagsFromClass = JImSliderFlags.class)int flags){return sliderInt(label.bytes, value.nativeObjectPtr, valueMin, valueMax, format.bytes, flags);}
  protected static native boolean sliderInt(byte[] label, long value, int valueMin, int valueMax, byte[] format, @MagicConstant(flagsFromClass = JImSliderFlags.class)int flags);
  public final boolean sliderInt(@NotNull String label, @NotNull NativeInt value, int valueMin, int valueMax, @NotNull String format){return sliderInt(getBytes(label), value.nativeObjectPtr, valueMin, valueMax, getBytes(format),JImSliderFlags.None);}
  public final boolean sliderInt(@NotNull JImStr label, @NotNull NativeInt value, int valueMin, int valueMax, @NotNull JImStr format){return sliderInt(label.bytes, value.nativeObjectPtr, valueMin, valueMax, format.bytes,JImSliderFlags.None);}
  public final boolean sliderInt(@NotNull String label, @NotNull NativeInt value, int valueMin, int valueMax){return sliderInt(getBytes(label), value.nativeObjectPtr, valueMin, valueMax,INT_FMT, JImSliderFlags.None);}
  public final boolean sliderInt(@NotNull JImStr label, @NotNull NativeInt value, int valueMin, int valueMax){return sliderInt(label.bytes, value.nativeObjectPtr, valueMin, valueMax,INT_FMT, JImSliderFlags.None);}
  public final boolean sliderInt(@NotNull String label, @NotNull NativeInt value, int valueMin){return sliderInt(getBytes(label), value.nativeObjectPtr, valueMin,0, INT_FMT, JImSliderFlags.None);}
  public final boolean sliderInt(@NotNull JImStr label, @NotNull NativeInt value, int valueMin){return sliderInt(label.bytes, value.nativeObjectPtr, valueMin,0, INT_FMT, JImSliderFlags.None);}
  public final boolean sliderInt(@NotNull String label, @NotNull NativeInt value){return sliderInt(getBytes(label), value.nativeObjectPtr,0, 0, INT_FMT, JImSliderFlags.None);}
  public final boolean sliderInt(@NotNull JImStr label, @NotNull NativeInt value){return sliderInt(label.bytes, value.nativeObjectPtr,0, 0, INT_FMT, JImSliderFlags.None);}
  public final boolean vSliderFloat(@NotNull String label, float width, float height, @NotNull NativeFloat value, float valueMin, float valueMax, @NotNull String format, @MagicConstant(flagsFromClass = JImSliderFlags.class)int flags){return vSliderFloat(getBytes(label), width, height, value.nativeObjectPtr, valueMin, valueMax, getBytes(format), flags);}
  public final boolean vSliderFloat(@NotNull JImStr label, float width, float height, @NotNull NativeFloat value, float valueMin, float valueMax, @NotNull JImStr format, @MagicConstant(flagsFromClass = JImSliderFlags.class)int flags){return vSliderFloat(label.bytes, width, height, value.nativeObjectPtr, valueMin, valueMax, format.bytes, flags);}
  protected static native boolean vSliderFloat(byte[] label, float width, float height, long value, float valueMin, float valueMax, byte[] format, @MagicConstant(flagsFromClass = JImSliderFlags.class)int flags);
  public final boolean vSliderFloat(@NotNull String label, float width, float height, @NotNull NativeFloat value, float valueMin, float valueMax, @NotNull String format){return vSliderFloat(getBytes(label), width, height, value.nativeObjectPtr, valueMin, valueMax, getBytes(format),JImSliderFlags.None);}
  public final boolean vSliderFloat(@NotNull JImStr label, float width, float height, @NotNull NativeFloat value, float valueMin, float valueMax, @NotNull JImStr format){return vSliderFloat(label.bytes, width, height, value.nativeObjectPtr, valueMin, valueMax, format.bytes,JImSliderFlags.None);}
  public final boolean vSliderFloat(@NotNull String label, float width, float height, @NotNull NativeFloat value, float valueMin, float valueMax){return vSliderFloat(getBytes(label), width, height, value.nativeObjectPtr, valueMin, valueMax,FLOAT_FMT, JImSliderFlags.None);}
  public final boolean vSliderFloat(@NotNull JImStr label, float width, float height, @NotNull NativeFloat value, float valueMin, float valueMax){return vSliderFloat(label.bytes, width, height, value.nativeObjectPtr, valueMin, valueMax,FLOAT_FMT, JImSliderFlags.None);}
  public final boolean vSliderFloat(@NotNull String label, float width, float height, @NotNull NativeFloat value, float valueMin){return vSliderFloat(getBytes(label), width, height, value.nativeObjectPtr, valueMin,0, FLOAT_FMT, JImSliderFlags.None);}
  public final boolean vSliderFloat(@NotNull JImStr label, float width, float height, @NotNull NativeFloat value, float valueMin){return vSliderFloat(label.bytes, width, height, value.nativeObjectPtr, valueMin,0, FLOAT_FMT, JImSliderFlags.None);}
  public final boolean vSliderFloat(@NotNull String label, float width, float height, @NotNull NativeFloat value){return vSliderFloat(getBytes(label), width, height, value.nativeObjectPtr,0, 0, FLOAT_FMT, JImSliderFlags.None);}
  public final boolean vSliderFloat(@NotNull JImStr label, float width, float height, @NotNull NativeFloat value){return vSliderFloat(label.bytes, width, height, value.nativeObjectPtr,0, 0, FLOAT_FMT, JImSliderFlags.None);}
  public final boolean vSliderInt(@NotNull String label, float width, float height, @NotNull NativeInt value, int valueMin, int valueMax, @NotNull String format, @MagicConstant(flagsFromClass = JImSliderFlags.class)int flags){return vSliderInt(getBytes(label), width, height, value.nativeObjectPtr, valueMin, valueMax, getBytes(format), flags);}
  public final boolean vSliderInt(@NotNull JImStr label, float width, float height, @NotNull NativeInt value, int valueMin, int valueMax, @NotNull JImStr format, @MagicConstant(flagsFromClass = JImSliderFlags.class)int flags){return vSliderInt(label.bytes, width, height, value.nativeObjectPtr, valueMin, valueMax, format.bytes, flags);}
  protected static native boolean vSliderInt(byte[] label, float width, float height, long value, int valueMin, int valueMax, byte[] format, @MagicConstant(flagsFromClass = JImSliderFlags.class)int flags);
  public final boolean vSliderInt(@NotNull String label, float width, float height, @NotNull NativeInt value, int valueMin, int valueMax, @NotNull String format){return vSliderInt(getBytes(label), width, height, value.nativeObjectPtr, valueMin, valueMax, getBytes(format),JImSliderFlags.None);}
  public final boolean vSliderInt(@NotNull JImStr label, float width, float height, @NotNull NativeInt value, int valueMin, int valueMax, @NotNull JImStr format){return vSliderInt(label.bytes, width, height, value.nativeObjectPtr, valueMin, valueMax, format.bytes,JImSliderFlags.None);}
  public final boolean vSliderInt(@NotNull String label, float width, float height, @NotNull NativeInt value, int valueMin, int valueMax){return vSliderInt(getBytes(label), width, height, value.nativeObjectPtr, valueMin, valueMax,INT_FMT, JImSliderFlags.None);}
  public final boolean vSliderInt(@NotNull JImStr label, float width, float height, @NotNull NativeInt value, int valueMin, int valueMax){return vSliderInt(label.bytes, width, height, value.nativeObjectPtr, valueMin, valueMax,INT_FMT, JImSliderFlags.None);}
  public final boolean vSliderInt(@NotNull String label, float width, float height, @NotNull NativeInt value, int valueMin){return vSliderInt(getBytes(label), width, height, value.nativeObjectPtr, valueMin,0, INT_FMT, JImSliderFlags.None);}
  public final boolean vSliderInt(@NotNull JImStr label, float width, float height, @NotNull NativeInt value, int valueMin){return vSliderInt(label.bytes, width, height, value.nativeObjectPtr, valueMin,0, INT_FMT, JImSliderFlags.None);}
  public final boolean vSliderInt(@NotNull String label, float width, float height, @NotNull NativeInt value){return vSliderInt(getBytes(label), width, height, value.nativeObjectPtr,0, 0, INT_FMT, JImSliderFlags.None);}
  public final boolean vSliderInt(@NotNull JImStr label, float width, float height, @NotNull NativeInt value){return vSliderInt(label.bytes, width, height, value.nativeObjectPtr,0, 0, INT_FMT, JImSliderFlags.None);}
  public final boolean treeNode(@NotNull String label){return treeNode(getBytes(label));}
  public final boolean treeNode(@NotNull JImStr label){return treeNode(label.bytes);}
  protected static native boolean treeNode(byte[] label);
  public final boolean treeNodeEx(@NotNull String label, @MagicConstant(flagsFromClass = JImTreeNodeFlags.class)int flags){return treeNodeEx(getBytes(label), flags);}
  public final boolean treeNodeEx(@NotNull JImStr label, @MagicConstant(flagsFromClass = JImTreeNodeFlags.class)int flags){return treeNodeEx(label.bytes, flags);}
  protected static native boolean treeNodeEx(byte[] label, @MagicConstant(flagsFromClass = JImTreeNodeFlags.class)int flags);
  public final boolean treeNodeEx(@NotNull String label){return treeNodeEx(getBytes(label),JImTreeNodeFlags.Selected);}
  public final boolean treeNodeEx(@NotNull JImStr label){return treeNodeEx(label.bytes,JImTreeNodeFlags.Selected);}
  public final void treePush(@NotNull String stringID){treePush(getBytes(stringID));}
  public final void treePush(@NotNull JImStr stringID){treePush(stringID.bytes);}
  protected static native void treePush(byte[] stringID);
  public static native void treePop();
  public static native float getTreeNodeToLabelSpacing();
  public static native void SetNextItemOpen(boolean isOpen, @MagicConstant(valuesFromClass = JImCond.class)int condition);
  public final void SetNextItemOpen(boolean isOpen){SetNextItemOpen(isOpen,JImCond.Always);}
  public final boolean collapsingHeader(@NotNull String label, @NotNull NativeBool openPtr, @MagicConstant(flagsFromClass = JImTreeNodeFlags.class)int flags){return collapsingHeader(getBytes(label), openPtr.nativeObjectPtr, flags);}
  public final boolean collapsingHeader(@NotNull JImStr label, @NotNull NativeBool openPtr, @MagicConstant(flagsFromClass = JImTreeNodeFlags.class)int flags){return collapsingHeader(label.bytes, openPtr.nativeObjectPtr, flags);}
  protected static native boolean collapsingHeader(byte[] label, long openPtr, @MagicConstant(flagsFromClass = JImTreeNodeFlags.class)int flags);
  public final boolean collapsingHeader(@NotNull String label, @NotNull NativeBool openPtr){return collapsingHeader(getBytes(label), openPtr.nativeObjectPtr,JImTreeNodeFlags.Selected);}
  public final boolean collapsingHeader(@NotNull JImStr label, @NotNull NativeBool openPtr){return collapsingHeader(label.bytes, openPtr.nativeObjectPtr,JImTreeNodeFlags.Selected);}
  public final boolean collapsingHeader(@NotNull String label){return collapsingHeader(getBytes(label),0, JImTreeNodeFlags.Selected);}
  public final boolean collapsingHeader(@NotNull JImStr label){return collapsingHeader(label.bytes,0, JImTreeNodeFlags.Selected);}
  public final boolean colorEdit3(@NotNull String label, @NotNull JImVec4 color, @MagicConstant(flagsFromClass = JImColorEditFlags.class)int flags){return colorEdit3(getBytes(label), color.nativeObjectPtr, flags);}
  public final boolean colorEdit3(@NotNull JImStr label, @NotNull JImVec4 color, @MagicConstant(flagsFromClass = JImColorEditFlags.class)int flags){return colorEdit3(label.bytes, color.nativeObjectPtr, flags);}
  protected static native boolean colorEdit3(byte[] label, long color, @MagicConstant(flagsFromClass = JImColorEditFlags.class)int flags);
  public final boolean colorEdit3(@NotNull String label, @NotNull JImVec4 color){return colorEdit3(getBytes(label), color.nativeObjectPtr,JImColorEditFlags.None);}
  public final boolean colorEdit3(@NotNull JImStr label, @NotNull JImVec4 color){return colorEdit3(label.bytes, color.nativeObjectPtr,JImColorEditFlags.None);}
  public final boolean colorEdit4(@NotNull String label, @NotNull JImVec4 color, @MagicConstant(flagsFromClass = JImColorEditFlags.class)int flags){return colorEdit4(getBytes(label), color.nativeObjectPtr, flags);}
  public final boolean colorEdit4(@NotNull JImStr label, @NotNull JImVec4 color, @MagicConstant(flagsFromClass = JImColorEditFlags.class)int flags){return colorEdit4(label.bytes, color.nativeObjectPtr, flags);}
  protected static native boolean colorEdit4(byte[] label, long color, @MagicConstant(flagsFromClass = JImColorEditFlags.class)int flags);
  public final boolean colorEdit4(@NotNull String label, @NotNull JImVec4 color){return colorEdit4(getBytes(label), color.nativeObjectPtr,JImColorEditFlags.None);}
  public final boolean colorEdit4(@NotNull JImStr label, @NotNull JImVec4 color){return colorEdit4(label.bytes, color.nativeObjectPtr,JImColorEditFlags.None);}
  public final boolean colorButton(@NotNull String descriptionID, @NotNull JImVec4 color, @MagicConstant(flagsFromClass = JImColorEditFlags.class)int flags, float width, float height){return colorButton(getBytes(descriptionID), color.nativeObjectPtr, flags, width, height);}
  public final boolean colorButton(@NotNull JImStr descriptionID, @NotNull JImVec4 color, @MagicConstant(flagsFromClass = JImColorEditFlags.class)int flags, float width, float height){return colorButton(descriptionID.bytes, color.nativeObjectPtr, flags, width, height);}
  protected static native boolean colorButton(byte[] descriptionID, long color, @MagicConstant(flagsFromClass = JImColorEditFlags.class)int flags, float width, float height);
  public final boolean colorButton(@NotNull String descriptionID, @NotNull JImVec4 color, @MagicConstant(flagsFromClass = JImColorEditFlags.class)int flags){return colorButton(getBytes(descriptionID), color.nativeObjectPtr, flags,0,0);}
  public final boolean colorButton(@NotNull JImStr descriptionID, @NotNull JImVec4 color, @MagicConstant(flagsFromClass = JImColorEditFlags.class)int flags){return colorButton(descriptionID.bytes, color.nativeObjectPtr, flags,0,0);}
  public final boolean colorButton(@NotNull String descriptionID, @NotNull JImVec4 color){return colorButton(getBytes(descriptionID), color.nativeObjectPtr,JImColorEditFlags.None, 0,0);}
  public final boolean colorButton(@NotNull JImStr descriptionID, @NotNull JImVec4 color){return colorButton(descriptionID.bytes, color.nativeObjectPtr,JImColorEditFlags.None, 0,0);}
  public final boolean colorPicker3(@NotNull String label, @NotNull JImVec4 color, @MagicConstant(flagsFromClass = JImColorEditFlags.class)int flags){return colorPicker3(getBytes(label), color.nativeObjectPtr, flags);}
  public final boolean colorPicker3(@NotNull JImStr label, @NotNull JImVec4 color, @MagicConstant(flagsFromClass = JImColorEditFlags.class)int flags){return colorPicker3(label.bytes, color.nativeObjectPtr, flags);}
  protected static native boolean colorPicker3(byte[] label, long color, @MagicConstant(flagsFromClass = JImColorEditFlags.class)int flags);
  public final boolean colorPicker3(@NotNull String label, @NotNull JImVec4 color){return colorPicker3(getBytes(label), color.nativeObjectPtr,JImColorEditFlags.None);}
  public final boolean colorPicker3(@NotNull JImStr label, @NotNull JImVec4 color){return colorPicker3(label.bytes, color.nativeObjectPtr,JImColorEditFlags.None);}
  public final boolean colorPicker4(@NotNull String label, @NotNull JImVec4 color, @MagicConstant(flagsFromClass = JImColorEditFlags.class)int flags){return colorPicker4(getBytes(label), color.nativeObjectPtr, flags);}
  public final boolean colorPicker4(@NotNull JImStr label, @NotNull JImVec4 color, @MagicConstant(flagsFromClass = JImColorEditFlags.class)int flags){return colorPicker4(label.bytes, color.nativeObjectPtr, flags);}
  protected static native boolean colorPicker4(byte[] label, long color, @MagicConstant(flagsFromClass = JImColorEditFlags.class)int flags);
  public final boolean colorPicker4(@NotNull String label, @NotNull JImVec4 color){return colorPicker4(getBytes(label), color.nativeObjectPtr,JImColorEditFlags.None);}
  public final boolean colorPicker4(@NotNull JImStr label, @NotNull JImVec4 color){return colorPicker4(label.bytes, color.nativeObjectPtr,JImColorEditFlags.None);}
  public static native void setColorEditOptions(@MagicConstant(flagsFromClass = JImColorEditFlags.class)int flags);
  public final void setColorEditOptions(){setColorEditOptions(0);}
  public final boolean selectable0(@NotNull String label, boolean selected, @MagicConstant(flagsFromClass = JImSelectableFlags.class)int flags, float width, float height){return selectable0(getBytes(label), selected, flags, width, height);}
  public final boolean selectable0(@NotNull JImStr label, boolean selected, @MagicConstant(flagsFromClass = JImSelectableFlags.class)int flags, float width, float height){return selectable0(label.bytes, selected, flags, width, height);}
  protected static native boolean selectable0(byte[] label, boolean selected, @MagicConstant(flagsFromClass = JImSelectableFlags.class)int flags, float width, float height);
  public final boolean selectable0(@NotNull String label, boolean selected, @MagicConstant(flagsFromClass = JImSelectableFlags.class)int flags){return selectable0(getBytes(label), selected, flags,0,0);}
  public final boolean selectable0(@NotNull JImStr label, boolean selected, @MagicConstant(flagsFromClass = JImSelectableFlags.class)int flags){return selectable0(label.bytes, selected, flags,0,0);}
  public final boolean selectable0(@NotNull String label, boolean selected){return selectable0(getBytes(label), selected,JImSelectableFlags.None, 0,0);}
  public final boolean selectable0(@NotNull JImStr label, boolean selected){return selectable0(label.bytes, selected,JImSelectableFlags.None, 0,0);}
  public final boolean selectable0(@NotNull String label){return selectable0(getBytes(label),false, JImSelectableFlags.None, 0,0);}
  public final boolean selectable0(@NotNull JImStr label){return selectable0(label.bytes,false, JImSelectableFlags.None, 0,0);}
  public final boolean selectable(@NotNull String label, @NotNull NativeBool selected, @MagicConstant(flagsFromClass = JImSelectableFlags.class)int flags, float width, float height){return selectable(getBytes(label), selected.nativeObjectPtr, flags, width, height);}
  public final boolean selectable(@NotNull JImStr label, @NotNull NativeBool selected, @MagicConstant(flagsFromClass = JImSelectableFlags.class)int flags, float width, float height){return selectable(label.bytes, selected.nativeObjectPtr, flags, width, height);}
  protected static native boolean selectable(byte[] label, long selected, @MagicConstant(flagsFromClass = JImSelectableFlags.class)int flags, float width, float height);
  public final boolean selectable(@NotNull String label, @NotNull NativeBool selected, @MagicConstant(flagsFromClass = JImSelectableFlags.class)int flags){return selectable(getBytes(label), selected.nativeObjectPtr, flags,0,0);}
  public final boolean selectable(@NotNull JImStr label, @NotNull NativeBool selected, @MagicConstant(flagsFromClass = JImSelectableFlags.class)int flags){return selectable(label.bytes, selected.nativeObjectPtr, flags,0,0);}
  public final boolean selectable(@NotNull String label, @NotNull NativeBool selected){return selectable(getBytes(label), selected.nativeObjectPtr,JImSelectableFlags.None, 0,0);}
  public final boolean selectable(@NotNull JImStr label, @NotNull NativeBool selected){return selectable(label.bytes, selected.nativeObjectPtr,JImSelectableFlags.None, 0,0);}
  public final void setTooltip(@NotNull String text){setTooltip(getBytes(text));}
  public final void setTooltip(@NotNull JImStr text){setTooltip(text.bytes);}
  protected static native void setTooltip(byte[] text);
  public static native void beginTooltip();
  public static native void endTooltip();
  public static native boolean beginMainMenuBar();
  public static native void endMainMenuBar();
  public static native boolean beginMenuBar();
  public static native void endMenuBar();
  public final boolean beginMenu(@NotNull String label, boolean enabled){return beginMenu(getBytes(label), enabled);}
  public final boolean beginMenu(@NotNull JImStr label, boolean enabled){return beginMenu(label.bytes, enabled);}
  protected static native boolean beginMenu(byte[] label, boolean enabled);
  public final boolean beginMenu(@NotNull String label){return beginMenu(getBytes(label),true);}
  public final boolean beginMenu(@NotNull JImStr label){return beginMenu(label.bytes,true);}
  public static native void endMenu();
  public final boolean menuItem(@NotNull String label, @Nullable String shortcut, @NotNull NativeBool selected, boolean enabled){return menuItem(getBytes(label), getBytes(shortcut), selected.nativeObjectPtr, enabled);}
  public final boolean menuItem(@NotNull JImStr label, @Nullable JImStr shortcut, @NotNull NativeBool selected, boolean enabled){return menuItem(label.bytes, shortcut.bytes, selected.nativeObjectPtr, enabled);}
  protected static native boolean menuItem(byte[] label, byte[] shortcut, long selected, boolean enabled);
  public final boolean menuItem(@NotNull String label, @Nullable String shortcut, @NotNull NativeBool selected){return menuItem(getBytes(label), getBytes(shortcut), selected.nativeObjectPtr,true);}
  public final boolean menuItem(@NotNull JImStr label, @Nullable JImStr shortcut, @NotNull NativeBool selected){return menuItem(label.bytes, shortcut.bytes, selected.nativeObjectPtr,true);}
  public final boolean menuItem(@NotNull String label, @Nullable String shortcut){return menuItem(getBytes(label), getBytes(shortcut),0, true);}
  public final boolean menuItem(@NotNull JImStr label, @Nullable JImStr shortcut){return menuItem(label.bytes, shortcut.bytes,0, true);}
  public final boolean menuItem(@NotNull String label){return menuItem(getBytes(label),(byte[]) null, 0, true);}
  public final boolean menuItem(@NotNull JImStr label){return menuItem(label.bytes,(byte[]) null, 0, true);}
  public final void openPopup(@NotNull String stringID, @MagicConstant(flagsFromClass = JImPopupFlags.class)int flags){openPopup(getBytes(stringID), flags);}
  public final void openPopup(@NotNull JImStr stringID, @MagicConstant(flagsFromClass = JImPopupFlags.class)int flags){openPopup(stringID.bytes, flags);}
  protected static native void openPopup(byte[] stringID, @MagicConstant(flagsFromClass = JImPopupFlags.class)int flags);
  public final void openPopup(@NotNull String stringID){openPopup(getBytes(stringID),JImPopupFlags.MouseButtonLeft);}
  public final void openPopup(@NotNull JImStr stringID){openPopup(stringID.bytes,JImPopupFlags.MouseButtonLeft);}
  public final boolean beginPopup(@NotNull String stringID, @MagicConstant(flagsFromClass = JImWindowFlags.class)int flags){return beginPopup(getBytes(stringID), flags);}
  public final boolean beginPopup(@NotNull JImStr stringID, @MagicConstant(flagsFromClass = JImWindowFlags.class)int flags){return beginPopup(stringID.bytes, flags);}
  protected static native boolean beginPopup(byte[] stringID, @MagicConstant(flagsFromClass = JImWindowFlags.class)int flags);
  public final boolean beginPopup(@NotNull String stringID){return beginPopup(getBytes(stringID),JImWindowFlags.None);}
  public final boolean beginPopup(@NotNull JImStr stringID){return beginPopup(stringID.bytes,JImWindowFlags.None);}
  public final boolean beginPopupContextItem(@Nullable String stringID, @MagicConstant(flagsFromClass = JImPopupFlags.class)int flags){return beginPopupContextItem(getBytes(stringID), flags);}
  protected static native boolean beginPopupContextItem(byte[] stringID, @MagicConstant(flagsFromClass = JImPopupFlags.class)int flags);
  public final boolean beginPopupContextItem(@Nullable String stringID){return beginPopupContextItem(getBytes(stringID),JImPopupFlags.MouseButtonRight);}
  public final boolean beginPopupContextItem(){return beginPopupContextItem((byte[]) null, JImPopupFlags.MouseButtonRight);}
  public final boolean beginPopupContextWindow(@Nullable String stringID, @MagicConstant(flagsFromClass = JImPopupFlags.class)int flags){return beginPopupContextWindow(getBytes(stringID), flags);}
  protected static native boolean beginPopupContextWindow(byte[] stringID, @MagicConstant(flagsFromClass = JImPopupFlags.class)int flags);
  public final boolean beginPopupContextWindow(@Nullable String stringID){return beginPopupContextWindow(getBytes(stringID),JImPopupFlags.MouseButtonRight);}
  public final boolean beginPopupContextWindow(){return beginPopupContextWindow((byte[]) null, JImPopupFlags.MouseButtonRight);}
  public final boolean beginPopupContextVoid(@Nullable String stringID, @MagicConstant(flagsFromClass = JImPopupFlags.class)int flags){return beginPopupContextVoid(getBytes(stringID), flags);}
  protected static native boolean beginPopupContextVoid(byte[] stringID, @MagicConstant(flagsFromClass = JImPopupFlags.class)int flags);
  public final boolean beginPopupContextVoid(@Nullable String stringID){return beginPopupContextVoid(getBytes(stringID),JImPopupFlags.MouseButtonRight);}
  public final boolean beginPopupContextVoid(){return beginPopupContextVoid((byte[]) null, JImPopupFlags.MouseButtonRight);}
  public final boolean beginPopupModal(@NotNull String name, @NotNull NativeBool openPtr, @MagicConstant(flagsFromClass = JImWindowFlags.class)int flags){return beginPopupModal(getBytes(name), openPtr.nativeObjectPtr, flags);}
  public final boolean beginPopupModal(@NotNull JImStr name, @NotNull NativeBool openPtr, @MagicConstant(flagsFromClass = JImWindowFlags.class)int flags){return beginPopupModal(name.bytes, openPtr.nativeObjectPtr, flags);}
  protected static native boolean beginPopupModal(byte[] name, long openPtr, @MagicConstant(flagsFromClass = JImWindowFlags.class)int flags);
  public final boolean beginPopupModal(@NotNull String name, @NotNull NativeBool openPtr){return beginPopupModal(getBytes(name), openPtr.nativeObjectPtr,JImWindowFlags.None);}
  public final boolean beginPopupModal(@NotNull JImStr name, @NotNull NativeBool openPtr){return beginPopupModal(name.bytes, openPtr.nativeObjectPtr,JImWindowFlags.None);}
  public static native void endPopup();
  public final void openPopupOnItemClick(@Nullable String stringID, @MagicConstant(flagsFromClass = JImPopupFlags.class)int flags){openPopupOnItemClick(getBytes(stringID), flags);}
  protected static native void openPopupOnItemClick(byte[] stringID, @MagicConstant(flagsFromClass = JImPopupFlags.class)int flags);
  public final void openPopupOnItemClick(@Nullable String stringID){openPopupOnItemClick(getBytes(stringID),JImPopupFlags.MouseButtonRight);}
  public final void openPopupOnItemClick(){openPopupOnItemClick((byte[]) null, JImPopupFlags.MouseButtonRight);}
  public final boolean isPopupOpen(@NotNull String stringID, @MagicConstant(flagsFromClass = JImPopupFlags.class)int flags){return isPopupOpen(getBytes(stringID), flags);}
  public final boolean isPopupOpen(@NotNull JImStr stringID, @MagicConstant(flagsFromClass = JImPopupFlags.class)int flags){return isPopupOpen(stringID.bytes, flags);}
  protected static native boolean isPopupOpen(byte[] stringID, @MagicConstant(flagsFromClass = JImPopupFlags.class)int flags);
  public final boolean isPopupOpen(@NotNull String stringID){return isPopupOpen(getBytes(stringID),JImPopupFlags.MouseButtonRight);}
  public final boolean isPopupOpen(@NotNull JImStr stringID){return isPopupOpen(stringID.bytes,JImPopupFlags.MouseButtonRight);}
  public static native void closeCurrentPopup();
  public final boolean beginTable(@NotNull String stringID, int columnsCount, @MagicConstant(flagsFromClass = JImTableFlags.class)int flags, float widthouterSize, float heightouterSize, float innerWidth){return beginTable(getBytes(stringID), columnsCount, flags, widthouterSize, heightouterSize, innerWidth);}
  public final boolean beginTable(@NotNull JImStr stringID, int columnsCount, @MagicConstant(flagsFromClass = JImTableFlags.class)int flags, float widthouterSize, float heightouterSize, float innerWidth){return beginTable(stringID.bytes, columnsCount, flags, widthouterSize, heightouterSize, innerWidth);}
  protected static native boolean beginTable(byte[] stringID, int columnsCount, @MagicConstant(flagsFromClass = JImTableFlags.class)int flags, float widthouterSize, float heightouterSize, float innerWidth);
  public final boolean beginTable(@NotNull String stringID, int columnsCount, @MagicConstant(flagsFromClass = JImTableFlags.class)int flags, float widthouterSize, float heightouterSize){return beginTable(getBytes(stringID), columnsCount, flags, widthouterSize, heightouterSize,0);}
  public final boolean beginTable(@NotNull JImStr stringID, int columnsCount, @MagicConstant(flagsFromClass = JImTableFlags.class)int flags, float widthouterSize, float heightouterSize){return beginTable(stringID.bytes, columnsCount, flags, widthouterSize, heightouterSize,0);}
  public final boolean beginTable(@NotNull String stringID, int columnsCount, @MagicConstant(flagsFromClass = JImTableFlags.class)int flags){return beginTable(getBytes(stringID), columnsCount, flags,0,0, 0);}
  public final boolean beginTable(@NotNull JImStr stringID, int columnsCount, @MagicConstant(flagsFromClass = JImTableFlags.class)int flags){return beginTable(stringID.bytes, columnsCount, flags,0,0, 0);}
  public final boolean beginTable(@NotNull String stringID, int columnsCount){return beginTable(getBytes(stringID), columnsCount,JImTableFlags.None, 0,0, 0);}
  public final boolean beginTable(@NotNull JImStr stringID, int columnsCount){return beginTable(stringID.bytes, columnsCount,JImTableFlags.None, 0,0, 0);}
  public static native void endTable();
  public static native void tableNextRow(@MagicConstant(flagsFromClass = JImTableRowFlags.class)int flags, float minRowHeight);
  public final void tableNextRow(@MagicConstant(flagsFromClass = JImTableRowFlags.class)int flags){tableNextRow(flags,0);}
  public final void tableNextRow(){tableNextRow(JImTableRowFlags.None, 0);}
  public static native boolean tableNextColumn();
  public static native boolean tableSetColumnIndex(int columnN);
  public final void tableSetupColumn(@NotNull String label, @MagicConstant(flagsFromClass = JImTableColumnFlags.class)int flags, float initWidthOrWeight, int userID){tableSetupColumn(getBytes(label), flags, initWidthOrWeight, userID);}
  public final void tableSetupColumn(@NotNull JImStr label, @MagicConstant(flagsFromClass = JImTableColumnFlags.class)int flags, float initWidthOrWeight, int userID){tableSetupColumn(label.bytes, flags, initWidthOrWeight, userID);}
  protected static native void tableSetupColumn(byte[] label, @MagicConstant(flagsFromClass = JImTableColumnFlags.class)int flags, float initWidthOrWeight, int userID);
  public final void tableSetupColumn(@NotNull String label, @MagicConstant(flagsFromClass = JImTableColumnFlags.class)int flags, float initWidthOrWeight){tableSetupColumn(getBytes(label), flags, initWidthOrWeight,0);}
  public final void tableSetupColumn(@NotNull JImStr label, @MagicConstant(flagsFromClass = JImTableColumnFlags.class)int flags, float initWidthOrWeight){tableSetupColumn(label.bytes, flags, initWidthOrWeight,0);}
  public final void tableSetupColumn(@NotNull String label, @MagicConstant(flagsFromClass = JImTableColumnFlags.class)int flags){tableSetupColumn(getBytes(label), flags,-1, 0);}
  public final void tableSetupColumn(@NotNull JImStr label, @MagicConstant(flagsFromClass = JImTableColumnFlags.class)int flags){tableSetupColumn(label.bytes, flags,-1, 0);}
  public final void tableSetupColumn(@NotNull String label){tableSetupColumn(getBytes(label),JImTableColumnFlags.None, -1, 0);}
  public final void tableSetupColumn(@NotNull JImStr label){tableSetupColumn(label.bytes,JImTableColumnFlags.None, -1, 0);}
  public static native void tableSetupScrollFreeze(int cols, int rows);
  public static native void tableHeadersRow();
  public final void tableHeader(@NotNull String label){tableHeader(getBytes(label));}
  public final void tableHeader(@NotNull JImStr label){tableHeader(label.bytes);}
  protected static native void tableHeader(byte[] label);
  public static native int tableGetColumnCount();
  public static native int tableGetColumnIndex();
  public static native int tableGetRowIndex();
  protected static native long tableGetColumnName(int column_n);
  protected static native int tableGetColumnFlags(int column_n);
  public static native void tableSetBgColor(@MagicConstant(valuesFromClass = JImTableBgTarget.class)int flags, int u32Color, int column_n);
  public final void tableSetBgColor(@MagicConstant(valuesFromClass = JImTableBgTarget.class)int flags, int u32Color){tableSetBgColor(flags, u32Color,-1);}
  public final void columns(int count, @Nullable String stringID, boolean border){columns(count, getBytes(stringID), border);}
  protected static native void columns(int count, byte[] stringID, boolean border);
  public final void columns(int count, @Nullable String stringID){columns(count, getBytes(stringID),true);}
  public final void columns(int count){columns(count,(byte[]) null, true);}
  public final void columns(){columns(1, (byte[]) null, true);}
  public static native void nextColumn();
  public static native int getColumnIndex();
  public static native float getColumnWidth(int columnIndex);
  public final float getColumnWidth(){return getColumnWidth(-1);}
  public static native float getColumnOffset(int columnIndex);
  public final float getColumnOffset(){return getColumnOffset(-1);}
  public static native void setColumnWidth(int columnIndex, float width);
  public static native void setColumnOffset(int columnIndex, float offsetX);
  public static native int getColumnsCount();
  public final boolean beginTabBar(@NotNull String stringID, @MagicConstant(flagsFromClass = JImTabBarFlags.class)int flags){return beginTabBar(getBytes(stringID), flags);}
  public final boolean beginTabBar(@NotNull JImStr stringID, @MagicConstant(flagsFromClass = JImTabBarFlags.class)int flags){return beginTabBar(stringID.bytes, flags);}
  protected static native boolean beginTabBar(byte[] stringID, @MagicConstant(flagsFromClass = JImTabBarFlags.class)int flags);
  public final boolean beginTabBar(@NotNull String stringID){return beginTabBar(getBytes(stringID),JImTabBarFlags.None);}
  public final boolean beginTabBar(@NotNull JImStr stringID){return beginTabBar(stringID.bytes,JImTabBarFlags.None);}
  public static native void endTabBar();
  public final boolean beginTabItem(@NotNull String label, @NotNull NativeBool openPtr, @MagicConstant(flagsFromClass = JImTabItemFlags.class)int flags){return beginTabItem(getBytes(label), openPtr.nativeObjectPtr, flags);}
  public final boolean beginTabItem(@NotNull JImStr label, @NotNull NativeBool openPtr, @MagicConstant(flagsFromClass = JImTabItemFlags.class)int flags){return beginTabItem(label.bytes, openPtr.nativeObjectPtr, flags);}
  protected static native boolean beginTabItem(byte[] label, long openPtr, @MagicConstant(flagsFromClass = JImTabItemFlags.class)int flags);
  public final boolean beginTabItem(@NotNull String label, @NotNull NativeBool openPtr){return beginTabItem(getBytes(label), openPtr.nativeObjectPtr,JImTabItemFlags.None);}
  public final boolean beginTabItem(@NotNull JImStr label, @NotNull NativeBool openPtr){return beginTabItem(label.bytes, openPtr.nativeObjectPtr,JImTabItemFlags.None);}
  public final boolean beginTabItem(@NotNull String label){return beginTabItem(getBytes(label),0, JImTabItemFlags.None);}
  public final boolean beginTabItem(@NotNull JImStr label){return beginTabItem(label.bytes,0, JImTabItemFlags.None);}
  public static native void endTabItem();
  public final boolean tabItemButton(@NotNull String label, @MagicConstant(flagsFromClass = JImTabItemFlags.class)int flags){return tabItemButton(getBytes(label), flags);}
  public final boolean tabItemButton(@NotNull JImStr label, @MagicConstant(flagsFromClass = JImTabItemFlags.class)int flags){return tabItemButton(label.bytes, flags);}
  protected static native boolean tabItemButton(byte[] label, @MagicConstant(flagsFromClass = JImTabItemFlags.class)int flags);
  public final boolean tabItemButton(@NotNull String label){return tabItemButton(getBytes(label),JImTabItemFlags.None);}
  public final boolean tabItemButton(@NotNull JImStr label){return tabItemButton(label.bytes,JImTabItemFlags.None);}
  public final void setTabItemClosed(@NotNull String tabOrDockedWindowLabel){setTabItemClosed(getBytes(tabOrDockedWindowLabel));}
  public final void setTabItemClosed(@NotNull JImStr tabOrDockedWindowLabel){setTabItemClosed(tabOrDockedWindowLabel.bytes);}
  protected static native void setTabItemClosed(byte[] tabOrDockedWindowLabel);
  public static native void logToTTY(int maxDepth);
  public final void logToTTY(){logToTTY(-1);}
  public final void logToFile(int maxDepth, @Nullable String fileName){logToFile(maxDepth, getBytes(fileName));}
  protected static native void logToFile(int maxDepth, byte[] fileName);
  public final void logToFile(int maxDepth){logToFile(maxDepth,(byte[]) null);}
  public final void logToFile(){logToFile(-1, (byte[]) null);}
  public static native void logToClipboard(int maxDepth);
  public final void logToClipboard(){logToClipboard(-1);}
  public static native void logFinish();
  public static native void logButtons();
  public final void logText(@NotNull String text){logText(getBytes(text));}
  public final void logText(@NotNull JImStr text){logText(text.bytes);}
  protected static native void logText(byte[] text);
  public static native void pushClipRect(float widthClipRectMin, float heightClipRectMin, float widthClipRectMax, float heightClipRectMax, boolean intersectWithCurrentClipRect);
  public static native void popClipRect();
  public static native void pushItemWidth(float itemWidth);
  public static native void popItemWidth();
  public static native void setNextItemWidth(float itemWidth);
  public static native float calcItemWidth();
  public static native void pushTextWrapPos(float wrapPosX);
  public final void pushTextWrapPos(){pushTextWrapPos(0);}
  public static native void popTextWrapPos();
  public static native void pushAllowKeyboardFocus(boolean allowKeyboardFocus);
  public static native void popAllowKeyboardFocus();
  public static native void pushButtonRepeat(boolean repeat);
  public final void pushButtonRepeat(){pushButtonRepeat(false);}
  public static native void popButtonRepeat();
  public static native float getFontSize();
  public final void pushFont(@NotNull JImFont font){pushFont(font.nativeObjectPtr);}
  protected static native void pushFont(long font);
  public static native void popFont();
  public final void pushStyleColor(@MagicConstant(valuesFromClass = JImStyleColors.class)int index, @NotNull JImVec4 color){pushStyleColor(index, color.nativeObjectPtr);}
  protected static native void pushStyleColor(@MagicConstant(valuesFromClass = JImStyleColors.class)int index, long color);
  public static native void popStyleColor(int count);
  public final void popStyleColor(){popStyleColor(1);}
  protected static native void pushStyleVarImVec2(int styleVar, float valueX, float valueY);
  protected static native void pushStyleVarFloat(int styleVar, float value);
  public static native void popStyleVar(int count);
  public final void popStyleVar(){popStyleVar(1);}
  public static native void setItemDefaultFocus();
  public static native void setKeyboardFocusHere(int offset);
  public final void loadIniSettingsFromDisk(@NotNull String iniFileName){loadIniSettingsFromDisk(getBytes(iniFileName));}
  public final void loadIniSettingsFromDisk(@NotNull JImStr iniFileName){loadIniSettingsFromDisk(iniFileName.bytes);}
  protected static native void loadIniSettingsFromDisk(byte[] iniFileName);
  public final void saveIniSettingsToDisk(@NotNull String iniFileName){saveIniSettingsToDisk(getBytes(iniFileName));}
  public final void saveIniSettingsToDisk(@NotNull JImStr iniFileName){saveIniSettingsToDisk(iniFileName.bytes);}
  protected static native void saveIniSettingsToDisk(byte[] iniFileName);
  public static native boolean isItemHovered(@MagicConstant(flagsFromClass = JImHoveredFlags.class)int flags);
  public final boolean isItemHovered(){return isItemHovered(JImHoveredFlags.None);}
  public static native boolean isItemActive();
  public static native boolean isItemFocused();
  public static native boolean isItemClicked(int mouseButton);
  public final boolean isItemClicked(){return isItemClicked(0);}
  public static native boolean isItemVisible();
  public static native boolean isItemDeactivated();
  public static native boolean isItemDeactivatedAfterEdit();
  public static native boolean IsItemToggledOpen();
  public static native boolean isAnyItemHovered();
  public static native boolean isAnyItemActive();
  public static native boolean isAnyItemFocused();
  public static native void setItemAllowOverlap();
  public static native boolean isRectVisible(float width, float height);
  public static native float getTime();
  public static native int getFrameCount();
  public static native void setScrollX(float scrollX);
  public static native void setScrollY(float scrollY);
  public static native void setScrollHereX(float centerXRatio);
  public static native void setScrollHereY(float centerYRatio);
  public static native void setScrollFromPosX(float posX, float centerXRatio);
  public static native void setScrollFromPosY(float posY, float centerYRatio);
  public static native float getScrollX();
  public static native float getScrollY();
  public static native float getScrollMaxX();
  public static native float getScrollMaxY();

}