package org.ice1000.jimgui;

import org.ice1000.jimgui.*;
import org.ice1000.jimgui.flag.*;
import org.ice1000.jimgui.cpp.*;
import org.intellij.lang.annotations.*;
import org.jetbrains.annotations.*;
import java.nio.charset.StandardCharsets;

import static org.ice1000.jimgui.util.JImGuiUtil.*;

/**
 * @author ice1000
 * @since v0.1
 */
@SuppressWarnings("ALL")

public class JImGuiIOGen {
  @Contract(pure = true)
  public static @NotNull JImGuiIOGen getInstance(@NotNull JImGui owner) {
    return owner.getIO();
  }

  /** package-private by design */
  JImGuiIOGen() { }

  public static native float getDisplayFramebufferScaleX();
  public static native void setDisplayFramebufferScaleX(float newValue);
  public static native float getDisplayFramebufferScaleY();
  public static native void setDisplayFramebufferScaleY(float newValue);
  public static native float getDisplaySizeX();
  public static native void setDisplaySizeX(float newValue);
  public static native float getDisplaySizeY();
  public static native void setDisplaySizeY(float newValue);
  public static native float getMousePosX();
  public static native void setMousePosX(float newValue);
  public static native float getMousePosY();
  public static native void setMousePosY(float newValue);
  public static native float getMouseDeltaX();
  public static native void setMouseDeltaX(float newValue);
  public static native float getMouseDeltaY();
  public static native void setMouseDeltaY(float newValue);
  public static native float getMousePosPrevX();
  public static native void setMousePosPrevX(float newValue);
  public static native float getMousePosPrevY();
  public static native void setMousePosPrevY(float newValue);
  public final void addInputCharactersUTF8(@NotNull String characters){addInputCharactersUTF8(getBytes(characters));}
  public final void addInputCharactersUTF8(@NotNull JImStr characters){addInputCharactersUTF8(characters.bytes);}
  protected static native void addInputCharactersUTF8(byte[] characters);
  public static native void clearInputCharacters();
  public static native void addInputCharacter(int character);
  public static native int inputQueueCharacterAt(int index);
  public static native void inputQueueCharacter(int index,int newValue);
  public static native float navInputAt(int index);
  public static native void navInput(int index,float newValue);
  public static native @MagicConstant(valuesFromClass = JImMouseButton.class)float mouseClickedTimeAt(@MagicConstant(valuesFromClass = JImMouseButton.class)int index);
  public static native void mouseClickedTime(@MagicConstant(valuesFromClass = JImMouseButton.class)int index,@MagicConstant(valuesFromClass = JImMouseButton.class)float newValue);
  public static native @MagicConstant(valuesFromClass = JImMouseButton.class)float mouseDownDurationAt(@MagicConstant(valuesFromClass = JImMouseButton.class)int index);
  public static native void mouseDownDuration(@MagicConstant(valuesFromClass = JImMouseButton.class)int index,@MagicConstant(valuesFromClass = JImMouseButton.class)float newValue);
  public static native @MagicConstant(valuesFromClass = JImMouseButton.class)float mouseDownDurationPrevAt(@MagicConstant(valuesFromClass = JImMouseButton.class)int index);
  public static native void mouseDownDurationPrev(@MagicConstant(valuesFromClass = JImMouseButton.class)int index,@MagicConstant(valuesFromClass = JImMouseButton.class)float newValue);
  public static native @MagicConstant(valuesFromClass = JImMouseButton.class)float mouseDragMaxDistanceSqrAt(@MagicConstant(valuesFromClass = JImMouseButton.class)int index);
  public static native void mouseDragMaxDistanceSqr(@MagicConstant(valuesFromClass = JImMouseButton.class)int index,@MagicConstant(valuesFromClass = JImMouseButton.class)float newValue);
  public static native float keysDownDurationAt(int index);
  public static native void keysDownDuration(int index,float newValue);
  public static native float keysDownDurationPrevAt(int index);
  public static native void keysDownDurationPrev(int index,float newValue);
  public static native float navInputsDownDurationAt(int index);
  public static native void navInputsDownDuration(int index,float newValue);
  public static native float navInputsDownDurationPrevAt(int index);
  public static native void navInputsDownDurationPrev(int index,float newValue);
  public static native int getMetricsRenderVertices();
  public static native void setMetricsRenderVertices(int newValue);
  public static native int getMetricsRenderIndices();
  public static native void setMetricsRenderIndices(int newValue);
  public static native int getMetricsActiveWindows();
  public static native void setMetricsActiveWindows(int newValue);
  public static native int keyMapAt(int index);
  public static native void keyMap(int index,int newValue);
  public static native @MagicConstant(flagsFromClass = JImConfigFlags.class)int getConfigFlags();
  public static native void setConfigFlags(@MagicConstant(flagsFromClass = JImConfigFlags.class)int newValue);
  public static native @MagicConstant(flagsFromClass = JImBackendFlags.class)int getBackendFlags();
  public static native void setBackendFlags(@MagicConstant(flagsFromClass = JImBackendFlags.class)int newValue);
  public static native float getConfigMemoryCompactTimer();
  public static native void setConfigMemoryCompactTimer(float newValue);
  public static native float getMouseDoubleClickTime();
  public static native void setMouseDoubleClickTime(float newValue);
  public static native float getMouseDoubleClickMaxDist();
  public static native void setMouseDoubleClickMaxDist(float newValue);
  public static native float getKeyRepeatDelay();
  public static native void setKeyRepeatDelay(float newValue);
  public static native float getKeyRepeatRate();
  public static native void setKeyRepeatRate(float newValue);
  public static native float getFontGlobalScale();
  public static native void setFontGlobalScale(float newValue);
  public static native float getMouseWheel();
  public static native void setMouseWheel(float newValue);
  public static native float getMouseWheelH();
  public static native void setMouseWheelH(float newValue);
  public static native float getFramerate();
  public static native void setFramerate(float newValue);
  public static native float getDeltaTime();
  public static native void setDeltaTime(float newValue);
  public static native float getIniSavingRate();
  public static native void setIniSavingRate(float newValue);
  public static native boolean keyDownAt(int index);
  public static native void keyDown(int index,boolean newValue);
  public static native boolean mouseClickedAt(@MagicConstant(valuesFromClass = JImMouseButton.class)int index);
  public static native void mouseClicked(@MagicConstant(valuesFromClass = JImMouseButton.class)int index,boolean newValue);
  public static native boolean mouseDoubleClickedAt(@MagicConstant(valuesFromClass = JImMouseButton.class)int index);
  public static native void mouseDoubleClicked(@MagicConstant(valuesFromClass = JImMouseButton.class)int index,boolean newValue);
  public static native boolean mouseReleasedAt(@MagicConstant(valuesFromClass = JImMouseButton.class)int index);
  public static native void mouseReleased(@MagicConstant(valuesFromClass = JImMouseButton.class)int index,boolean newValue);
  public static native boolean mouseDownOwnedAt(@MagicConstant(valuesFromClass = JImMouseButton.class)int index);
  public static native void mouseDownOwned(@MagicConstant(valuesFromClass = JImMouseButton.class)int index,boolean newValue);
  public static native boolean isFontAllowUserScaling();
  public static native void setFontAllowUserScaling(boolean newValue);
  public static native boolean isConfigMacOSXBehaviors();
  public static native void setConfigMacOSXBehaviors(boolean newValue);
  public static native boolean isConfigInputTextCursorBlink();
  public static native void setConfigInputTextCursorBlink(boolean newValue);
  public static native boolean isConfigDragClickToInputText();
  public static native void setConfigDragClickToInputText(boolean newValue);
  public static native boolean isConfigWindowsResizeFromEdges();
  public static native void setConfigWindowsResizeFromEdges(boolean newValue);
  public static native boolean isConfigWindowsMoveFromTitleBarOnly();
  public static native void setConfigWindowsMoveFromTitleBarOnly(boolean newValue);
  public static native boolean isMouseDrawCursor();
  public static native void setMouseDrawCursor(boolean newValue);
  public static native boolean isKeyCtrl();
  public static native void setKeyCtrl(boolean newValue);
  public static native boolean isKeyShift();
  public static native void setKeyShift(boolean newValue);
  public static native boolean isKeyAlt();
  public static native void setKeyAlt(boolean newValue);
  public static native boolean isKeySuper();
  public static native void setKeySuper(boolean newValue);
  public static native boolean isWantCaptureMouse();
  public static native void setWantCaptureMouse(boolean newValue);
  public static native boolean isWantCaptureKeyboard();
  public static native void setWantCaptureKeyboard(boolean newValue);
  public static native boolean isWantTextInput();
  public static native void setWantTextInput(boolean newValue);
  public static native boolean isWantSetMousePos();
  public static native void setWantSetMousePos(boolean newValue);
  public static native boolean isWantSaveIniSettings();
  public static native void setWantSaveIniSettings(boolean newValue);
  public static native boolean isNavActive();
  public static native void setNavActive(boolean newValue);
  public static native boolean isNavVisible();
  public static native void setNavVisible(boolean newValue);
  private static native void setIniFilename(byte[]newValue);
  public void setIniFilename(@NotNull String newValue){setIniFilename(getBytes(newValue));}
  private static native void setLogFilename(byte[]newValue);
  public void setLogFilename(@NotNull String newValue){setLogFilename(getBytes(newValue));}

}