package org.ice1000.jimgui;

import org.ice1000.jimgui.*;
import org.ice1000.jimgui.flag.*;
import org.ice1000.jimgui.cpp.*;
import org.intellij.lang.annotations.*;
import org.jetbrains.annotations.*;
import java.nio.charset.StandardCharsets;

import static org.ice1000.jimgui.util.JImGuiUtil.*;

/**
 * @author ice1000
 * @since v0.1
 */
@SuppressWarnings("ALL")

public class JImGuiStyleGen {
  @Contract(pure = true)
  public static @NotNull JImGuiStyleGen getInstance(@NotNull JImGui owner) { return owner.getStyle(); }

  /** package-private by design */
  JImGuiStyleGen(long nativeObjectPtr) {
    this.nativeObjectPtr = nativeObjectPtr;
  }

  protected long nativeObjectPtr;

  private static native void setWindowPaddingX(long nativeObjectPtr,float newValue);
  public void setWindowPaddingX(float newValue){setWindowPaddingX(nativeObjectPtr, newValue); }
  private static native float getWindowPaddingX(long nativeObjectPtr);
  public float getWindowPaddingX(){return getWindowPaddingX(nativeObjectPtr);}
  private static native void setWindowPaddingY(long nativeObjectPtr,float newValue);
  public void setWindowPaddingY(float newValue){setWindowPaddingY(nativeObjectPtr, newValue); }
  private static native float getWindowPaddingY(long nativeObjectPtr);
  public float getWindowPaddingY(){return getWindowPaddingY(nativeObjectPtr);}
  private static native void setWindowMinSizeX(long nativeObjectPtr,float newValue);
  public void setWindowMinSizeX(float newValue){setWindowMinSizeX(nativeObjectPtr, newValue); }
  private static native float getWindowMinSizeX(long nativeObjectPtr);
  public float getWindowMinSizeX(){return getWindowMinSizeX(nativeObjectPtr);}
  private static native void setWindowMinSizeY(long nativeObjectPtr,float newValue);
  public void setWindowMinSizeY(float newValue){setWindowMinSizeY(nativeObjectPtr, newValue); }
  private static native float getWindowMinSizeY(long nativeObjectPtr);
  public float getWindowMinSizeY(){return getWindowMinSizeY(nativeObjectPtr);}
  private static native void setWindowTitleAlignX(long nativeObjectPtr,float newValue);
  public void setWindowTitleAlignX(float newValue){setWindowTitleAlignX(nativeObjectPtr, newValue); }
  private static native float getWindowTitleAlignX(long nativeObjectPtr);
  public float getWindowTitleAlignX(){return getWindowTitleAlignX(nativeObjectPtr);}
  private static native void setWindowTitleAlignY(long nativeObjectPtr,float newValue);
  public void setWindowTitleAlignY(float newValue){setWindowTitleAlignY(nativeObjectPtr, newValue); }
  private static native float getWindowTitleAlignY(long nativeObjectPtr);
  public float getWindowTitleAlignY(){return getWindowTitleAlignY(nativeObjectPtr);}
  private static native void setFramePaddingX(long nativeObjectPtr,float newValue);
  public void setFramePaddingX(float newValue){setFramePaddingX(nativeObjectPtr, newValue); }
  private static native float getFramePaddingX(long nativeObjectPtr);
  public float getFramePaddingX(){return getFramePaddingX(nativeObjectPtr);}
  private static native void setFramePaddingY(long nativeObjectPtr,float newValue);
  public void setFramePaddingY(float newValue){setFramePaddingY(nativeObjectPtr, newValue); }
  private static native float getFramePaddingY(long nativeObjectPtr);
  public float getFramePaddingY(){return getFramePaddingY(nativeObjectPtr);}
  private static native void setItemSpacingX(long nativeObjectPtr,float newValue);
  public void setItemSpacingX(float newValue){setItemSpacingX(nativeObjectPtr, newValue); }
  private static native float getItemSpacingX(long nativeObjectPtr);
  public float getItemSpacingX(){return getItemSpacingX(nativeObjectPtr);}
  private static native void setItemSpacingY(long nativeObjectPtr,float newValue);
  public void setItemSpacingY(float newValue){setItemSpacingY(nativeObjectPtr, newValue); }
  private static native float getItemSpacingY(long nativeObjectPtr);
  public float getItemSpacingY(){return getItemSpacingY(nativeObjectPtr);}
  private static native void setCellPaddingX(long nativeObjectPtr,float newValue);
  public void setCellPaddingX(float newValue){setCellPaddingX(nativeObjectPtr, newValue); }
  private static native float getCellPaddingX(long nativeObjectPtr);
  public float getCellPaddingX(){return getCellPaddingX(nativeObjectPtr);}
  private static native void setCellPaddingY(long nativeObjectPtr,float newValue);
  public void setCellPaddingY(float newValue){setCellPaddingY(nativeObjectPtr, newValue); }
  private static native float getCellPaddingY(long nativeObjectPtr);
  public float getCellPaddingY(){return getCellPaddingY(nativeObjectPtr);}
  private static native void setItemInnerSpacingX(long nativeObjectPtr,float newValue);
  public void setItemInnerSpacingX(float newValue){setItemInnerSpacingX(nativeObjectPtr, newValue); }
  private static native float getItemInnerSpacingX(long nativeObjectPtr);
  public float getItemInnerSpacingX(){return getItemInnerSpacingX(nativeObjectPtr);}
  private static native void setItemInnerSpacingY(long nativeObjectPtr,float newValue);
  public void setItemInnerSpacingY(float newValue){setItemInnerSpacingY(nativeObjectPtr, newValue); }
  private static native float getItemInnerSpacingY(long nativeObjectPtr);
  public float getItemInnerSpacingY(){return getItemInnerSpacingY(nativeObjectPtr);}
  private static native void setTouchExtraPaddingX(long nativeObjectPtr,float newValue);
  public void setTouchExtraPaddingX(float newValue){setTouchExtraPaddingX(nativeObjectPtr, newValue); }
  private static native float getTouchExtraPaddingX(long nativeObjectPtr);
  public float getTouchExtraPaddingX(){return getTouchExtraPaddingX(nativeObjectPtr);}
  private static native void setTouchExtraPaddingY(long nativeObjectPtr,float newValue);
  public void setTouchExtraPaddingY(float newValue){setTouchExtraPaddingY(nativeObjectPtr, newValue); }
  private static native float getTouchExtraPaddingY(long nativeObjectPtr);
  public float getTouchExtraPaddingY(){return getTouchExtraPaddingY(nativeObjectPtr);}
  private static native void setButtonTextAlignX(long nativeObjectPtr,float newValue);
  public void setButtonTextAlignX(float newValue){setButtonTextAlignX(nativeObjectPtr, newValue); }
  private static native float getButtonTextAlignX(long nativeObjectPtr);
  public float getButtonTextAlignX(){return getButtonTextAlignX(nativeObjectPtr);}
  private static native void setButtonTextAlignY(long nativeObjectPtr,float newValue);
  public void setButtonTextAlignY(float newValue){setButtonTextAlignY(nativeObjectPtr, newValue); }
  private static native float getButtonTextAlignY(long nativeObjectPtr);
  public float getButtonTextAlignY(){return getButtonTextAlignY(nativeObjectPtr);}
  private static native void setSelectableTextAlignX(long nativeObjectPtr,float newValue);
  public void setSelectableTextAlignX(float newValue){setSelectableTextAlignX(nativeObjectPtr, newValue); }
  private static native float getSelectableTextAlignX(long nativeObjectPtr);
  public float getSelectableTextAlignX(){return getSelectableTextAlignX(nativeObjectPtr);}
  private static native void setSelectableTextAlignY(long nativeObjectPtr,float newValue);
  public void setSelectableTextAlignY(float newValue){setSelectableTextAlignY(nativeObjectPtr, newValue); }
  private static native float getSelectableTextAlignY(long nativeObjectPtr);
  public float getSelectableTextAlignY(){return getSelectableTextAlignY(nativeObjectPtr);}
  private static native void setDisplayWindowPaddingX(long nativeObjectPtr,float newValue);
  public void setDisplayWindowPaddingX(float newValue){setDisplayWindowPaddingX(nativeObjectPtr, newValue); }
  private static native float getDisplayWindowPaddingX(long nativeObjectPtr);
  public float getDisplayWindowPaddingX(){return getDisplayWindowPaddingX(nativeObjectPtr);}
  private static native void setDisplayWindowPaddingY(long nativeObjectPtr,float newValue);
  public void setDisplayWindowPaddingY(float newValue){setDisplayWindowPaddingY(nativeObjectPtr, newValue); }
  private static native float getDisplayWindowPaddingY(long nativeObjectPtr);
  public float getDisplayWindowPaddingY(){return getDisplayWindowPaddingY(nativeObjectPtr);}
  private static native void setDisplaySafeAreaPaddingX(long nativeObjectPtr,float newValue);
  public void setDisplaySafeAreaPaddingX(float newValue){setDisplaySafeAreaPaddingX(nativeObjectPtr, newValue); }
  private static native float getDisplaySafeAreaPaddingX(long nativeObjectPtr);
  public float getDisplaySafeAreaPaddingX(){return getDisplaySafeAreaPaddingX(nativeObjectPtr);}
  private static native void setDisplaySafeAreaPaddingY(long nativeObjectPtr,float newValue);
  public void setDisplaySafeAreaPaddingY(float newValue){setDisplaySafeAreaPaddingY(nativeObjectPtr, newValue); }
  private static native float getDisplaySafeAreaPaddingY(long nativeObjectPtr);
  public float getDisplaySafeAreaPaddingY(){return getDisplaySafeAreaPaddingY(nativeObjectPtr);}
  public int getWindowMenuButtonPosition(){return getWindowMenuButtonPosition(nativeObjectPtr);}
  protected static native int getWindowMenuButtonPosition(long nativeObjectPtr);
  public void setWindowMenuButtonPosition(int newValue) {setWindowMenuButtonPosition(nativeObjectPtr, newValue);}
  protected static native void setWindowMenuButtonPosition(long nativeObjectPtr, int newValue);
  public int getColorButtonPosition(){return getColorButtonPosition(nativeObjectPtr);}
  protected static native int getColorButtonPosition(long nativeObjectPtr);
  public void setColorButtonPosition(int newValue) {setColorButtonPosition(nativeObjectPtr, newValue);}
  protected static native void setColorButtonPosition(long nativeObjectPtr, int newValue);
  public float getAlpha(){return getAlpha(nativeObjectPtr);}
  protected static native float getAlpha(long nativeObjectPtr);
  public void setAlpha(float newValue) {setAlpha(nativeObjectPtr, newValue);}
  protected static native void setAlpha(long nativeObjectPtr, float newValue);
  public float getWindowRounding(){return getWindowRounding(nativeObjectPtr);}
  protected static native float getWindowRounding(long nativeObjectPtr);
  public void setWindowRounding(float newValue) {setWindowRounding(nativeObjectPtr, newValue);}
  protected static native void setWindowRounding(long nativeObjectPtr, float newValue);
  public float getWindowBorderSize(){return getWindowBorderSize(nativeObjectPtr);}
  protected static native float getWindowBorderSize(long nativeObjectPtr);
  public void setWindowBorderSize(float newValue) {setWindowBorderSize(nativeObjectPtr, newValue);}
  protected static native void setWindowBorderSize(long nativeObjectPtr, float newValue);
  public float getChildRounding(){return getChildRounding(nativeObjectPtr);}
  protected static native float getChildRounding(long nativeObjectPtr);
  public void setChildRounding(float newValue) {setChildRounding(nativeObjectPtr, newValue);}
  protected static native void setChildRounding(long nativeObjectPtr, float newValue);
  public float getChildBorderSize(){return getChildBorderSize(nativeObjectPtr);}
  protected static native float getChildBorderSize(long nativeObjectPtr);
  public void setChildBorderSize(float newValue) {setChildBorderSize(nativeObjectPtr, newValue);}
  protected static native void setChildBorderSize(long nativeObjectPtr, float newValue);
  public float getPopupRounding(){return getPopupRounding(nativeObjectPtr);}
  protected static native float getPopupRounding(long nativeObjectPtr);
  public void setPopupRounding(float newValue) {setPopupRounding(nativeObjectPtr, newValue);}
  protected static native void setPopupRounding(long nativeObjectPtr, float newValue);
  public float getPopupBorderSize(){return getPopupBorderSize(nativeObjectPtr);}
  protected static native float getPopupBorderSize(long nativeObjectPtr);
  public void setPopupBorderSize(float newValue) {setPopupBorderSize(nativeObjectPtr, newValue);}
  protected static native void setPopupBorderSize(long nativeObjectPtr, float newValue);
  public float getFrameRounding(){return getFrameRounding(nativeObjectPtr);}
  protected static native float getFrameRounding(long nativeObjectPtr);
  public void setFrameRounding(float newValue) {setFrameRounding(nativeObjectPtr, newValue);}
  protected static native void setFrameRounding(long nativeObjectPtr, float newValue);
  public float getFrameBorderSize(){return getFrameBorderSize(nativeObjectPtr);}
  protected static native float getFrameBorderSize(long nativeObjectPtr);
  public void setFrameBorderSize(float newValue) {setFrameBorderSize(nativeObjectPtr, newValue);}
  protected static native void setFrameBorderSize(long nativeObjectPtr, float newValue);
  public float getIndentSpacing(){return getIndentSpacing(nativeObjectPtr);}
  protected static native float getIndentSpacing(long nativeObjectPtr);
  public void setIndentSpacing(float newValue) {setIndentSpacing(nativeObjectPtr, newValue);}
  protected static native void setIndentSpacing(long nativeObjectPtr, float newValue);
  public float getColumnsMinSpacing(){return getColumnsMinSpacing(nativeObjectPtr);}
  protected static native float getColumnsMinSpacing(long nativeObjectPtr);
  public void setColumnsMinSpacing(float newValue) {setColumnsMinSpacing(nativeObjectPtr, newValue);}
  protected static native void setColumnsMinSpacing(long nativeObjectPtr, float newValue);
  public float getScrollbarSize(){return getScrollbarSize(nativeObjectPtr);}
  protected static native float getScrollbarSize(long nativeObjectPtr);
  public void setScrollbarSize(float newValue) {setScrollbarSize(nativeObjectPtr, newValue);}
  protected static native void setScrollbarSize(long nativeObjectPtr, float newValue);
  public float getScrollbarRounding(){return getScrollbarRounding(nativeObjectPtr);}
  protected static native float getScrollbarRounding(long nativeObjectPtr);
  public void setScrollbarRounding(float newValue) {setScrollbarRounding(nativeObjectPtr, newValue);}
  protected static native void setScrollbarRounding(long nativeObjectPtr, float newValue);
  public float getGrabMinSize(){return getGrabMinSize(nativeObjectPtr);}
  protected static native float getGrabMinSize(long nativeObjectPtr);
  public void setGrabMinSize(float newValue) {setGrabMinSize(nativeObjectPtr, newValue);}
  protected static native void setGrabMinSize(long nativeObjectPtr, float newValue);
  public float getGrabRounding(){return getGrabRounding(nativeObjectPtr);}
  protected static native float getGrabRounding(long nativeObjectPtr);
  public void setGrabRounding(float newValue) {setGrabRounding(nativeObjectPtr, newValue);}
  protected static native void setGrabRounding(long nativeObjectPtr, float newValue);
  public float getLogSliderDeadzone(){return getLogSliderDeadzone(nativeObjectPtr);}
  protected static native float getLogSliderDeadzone(long nativeObjectPtr);
  public void setLogSliderDeadzone(float newValue) {setLogSliderDeadzone(nativeObjectPtr, newValue);}
  protected static native void setLogSliderDeadzone(long nativeObjectPtr, float newValue);
  public float getTabRounding(){return getTabRounding(nativeObjectPtr);}
  protected static native float getTabRounding(long nativeObjectPtr);
  public void setTabRounding(float newValue) {setTabRounding(nativeObjectPtr, newValue);}
  protected static native void setTabRounding(long nativeObjectPtr, float newValue);
  public float getTabBorderSize(){return getTabBorderSize(nativeObjectPtr);}
  protected static native float getTabBorderSize(long nativeObjectPtr);
  public void setTabBorderSize(float newValue) {setTabBorderSize(nativeObjectPtr, newValue);}
  protected static native void setTabBorderSize(long nativeObjectPtr, float newValue);
  public float getTabMinWidthForCloseButton(){return getTabMinWidthForCloseButton(nativeObjectPtr);}
  protected static native float getTabMinWidthForCloseButton(long nativeObjectPtr);
  public void setTabMinWidthForCloseButton(float newValue) {setTabMinWidthForCloseButton(nativeObjectPtr, newValue);}
  protected static native void setTabMinWidthForCloseButton(long nativeObjectPtr, float newValue);
  public float getMouseCursorScale(){return getMouseCursorScale(nativeObjectPtr);}
  protected static native float getMouseCursorScale(long nativeObjectPtr);
  public void setMouseCursorScale(float newValue) {setMouseCursorScale(nativeObjectPtr, newValue);}
  protected static native void setMouseCursorScale(long nativeObjectPtr, float newValue);
  public float getCurveTessellationTol(){return getCurveTessellationTol(nativeObjectPtr);}
  protected static native float getCurveTessellationTol(long nativeObjectPtr);
  public void setCurveTessellationTol(float newValue) {setCurveTessellationTol(nativeObjectPtr, newValue);}
  protected static native void setCurveTessellationTol(long nativeObjectPtr, float newValue);
  public float getCircleTessellationMaxError(){return getCircleTessellationMaxError(nativeObjectPtr);}
  protected static native float getCircleTessellationMaxError(long nativeObjectPtr);
  public void setCircleTessellationMaxError(float newValue) {setCircleTessellationMaxError(nativeObjectPtr, newValue);}
  protected static native void setCircleTessellationMaxError(long nativeObjectPtr, float newValue);
  public boolean isAntiAliasedLines(){return isAntiAliasedLines(this.nativeObjectPtr);}
  public static native boolean isAntiAliasedLines(long nativeObjectPtr);
  public void setAntiAliasedLines(boolean newValue){setAntiAliasedLines(this.nativeObjectPtr,newValue);}
  public static native void setAntiAliasedLines(long nativeObjectPtr, boolean newValue);
  public boolean isAntiAliasedFill(){return isAntiAliasedFill(this.nativeObjectPtr);}
  public static native boolean isAntiAliasedFill(long nativeObjectPtr);
  public void setAntiAliasedFill(boolean newValue){setAntiAliasedFill(this.nativeObjectPtr,newValue);}
  public static native void setAntiAliasedFill(long nativeObjectPtr, boolean newValue);
  public static native void scaleAllSizes(float scaleFactor, long nativeObjectPtr);
  public final void scaleAllSizes(float scaleFactor){scaleAllSizes(scaleFactor,this.nativeObjectPtr);}

}