
package org.ice1000.jimgui;
import org.ice1000.jimgui.cpp.*;
import org.jetbrains.annotations.*;

/**
 * @author ice1000
 * @since v0.1
 */
@SuppressWarnings("ALL")
public final class NativeInt extends Number implements DeallocatableObject, Cloneable {
  /** package-private by design */
  long nativeObjectPtr;
  @Contract public NativeInt() { nativeObjectPtr = allocateNativeObject(); }
  @Contract(pure = true) public NativeInt(long nativeObjectPtr) { this.nativeObjectPtr = nativeObjectPtr; }

  @Override @Contract
  public void deallocateNativeObject() { deallocateNativeObject0(nativeObjectPtr); nativeObjectPtr = 0; }
  @Contract(pure = true) public int accessValue() { return accessValue(nativeObjectPtr); }
  @Contract public void increaseValue(int increment) { increaseValue(nativeObjectPtr, increment); }
  @Contract public void modifyValue(int newValue) { modifyValue(nativeObjectPtr, newValue); }

  @Override @Contract(pure = true) public int intValue() { return (int) accessValue(); }
  @Override @Contract(pure = true) public long longValue() { return (long) accessValue(); }
  @Override @Contract(pure = true) public float floatValue() { return (float) accessValue(); }
  @Override @Contract(pure = true) public double doubleValue() { return (double) accessValue(); }

  private static native int accessValue(long nativeObjectPtr);
  private static native void modifyValue(long nativeObjectPtr, int newValue);
  private static native void increaseValue(long nativeObjectPtr, int increment);
  private static native long allocateNativeObject();
  private static native void deallocateNativeObject0(long nativeObjectPtr);

  @Override @Contract(value = "null -> false", pure = true)
  public boolean equals(@Nullable Object o) {
    return this == o || o instanceof NativeInt && nativeObjectPtr == ((NativeInt) o).nativeObjectPtr;
  }
  @Override @Contract(pure = true)
  public int hashCode() { return Long.hashCode(nativeObjectPtr); }
  @Override public @NotNull String toString() { return String.valueOf(accessValue()); }
  @Override @Contract public @NotNull NativeInt clone() {
    NativeInt newInstance = new NativeInt();
    newInstance.modifyValue(accessValue());
    return newInstance;
  }
}
