package org.ice1000.jimgui.flag;

import org.ice1000.jimgui.*;
import org.ice1000.jimgui.flag.*;
import org.ice1000.jimgui.cpp.*;
import org.intellij.lang.annotations.*;
import org.jetbrains.annotations.*;
import java.nio.charset.StandardCharsets;

import static org.ice1000.jimgui.util.JImGuiUtil.*;

/**
 * @author ice1000
 * @since undecidable
 */
@SuppressWarnings("ALL")

public interface JImColorEditFlags {
  int None = 0;
  int NoAlpha = 1 << 1;
  int NoPicker = 1 << 2;
  int NoOptions = 1 << 3;
  int NoSmallPreview = 1 << 4;
  int NoInputs = 1 << 5;
  int NoTooltip = 1 << 6;
  int NoLabel = 1 << 7;
  int NoSidePreview = 1 << 8;
  int NoDragDrop = 1 << 9;
  int NoBorder = 1 << 10;
  int AlphaBar = 1 << 16;
  int AlphaPreview = 1 << 17;
  int AlphaPreviewHalf = 1 << 18;
  int HDR = 1 << 19;
  int DisplayRGB = 1 << 20;
  int DisplayHSV = 1 << 21;
  int DisplayHex = 1 << 22;
  int Uint8 = 1 << 23;
  int Float = 1 << 24;
  int PickerHueBar = 1 << 25;
  int PickerHueWheel = 1 << 26;
  int InputRGB = 1 << 27;
  int InputHSV = 1 << 28;
  int OptionsDefault = Uint8 | InputRGB | PickerHueBar;
  int _DisplayMask = DisplayRGB | DisplayHSV | DisplayHex;
  int _DataTypeMask = Uint8 | Float;
  int _PickerMask = PickerHueWheel | PickerHueBar;
  int _InputMask = InputRGB | InputHSV;
  enum Type implements Flag {
    None(JImColorEditFlags.None),
    NoAlpha(JImColorEditFlags.NoAlpha),
    NoPicker(JImColorEditFlags.NoPicker),
    NoOptions(JImColorEditFlags.NoOptions),
    NoSmallPreview(JImColorEditFlags.NoSmallPreview),
    NoInputs(JImColorEditFlags.NoInputs),
    NoTooltip(JImColorEditFlags.NoTooltip),
    NoLabel(JImColorEditFlags.NoLabel),
    NoSidePreview(JImColorEditFlags.NoSidePreview),
    NoDragDrop(JImColorEditFlags.NoDragDrop),
    NoBorder(JImColorEditFlags.NoBorder),
    AlphaBar(JImColorEditFlags.AlphaBar),
    AlphaPreview(JImColorEditFlags.AlphaPreview),
    AlphaPreviewHalf(JImColorEditFlags.AlphaPreviewHalf),
    HDR(JImColorEditFlags.HDR),
    DisplayRGB(JImColorEditFlags.DisplayRGB),
    DisplayHSV(JImColorEditFlags.DisplayHSV),
    DisplayHex(JImColorEditFlags.DisplayHex),
    Uint8(JImColorEditFlags.Uint8),
    Float(JImColorEditFlags.Float),
    PickerHueBar(JImColorEditFlags.PickerHueBar),
    PickerHueWheel(JImColorEditFlags.PickerHueWheel),
    InputRGB(JImColorEditFlags.InputRGB),
    InputHSV(JImColorEditFlags.InputHSV),
    OptionsDefault(JImColorEditFlags.OptionsDefault),
    _DisplayMask(JImColorEditFlags._DisplayMask),
    _DataTypeMask(JImColorEditFlags._DataTypeMask),
    _PickerMask(JImColorEditFlags._PickerMask),
    _InputMask(JImColorEditFlags._InputMask),
    ;
    public final int flag;
    Type(int flag) { this.flag = flag; }
    @Override public int get() { return flag; }
  }
}
