package org.ice1000.jimgui.flag;

import org.ice1000.jimgui.*;
import org.ice1000.jimgui.flag.*;
import org.ice1000.jimgui.cpp.*;
import org.intellij.lang.annotations.*;
import org.jetbrains.annotations.*;
import java.nio.charset.StandardCharsets;

import static org.ice1000.jimgui.util.JImGuiUtil.*;

/**
 * @author ice1000
 * @since undecidable
 */
@SuppressWarnings("ALL")

public interface JImConfigFlags {
  int None = 0;
  int NavEnableKeyboard = 1 << 0;
  int NavEnableGamepad = 1 << 1;
  int NavEnableSetMousePos = 1 << 2;
  int NavNoCaptureKeyboard = 1 << 3;
  int NoMouse = 1 << 4;
  int NoMouseCursorChange = 1 << 5;
  int IsSRGB = 1 << 20;
  int IsTouchScreen = 1 << 21;
  enum Type implements Flag {
    None(JImConfigFlags.None),
    NavEnableKeyboard(JImConfigFlags.NavEnableKeyboard),
    NavEnableGamepad(JImConfigFlags.NavEnableGamepad),
    NavEnableSetMousePos(JImConfigFlags.NavEnableSetMousePos),
    NavNoCaptureKeyboard(JImConfigFlags.NavNoCaptureKeyboard),
    NoMouse(JImConfigFlags.NoMouse),
    NoMouseCursorChange(JImConfigFlags.NoMouseCursorChange),
    IsSRGB(JImConfigFlags.IsSRGB),
    IsTouchScreen(JImConfigFlags.IsTouchScreen),
    ;
    public final int flag;
    Type(int flag) { this.flag = flag; }
    @Override public int get() { return flag; }
  }
}
