package org.ice1000.jimgui.flag;

import org.ice1000.jimgui.*;
import org.ice1000.jimgui.flag.*;
import org.ice1000.jimgui.cpp.*;
import org.intellij.lang.annotations.*;
import org.jetbrains.annotations.*;
import java.nio.charset.StandardCharsets;

import static org.ice1000.jimgui.util.JImGuiUtil.*;

/**
 * @author ice1000
 * @since undecidable
 */
@SuppressWarnings("ALL")

public interface JImHoveredFlags {
  int None = 0;
  int ChildWindows = 1 << 0;
  int RootWindow = 1 << 1;
  int AnyWindow = 1 << 2;
  int AllowWhenBlockedByPopup = 1 << 3;
  int AllowWhenBlockedByActiveItem = 1 << 5;
  int AllowWhenOverlapped = 1 << 6;
  int AllowWhenDisabled = 1 << 7;
  int RectOnly = AllowWhenBlockedByPopup | AllowWhenBlockedByActiveItem | AllowWhenOverlapped;
  int RootAndChildWindows = RootWindow | ChildWindows;
  enum Type implements Flag {
    None(JImHoveredFlags.None),
    ChildWindows(JImHoveredFlags.ChildWindows),
    RootWindow(JImHoveredFlags.RootWindow),
    AnyWindow(JImHoveredFlags.AnyWindow),
    AllowWhenBlockedByPopup(JImHoveredFlags.AllowWhenBlockedByPopup),
    AllowWhenBlockedByActiveItem(JImHoveredFlags.AllowWhenBlockedByActiveItem),
    AllowWhenOverlapped(JImHoveredFlags.AllowWhenOverlapped),
    AllowWhenDisabled(JImHoveredFlags.AllowWhenDisabled),
    RectOnly(JImHoveredFlags.RectOnly),
    RootAndChildWindows(JImHoveredFlags.RootAndChildWindows),
    ;
    public final int flag;
    Type(int flag) { this.flag = flag; }
    @Override public int get() { return flag; }
  }
}
