package org.ice1000.jimgui.flag;

import org.ice1000.jimgui.*;
import org.ice1000.jimgui.flag.*;
import org.ice1000.jimgui.cpp.*;
import org.intellij.lang.annotations.*;
import org.jetbrains.annotations.*;
import java.nio.charset.StandardCharsets;

import static org.ice1000.jimgui.util.JImGuiUtil.*;

/**
 * @author ice1000
 * @since undecidable
 */
@SuppressWarnings("ALL")

public interface JImInputTextFlags {
  int None = 0;
  int CharsDecimal = 1 << 0;
  int CharsHexadecimal = 1 << 1;
  int CharsUppercase = 1 << 2;
  int CharsNoBlank = 1 << 3;
  int AutoSelectAll = 1 << 4;
  int EnterReturnsTrue = 1 << 5;
  int CallbackCompletion = 1 << 6;
  int CallbackHistory = 1 << 7;
  int CallbackAlways = 1 << 8;
  int CallbackCharFilter = 1 << 9;
  int AllowTabInput = 1 << 10;
  int CtrlEnterForNewLine = 1 << 11;
  int NoHorizontalScroll = 1 << 12;
  int AlwaysInsertMode = 1 << 13;
  int ReadOnly = 1 << 14;
  int Password = 1 << 15;
  int NoUndoRedo = 1 << 16;
  int CharsScientific = 1 << 17;
  int CallbackResize = 1 << 18;
  int CallbackEdit = 1 << 19;
  int Multiline = 1 << 20;
  int NoMarkEdited = 1 << 21;
  enum Type implements Flag {
    None(JImInputTextFlags.None),
    CharsDecimal(JImInputTextFlags.CharsDecimal),
    CharsHexadecimal(JImInputTextFlags.CharsHexadecimal),
    CharsUppercase(JImInputTextFlags.CharsUppercase),
    CharsNoBlank(JImInputTextFlags.CharsNoBlank),
    AutoSelectAll(JImInputTextFlags.AutoSelectAll),
    EnterReturnsTrue(JImInputTextFlags.EnterReturnsTrue),
    CallbackCompletion(JImInputTextFlags.CallbackCompletion),
    CallbackHistory(JImInputTextFlags.CallbackHistory),
    CallbackAlways(JImInputTextFlags.CallbackAlways),
    CallbackCharFilter(JImInputTextFlags.CallbackCharFilter),
    AllowTabInput(JImInputTextFlags.AllowTabInput),
    CtrlEnterForNewLine(JImInputTextFlags.CtrlEnterForNewLine),
    NoHorizontalScroll(JImInputTextFlags.NoHorizontalScroll),
    AlwaysInsertMode(JImInputTextFlags.AlwaysInsertMode),
    ReadOnly(JImInputTextFlags.ReadOnly),
    Password(JImInputTextFlags.Password),
    NoUndoRedo(JImInputTextFlags.NoUndoRedo),
    CharsScientific(JImInputTextFlags.CharsScientific),
    CallbackResize(JImInputTextFlags.CallbackResize),
    CallbackEdit(JImInputTextFlags.CallbackEdit),
    Multiline(JImInputTextFlags.Multiline),
    NoMarkEdited(JImInputTextFlags.NoMarkEdited),
    ;
    public final int flag;
    Type(int flag) { this.flag = flag; }
    @Override public int get() { return flag; }
  }
}
