package org.ice1000.jimgui.flag;

import org.ice1000.jimgui.*;
import org.ice1000.jimgui.flag.*;
import org.ice1000.jimgui.cpp.*;
import org.intellij.lang.annotations.*;
import org.jetbrains.annotations.*;
import java.nio.charset.StandardCharsets;

import static org.ice1000.jimgui.util.JImGuiUtil.*;

/**
 * @author ice1000
 * @since undecidable
 */
@SuppressWarnings("ALL")

public interface JImItemFlags {
  int None = 0;
  int NoTabStop = 1 << 0;
  int ButtonRepeat = 1 << 1;
  int Disabled = 1 << 2;
  int NoNav = 1 << 3;
  int NoNavDefaultFocus = 1 << 4;
  int SelectableDontClosePopup = 1 << 5;
  int MixedValue = 1 << 6;
  int ReadOnly = 1 << 7;
  int Default = 0;
  enum Type implements Flag {
    None(JImItemFlags.None),
    NoTabStop(JImItemFlags.NoTabStop),
    ButtonRepeat(JImItemFlags.ButtonRepeat),
    Disabled(JImItemFlags.Disabled),
    NoNav(JImItemFlags.NoNav),
    NoNavDefaultFocus(JImItemFlags.NoNavDefaultFocus),
    SelectableDontClosePopup(JImItemFlags.SelectableDontClosePopup),
    MixedValue(JImItemFlags.MixedValue),
    ReadOnly(JImItemFlags.ReadOnly),
    Default(JImItemFlags.Default),
    ;
    public final int flag;
    Type(int flag) { this.flag = flag; }
    @Override public int get() { return flag; }
  }
}
