package org.ice1000.jimgui.flag;

import org.ice1000.jimgui.*;
import org.ice1000.jimgui.flag.*;
import org.ice1000.jimgui.cpp.*;
import org.intellij.lang.annotations.*;
import org.jetbrains.annotations.*;
import java.nio.charset.StandardCharsets;

import static org.ice1000.jimgui.util.JImGuiUtil.*;

/**
 * @author ice1000
 * @since undecidable
 */
@SuppressWarnings("ALL")

public interface JImPopupFlags {
  int None = 0;
  int MouseButtonLeft = 0;
  int MouseButtonRight = 1;
  int MouseButtonMiddle = 2;
  int MouseButtonMask = 0x1F;
  int MouseButtonDefault = 1;
  int NoOpenOverExistingPopup = 1 << 5;
  int NoOpenOverItems = 1 << 6;
  int AnyPopupId = 1 << 7;
  int AnyPopupLevel = 1 << 8;
  int AnyPopup = AnyPopupId | AnyPopupLevel;
  enum Type implements Flag {
    None(JImPopupFlags.None),
    MouseButtonLeft(JImPopupFlags.MouseButtonLeft),
    MouseButtonRight(JImPopupFlags.MouseButtonRight),
    MouseButtonMiddle(JImPopupFlags.MouseButtonMiddle),
    MouseButtonMask(JImPopupFlags.MouseButtonMask),
    MouseButtonDefault(JImPopupFlags.MouseButtonDefault),
    NoOpenOverExistingPopup(JImPopupFlags.NoOpenOverExistingPopup),
    NoOpenOverItems(JImPopupFlags.NoOpenOverItems),
    AnyPopupId(JImPopupFlags.AnyPopupId),
    AnyPopupLevel(JImPopupFlags.AnyPopupLevel),
    AnyPopup(JImPopupFlags.AnyPopup),
    ;
    public final int flag;
    Type(int flag) { this.flag = flag; }
    @Override public int get() { return flag; }
  }
}
