package org.ice1000.jimgui.flag;

import org.ice1000.jimgui.*;
import org.ice1000.jimgui.flag.*;
import org.ice1000.jimgui.cpp.*;
import org.intellij.lang.annotations.*;
import org.jetbrains.annotations.*;
import java.nio.charset.StandardCharsets;

import static org.ice1000.jimgui.util.JImGuiUtil.*;

/**
 * @author ice1000
 * @since undecidable
 */
@SuppressWarnings("ALL")

public interface JImTabBarFlags {
  int None = 0;
  int Reorderable = 1;
  int AutoSelectNewTabs = 1 << 1;
  int TabListPopupButton = 1 << 2;
  int NoCloseWithMiddleMouseButton = 1 << 3;
  int NoTabListScrollingButtons = 1 << 4;
  int NoTooltip = 1 << 5;
  int FittingPolicyResizeDown = 1 << 6;
  int FittingPolicyScroll = 1 << 7;
  int FittingPolicyMask = FittingPolicyResizeDown | FittingPolicyScroll;
  int FittingPolicyDefault = FittingPolicyResizeDown;
  enum Type implements Flag {
    None(JImTabBarFlags.None),
    Reorderable(JImTabBarFlags.Reorderable),
    AutoSelectNewTabs(JImTabBarFlags.AutoSelectNewTabs),
    TabListPopupButton(JImTabBarFlags.TabListPopupButton),
    NoCloseWithMiddleMouseButton(JImTabBarFlags.NoCloseWithMiddleMouseButton),
    NoTabListScrollingButtons(JImTabBarFlags.NoTabListScrollingButtons),
    NoTooltip(JImTabBarFlags.NoTooltip),
    FittingPolicyResizeDown(JImTabBarFlags.FittingPolicyResizeDown),
    FittingPolicyScroll(JImTabBarFlags.FittingPolicyScroll),
    FittingPolicyMask(JImTabBarFlags.FittingPolicyMask),
    FittingPolicyDefault(JImTabBarFlags.FittingPolicyDefault),
    ;
    public final int flag;
    Type(int flag) { this.flag = flag; }
    @Override public int get() { return flag; }
  }
}
