package org.ice1000.jimgui.flag;

import org.ice1000.jimgui.*;
import org.ice1000.jimgui.flag.*;
import org.ice1000.jimgui.cpp.*;
import org.intellij.lang.annotations.*;
import org.jetbrains.annotations.*;
import java.nio.charset.StandardCharsets;

import static org.ice1000.jimgui.util.JImGuiUtil.*;

/**
 * @author ice1000
 * @since undecidable
 */
@SuppressWarnings("ALL")

public interface JImTableColumnFlags {
  int None = 0;
  int DefaultHide = 1 << 0;
  int DefaultSort = 1 << 1;
  int WidthStretch = 1 << 2;
  int WidthFixed = 1 << 3;
  int NoResize = 1 << 5;
  int NoReorder = 1 << 6;
  int NoHide = 1 << 7;
  int NoClip = 1 << 8;
  int NoSort = 1 << 9;
  int NoSortAscending = 1 << 10;
  int NoSortDescending = 1 << 11;
  int NoHeaderWidth = 1 << 12;
  int PreferSortAscending = 1 << 13;
  int PreferSortDescending = 1 << 14;
  int IndentEnable = 1 << 15;
  int IndentDisable = 1 << 16;
  int IsEnabled = 1 << 20;
  int IsVisible = 1 << 21;
  int IsSorted = 1 << 22;
  int IsHovered = 1 << 23;
  int WidthMask = WidthStretch | WidthFixed;
  int IndentMask = IndentEnable | IndentDisable;
  int StatusMask = IsEnabled | IsVisible | IsSorted | IsHovered;
  int NoDirectResize = 1 << 30;
  enum Type implements Flag {
    None(JImTableColumnFlags.None),
    DefaultHide(JImTableColumnFlags.DefaultHide),
    DefaultSort(JImTableColumnFlags.DefaultSort),
    WidthStretch(JImTableColumnFlags.WidthStretch),
    WidthFixed(JImTableColumnFlags.WidthFixed),
    NoResize(JImTableColumnFlags.NoResize),
    NoReorder(JImTableColumnFlags.NoReorder),
    NoHide(JImTableColumnFlags.NoHide),
    NoClip(JImTableColumnFlags.NoClip),
    NoSort(JImTableColumnFlags.NoSort),
    NoSortAscending(JImTableColumnFlags.NoSortAscending),
    NoSortDescending(JImTableColumnFlags.NoSortDescending),
    NoHeaderWidth(JImTableColumnFlags.NoHeaderWidth),
    PreferSortAscending(JImTableColumnFlags.PreferSortAscending),
    PreferSortDescending(JImTableColumnFlags.PreferSortDescending),
    IndentEnable(JImTableColumnFlags.IndentEnable),
    IndentDisable(JImTableColumnFlags.IndentDisable),
    IsEnabled(JImTableColumnFlags.IsEnabled),
    IsVisible(JImTableColumnFlags.IsVisible),
    IsSorted(JImTableColumnFlags.IsSorted),
    IsHovered(JImTableColumnFlags.IsHovered),
    WidthMask(JImTableColumnFlags.WidthMask),
    IndentMask(JImTableColumnFlags.IndentMask),
    StatusMask(JImTableColumnFlags.StatusMask),
    NoDirectResize(JImTableColumnFlags.NoDirectResize),
    ;
    public final int flag;
    Type(int flag) { this.flag = flag; }
    @Override public int get() { return flag; }
  }
}
