package org.ice1000.jimgui.flag;

import org.ice1000.jimgui.*;
import org.ice1000.jimgui.flag.*;
import org.ice1000.jimgui.cpp.*;
import org.intellij.lang.annotations.*;
import org.jetbrains.annotations.*;
import java.nio.charset.StandardCharsets;

import static org.ice1000.jimgui.util.JImGuiUtil.*;

/**
 * @author ice1000
 * @since undecidable
 */
@SuppressWarnings("ALL")

public interface JImTableFlags {
  int None = 0;
  int Resizable = 1 << 0;
  int Reorderable = 1 << 1;
  int Hideable = 1 << 2;
  int Sortable = 1 << 3;
  int NoSavedSettings = 1 << 4;
  int ContextMenuInBody = 1 << 5;
  int RowBg = 1 << 6;
  int BordersInnerH = 1 << 7;
  int BordersOuterH = 1 << 8;
  int BordersInnerV = 1 << 9;
  int BordersOuterV = 1 << 10;
  int BordersH = BordersInnerH | BordersOuterH;
  int BordersV = BordersInnerV | BordersOuterV;
  int BordersInner = BordersInnerV | BordersInnerH;
  int BordersOuter = BordersOuterV | BordersOuterH;
  int Borders = BordersInner | BordersOuter;
  int NoBordersInBody = 1 << 11;
  int NoBordersInBodyUntilResize = 1 << 12;
  int SizingFixedFit = 1 << 13;
  int SizingFixedSame = 2 << 13;
  int SizingStretchProp = 3 << 13;
  int SizingStretchSame = 4 << 13;
  int NoHostExtendX = 1 << 16;
  int NoHostExtendY = 1 << 17;
  int NoKeepColumnsVisible = 1 << 18;
  int PreciseWidths = 1 << 19;
  int NoClip = 1 << 20;
  int PadOuterX = 1 << 21;
  int NoPadOuterX = 1 << 22;
  int NoPadInnerX = 1 << 23;
  int ScrollX = 1 << 24;
  int ScrollY = 1 << 25;
  int SortMulti = 1 << 26;
  int SortTristate = 1 << 27;
  int SizingMask = SizingFixedFit | SizingFixedSame | SizingStretchProp | SizingStretchSame;
  enum Type implements Flag {
    None(JImTableFlags.None),
    Resizable(JImTableFlags.Resizable),
    Reorderable(JImTableFlags.Reorderable),
    Hideable(JImTableFlags.Hideable),
    Sortable(JImTableFlags.Sortable),
    NoSavedSettings(JImTableFlags.NoSavedSettings),
    ContextMenuInBody(JImTableFlags.ContextMenuInBody),
    RowBg(JImTableFlags.RowBg),
    BordersInnerH(JImTableFlags.BordersInnerH),
    BordersOuterH(JImTableFlags.BordersOuterH),
    BordersInnerV(JImTableFlags.BordersInnerV),
    BordersOuterV(JImTableFlags.BordersOuterV),
    BordersH(JImTableFlags.BordersH),
    BordersV(JImTableFlags.BordersV),
    BordersInner(JImTableFlags.BordersInner),
    BordersOuter(JImTableFlags.BordersOuter),
    Borders(JImTableFlags.Borders),
    NoBordersInBody(JImTableFlags.NoBordersInBody),
    NoBordersInBodyUntilResize(JImTableFlags.NoBordersInBodyUntilResize),
    SizingFixedFit(JImTableFlags.SizingFixedFit),
    SizingFixedSame(JImTableFlags.SizingFixedSame),
    SizingStretchProp(JImTableFlags.SizingStretchProp),
    SizingStretchSame(JImTableFlags.SizingStretchSame),
    NoHostExtendX(JImTableFlags.NoHostExtendX),
    NoHostExtendY(JImTableFlags.NoHostExtendY),
    NoKeepColumnsVisible(JImTableFlags.NoKeepColumnsVisible),
    PreciseWidths(JImTableFlags.PreciseWidths),
    NoClip(JImTableFlags.NoClip),
    PadOuterX(JImTableFlags.PadOuterX),
    NoPadOuterX(JImTableFlags.NoPadOuterX),
    NoPadInnerX(JImTableFlags.NoPadInnerX),
    ScrollX(JImTableFlags.ScrollX),
    ScrollY(JImTableFlags.ScrollY),
    SortMulti(JImTableFlags.SortMulti),
    SortTristate(JImTableFlags.SortTristate),
    SizingMask(JImTableFlags.SizingMask),
    ;
    public final int flag;
    Type(int flag) { this.flag = flag; }
    @Override public int get() { return flag; }
  }
}
