package org.ice1000.jimgui.flag;

import org.ice1000.jimgui.*;
import org.ice1000.jimgui.flag.*;
import org.ice1000.jimgui.cpp.*;
import org.intellij.lang.annotations.*;
import org.jetbrains.annotations.*;
import java.nio.charset.StandardCharsets;

import static org.ice1000.jimgui.util.JImGuiUtil.*;

/**
 * @author ice1000
 * @since undecidable
 */
@SuppressWarnings("ALL")

public interface JImTreeNodeFlags {
  int None = 0;
  int Selected = 1 << 0;
  int Framed = 1 << 1;
  int AllowItemOverlap = 1 << 2;
  int NoTreePushOnOpen = 1 << 3;
  int NoAutoOpenOnLog = 1 << 4;
  int DefaultOpen = 1 << 5;
  int OpenOnDoubleClick = 1 << 6;
  int OpenOnArrow = 1 << 7;
  int Leaf = 1 << 8;
  int Bullet = 1 << 9;
  int FramePadding = 1 << 10;
  int SpanAvailWidth = 1 << 11;
  int SpanFullWidth = 1 << 12;
  int NavLeftJumpsBackHere = 1 << 13;
  int CollapsingHeader = Framed | NoTreePushOnOpen | NoAutoOpenOnLog;
  enum Type implements Flag {
    None(JImTreeNodeFlags.None),
    Selected(JImTreeNodeFlags.Selected),
    Framed(JImTreeNodeFlags.Framed),
    AllowItemOverlap(JImTreeNodeFlags.AllowItemOverlap),
    NoTreePushOnOpen(JImTreeNodeFlags.NoTreePushOnOpen),
    NoAutoOpenOnLog(JImTreeNodeFlags.NoAutoOpenOnLog),
    DefaultOpen(JImTreeNodeFlags.DefaultOpen),
    OpenOnDoubleClick(JImTreeNodeFlags.OpenOnDoubleClick),
    OpenOnArrow(JImTreeNodeFlags.OpenOnArrow),
    Leaf(JImTreeNodeFlags.Leaf),
    Bullet(JImTreeNodeFlags.Bullet),
    FramePadding(JImTreeNodeFlags.FramePadding),
    SpanAvailWidth(JImTreeNodeFlags.SpanAvailWidth),
    SpanFullWidth(JImTreeNodeFlags.SpanFullWidth),
    NavLeftJumpsBackHere(JImTreeNodeFlags.NavLeftJumpsBackHere),
    CollapsingHeader(JImTreeNodeFlags.CollapsingHeader),
    ;
    public final int flag;
    Type(int flag) { this.flag = flag; }
    @Override public int get() { return flag; }
  }
}
