package org.ice1000.jimgui.flag;

import org.ice1000.jimgui.*;
import org.ice1000.jimgui.flag.*;
import org.ice1000.jimgui.cpp.*;
import org.intellij.lang.annotations.*;
import org.jetbrains.annotations.*;
import java.nio.charset.StandardCharsets;

import static org.ice1000.jimgui.util.JImGuiUtil.*;

/**
 * @author ice1000
 * @since undecidable
 */
@SuppressWarnings("ALL")

public interface JImWindowFlags {
  int None = 0;
  int NoTitleBar = 1 << 0;
  int NoResize = 1 << 1;
  int NoMove = 1 << 2;
  int NoScrollbar = 1 << 3;
  int NoScrollWithMouse = 1 << 4;
  int NoCollapse = 1 << 5;
  int AlwaysAutoResize = 1 << 6;
  int NoBackground = 1 << 7;
  int NoSavedSettings = 1 << 8;
  int NoMouseInputs = 1 << 9;
  int MenuBar = 1 << 10;
  int HorizontalScrollbar = 1 << 11;
  int NoFocusOnAppearing = 1 << 12;
  int NoBringToFrontOnFocus = 1 << 13;
  int AlwaysVerticalScrollbar = 1 << 14;
  int AlwaysHorizontalScrollbar = 1<< 15;
  int AlwaysUseWindowPadding = 1 << 16;
  int NoNavInputs = 1 << 18;
  int NoNavFocus = 1 << 19;
  int UnsavedDocument = 1 << 20;
  int NoNav = NoNavInputs | NoNavFocus;
  int NoDecoration = NoTitleBar | NoResize | NoScrollbar | NoCollapse;
  int NoInputs = NoMouseInputs | NoNavInputs | NoNavFocus;
  int NavFlattened = 1 << 23;
  int ChildWindow = 1 << 24;
  int Tooltip = 1 << 25;
  int Popup = 1 << 26;
  int Modal = 1 << 27;
  int ChildMenu = 1 << 28;
  enum Type implements Flag {
    None(JImWindowFlags.None),
    NoTitleBar(JImWindowFlags.NoTitleBar),
    NoResize(JImWindowFlags.NoResize),
    NoMove(JImWindowFlags.NoMove),
    NoScrollbar(JImWindowFlags.NoScrollbar),
    NoScrollWithMouse(JImWindowFlags.NoScrollWithMouse),
    NoCollapse(JImWindowFlags.NoCollapse),
    AlwaysAutoResize(JImWindowFlags.AlwaysAutoResize),
    NoBackground(JImWindowFlags.NoBackground),
    NoSavedSettings(JImWindowFlags.NoSavedSettings),
    NoMouseInputs(JImWindowFlags.NoMouseInputs),
    MenuBar(JImWindowFlags.MenuBar),
    HorizontalScrollbar(JImWindowFlags.HorizontalScrollbar),
    NoFocusOnAppearing(JImWindowFlags.NoFocusOnAppearing),
    NoBringToFrontOnFocus(JImWindowFlags.NoBringToFrontOnFocus),
    AlwaysVerticalScrollbar(JImWindowFlags.AlwaysVerticalScrollbar),
    AlwaysHorizontalScrollbar(JImWindowFlags.AlwaysHorizontalScrollbar),
    AlwaysUseWindowPadding(JImWindowFlags.AlwaysUseWindowPadding),
    NoNavInputs(JImWindowFlags.NoNavInputs),
    NoNavFocus(JImWindowFlags.NoNavFocus),
    UnsavedDocument(JImWindowFlags.UnsavedDocument),
    NoNav(JImWindowFlags.NoNav),
    NoDecoration(JImWindowFlags.NoDecoration),
    NoInputs(JImWindowFlags.NoInputs),
    NavFlattened(JImWindowFlags.NavFlattened),
    ChildWindow(JImWindowFlags.ChildWindow),
    Tooltip(JImWindowFlags.Tooltip),
    Popup(JImWindowFlags.Popup),
    Modal(JImWindowFlags.Modal),
    ChildMenu(JImWindowFlags.ChildMenu),
    ;
    public final int flag;
    Type(int flag) { this.flag = flag; }
    @Override public int get() { return flag; }
  }
}
