/*
 * Decompiled with CFR 0.152.
 */
package org.ice1000.jimgui.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.ProviderNotFoundException;
import java.nio.file.StandardCopyOption;
import org.jetbrains.annotations.NotNull;

public interface NativeUtil {
    @NotNull
    public static final String NATIVE_FOLDER_PATH_PREFIX = "jimgui";
    @NotNull
    public static final String TEM_DIR = System.getProperty("java.io.tmpdir");
    public static final boolean isPosixCompliant = NativeUtil.isPosixCompliant();

    public static void loadLibraryFromJar(@NotNull String fileName, @NotNull Class<?> callerClass) {
        File temp;
        block17: {
            File temporaryDir = NativeUtil.createTempDirectory();
            temporaryDir.deleteOnExit();
            String fullPath = "/native/" + fileName;
            temp = new File(temporaryDir, fileName);
            try (InputStream is = callerClass.getResourceAsStream(fullPath);){
                if (is == null) {
                    throw new UnsupportedOperationException("Native library " + fileName + " not found.");
                }
                Files.copy(is, temp.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException | NullPointerException e) {
                if (!temp.exists()) break block17;
                System.err.println("Deleting since load failed... " + temp.delete());
            }
        }
        try {
            System.load(temp.getAbsolutePath());
        }
        catch (UnsatisfiedLinkError e) {
            System.err.println("Got unsatisfied link error, please check the native library " + fileName);
            throw new UnsupportedOperationException(e);
        }
        finally {
            if (isPosixCompliant) {
                boolean delete = temp.delete();
                if (!delete) {
                    System.err.println("Failed to delete native library.");
                }
            } else {
                temp.deleteOnExit();
            }
        }
    }

    public static boolean isPosixCompliant() {
        try {
            return FileSystems.getDefault().supportedFileAttributeViews().contains("posix");
        }
        catch (SecurityException | FileSystemNotFoundException | ProviderNotFoundException e) {
            return false;
        }
    }

    @NotNull
    public static File createTempDirectory() {
        File generatedDir = new File(TEM_DIR, NATIVE_FOLDER_PATH_PREFIX + System.currentTimeMillis());
        if (!generatedDir.mkdir()) {
            throw new IllegalStateException("Failed to create temp directory " + generatedDir.getName());
        }
        return generatedDir;
    }
}

