package org.ice1000.jimgui;

import org.ice1000.jimgui.*;
import org.ice1000.jimgui.flag.*;
import org.ice1000.jimgui.cpp.*;
import org.intellij.lang.annotations.*;
import org.jetbrains.annotations.*;
import java.nio.charset.StandardCharsets;

import static org.ice1000.jimgui.util.JImGuiUtil.*;

/**
 * @author ice1000
 * @since v0.1
 */
@SuppressWarnings("ALL")

public class JImGuiFontAtlasGen {
protected long nativeObjectPtr;

  /** package-private by design */
  JImGuiFontAtlasGen(long nativeObjectPtr) {
    this.nativeObjectPtr = nativeObjectPtr;
  }

  private static native void setTexUvScaleX(long nativeObjectPtr,float newValue);
  public void setTexUvScaleX(float newValue){setTexUvScaleX(nativeObjectPtr, newValue); }
  private static native float getTexUvScaleX(long nativeObjectPtr);
  public float getTexUvScaleX(){return getTexUvScaleX(nativeObjectPtr);}
  private static native void setTexUvScaleY(long nativeObjectPtr,float newValue);
  public void setTexUvScaleY(float newValue){setTexUvScaleY(nativeObjectPtr, newValue); }
  private static native float getTexUvScaleY(long nativeObjectPtr);
  public float getTexUvScaleY(){return getTexUvScaleY(nativeObjectPtr);}
  private static native void setTexUvWhitePixelX(long nativeObjectPtr,float newValue);
  /**Texture+coordinates+to+a+white+pixel%0A++UV+of+white+pixel+in+the+atlas*/
  public void setTexUvWhitePixelX(float newValue){setTexUvWhitePixelX(nativeObjectPtr, newValue); }
  private static native float getTexUvWhitePixelX(long nativeObjectPtr);
  /**Texture+coordinates+to+a+white+pixel%0A++UV+of+white+pixel+in+the+atlas*/
  public float getTexUvWhitePixelX(){return getTexUvWhitePixelX(nativeObjectPtr);}
  private static native void setTexUvWhitePixelY(long nativeObjectPtr,float newValue);
  /**Texture+coordinates+to+a+white+pixel%0A++UV+of+white+pixel+in+the+atlas*/
  public void setTexUvWhitePixelY(float newValue){setTexUvWhitePixelY(nativeObjectPtr, newValue); }
  private static native float getTexUvWhitePixelY(long nativeObjectPtr);
  /**Texture+coordinates+to+a+white+pixel%0A++UV+of+white+pixel+in+the+atlas*/
  public float getTexUvWhitePixelY(){return getTexUvWhitePixelY(nativeObjectPtr);}
  /**What+user+passed+to+InputText%28%29++++++%7C%7C+Read-only%0A++Flags%2C+you+may+poke+into+these+to+adjust+anti-aliasing+settings+per-primitive.%0A++Build+flags+%28see+ImFontAtlasFlags_%29%0A++See+ImGuiViewportFlags_%0A++copy+of+InputText%28%29+flags%0A++Not+exposed%0A++See+enum+ImGuiWindowFlags_%0A++Flags+after+some+patching+%28not+directly+same+as+provided+by+user%29.+See+ImGuiTableColumnFlags_*/
  public @MagicConstant(flagsFromClass = JImFontAtlasFlags.class)int getFlags(){return getFlags(nativeObjectPtr);}
  protected static native @MagicConstant(flagsFromClass = JImFontAtlasFlags.class)int getFlags(long nativeObjectPtr);
  /**What+user+passed+to+InputText%28%29++++++%7C%7C+Read-only%0A++Flags%2C+you+may+poke+into+these+to+adjust+anti-aliasing+settings+per-primitive.%0A++Build+flags+%28see+ImFontAtlasFlags_%29%0A++See+ImGuiViewportFlags_%0A++copy+of+InputText%28%29+flags%0A++Not+exposed%0A++See+enum+ImGuiWindowFlags_%0A++Flags+after+some+patching+%28not+directly+same+as+provided+by+user%29.+See+ImGuiTableColumnFlags_*/
  public void setFlags(@MagicConstant(flagsFromClass = JImFontAtlasFlags.class)int newValue) {setFlags(nativeObjectPtr, newValue);}
  protected static native void setFlags(long nativeObjectPtr, @MagicConstant(flagsFromClass = JImFontAtlasFlags.class)int newValue);
  /**Texture+width+calculated+during+Build%28%29.*/
  public int getTexWidth(){return getTexWidth(nativeObjectPtr);}
  protected static native int getTexWidth(long nativeObjectPtr);
  /**Texture+width+calculated+during+Build%28%29.*/
  public void setTexWidth(int newValue) {setTexWidth(nativeObjectPtr, newValue);}
  protected static native void setTexWidth(long nativeObjectPtr, int newValue);
  /**Texture+height+calculated+during+Build%28%29.*/
  public int getTexHeight(){return getTexHeight(nativeObjectPtr);}
  protected static native int getTexHeight(long nativeObjectPtr);
  /**Texture+height+calculated+during+Build%28%29.*/
  public void setTexHeight(int newValue) {setTexHeight(nativeObjectPtr, newValue);}
  protected static native void setTexHeight(long nativeObjectPtr, int newValue);
  /**Texture+width+desired+by+user+before+Build%28%29.+Must+be+a+power-of-two.+If+have+many+glyphs+your+graphics+API+have+texture+size+restrictions+you+may+want+to+increase+texture+width+to+decrease+height.*/
  public int getTexDesiredWidth(){return getTexDesiredWidth(nativeObjectPtr);}
  protected static native int getTexDesiredWidth(long nativeObjectPtr);
  /**Texture+width+desired+by+user+before+Build%28%29.+Must+be+a+power-of-two.+If+have+many+glyphs+your+graphics+API+have+texture+size+restrictions+you+may+want+to+increase+texture+width+to+decrease+height.*/
  public void setTexDesiredWidth(int newValue) {setTexDesiredWidth(nativeObjectPtr, newValue);}
  protected static native void setTexDesiredWidth(long nativeObjectPtr, int newValue);
  /**Padding+between+glyphs+within+texture+in+pixels.+Defaults+to+1.+If+your+rendering+method+doesn%27t+rely+on+bilinear+filtering+you+may+set+this+to+0.*/
  public int getTexGlyphPadding(){return getTexGlyphPadding(nativeObjectPtr);}
  protected static native int getTexGlyphPadding(long nativeObjectPtr);
  /**Padding+between+glyphs+within+texture+in+pixels.+Defaults+to+1.+If+your+rendering+method+doesn%27t+rely+on+bilinear+filtering+you+may+set+this+to+0.*/
  public void setTexGlyphPadding(int newValue) {setTexGlyphPadding(nativeObjectPtr, newValue);}
  protected static native void setTexGlyphPadding(long nativeObjectPtr, int newValue);
  protected final long addFont(@NotNull JImFontConfig fontConfig, long nativeObjectPtr){return addFont(fontConfig.nativeObjectPtr, nativeObjectPtr);}
  protected static native long addFont(long fontConfig, long nativeObjectPtr);
  public final long addFont(@NotNull JImFontConfig fontConfig){return addFont(fontConfig.nativeObjectPtr,this.nativeObjectPtr);}
  protected final long addFontDefault(@NotNull JImFontConfig fontConfig, long nativeObjectPtr){return addFontDefault(fontConfig.nativeObjectPtr, nativeObjectPtr);}
  protected static native long addFontDefault(long fontConfig, long nativeObjectPtr);
  public final long addFontDefault(@NotNull JImFontConfig fontConfig){return addFontDefault(fontConfig.nativeObjectPtr,this.nativeObjectPtr);}
  public final long addFontDefault(){return addFontDefault(0, this.nativeObjectPtr);}
  /**%27compressed_font_data_base85%27+still+owned+by+caller.+Compress+with+binary_to_compressed_c.cpp+with+-base85+parameter.*/
  protected final long addFontFromMemoryCompressedBase85TTF(@NotNull String compressedFontDataBase85, float sizePixels, long nativeObjectPtr){return addFontFromMemoryCompressedBase85TTF(getBytes(compressedFontDataBase85), sizePixels, nativeObjectPtr);}
  /**%27compressed_font_data_base85%27+still+owned+by+caller.+Compress+with+binary_to_compressed_c.cpp+with+-base85+parameter.*/
  public final long addFontFromMemoryCompressedBase85TTF(@NotNull JImStr compressedFontDataBase85, float sizePixels, long nativeObjectPtr){return addFontFromMemoryCompressedBase85TTF(compressedFontDataBase85.bytes, sizePixels, nativeObjectPtr);}
  protected static native long addFontFromMemoryCompressedBase85TTF(byte[] compressedFontDataBase85, float sizePixels, long nativeObjectPtr);
  /**%27compressed_font_data_base85%27+still+owned+by+caller.+Compress+with+binary_to_compressed_c.cpp+with+-base85+parameter.*/
  public final long addFontFromMemoryCompressedBase85TTF(@NotNull String compressedFontDataBase85, float sizePixels){return addFontFromMemoryCompressedBase85TTF(getBytes(compressedFontDataBase85), sizePixels,this.nativeObjectPtr);}
  /**%27compressed_font_data_base85%27+still+owned+by+caller.+Compress+with+binary_to_compressed_c.cpp+with+-base85+parameter.*/
  public final long addFontFromMemoryCompressedBase85TTF(@NotNull JImStr compressedFontDataBase85, float sizePixels){return addFontFromMemoryCompressedBase85TTF(compressedFontDataBase85.bytes, sizePixels,this.nativeObjectPtr);}
  /**Build+pixels+data.+This+is+called+automatically+for+you+by+the+GetTexData***+functions.*/
  private static native boolean build(long nativeObjectPtr);
  /**Build+pixels+data.+This+is+called+automatically+for+you+by+the+GetTexData***+functions.*/
  public final boolean build(){return build(this.nativeObjectPtr);}
  /**Bit+ambiguous%3A+used+to+detect+when+user+didn%27t+built+texture+but+effectively+we+should+check+TexID+%21%3D+0+except+that+would+be+backend+dependent...*/
  private static native boolean isBuilt(long nativeObjectPtr);
  /**Bit+ambiguous%3A+used+to+detect+when+user+didn%27t+built+texture+but+effectively+we+should+check+TexID+%21%3D+0+except+that+would+be+backend+dependent...*/
  public final boolean isBuilt(){return isBuilt(this.nativeObjectPtr);}
  /**Clear+input+data+%28all+ImFontConfig+structures+including+sizes%2C+TTF+data%2C+glyph+ranges%2C+etc.%29+%3D+all+the+data+used+to+build+the+texture+and+fonts.*/
  private static native void clearInputData(long nativeObjectPtr);
  /**Clear+input+data+%28all+ImFontConfig+structures+including+sizes%2C+TTF+data%2C+glyph+ranges%2C+etc.%29+%3D+all+the+data+used+to+build+the+texture+and+fonts.*/
  public final void clearInputData(){clearInputData(this.nativeObjectPtr);}
  /**Clear+output+texture+data+%28CPU+side%29.+Saves+RAM+once+the+texture+has+been+copied+to+graphics+memory.*/
  private static native void clearTexData(long nativeObjectPtr);
  /**Clear+output+texture+data+%28CPU+side%29.+Saves+RAM+once+the+texture+has+been+copied+to+graphics+memory.*/
  public final void clearTexData(){clearTexData(this.nativeObjectPtr);}
  /**Clear+output+font+data+%28glyphs+storage%2C+UV+coordinates%29.*/
  private static native void clearFonts(long nativeObjectPtr);
  /**Clear+output+font+data+%28glyphs+storage%2C+UV+coordinates%29.*/
  public final void clearFonts(){clearFonts(this.nativeObjectPtr);}
  /**Do+not+clear+Channels%5B%5D+so+our+allocations+are+reused+next+frame%0A++The+ImDrawList+are+owned+by+ImGuiContext%21%0A++Clear+all+input+and+output.*/
  private static native void clear(long nativeObjectPtr);
  /**Do+not+clear+Channels%5B%5D+so+our+allocations+are+reused+next+frame%0A++The+ImDrawList+are+owned+by+ImGuiContext%21%0A++Clear+all+input+and+output.*/
  public final void clear(){clear(this.nativeObjectPtr);}
  private final void setTexID(@NotNull JImTextureID id, long nativeObjectPtr){setTexID(id.nativeObjectPtr, nativeObjectPtr);}
  protected static native void setTexID(long id, long nativeObjectPtr);
  public final void setTexID(@NotNull JImTextureID id){setTexID(id.nativeObjectPtr,this.nativeObjectPtr);}
  /**Basic+Latin%2C+Extended+Latin*/
  protected static native long getGlyphRangesDefault(long nativeObjectPtr);
  /**Basic+Latin%2C+Extended+Latin*/
  public final long getGlyphRangesDefault(){return getGlyphRangesDefault(this.nativeObjectPtr);}
  /**Default+%2B+Korean+characters*/
  protected static native long getGlyphRangesKorean(long nativeObjectPtr);
  /**Default+%2B+Korean+characters*/
  public final long getGlyphRangesKorean(){return getGlyphRangesKorean(this.nativeObjectPtr);}
  /**Default+%2B+Hiragana%2C+Katakana%2C+Half-Width%2C+Selection+of+2999+Ideographs*/
  protected static native long getGlyphRangesJapanese(long nativeObjectPtr);
  /**Default+%2B+Hiragana%2C+Katakana%2C+Half-Width%2C+Selection+of+2999+Ideographs*/
  public final long getGlyphRangesJapanese(){return getGlyphRangesJapanese(this.nativeObjectPtr);}
  /**Default+%2B+Half-Width+%2B+Japanese+Hiragana%7CKatakana+%2B+full+set+of+about+21000+CJK+Unified+Ideographs*/
  protected static native long getGlyphRangesChineseFull(long nativeObjectPtr);
  /**Default+%2B+Half-Width+%2B+Japanese+Hiragana%7CKatakana+%2B+full+set+of+about+21000+CJK+Unified+Ideographs*/
  public final long getGlyphRangesChineseFull(){return getGlyphRangesChineseFull(this.nativeObjectPtr);}
  /**Default+%2B+Half-Width+%2B+Japanese+Hiragana%7CKatakana+%2B+set+of+2500+CJK+Unified+Ideographs+for+common+simplified+Chinese*/
  protected static native long getGlyphRangesChineseSimplifiedCommon(long nativeObjectPtr);
  /**Default+%2B+Half-Width+%2B+Japanese+Hiragana%7CKatakana+%2B+set+of+2500+CJK+Unified+Ideographs+for+common+simplified+Chinese*/
  public final long getGlyphRangesChineseSimplifiedCommon(){return getGlyphRangesChineseSimplifiedCommon(this.nativeObjectPtr);}
  /**Default+%2B+about+400+Cyrillic+characters*/
  protected static native long getGlyphRangesCyrillic(long nativeObjectPtr);
  /**Default+%2B+about+400+Cyrillic+characters*/
  public final long getGlyphRangesCyrillic(){return getGlyphRangesCyrillic(this.nativeObjectPtr);}
  /**Default+%2B+Vietnamese+characters*/
  protected static native long getGlyphRangesVietnamese(long nativeObjectPtr);
  /**Default+%2B+Vietnamese+characters*/
  public final long getGlyphRangesVietnamese(){return getGlyphRangesVietnamese(this.nativeObjectPtr);}
  /**Default+%2B+Thai+characters*/
  protected static native long getGlyphRangesThai(long nativeObjectPtr);
  /**Default+%2B+Thai+characters*/
  public final long getGlyphRangesThai(){return getGlyphRangesThai(this.nativeObjectPtr);}
  private static native void addCustomRectRegular(int width, int height, long nativeObjectPtr);
  public final void addCustomRectRegular(int width, int height){addCustomRectRegular(width, height,this.nativeObjectPtr);}
  protected final void addCustomRectFontGlyph(@NotNull JImFont font, short id, int width, int height, float advanceX, float offsetX, float offsetY, long nativeObjectPtr){addCustomRectFontGlyph(font.nativeObjectPtr, id, width, height, advanceX, offsetX, offsetY, nativeObjectPtr);}
  protected static native void addCustomRectFontGlyph(long font, short id, int width, int height, float advanceX, float offsetX, float offsetY, long nativeObjectPtr);
  public final void addCustomRectFontGlyph(@NotNull JImFont font, short id, int width, int height, float advanceX, float offsetX, float offsetY){addCustomRectFontGlyph(font.nativeObjectPtr, id, width, height, advanceX, offsetX, offsetY,this.nativeObjectPtr);}
  public final void addCustomRectFontGlyph(@NotNull JImFont font, short id, int width, int height, float advanceX){addCustomRectFontGlyph(font.nativeObjectPtr, id, width, height, advanceX,0,0, this.nativeObjectPtr);}

}