package org.ice1000.jimgui;

import org.ice1000.jimgui.*;
import org.ice1000.jimgui.flag.*;
import org.ice1000.jimgui.cpp.*;
import org.intellij.lang.annotations.*;
import org.jetbrains.annotations.*;
import java.nio.charset.StandardCharsets;

import static org.ice1000.jimgui.util.JImGuiUtil.*;

/**
 * @author ice1000
 * @since v0.1
 */
@SuppressWarnings("ALL")

public class JImGuiGen {

  public static final byte@NotNull[] FLOAT_FMT = new byte[]{37, 46, 51, 102, 0};
  public static final byte@NotNull[] DOUBLE_FMT = new byte[]{37, 46, 54, 102, 0};
  public static final byte@NotNull[] INT_FMT = new byte[]{37, 100, 0};
  public static final byte@NotNull[] TIME_FMT = new byte[]{37, 100, 47, 37, 109, 47, 37, 89, 0};
  public static final byte@NotNull[] LEFT_ARROW = new byte[]{60, 0};
  public static final byte@NotNull[] RIGHT_ARROW = new byte[]{62, 0};
  public static final byte@NotNull[] UP_ARROW = new byte[]{32, 32, 32, 94, 32, 32, 32, 0};
  public static final byte@NotNull[] DOWN_ARROW = new byte[]{32, 32, 32, 118, 32, 32, 32, 0};

  public static native void popItemFlag();
  public static native void pushItemFlag(@MagicConstant(flagsFromClass = JImItemFlags.class)int flags, boolean enabled);
  /**new%2C+recommended+style+%28default%29*/
  public final void styleColorsDark(@NotNull JImStyle style){styleColorsDark(style.nativeObjectPtr);}
  protected static native void styleColorsDark(long style);
  /**new%2C+recommended+style+%28default%29*/
  public final void styleColorsDark(){styleColorsDark(0);}
  /**classic+imgui+style*/
  public final void styleColorsClassic(@NotNull JImStyle style){styleColorsClassic(style.nativeObjectPtr);}
  protected static native void styleColorsClassic(long style);
  /**classic+imgui+style*/
  public final void styleColorsClassic(){styleColorsClassic(0);}
  /**best+used+with+borders+and+a+custom%2C+thicker+font*/
  public final void styleColorsLight(@NotNull JImStyle style){styleColorsLight(style.nativeObjectPtr);}
  protected static native void styleColorsLight(long style);
  /**best+used+with+borders+and+a+custom%2C+thicker+font*/
  public final void styleColorsLight(){styleColorsLight(0);}
  public final boolean emptyButton(@NotNull JImVec4 bounds){return emptyButton(bounds.nativeObjectPtr);}
  protected static native boolean emptyButton(long bounds);
  public static native void setDisableHighlight(boolean newValue);
  public static native boolean getDisableHighlight();
  public final void dragVec4(@NotNull String label, @NotNull JImVec4 bounds, float speed, float min, float max, @MagicConstant(flagsFromClass = JImSliderFlags.class)int flags){dragVec4(getBytes(label), bounds.nativeObjectPtr, speed, min, max, flags);}
  public final void dragVec4(@NotNull JImStr label, @NotNull JImVec4 bounds, float speed, float min, float max, @MagicConstant(flagsFromClass = JImSliderFlags.class)int flags){dragVec4(label.bytes, bounds.nativeObjectPtr, speed, min, max, flags);}
  protected static native void dragVec4(byte[] label, long bounds, float speed, float min, float max, @MagicConstant(flagsFromClass = JImSliderFlags.class)int flags);
  public final void dragVec4(@NotNull String label, @NotNull JImVec4 bounds, float speed, float min, float max){dragVec4(getBytes(label), bounds.nativeObjectPtr, speed, min, max,JImSliderFlags.None);}
  public final void dragVec4(@NotNull JImStr label, @NotNull JImVec4 bounds, float speed, float min, float max){dragVec4(label.bytes, bounds.nativeObjectPtr, speed, min, max,JImSliderFlags.None);}
  public final void dragVec4(@NotNull String label, @NotNull JImVec4 bounds, float speed, float min){dragVec4(getBytes(label), bounds.nativeObjectPtr, speed, min,0, JImSliderFlags.None);}
  public final void dragVec4(@NotNull JImStr label, @NotNull JImVec4 bounds, float speed, float min){dragVec4(label.bytes, bounds.nativeObjectPtr, speed, min,0, JImSliderFlags.None);}
  public final void dragVec4(@NotNull String label, @NotNull JImVec4 bounds, float speed){dragVec4(getBytes(label), bounds.nativeObjectPtr, speed,0, 0, JImSliderFlags.None);}
  public final void dragVec4(@NotNull JImStr label, @NotNull JImVec4 bounds, float speed){dragVec4(label.bytes, bounds.nativeObjectPtr, speed,0, 0, JImSliderFlags.None);}
  public final void dragVec4(@NotNull String label, @NotNull JImVec4 bounds){dragVec4(getBytes(label), bounds.nativeObjectPtr,1, 0, 0, JImSliderFlags.None);}
  public final void dragVec4(@NotNull JImStr label, @NotNull JImVec4 bounds){dragVec4(label.bytes, bounds.nativeObjectPtr,1, 0, 0, JImSliderFlags.None);}
  public final void sliderVec4(@NotNull String label, @NotNull JImVec4 bounds, float min, float max, @MagicConstant(flagsFromClass = JImSliderFlags.class)int flags){sliderVec4(getBytes(label), bounds.nativeObjectPtr, min, max, flags);}
  public final void sliderVec4(@NotNull JImStr label, @NotNull JImVec4 bounds, float min, float max, @MagicConstant(flagsFromClass = JImSliderFlags.class)int flags){sliderVec4(label.bytes, bounds.nativeObjectPtr, min, max, flags);}
  protected static native void sliderVec4(byte[] label, long bounds, float min, float max, @MagicConstant(flagsFromClass = JImSliderFlags.class)int flags);
  public final void sliderVec4(@NotNull String label, @NotNull JImVec4 bounds, float min, float max){sliderVec4(getBytes(label), bounds.nativeObjectPtr, min, max,JImSliderFlags.None);}
  public final void sliderVec4(@NotNull JImStr label, @NotNull JImVec4 bounds, float min, float max){sliderVec4(label.bytes, bounds.nativeObjectPtr, min, max,JImSliderFlags.None);}
  public final void sliderVec4(@NotNull String label, @NotNull JImVec4 bounds, float min){sliderVec4(getBytes(label), bounds.nativeObjectPtr, min,100, JImSliderFlags.None);}
  public final void sliderVec4(@NotNull JImStr label, @NotNull JImVec4 bounds, float min){sliderVec4(label.bytes, bounds.nativeObjectPtr, min,100, JImSliderFlags.None);}
  public final void sliderVec4(@NotNull String label, @NotNull JImVec4 bounds){sliderVec4(getBytes(label), bounds.nativeObjectPtr,0, 100, JImSliderFlags.None);}
  public final void sliderVec4(@NotNull JImStr label, @NotNull JImVec4 bounds){sliderVec4(label.bytes, bounds.nativeObjectPtr,0, 100, JImSliderFlags.None);}
  public final void lineTo(float deltaX, float deltaY, @NotNull JImVec4 color, float thickness){lineTo(deltaX, deltaY, color.nativeObjectPtr, thickness);}
  protected static native void lineTo(float deltaX, float deltaY, long color, float thickness);
  public final void lineTo(float deltaX, float deltaY, @NotNull JImVec4 color){lineTo(deltaX, deltaY, color.nativeObjectPtr,1);}
  /**%40param+thickness+if+%3C+0%2C+circle+will+be+filled*/
  public final void circle(float radius, @NotNull JImVec4 color, int numSegments, float thickness){circle(radius, color.nativeObjectPtr, numSegments, thickness);}
  protected static native void circle(float radius, long color, int numSegments, float thickness);
  /**%40param+thickness+if+%3C+0%2C+circle+will+be+filled*/
  public final void circle(float radius, @NotNull JImVec4 color, int numSegments){circle(radius, color.nativeObjectPtr, numSegments,1);}
  /**%40param+thickness+if+%3C+0%2C+circle+will+be+filled*/
  public final void circle(float radius, @NotNull JImVec4 color){circle(radius, color.nativeObjectPtr,12, 1);}
  /**%40param+thickness+if+%3C+0%2C+circle+will+be+filled*/
  public final void rect(float width, float height, @NotNull JImVec4 color, float rounding, float thickness, @MagicConstant(flagsFromClass = JImDrawCornerFlags.class)int roundingCornersFlags){rect(width, height, color.nativeObjectPtr, rounding, thickness, roundingCornersFlags);}
  protected static native void rect(float width, float height, long color, float rounding, float thickness, @MagicConstant(flagsFromClass = JImDrawCornerFlags.class)int roundingCornersFlags);
  /**%40param+thickness+if+%3C+0%2C+circle+will+be+filled*/
  public final void rect(float width, float height, @NotNull JImVec4 color, float rounding, float thickness){rect(width, height, color.nativeObjectPtr, rounding, thickness,JImDrawCornerFlags.All);}
  /**%40param+thickness+if+%3C+0%2C+circle+will+be+filled*/
  public final void rect(float width, float height, @NotNull JImVec4 color, float rounding){rect(width, height, color.nativeObjectPtr, rounding,1, JImDrawCornerFlags.All);}
  /**%40param+thickness+if+%3C+0%2C+circle+will+be+filled*/
  public final void rect(float width, float height, @NotNull JImVec4 color){rect(width, height, color.nativeObjectPtr,0, 1, JImDrawCornerFlags.All);}
  public final void dialogBox(@NotNull String title, @NotNull String text, float widthWindow, float heightWindow, @NotNull NativeBool openPtr, float percentageOnScreen){dialogBox(getBytes(title), getBytes(text), widthWindow, heightWindow, openPtr.nativeObjectPtr, percentageOnScreen);}
  public final void dialogBox(@NotNull JImStr title, @NotNull JImStr text, float widthWindow, float heightWindow, @NotNull NativeBool openPtr, float percentageOnScreen){dialogBox(title.bytes, text.bytes, widthWindow, heightWindow, openPtr.nativeObjectPtr, percentageOnScreen);}
  protected static native void dialogBox(byte[] title, byte[] text, float widthWindow, float heightWindow, long openPtr, float percentageOnScreen);
  public final void dialogBox(@NotNull String title, @NotNull String text, float widthWindow, float heightWindow, @NotNull NativeBool openPtr){dialogBox(getBytes(title), getBytes(text), widthWindow, heightWindow, openPtr.nativeObjectPtr,0.2f);}
  public final void dialogBox(@NotNull JImStr title, @NotNull JImStr text, float widthWindow, float heightWindow, @NotNull NativeBool openPtr){dialogBox(title.bytes, text.bytes, widthWindow, heightWindow, openPtr.nativeObjectPtr,0.2f);}
  public final void bufferingBar(float value, float width, float height, @NotNull JImVec4 backgroundColor, @NotNull JImVec4 foregroundColor){bufferingBar(value, width, height, backgroundColor.nativeObjectPtr, foregroundColor.nativeObjectPtr);}
  protected static native void bufferingBar(float value, float width, float height, long backgroundColor, long foregroundColor);
  public final void spinner(float radius, float thickness, int numSegments, @NotNull JImVec4 color){spinner(radius, thickness, numSegments, color.nativeObjectPtr);}
  protected static native void spinner(float radius, float thickness, int numSegments, long color);
  public final void toggleButton(@NotNull String stringID, @NotNull NativeBool openPtr){toggleButton(getBytes(stringID), openPtr.nativeObjectPtr);}
  public final void toggleButton(@NotNull JImStr stringID, @NotNull NativeBool openPtr){toggleButton(stringID.bytes, openPtr.nativeObjectPtr);}
  protected static native void toggleButton(byte[] stringID, long openPtr);
  public final boolean dateChooser(@NotNull String label, @NotNull NativeTime time, @NotNull String dateFormat, boolean closeWhenMouseLeavesIt, @NotNull NativeBool pSetStartDateToDateOutThisFrame, @NotNull String leftArrow, @NotNull String rightArrow, @NotNull String upArrow, @NotNull String downArrow){return dateChooser(getBytes(label), time.nativeObjectPtr, getBytes(dateFormat), closeWhenMouseLeavesIt, pSetStartDateToDateOutThisFrame.nativeObjectPtr, getBytes(leftArrow), getBytes(rightArrow), getBytes(upArrow), getBytes(downArrow));}
  public final boolean dateChooser(@NotNull JImStr label, @NotNull NativeTime time, @NotNull JImStr dateFormat, boolean closeWhenMouseLeavesIt, @NotNull NativeBool pSetStartDateToDateOutThisFrame, @NotNull JImStr leftArrow, @NotNull JImStr rightArrow, @NotNull JImStr upArrow, @NotNull JImStr downArrow){return dateChooser(label.bytes, time.nativeObjectPtr, dateFormat.bytes, closeWhenMouseLeavesIt, pSetStartDateToDateOutThisFrame.nativeObjectPtr, leftArrow.bytes, rightArrow.bytes, upArrow.bytes, downArrow.bytes);}
  protected static native boolean dateChooser(byte[] label, long time, byte[] dateFormat, boolean closeWhenMouseLeavesIt, long pSetStartDateToDateOutThisFrame, byte[] leftArrow, byte[] rightArrow, byte[] upArrow, byte[] downArrow);
  public final boolean dateChooser(@NotNull String label, @NotNull NativeTime time, @NotNull String dateFormat, boolean closeWhenMouseLeavesIt, @NotNull NativeBool pSetStartDateToDateOutThisFrame, @NotNull String leftArrow, @NotNull String rightArrow, @NotNull String upArrow){return dateChooser(getBytes(label), time.nativeObjectPtr, getBytes(dateFormat), closeWhenMouseLeavesIt, pSetStartDateToDateOutThisFrame.nativeObjectPtr, getBytes(leftArrow), getBytes(rightArrow), getBytes(upArrow),DOWN_ARROW);}
  public final boolean dateChooser(@NotNull JImStr label, @NotNull NativeTime time, @NotNull JImStr dateFormat, boolean closeWhenMouseLeavesIt, @NotNull NativeBool pSetStartDateToDateOutThisFrame, @NotNull JImStr leftArrow, @NotNull JImStr rightArrow, @NotNull JImStr upArrow){return dateChooser(label.bytes, time.nativeObjectPtr, dateFormat.bytes, closeWhenMouseLeavesIt, pSetStartDateToDateOutThisFrame.nativeObjectPtr, leftArrow.bytes, rightArrow.bytes, upArrow.bytes,DOWN_ARROW);}
  public final boolean dateChooser(@NotNull String label, @NotNull NativeTime time, @NotNull String dateFormat, boolean closeWhenMouseLeavesIt, @NotNull NativeBool pSetStartDateToDateOutThisFrame, @NotNull String leftArrow, @NotNull String rightArrow){return dateChooser(getBytes(label), time.nativeObjectPtr, getBytes(dateFormat), closeWhenMouseLeavesIt, pSetStartDateToDateOutThisFrame.nativeObjectPtr, getBytes(leftArrow), getBytes(rightArrow),UP_ARROW, DOWN_ARROW);}
  public final boolean dateChooser(@NotNull JImStr label, @NotNull NativeTime time, @NotNull JImStr dateFormat, boolean closeWhenMouseLeavesIt, @NotNull NativeBool pSetStartDateToDateOutThisFrame, @NotNull JImStr leftArrow, @NotNull JImStr rightArrow){return dateChooser(label.bytes, time.nativeObjectPtr, dateFormat.bytes, closeWhenMouseLeavesIt, pSetStartDateToDateOutThisFrame.nativeObjectPtr, leftArrow.bytes, rightArrow.bytes,UP_ARROW, DOWN_ARROW);}
  public final boolean dateChooser(@NotNull String label, @NotNull NativeTime time, @NotNull String dateFormat, boolean closeWhenMouseLeavesIt, @NotNull NativeBool pSetStartDateToDateOutThisFrame, @NotNull String leftArrow){return dateChooser(getBytes(label), time.nativeObjectPtr, getBytes(dateFormat), closeWhenMouseLeavesIt, pSetStartDateToDateOutThisFrame.nativeObjectPtr, getBytes(leftArrow),RIGHT_ARROW, UP_ARROW, DOWN_ARROW);}
  public final boolean dateChooser(@NotNull JImStr label, @NotNull NativeTime time, @NotNull JImStr dateFormat, boolean closeWhenMouseLeavesIt, @NotNull NativeBool pSetStartDateToDateOutThisFrame, @NotNull JImStr leftArrow){return dateChooser(label.bytes, time.nativeObjectPtr, dateFormat.bytes, closeWhenMouseLeavesIt, pSetStartDateToDateOutThisFrame.nativeObjectPtr, leftArrow.bytes,RIGHT_ARROW, UP_ARROW, DOWN_ARROW);}
  public final boolean dateChooser(@NotNull String label, @NotNull NativeTime time, @NotNull String dateFormat, boolean closeWhenMouseLeavesIt, @NotNull NativeBool pSetStartDateToDateOutThisFrame){return dateChooser(getBytes(label), time.nativeObjectPtr, getBytes(dateFormat), closeWhenMouseLeavesIt, pSetStartDateToDateOutThisFrame.nativeObjectPtr,LEFT_ARROW, RIGHT_ARROW, UP_ARROW, DOWN_ARROW);}
  public final boolean dateChooser(@NotNull JImStr label, @NotNull NativeTime time, @NotNull JImStr dateFormat, boolean closeWhenMouseLeavesIt, @NotNull NativeBool pSetStartDateToDateOutThisFrame){return dateChooser(label.bytes, time.nativeObjectPtr, dateFormat.bytes, closeWhenMouseLeavesIt, pSetStartDateToDateOutThisFrame.nativeObjectPtr,LEFT_ARROW, RIGHT_ARROW, UP_ARROW, DOWN_ARROW);}
  public final boolean dateChooser(@NotNull String label, @NotNull NativeTime time, @NotNull String dateFormat, boolean closeWhenMouseLeavesIt){return dateChooser(getBytes(label), time.nativeObjectPtr, getBytes(dateFormat), closeWhenMouseLeavesIt,0, LEFT_ARROW, RIGHT_ARROW, UP_ARROW, DOWN_ARROW);}
  public final boolean dateChooser(@NotNull JImStr label, @NotNull NativeTime time, @NotNull JImStr dateFormat, boolean closeWhenMouseLeavesIt){return dateChooser(label.bytes, time.nativeObjectPtr, dateFormat.bytes, closeWhenMouseLeavesIt,0, LEFT_ARROW, RIGHT_ARROW, UP_ARROW, DOWN_ARROW);}
  public final boolean dateChooser(@NotNull String label, @NotNull NativeTime time, @NotNull String dateFormat){return dateChooser(getBytes(label), time.nativeObjectPtr, getBytes(dateFormat),true, 0, LEFT_ARROW, RIGHT_ARROW, UP_ARROW, DOWN_ARROW);}
  public final boolean dateChooser(@NotNull JImStr label, @NotNull NativeTime time, @NotNull JImStr dateFormat){return dateChooser(label.bytes, time.nativeObjectPtr, dateFormat.bytes,true, 0, LEFT_ARROW, RIGHT_ARROW, UP_ARROW, DOWN_ARROW);}
  public final boolean dateChooser(@NotNull String label, @NotNull NativeTime time){return dateChooser(getBytes(label), time.nativeObjectPtr,TIME_FMT, true, 0, LEFT_ARROW, RIGHT_ARROW, UP_ARROW, DOWN_ARROW);}
  public final boolean dateChooser(@NotNull JImStr label, @NotNull NativeTime time){return dateChooser(label.bytes, time.nativeObjectPtr,TIME_FMT, true, 0, LEFT_ARROW, RIGHT_ARROW, UP_ARROW, DOWN_ARROW);}
  /**separator%2C+generally+horizontal.+inside+a+menu+bar+or+in+horizontal+layout+mode%2C+this+becomes+a+vertical+separator.*/
  public static native void separator();
  /**call+between+widgets+or+groups+to+layout+them+horizontally.+X+position+given+in+window+coordinates.*/
  public static native void sameLine(float posX, float spacingW);
  /**call+between+widgets+or+groups+to+layout+them+horizontally.+X+position+given+in+window+coordinates.*/
  public final void sameLine(float posX){sameLine(posX,-1);}
  /**call+between+widgets+or+groups+to+layout+them+horizontally.+X+position+given+in+window+coordinates.*/
  public final void sameLine(){sameLine(0, -1);}
  /**undo+a+SameLine%28%29+or+force+a+new+line+when+in+an+horizontal-layout+context.*/
  public static native void newLine();
  /**add+vertical+spacing.*/
  public static native void spacing();
  /**add+a+dummy+item+of+given+size.+unlike+InvisibleButton%28%29%2C+Dummy%28%29+won%27t+take+the+mouse+click+or+be+navigable+into.*/
  public static native void dummy(float width, float height);
  /**move+content+position+toward+the+right%2C+by+indent_w%2C+or+style.IndentSpacing+if+indent_w+%3C%3D+0%0A++Indentation+%7C+start+position+from+left+of+window+%28increased+by+TreePush%7CTreePop%2C+etc.%29*/
  public static native void indent(float indentW);
  /**move+content+position+toward+the+right%2C+by+indent_w%2C+or+style.IndentSpacing+if+indent_w+%3C%3D+0%0A++Indentation+%7C+start+position+from+left+of+window+%28increased+by+TreePush%7CTreePop%2C+etc.%29*/
  public final void indent(){indent(0);}
  /**move+content+position+back+to+the+left%2C+by+indent_w%2C+or+style.IndentSpacing+if+indent_w+%3C%3D+0*/
  public static native void unindent(float indentW);
  /**move+content+position+back+to+the+left%2C+by+indent_w%2C+or+style.IndentSpacing+if+indent_w+%3C%3D+0*/
  public final void unindent(){unindent(0);}
  /**lock+horizontal+starting+position*/
  public static native void beginGroup();
  /**unlock+horizontal+starting+position+%2B+capture+the+whole+group+bounding+box+into+one+%22item%22+%28so+you+can+use+IsItemHovered%28%29+or+layout+primitives+such+as+SameLine%28%29+on+whole+group%2C+etc.%29*/
  public static native void endGroup();
  /**%28some+functions+are+using+window-relative+coordinates%2C+such+as%3A+GetCursorPos%2C+GetCursorStartPos%2C+GetContentRegionMax%2C+GetWindowContentRegion*+etc.*/
  public static native float getCursorPosX();
  /**other+functions+such+as+GetCursorScreenPos+or+everything+in+ImDrawList%3A%3A*/
  public static native float getCursorPosY();
  /**are+using+the+main%2C+absolute+coordinate+system.*/
  public static native void setCursorPos(float posX, float spacingW);
  /**cursor+position+in+absolute+coordinates*/
  public static native void setCursorScreenPos(float screenPosX, float screenPosY);
  /**GetWindowPos%28%29+%2B+GetCursorPos%28%29+%3D%3D+GetCursorScreenPos%28%29+etc.%29*/
  public static native void setCursorPosX(float newValue);
  /***/
  public static native void setCursorPosY(float newValue);
  /**vertically+align+upcoming+text+baseline+to+FramePadding.y+so+that+it+will+align+properly+to+regularly+framed+items+%28call+if+you+have+text+on+a+line+before+a+framed+item%29*/
  public static native void alignTextToFramePadding();
  /**%7E+FontSize*/
  public static native float getTextLineHeight();
  /**%7E+FontSize+%2B+style.ItemSpacing.y+%28distance+in+pixels+between+2+consecutive+lines+of+text%29*/
  public static native float getTextLineHeightWithSpacing();
  /**%7E+FontSize+%2B+style.FramePadding.y+*+2*/
  public static native float getFrameHeight();
  /**%7E+FontSize+%2B+style.FramePadding.y+*+2+%2B+style.ItemSpacing.y+%28distance+in+pixels+between+2+consecutive+lines+of+framed+widgets%29*/
  public static native float getFrameHeightWithSpacing();
  /**add+basic+help%7Cinfo+block+%28not+a+window%29%3A+how+to+manipulate+ImGui+as+a+end-user+%28mouse%7Ckeyboard+controls%29.*/
  public static native void showUserGuide();
  /**create+Demo+window.+demonstrate+most+ImGui+features.+call+this+to+learn+about+the+library%21+try+to+make+it+always+available+in+your+application%21*/
  public final void showDemoWindow(@NotNull NativeBool openPtr){showDemoWindow(openPtr.nativeObjectPtr);}
  protected static native void showDemoWindow(long openPtr);
  /**create+Demo+window.+demonstrate+most+ImGui+features.+call+this+to+learn+about+the+library%21+try+to+make+it+always+available+in+your+application%21*/
  public final void showDemoWindow(){showDemoWindow(0);}
  /**create+About+window.+display+Dear+ImGui+version%2C+credits+and+build%7Csystem+information.*/
  public final void showAboutWindow(@NotNull NativeBool openPtr){showAboutWindow(openPtr.nativeObjectPtr);}
  protected static native void showAboutWindow(long openPtr);
  /**create+About+window.+display+Dear+ImGui+version%2C+credits+and+build%7Csystem+information.*/
  public final void showAboutWindow(){showAboutWindow(0);}
  /**create+Metrics%7CDebugger+window.+display+Dear+ImGui+internals%3A+windows%2C+draw+commands%2C+various+internal+state%2C+etc.*/
  public final void showMetricsWindow(@NotNull NativeBool openPtr){showMetricsWindow(openPtr.nativeObjectPtr);}
  protected static native void showMetricsWindow(long openPtr);
  /**create+Metrics%7CDebugger+window.+display+Dear+ImGui+internals%3A+windows%2C+draw+commands%2C+various+internal+state%2C+etc.*/
  public final void showMetricsWindow(){showMetricsWindow(0);}
  /**add+font+selector+block+%28not+a+window%29%2C+essentially+a+combo+listing+the+loaded+fonts.*/
  public final void showFontSelector(@NotNull String label){showFontSelector(getBytes(label));}
  /**add+font+selector+block+%28not+a+window%29%2C+essentially+a+combo+listing+the+loaded+fonts.*/
  public final void showFontSelector(@NotNull JImStr label){showFontSelector(label.bytes);}
  protected static native void showFontSelector(byte[] label);
  /**add+style+selector+block+%28not+a+window%29%2C+essentially+a+combo+listing+the+default+styles.*/
  public final void showStyleSelector(@NotNull String label){showStyleSelector(getBytes(label));}
  /**add+style+selector+block+%28not+a+window%29%2C+essentially+a+combo+listing+the+default+styles.*/
  public final void showStyleSelector(@NotNull JImStr label){showStyleSelector(label.bytes);}
  protected static native void showStyleSelector(byte[] label);
  /**add+style+editor+block+%28not+a+window%29.+you+can+pass+in+a+reference+ImGuiStyle+structure+to+compare+to%2C+revert+to+and+save+to+%28else+it+uses+the+default+style%29*/
  public final void showStyleEditor(@NotNull JImStyle ref){showStyleEditor(ref.nativeObjectPtr);}
  protected static native void showStyleEditor(long ref);
  /**add+style+editor+block+%28not+a+window%29.+you+can+pass+in+a+reference+ImGuiStyle+structure+to+compare+to%2C+revert+to+and+save+to+%28else+it+uses+the+default+style%29*/
  public final void showStyleEditor(){showStyleEditor(0);}
  public static native boolean isWindowAppearing();
  public static native boolean isWindowCollapsed();
  /**is+current+window+focused%3F+or+its+root%7Cchild%2C+depending+on+flags.+see+flags+for+options.*/
  public static native boolean isWindowFocused(@MagicConstant(flagsFromClass = JImFocusedFlags.class)int flags);
  /**is+current+window+focused%3F+or+its+root%7Cchild%2C+depending+on+flags.+see+flags+for+options.*/
  public final boolean isWindowFocused(){return isWindowFocused(JImFocusedFlags.None);}
  /**is+current+window+hovered+%28and+typically%3A+not+blocked+by+a+popup%7Cmodal%29%3F+see+flags+for+options.+NB%3A+If+you+are+trying+to+check+whether+your+mouse+should+be+dispatched+to+imgui+or+to+your+app%2C+you+should+use+the+%27io.WantCaptureMouse%27+boolean+for+that%21+Please+read+the+FAQ%21*/
  public static native boolean isWindowHovered(@MagicConstant(flagsFromClass = JImHoveredFlags.class)int flags);
  /**is+current+window+hovered+%28and+typically%3A+not+blocked+by+a+popup%7Cmodal%29%3F+see+flags+for+options.+NB%3A+If+you+are+trying+to+check+whether+your+mouse+should+be+dispatched+to+imgui+or+to+your+app%2C+you+should+use+the+%27io.WantCaptureMouse%27+boolean+for+that%21+Please+read+the+FAQ%21*/
  public final boolean isWindowHovered(){return isWindowHovered(JImHoveredFlags.None);}
  /**get+current+window+width+%28shortcut+for+GetWindowSize%28%29.x%29*/
  public static native float getWindowWidth();
  /**get+current+window+height+%28shortcut+for+GetWindowSize%28%29.y%29*/
  public static native float getWindowHeight();
  /***/
  public static native float getWindowContentRegionWidth();
  /**set+next+window+position.+call+before+Begin%28%29.+use+pivot%3D%280.5f%2C0.5f%29+to+center+on+given+point%2C+etc.*/
  public static native void setNextWindowPos(float posX, float posY, @MagicConstant(valuesFromClass = JImCond.class)int condition, float windowPosPivotX, float windowPosPivotY);
  /**set+next+window+position.+call+before+Begin%28%29.+use+pivot%3D%280.5f%2C0.5f%29+to+center+on+given+point%2C+etc.*/
  public final void setNextWindowPos(float posX, float posY, @MagicConstant(valuesFromClass = JImCond.class)int condition){setNextWindowPos(posX, posY, condition,0,0);}
  /**set+next+window+position.+call+before+Begin%28%29.+use+pivot%3D%280.5f%2C0.5f%29+to+center+on+given+point%2C+etc.*/
  public final void setNextWindowPos(float posX, float posY){setNextWindowPos(posX, posY,JImCond.Always, 0,0);}
  /**set+next+window+size.+set+axis+to+0.0f+to+force+an+auto-fit+on+this+axis.+call+before+Begin%28%29*/
  public static native void setNextWindowSize(float width, float height, @MagicConstant(valuesFromClass = JImCond.class)int condition);
  /**set+next+window+size.+set+axis+to+0.0f+to+force+an+auto-fit+on+this+axis.+call+before+Begin%28%29*/
  public final void setNextWindowSize(float width, float height){setNextWindowSize(width, height,JImCond.Always);}
  /**set+next+window+size+limits.+use+-1%2C-1+on+either+X%7CY+axis+to+preserve+the+current+size.+Sizes+will+be+rounded+down.+Use+callback+to+apply+non-trivial+programmatic+constraints.*/
  public static native void setNextWindowSizeConstraints(float widthMin, float heightMin, float widthMax, float heightMax);
  /**set+next+window+content+size+%28%7E+scrollable+client+area%2C+which+enforce+the+range+of+scrollbars%29.+Not+including+window+decorations+%28title+bar%2C+menu+bar%2C+etc.%29+nor+WindowPadding.+set+an+axis+to+0.0f+to+leave+it+automatic.+call+before+Begin%28%29*/
  public static native void setNextWindowContentSize(float width, float height);
  /**set+next+window+collapsed+state.+call+before+Begin%28%29*/
  public static native void setNextWindowCollapsed(boolean collapsed, @MagicConstant(valuesFromClass = JImCond.class)int condition);
  /**set+next+window+collapsed+state.+call+before+Begin%28%29*/
  public final void setNextWindowCollapsed(boolean collapsed){setNextWindowCollapsed(collapsed,JImCond.Always);}
  /**set+next+window+to+be+focused+%7C+top-most.+call+before+Begin%28%29*/
  public static native void setNextWindowFocus();
  /**set+next+window+background+color+alpha.+helper+to+easily+override+the+Alpha+component+of+ImGuiCol_WindowBg%7CChildBg%7CPopupBg.+you+may+also+use+ImGuiWindowFlags_NoBackground.*/
  public static native void setNextWindowBgAlpha(float alpha);
  /**%5BOBSOLETE%5D+set+font+scale.+Adjust+IO.FontGlobalScale+if+you+want+to+scale+all+windows.+This+is+an+old+API%21+For+correct+scaling%2C+prefer+to+reload+font+%2B+rebuild+ImFontAtlas+%2B+call+style.ScaleAllSizes%28%29.*/
  public static native void setWindowFontScale(float scale);
  /**%28not+recommended%29+set+current+window+position+-+call+within+Begin%28%29%7CEnd%28%29.+prefer+using+SetNextWindowPos%28%29%2C+as+this+may+incur+tearing+and+side-effects.%0A++set+named+window+position.*/
  public final void setWindowPos(@NotNull String name, float windowPosX, float windowPosY, @MagicConstant(valuesFromClass = JImCond.class)int condition){setWindowPos(getBytes(name), windowPosX, windowPosY, condition);}
  /**%28not+recommended%29+set+current+window+position+-+call+within+Begin%28%29%7CEnd%28%29.+prefer+using+SetNextWindowPos%28%29%2C+as+this+may+incur+tearing+and+side-effects.%0A++set+named+window+position.*/
  public final void setWindowPos(@NotNull JImStr name, float windowPosX, float windowPosY, @MagicConstant(valuesFromClass = JImCond.class)int condition){setWindowPos(name.bytes, windowPosX, windowPosY, condition);}
  protected static native void setWindowPos(byte[] name, float windowPosX, float windowPosY, @MagicConstant(valuesFromClass = JImCond.class)int condition);
  /**%28not+recommended%29+set+current+window+position+-+call+within+Begin%28%29%7CEnd%28%29.+prefer+using+SetNextWindowPos%28%29%2C+as+this+may+incur+tearing+and+side-effects.%0A++set+named+window+position.*/
  public final void setWindowPos(@NotNull String name, float windowPosX, float windowPosY){setWindowPos(getBytes(name), windowPosX, windowPosY,JImCond.Always);}
  /**%28not+recommended%29+set+current+window+position+-+call+within+Begin%28%29%7CEnd%28%29.+prefer+using+SetNextWindowPos%28%29%2C+as+this+may+incur+tearing+and+side-effects.%0A++set+named+window+position.*/
  public final void setWindowPos(@NotNull JImStr name, float windowPosX, float windowPosY){setWindowPos(name.bytes, windowPosX, windowPosY,JImCond.Always);}
  /**%28not+recommended%29+set+current+window+size+-+call+within+Begin%28%29%7CEnd%28%29.+set+to+ImVec2%280%2C+0%29+to+force+an+auto-fit.+prefer+using+SetNextWindowSize%28%29%2C+as+this+may+incur+tearing+and+minor+side-effects.%0A++set+named+window+size.+set+axis+to+0.0f+to+force+an+auto-fit+on+this+axis.*/
  public final void setWindowSize(@NotNull String name, float width, float height, @MagicConstant(valuesFromClass = JImCond.class)int condition){setWindowSize(getBytes(name), width, height, condition);}
  /**%28not+recommended%29+set+current+window+size+-+call+within+Begin%28%29%7CEnd%28%29.+set+to+ImVec2%280%2C+0%29+to+force+an+auto-fit.+prefer+using+SetNextWindowSize%28%29%2C+as+this+may+incur+tearing+and+minor+side-effects.%0A++set+named+window+size.+set+axis+to+0.0f+to+force+an+auto-fit+on+this+axis.*/
  public final void setWindowSize(@NotNull JImStr name, float width, float height, @MagicConstant(valuesFromClass = JImCond.class)int condition){setWindowSize(name.bytes, width, height, condition);}
  protected static native void setWindowSize(byte[] name, float width, float height, @MagicConstant(valuesFromClass = JImCond.class)int condition);
  /**%28not+recommended%29+set+current+window+size+-+call+within+Begin%28%29%7CEnd%28%29.+set+to+ImVec2%280%2C+0%29+to+force+an+auto-fit.+prefer+using+SetNextWindowSize%28%29%2C+as+this+may+incur+tearing+and+minor+side-effects.%0A++set+named+window+size.+set+axis+to+0.0f+to+force+an+auto-fit+on+this+axis.*/
  public final void setWindowSize(@NotNull String name, float width, float height){setWindowSize(getBytes(name), width, height,JImCond.Always);}
  /**%28not+recommended%29+set+current+window+size+-+call+within+Begin%28%29%7CEnd%28%29.+set+to+ImVec2%280%2C+0%29+to+force+an+auto-fit.+prefer+using+SetNextWindowSize%28%29%2C+as+this+may+incur+tearing+and+minor+side-effects.%0A++set+named+window+size.+set+axis+to+0.0f+to+force+an+auto-fit+on+this+axis.*/
  public final void setWindowSize(@NotNull JImStr name, float width, float height){setWindowSize(name.bytes, width, height,JImCond.Always);}
  /**%28not+recommended%29+set+current+window+collapsed+state.+prefer+using+SetNextWindowCollapsed%28%29.%0A++set+named+window+collapsed+state*/
  public final void setWindowCollapsed(@NotNull String name, boolean collapsed, @MagicConstant(valuesFromClass = JImCond.class)int condition){setWindowCollapsed(getBytes(name), collapsed, condition);}
  /**%28not+recommended%29+set+current+window+collapsed+state.+prefer+using+SetNextWindowCollapsed%28%29.%0A++set+named+window+collapsed+state*/
  public final void setWindowCollapsed(@NotNull JImStr name, boolean collapsed, @MagicConstant(valuesFromClass = JImCond.class)int condition){setWindowCollapsed(name.bytes, collapsed, condition);}
  protected static native void setWindowCollapsed(byte[] name, boolean collapsed, @MagicConstant(valuesFromClass = JImCond.class)int condition);
  /**%28not+recommended%29+set+current+window+collapsed+state.+prefer+using+SetNextWindowCollapsed%28%29.%0A++set+named+window+collapsed+state*/
  public final void setWindowCollapsed(@NotNull String name, boolean collapsed){setWindowCollapsed(getBytes(name), collapsed,JImCond.Always);}
  /**%28not+recommended%29+set+current+window+collapsed+state.+prefer+using+SetNextWindowCollapsed%28%29.%0A++set+named+window+collapsed+state*/
  public final void setWindowCollapsed(@NotNull JImStr name, boolean collapsed){setWindowCollapsed(name.bytes, collapsed,JImCond.Always);}
  /**%28not+recommended%29+set+current+window+to+be+focused+%7C+top-most.+prefer+using+SetNextWindowFocus%28%29.%0A++set+named+window+to+be+focused+%7C+top-most.+use+NULL+to+remove+focus.*/
  public final void setWindowFocus(@NotNull String name){setWindowFocus(getBytes(name));}
  /**%28not+recommended%29+set+current+window+to+be+focused+%7C+top-most.+prefer+using+SetNextWindowFocus%28%29.%0A++set+named+window+to+be+focused+%7C+top-most.+use+NULL+to+remove+focus.*/
  public final void setWindowFocus(@NotNull JImStr name){setWindowFocus(name.bytes);}
  protected static native void setWindowFocus(byte[] name);
  /**map+ImGuiKey_*+values+into+user%27s+key+index.+%3D%3D+io.KeyMap%5Bkey%5D*/
  public static native int getKeyIndex(int imguiKey);
  /**is+key+being+held.+%3D%3D+io.KeysDown%5Buser_key_index%5D.*/
  public static native boolean isKeyDown(int userKeyIndex);
  /**was+key+pressed+%28went+from+%21Down+to+Down%29%3F+if+repeat%3Dtrue%2C+uses+io.KeyRepeatDelay+%7C+KeyRepeatRate*/
  public static native boolean isKeyPressed(int userKeyIndex, boolean repeat);
  /**was+key+pressed+%28went+from+%21Down+to+Down%29%3F+if+repeat%3Dtrue%2C+uses+io.KeyRepeatDelay+%7C+KeyRepeatRate*/
  public final boolean isKeyPressed(int userKeyIndex){return isKeyPressed(userKeyIndex,true);}
  /**was+key+released+%28went+from+Down+to+%21Down%29%3F*/
  public static native boolean isKeyReleased(int userKeyIndex);
  /**uses+provided+repeat+rate%7Cdelay.+return+a+count%2C+most+often+0+or+1+but+might+be+%3E1+if+RepeatRate+is+small+enough+that+DeltaTime+%3E+RepeatRate*/
  public static native int getKeyPressedAmount(int keyIndex, float repeatDelay, float rate);
  /**is+mouse+button+held%3F*/
  public static native boolean isMouseDown(@MagicConstant(valuesFromClass = JImMouseButton.class)int button);
  /**is+mouse+button+held%3F*/
  public final boolean isMouseDown(){return isMouseDown(JImMouseButton.Left);}
  /**is+any+mouse+button+held%3F*/
  public static native boolean isAnyMouseDown();
  /**did+mouse+button+clicked%3F+%28went+from+%21Down+to+Down%29*/
  public static native boolean isMouseClicked(@MagicConstant(valuesFromClass = JImMouseButton.class)int button, boolean repeat);
  /**did+mouse+button+clicked%3F+%28went+from+%21Down+to+Down%29*/
  public final boolean isMouseClicked(@MagicConstant(valuesFromClass = JImMouseButton.class)int button){return isMouseClicked(button,false);}
  /**did+mouse+button+clicked%3F+%28went+from+%21Down+to+Down%29*/
  public final boolean isMouseClicked(){return isMouseClicked(JImMouseButton.Left, false);}
  /**did+mouse+button+double-clicked%3F+%28note+that+a+double-click+will+also+report+IsMouseClicked%28%29+%3D%3D+true%29*/
  public static native boolean isMouseDoubleClicked(@MagicConstant(valuesFromClass = JImMouseButton.class)int button);
  /**did+mouse+button+double-clicked%3F+%28note+that+a+double-click+will+also+report+IsMouseClicked%28%29+%3D%3D+true%29*/
  public final boolean isMouseDoubleClicked(){return isMouseDoubleClicked(JImMouseButton.Left);}
  /**did+mouse+button+released%3F+%28went+from+Down+to+%21Down%29*/
  public static native boolean isMouseReleased(@MagicConstant(valuesFromClass = JImMouseButton.class)int button);
  /**did+mouse+button+released%3F+%28went+from+Down+to+%21Down%29*/
  public final boolean isMouseReleased(){return isMouseReleased(JImMouseButton.Left);}
  /**is+mouse+dragging%3F+%28if+lock_threshold+%3C+-1.0f%2C+uses+io.MouseDraggingThreshold%29*/
  public static native boolean isMouseDragging(@MagicConstant(valuesFromClass = JImMouseButton.class)int button, float lockThreshold);
  /**is+mouse+dragging%3F+%28if+lock_threshold+%3C+-1.0f%2C+uses+io.MouseDraggingThreshold%29*/
  public final boolean isMouseDragging(@MagicConstant(valuesFromClass = JImMouseButton.class)int button){return isMouseDragging(button,-1);}
  /**is+mouse+dragging%3F+%28if+lock_threshold+%3C+-1.0f%2C+uses+io.MouseDraggingThreshold%29*/
  public final boolean isMouseDragging(){return isMouseDragging(JImMouseButton.Left, -1);}
  /**is+mouse+hovering+given+bounding+rect+%28in+screen+space%29.+clipped+by+current+clipping+settings%2C+but+disregarding+of+other+consideration+of+focus%7Cwindow+ordering%7Cpopup-block.*/
  public static native boolean isMouseHoveringRect(float widthRMin, float heightRMin, float widthRMax, float heightRMax, boolean clip);
  /**is+mouse+hovering+given+bounding+rect+%28in+screen+space%29.+clipped+by+current+clipping+settings%2C+but+disregarding+of+other+consideration+of+focus%7Cwindow+ordering%7Cpopup-block.*/
  public final boolean isMouseHoveringRect(float widthRMin, float heightRMin, float widthRMax, float heightRMax){return isMouseHoveringRect(widthRMin, heightRMin, widthRMax, heightRMax,true);}
  /**by+convention+we+use+%28-FLT_MAX%2C-FLT_MAX%29+to+denote+that+there+is+no+mouse+available*/
  public static native boolean isMousePosValid();
  /**attention%3A+misleading+name%21+manually+override+io.WantCaptureKeyboard+flag+next+frame+%28said+flag+is+entirely+left+for+your+application+to+handle%29.+e.g.+force+capture+keyboard+when+your+widget+is+being+hovered.+This+is+equivalent+to+setting+%22io.WantCaptureKeyboard+%3D+want_capture_keyboard_value%22%3B+after+the+next+NewFrame%28%29+call.*/
  public static native void captureKeyboardFromApp(boolean capture);
  /**attention%3A+misleading+name%21+manually+override+io.WantCaptureKeyboard+flag+next+frame+%28said+flag+is+entirely+left+for+your+application+to+handle%29.+e.g.+force+capture+keyboard+when+your+widget+is+being+hovered.+This+is+equivalent+to+setting+%22io.WantCaptureKeyboard+%3D+want_capture_keyboard_value%22%3B+after+the+next+NewFrame%28%29+call.*/
  public final void captureKeyboardFromApp(){captureKeyboardFromApp(true);}
  /**attention%3A+misleading+name%21+manually+override+io.WantCaptureMouse+flag+next+frame+%28said+flag+is+entirely+left+for+your+application+to+handle%29.+This+is+equivalent+to+setting+%22io.WantCaptureMouse+%3D+want_capture_mouse_value%3B%22+after+the+next+NewFrame%28%29+call.*/
  public static native void captureMouseFromApp(boolean capture);
  /**attention%3A+misleading+name%21+manually+override+io.WantCaptureMouse+flag+next+frame+%28said+flag+is+entirely+left+for+your+application+to+handle%29.+This+is+equivalent+to+setting+%22io.WantCaptureMouse+%3D+want_capture_mouse_value%3B%22+after+the+next+NewFrame%28%29+call.*/
  public final void captureMouseFromApp(){captureMouseFromApp(true);}
  public final void setClipboardText(@NotNull String text){setClipboardText(getBytes(text));}
  public final void setClipboardText(@NotNull JImStr text){setClipboardText(text.bytes);}
  protected static native void setClipboardText(byte[] text);
  /**pop+from+the+ID+stack.*/
  public static native void popID();
  /**push+string+into+the+ID+stack+%28will+hash+string%29.%0A++push+string+into+the+ID+stack+%28will+hash+string%29.%0A++push+pointer+into+the+ID+stack+%28will+hash+pointer%29.%0A++push+integer+into+the+ID+stack+%28will+hash+integer%29.*/
  public final void pushID(@NotNull String stringID){pushID(stringID.getBytes(StandardCharsets.UTF_8));}
  protected static native void pushID(byte[] stringID);
  /**calculate+unique+ID+%28hash+of+whole+ID+stack+%2B+given+parameter%29.+e.g.+if+you+want+to+query+into+ImGuiStorage+yourself*/
  public final int getID(@NotNull String stringID){return getID(stringID.getBytes(StandardCharsets.UTF_8));}
  protected static native int getID(byte[] stringID);
  /**Automatically+called+by+constructor+if+you+passed+%27items_count%27+or+by+Step%28%29+in+Step+1.*/
  public final boolean begin(@NotNull String name, @NotNull NativeBool openPtr, @MagicConstant(flagsFromClass = JImWindowFlags.class)int flags){return begin(getBytes(name), openPtr.nativeObjectPtr, flags);}
  /**Automatically+called+by+constructor+if+you+passed+%27items_count%27+or+by+Step%28%29+in+Step+1.*/
  public final boolean begin(@NotNull JImStr name, @NotNull NativeBool openPtr, @MagicConstant(flagsFromClass = JImWindowFlags.class)int flags){return begin(name.bytes, openPtr.nativeObjectPtr, flags);}
  protected static native boolean begin(byte[] name, long openPtr, @MagicConstant(flagsFromClass = JImWindowFlags.class)int flags);
  /**Automatically+called+by+constructor+if+you+passed+%27items_count%27+or+by+Step%28%29+in+Step+1.*/
  public final boolean begin(@NotNull String name, @NotNull NativeBool openPtr){return begin(getBytes(name), openPtr.nativeObjectPtr,JImWindowFlags.None);}
  /**Automatically+called+by+constructor+if+you+passed+%27items_count%27+or+by+Step%28%29+in+Step+1.*/
  public final boolean begin(@NotNull JImStr name, @NotNull NativeBool openPtr){return begin(name.bytes, openPtr.nativeObjectPtr,JImWindowFlags.None);}
  /**Automatically+called+by+constructor+if+you+passed+%27items_count%27+or+by+Step%28%29+in+Step+1.*/
  public final boolean begin(@NotNull String name){return begin(getBytes(name),0, JImWindowFlags.None);}
  /**Automatically+called+by+constructor+if+you+passed+%27items_count%27+or+by+Step%28%29+in+Step+1.*/
  public final boolean begin(@NotNull JImStr name){return begin(name.bytes,0, JImWindowFlags.None);}
  /**Automatically+called+on+the+last+call+of+Step%28%29+that+returns+false.*/
  public static native void end();
  public static native boolean beginChild(int id, float width, float height, boolean border, @MagicConstant(flagsFromClass = JImWindowFlags.class)int flags);
  public final boolean beginChild(int id, float width, float height, boolean border){return beginChild(id, width, height, border,JImWindowFlags.None);}
  public final boolean beginChild(int id, float width, float height){return beginChild(id, width, height,false, JImWindowFlags.None);}
  public final boolean beginChild(int id){return beginChild(id,0,0, false, JImWindowFlags.None);}
  public final boolean beginChild0(@NotNull String stringID, float width, float height, boolean border, @MagicConstant(flagsFromClass = JImWindowFlags.class)int flags){return beginChild0(getBytes(stringID), width, height, border, flags);}
  public final boolean beginChild0(@NotNull JImStr stringID, float width, float height, boolean border, @MagicConstant(flagsFromClass = JImWindowFlags.class)int flags){return beginChild0(stringID.bytes, width, height, border, flags);}
  protected static native boolean beginChild0(byte[] stringID, float width, float height, boolean border, @MagicConstant(flagsFromClass = JImWindowFlags.class)int flags);
  public final boolean beginChild0(@NotNull String stringID, float width, float height, boolean border){return beginChild0(getBytes(stringID), width, height, border,JImWindowFlags.None);}
  public final boolean beginChild0(@NotNull JImStr stringID, float width, float height, boolean border){return beginChild0(stringID.bytes, width, height, border,JImWindowFlags.None);}
  public final boolean beginChild0(@NotNull String stringID, float width, float height){return beginChild0(getBytes(stringID), width, height,false, JImWindowFlags.None);}
  public final boolean beginChild0(@NotNull JImStr stringID, float width, float height){return beginChild0(stringID.bytes, width, height,false, JImWindowFlags.None);}
  public final boolean beginChild0(@NotNull String stringID){return beginChild0(getBytes(stringID),0,0, false, JImWindowFlags.None);}
  public final boolean beginChild0(@NotNull JImStr stringID){return beginChild0(stringID.bytes,0,0, false, JImWindowFlags.None);}
  public static native void endChild();
  /**shortcut+for+Bullet%28%29%2BText%28%29*/
  public final void bulletText(@NotNull String text){bulletText(getBytes(text));}
  /**shortcut+for+Bullet%28%29%2BText%28%29*/
  public final void bulletText(@NotNull JImStr text){bulletText(text.bytes);}
  protected static native void bulletText(byte[] text);
  /**display+text%2Blabel+aligned+the+same+way+as+value%2Blabel+widgets*/
  public final void labelText(@NotNull String label, @NotNull String text){labelText(getBytes(label), getBytes(text));}
  /**display+text%2Blabel+aligned+the+same+way+as+value%2Blabel+widgets*/
  public final void labelText(@NotNull JImStr label, @NotNull JImStr text){labelText(label.bytes, text.bytes);}
  protected static native void labelText(byte[] label, byte[] text);
  /**shortcut+for+PushTextWrapPos%280.0f%29%3B+Text%28fmt%2C+...%29%3B+PopTextWrapPos%28%29%3B.+Note+that+this+won%27t+work+on+an+auto-resizing+window+if+there%27s+no+other+widgets+to+extend+the+window+width%2C+yoy+may+need+to+set+a+size+using+SetNextWindowSize%28%29.*/
  public final void textWrapped(@NotNull String text){textWrapped(getBytes(text));}
  /**shortcut+for+PushTextWrapPos%280.0f%29%3B+Text%28fmt%2C+...%29%3B+PopTextWrapPos%28%29%3B.+Note+that+this+won%27t+work+on+an+auto-resizing+window+if+there%27s+no+other+widgets+to+extend+the+window+width%2C+yoy+may+need+to+set+a+size+using+SetNextWindowSize%28%29.*/
  public final void textWrapped(@NotNull JImStr text){textWrapped(text.bytes);}
  protected static native void textWrapped(byte[] text);
  /**raw+text+without+formatting.+Roughly+equivalent+to+Text%28%22%25s%22%2C+text%29+but%3A+A%29+doesn%27t+require+null+terminated+string+if+%27text_end%27+is+specified%2C+B%29+it%27s+faster%2C+no+memory+copy+is+done%2C+no+buffer+size+limits%2C+recommended+for+long+chunks+of+text.*/
  public final void textUnformatted(@NotNull String text){textUnformatted(text.getBytes(StandardCharsets.UTF_8));}
  protected static native void textUnformatted(byte[] text);
  /**shortcut+for+PushStyleColor%28ImGuiCol_Text%2C+style.Colors%5BImGuiCol_TextDisabled%5D%29%3B+Text%28fmt%2C+...%29%3B+PopStyleColor%28%29%3B*/
  public final void textDisabled(@NotNull String text){textDisabled(getBytes(text));}
  /**shortcut+for+PushStyleColor%28ImGuiCol_Text%2C+style.Colors%5BImGuiCol_TextDisabled%5D%29%3B+Text%28fmt%2C+...%29%3B+PopStyleColor%28%29%3B*/
  public final void textDisabled(@NotNull JImStr text){textDisabled(text.bytes);}
  protected static native void textDisabled(byte[] text);
  /**shortcut+for+PushStyleColor%28ImGuiCol_Text%2C+col%29%3B+Text%28fmt%2C+...%29%3B+PopStyleColor%28%29%3B*/
  public final void textColored(@NotNull JImVec4 color, @NotNull String text){textColored(color.nativeObjectPtr, getBytes(text));}
  /**shortcut+for+PushStyleColor%28ImGuiCol_Text%2C+col%29%3B+Text%28fmt%2C+...%29%3B+PopStyleColor%28%29%3B*/
  public final void textColored(@NotNull JImVec4 color, @NotNull JImStr text){textColored(color.nativeObjectPtr, text.bytes);}
  protected static native void textColored(long color, byte[] text);
  /**formatted+text*/
  public final void text(@NotNull String text){text(getBytes(text));}
  /**formatted+text*/
  public final void text(@NotNull JImStr text){text(text.bytes);}
  protected static native void text(byte[] text);
  /**button*/
  public final boolean button(@NotNull String text, float width, float height){return button(getBytes(text), width, height);}
  /**button*/
  public final boolean button(@NotNull JImStr text, float width, float height){return button(text.bytes, width, height);}
  protected static native boolean button(byte[] text, float width, float height);
  /**button*/
  public final boolean button(@NotNull String text){return button(getBytes(text),0,0);}
  /**button*/
  public final boolean button(@NotNull JImStr text){return button(text.bytes,0,0);}
  /**button+with+FramePadding%3D%280%2C0%29+to+easily+embed+within+text*/
  public final boolean smallButton(@NotNull String text){return smallButton(getBytes(text));}
  /**button+with+FramePadding%3D%280%2C0%29+to+easily+embed+within+text*/
  public final boolean smallButton(@NotNull JImStr text){return smallButton(text.bytes);}
  protected static native boolean smallButton(byte[] text);
  /**flexible+button+behavior+without+the+visuals%2C+frequently+useful+to+build+custom+behaviors+using+the+public+api+%28along+with+IsItemActive%2C+IsItemHovered%2C+etc.%29*/
  public final boolean invisibleButton(@NotNull String text, float width, float height, @MagicConstant(flagsFromClass = JImButtonFlags.class)int flags){return invisibleButton(getBytes(text), width, height, flags);}
  /**flexible+button+behavior+without+the+visuals%2C+frequently+useful+to+build+custom+behaviors+using+the+public+api+%28along+with+IsItemActive%2C+IsItemHovered%2C+etc.%29*/
  public final boolean invisibleButton(@NotNull JImStr text, float width, float height, @MagicConstant(flagsFromClass = JImButtonFlags.class)int flags){return invisibleButton(text.bytes, width, height, flags);}
  protected static native boolean invisibleButton(byte[] text, float width, float height, @MagicConstant(flagsFromClass = JImButtonFlags.class)int flags);
  /**flexible+button+behavior+without+the+visuals%2C+frequently+useful+to+build+custom+behaviors+using+the+public+api+%28along+with+IsItemActive%2C+IsItemHovered%2C+etc.%29*/
  public final boolean invisibleButton(@NotNull String text, float width, float height){return invisibleButton(getBytes(text), width, height,JImButtonFlags.None);}
  /**flexible+button+behavior+without+the+visuals%2C+frequently+useful+to+build+custom+behaviors+using+the+public+api+%28along+with+IsItemActive%2C+IsItemHovered%2C+etc.%29*/
  public final boolean invisibleButton(@NotNull JImStr text, float width, float height){return invisibleButton(text.bytes, width, height,JImButtonFlags.None);}
  /**flexible+button+behavior+without+the+visuals%2C+frequently+useful+to+build+custom+behaviors+using+the+public+api+%28along+with+IsItemActive%2C+IsItemHovered%2C+etc.%29*/
  public final boolean invisibleButton(@NotNull String text){return invisibleButton(getBytes(text),0,0, JImButtonFlags.None);}
  /**flexible+button+behavior+without+the+visuals%2C+frequently+useful+to+build+custom+behaviors+using+the+public+api+%28along+with+IsItemActive%2C+IsItemHovered%2C+etc.%29*/
  public final boolean invisibleButton(@NotNull JImStr text){return invisibleButton(text.bytes,0,0, JImButtonFlags.None);}
  /**square+button+with+an+arrow+shape*/
  public final boolean arrowButton(@NotNull String text, @MagicConstant(valuesFromClass = JImDirection.class)int direction){return arrowButton(getBytes(text), direction);}
  /**square+button+with+an+arrow+shape*/
  public final boolean arrowButton(@NotNull JImStr text, @MagicConstant(valuesFromClass = JImDirection.class)int direction){return arrowButton(text.bytes, direction);}
  protected static native boolean arrowButton(byte[] text, @MagicConstant(valuesFromClass = JImDirection.class)int direction);
  public final void image(@NotNull JImTextureID userTextureID, float width, float height, float uv0X, float uv0Y, float uv1X, float uv1Y){image(userTextureID.nativeObjectPtr, width, height, uv0X, uv0Y, uv1X, uv1Y);}
  protected static native void image(long userTextureID, float width, float height, float uv0X, float uv0Y, float uv1X, float uv1Y);
  public final void image(@NotNull JImTextureID userTextureID, float width, float height, float uv0X, float uv0Y){image(userTextureID.nativeObjectPtr, width, height, uv0X, uv0Y,1,1);}
  public final void image(@NotNull JImTextureID userTextureID, float width, float height){image(userTextureID.nativeObjectPtr, width, height,0,0, 1,1);}
  /**%3C0+frame_padding+uses+default+frame+padding+settings.+0+for+no+padding*/
  public final boolean imageButton(@NotNull JImTextureID userTextureID, float width, float height, float uv0X, float uv0Y, float uv1X, float uv1Y, int framePadding){return imageButton(userTextureID.nativeObjectPtr, width, height, uv0X, uv0Y, uv1X, uv1Y, framePadding);}
  protected static native boolean imageButton(long userTextureID, float width, float height, float uv0X, float uv0Y, float uv1X, float uv1Y, int framePadding);
  /**%3C0+frame_padding+uses+default+frame+padding+settings.+0+for+no+padding*/
  public final boolean imageButton(@NotNull JImTextureID userTextureID, float width, float height, float uv0X, float uv0Y, float uv1X, float uv1Y){return imageButton(userTextureID.nativeObjectPtr, width, height, uv0X, uv0Y, uv1X, uv1Y,-1);}
  /**%3C0+frame_padding+uses+default+frame+padding+settings.+0+for+no+padding*/
  public final boolean imageButton(@NotNull JImTextureID userTextureID, float width, float height, float uv0X, float uv0Y){return imageButton(userTextureID.nativeObjectPtr, width, height, uv0X, uv0Y,1,1, -1);}
  /**%3C0+frame_padding+uses+default+frame+padding+settings.+0+for+no+padding*/
  public final boolean imageButton(@NotNull JImTextureID userTextureID, float width, float height){return imageButton(userTextureID.nativeObjectPtr, width, height,0,0, 1,1, -1);}
  public final boolean checkbox(@NotNull String label, @NotNull NativeBool v){return checkbox(getBytes(label), v.nativeObjectPtr);}
  public final boolean checkbox(@NotNull JImStr label, @NotNull NativeBool v){return checkbox(label.bytes, v.nativeObjectPtr);}
  protected static native boolean checkbox(byte[] label, long v);
  /**use+with+e.g.+if+%28RadioButton%28%22one%22%2C+my_value%3D%3D1%29%29+%7B+my_value+%3D+1%3B+%7D%0A++shortcut+to+handle+the+above+pattern+when+value+is+an+integer*/
  public final boolean radioButton(@NotNull String text, @NotNull NativeInt v, int v_button){return radioButton(getBytes(text), v.nativeObjectPtr, v_button);}
  /**use+with+e.g.+if+%28RadioButton%28%22one%22%2C+my_value%3D%3D1%29%29+%7B+my_value+%3D+1%3B+%7D%0A++shortcut+to+handle+the+above+pattern+when+value+is+an+integer*/
  public final boolean radioButton(@NotNull JImStr text, @NotNull NativeInt v, int v_button){return radioButton(text.bytes, v.nativeObjectPtr, v_button);}
  protected static native boolean radioButton(byte[] text, long v, int v_button);
  public final boolean radioButton0(@NotNull String text, boolean active){return radioButton0(getBytes(text), active);}
  public final boolean radioButton0(@NotNull JImStr text, boolean active){return radioButton0(text.bytes, active);}
  protected static native boolean radioButton0(byte[] text, boolean active);
  /**draw+a+small+circle+%2B+keep+the+cursor+on+the+same+line.+advance+cursor+x+position+by+GetTreeNodeToLabelSpacing%28%29%2C+same+distance+that+TreeNode%28%29+uses*/
  public static native void bullet();
  public final void progressBar(float fraction, float width, float height, @Nullable String overlay){progressBar(fraction, width, height, getBytes(overlay));}
  protected static native void progressBar(float fraction, float width, float height, byte[] overlay);
  public final void progressBar(float fraction, float width, float height){progressBar(fraction, width, height,(byte[]) null);}
  public final void progressBar(float fraction){progressBar(fraction,-1,0, (byte[]) null);}
  public final boolean beginCombo(@NotNull String label, @NotNull String previewValue, @MagicConstant(flagsFromClass = JImComboFlags.class)int flags){return beginCombo(getBytes(label), getBytes(previewValue), flags);}
  public final boolean beginCombo(@NotNull JImStr label, @NotNull JImStr previewValue, @MagicConstant(flagsFromClass = JImComboFlags.class)int flags){return beginCombo(label.bytes, previewValue.bytes, flags);}
  protected static native boolean beginCombo(byte[] label, byte[] previewValue, @MagicConstant(flagsFromClass = JImComboFlags.class)int flags);
  public final boolean beginCombo(@NotNull String label, @NotNull String previewValue){return beginCombo(getBytes(label), getBytes(previewValue),JImComboFlags.PopupAlignLeft);}
  public final boolean beginCombo(@NotNull JImStr label, @NotNull JImStr previewValue){return beginCombo(label.bytes, previewValue.bytes,JImComboFlags.PopupAlignLeft);}
  /**only+call+EndCombo%28%29+if+BeginCombo%28%29+returns+true%21*/
  public static native void endCombo();
  /**Separate+items+with+%5C0+within+a+string%2C+end+item-list+with+%5C0%5C0.+e.g.+%22One%5C0Two%5C0Three%5C0%22*/
  public final void combo(@NotNull String label, @NotNull NativeInt currentItem, @NotNull String itemsSeparatedByZeros, int popupMaxHeightInItems){combo(getBytes(label), currentItem.nativeObjectPtr, getBytes(itemsSeparatedByZeros), popupMaxHeightInItems);}
  /**Separate+items+with+%5C0+within+a+string%2C+end+item-list+with+%5C0%5C0.+e.g.+%22One%5C0Two%5C0Three%5C0%22*/
  public final void combo(@NotNull JImStr label, @NotNull NativeInt currentItem, @NotNull JImStr itemsSeparatedByZeros, int popupMaxHeightInItems){combo(label.bytes, currentItem.nativeObjectPtr, itemsSeparatedByZeros.bytes, popupMaxHeightInItems);}
  protected static native void combo(byte[] label, long currentItem, byte[] itemsSeparatedByZeros, int popupMaxHeightInItems);
  /**Separate+items+with+%5C0+within+a+string%2C+end+item-list+with+%5C0%5C0.+e.g.+%22One%5C0Two%5C0Three%5C0%22*/
  public final void combo(@NotNull String label, @NotNull NativeInt currentItem, @NotNull String itemsSeparatedByZeros){combo(getBytes(label), currentItem.nativeObjectPtr, getBytes(itemsSeparatedByZeros),-1);}
  /**Separate+items+with+%5C0+within+a+string%2C+end+item-list+with+%5C0%5C0.+e.g.+%22One%5C0Two%5C0Three%5C0%22*/
  public final void combo(@NotNull JImStr label, @NotNull NativeInt currentItem, @NotNull JImStr itemsSeparatedByZeros){combo(label.bytes, currentItem.nativeObjectPtr, itemsSeparatedByZeros.bytes,-1);}
  /**open+a+framed+scrolling+region*/
  public final boolean beginListBox(@NotNull String label, float width, float height){return beginListBox(getBytes(label), width, height);}
  /**open+a+framed+scrolling+region*/
  public final boolean beginListBox(@NotNull JImStr label, float width, float height){return beginListBox(label.bytes, width, height);}
  protected static native boolean beginListBox(byte[] label, float width, float height);
  /**only+call+EndListBox%28%29+if+BeginListBox%28%29+returned+true%21*/
  public static native void endListBox();
  /**If+v_min+%3E%3D+v_max+we+have+no+bound*/
  public final boolean dragFloat(@NotNull String label, @NotNull NativeFloat value, float valueSpeed, float valueMin, float valueMax, @NotNull String format, @MagicConstant(flagsFromClass = JImSliderFlags.class)int flags){return dragFloat(getBytes(label), value.nativeObjectPtr, valueSpeed, valueMin, valueMax, getBytes(format), flags);}
  /**If+v_min+%3E%3D+v_max+we+have+no+bound*/
  public final boolean dragFloat(@NotNull JImStr label, @NotNull NativeFloat value, float valueSpeed, float valueMin, float valueMax, @NotNull JImStr format, @MagicConstant(flagsFromClass = JImSliderFlags.class)int flags){return dragFloat(label.bytes, value.nativeObjectPtr, valueSpeed, valueMin, valueMax, format.bytes, flags);}
  protected static native boolean dragFloat(byte[] label, long value, float valueSpeed, float valueMin, float valueMax, byte[] format, @MagicConstant(flagsFromClass = JImSliderFlags.class)int flags);
  /**If+v_min+%3E%3D+v_max+we+have+no+bound*/
  public final boolean dragFloat(@NotNull String label, @NotNull NativeFloat value, float valueSpeed, float valueMin, float valueMax, @NotNull String format){return dragFloat(getBytes(label), value.nativeObjectPtr, valueSpeed, valueMin, valueMax, getBytes(format),JImSliderFlags.None);}
  /**If+v_min+%3E%3D+v_max+we+have+no+bound*/
  public final boolean dragFloat(@NotNull JImStr label, @NotNull NativeFloat value, float valueSpeed, float valueMin, float valueMax, @NotNull JImStr format){return dragFloat(label.bytes, value.nativeObjectPtr, valueSpeed, valueMin, valueMax, format.bytes,JImSliderFlags.None);}
  /**If+v_min+%3E%3D+v_max+we+have+no+bound*/
  public final boolean dragFloat(@NotNull String label, @NotNull NativeFloat value, float valueSpeed, float valueMin, float valueMax){return dragFloat(getBytes(label), value.nativeObjectPtr, valueSpeed, valueMin, valueMax,FLOAT_FMT, JImSliderFlags.None);}
  /**If+v_min+%3E%3D+v_max+we+have+no+bound*/
  public final boolean dragFloat(@NotNull JImStr label, @NotNull NativeFloat value, float valueSpeed, float valueMin, float valueMax){return dragFloat(label.bytes, value.nativeObjectPtr, valueSpeed, valueMin, valueMax,FLOAT_FMT, JImSliderFlags.None);}
  /**If+v_min+%3E%3D+v_max+we+have+no+bound*/
  public final boolean dragFloat(@NotNull String label, @NotNull NativeFloat value, float valueSpeed, float valueMin){return dragFloat(getBytes(label), value.nativeObjectPtr, valueSpeed, valueMin,0, FLOAT_FMT, JImSliderFlags.None);}
  /**If+v_min+%3E%3D+v_max+we+have+no+bound*/
  public final boolean dragFloat(@NotNull JImStr label, @NotNull NativeFloat value, float valueSpeed, float valueMin){return dragFloat(label.bytes, value.nativeObjectPtr, valueSpeed, valueMin,0, FLOAT_FMT, JImSliderFlags.None);}
  /**If+v_min+%3E%3D+v_max+we+have+no+bound*/
  public final boolean dragFloat(@NotNull String label, @NotNull NativeFloat value, float valueSpeed){return dragFloat(getBytes(label), value.nativeObjectPtr, valueSpeed,0, 0, FLOAT_FMT, JImSliderFlags.None);}
  /**If+v_min+%3E%3D+v_max+we+have+no+bound*/
  public final boolean dragFloat(@NotNull JImStr label, @NotNull NativeFloat value, float valueSpeed){return dragFloat(label.bytes, value.nativeObjectPtr, valueSpeed,0, 0, FLOAT_FMT, JImSliderFlags.None);}
  /**If+v_min+%3E%3D+v_max+we+have+no+bound*/
  public final boolean dragFloat(@NotNull String label, @NotNull NativeFloat value){return dragFloat(getBytes(label), value.nativeObjectPtr,1, 0, 0, FLOAT_FMT, JImSliderFlags.None);}
  /**If+v_min+%3E%3D+v_max+we+have+no+bound*/
  public final boolean dragFloat(@NotNull JImStr label, @NotNull NativeFloat value){return dragFloat(label.bytes, value.nativeObjectPtr,1, 0, 0, FLOAT_FMT, JImSliderFlags.None);}
  public final boolean dragFloatRange2(@NotNull String label, @NotNull NativeFloat valueCurrentMin, @NotNull NativeFloat valueCurrentMax, float valueSpeed, float valueMin, float valueMax, @NotNull String format, @Nullable String formatMax, @MagicConstant(flagsFromClass = JImSliderFlags.class)int flags){return dragFloatRange2(getBytes(label), valueCurrentMin.nativeObjectPtr, valueCurrentMax.nativeObjectPtr, valueSpeed, valueMin, valueMax, getBytes(format), getBytes(formatMax), flags);}
  public final boolean dragFloatRange2(@NotNull JImStr label, @NotNull NativeFloat valueCurrentMin, @NotNull NativeFloat valueCurrentMax, float valueSpeed, float valueMin, float valueMax, @NotNull JImStr format, @Nullable JImStr formatMax, @MagicConstant(flagsFromClass = JImSliderFlags.class)int flags){return dragFloatRange2(label.bytes, valueCurrentMin.nativeObjectPtr, valueCurrentMax.nativeObjectPtr, valueSpeed, valueMin, valueMax, format.bytes, formatMax.bytes, flags);}
  protected static native boolean dragFloatRange2(byte[] label, long valueCurrentMin, long valueCurrentMax, float valueSpeed, float valueMin, float valueMax, byte[] format, byte[] formatMax, @MagicConstant(flagsFromClass = JImSliderFlags.class)int flags);
  public final boolean dragFloatRange2(@NotNull String label, @NotNull NativeFloat valueCurrentMin, @NotNull NativeFloat valueCurrentMax, float valueSpeed, float valueMin, float valueMax, @NotNull String format, @Nullable String formatMax){return dragFloatRange2(getBytes(label), valueCurrentMin.nativeObjectPtr, valueCurrentMax.nativeObjectPtr, valueSpeed, valueMin, valueMax, getBytes(format), getBytes(formatMax),JImSliderFlags.None);}
  public final boolean dragFloatRange2(@NotNull JImStr label, @NotNull NativeFloat valueCurrentMin, @NotNull NativeFloat valueCurrentMax, float valueSpeed, float valueMin, float valueMax, @NotNull JImStr format, @Nullable JImStr formatMax){return dragFloatRange2(label.bytes, valueCurrentMin.nativeObjectPtr, valueCurrentMax.nativeObjectPtr, valueSpeed, valueMin, valueMax, format.bytes, formatMax.bytes,JImSliderFlags.None);}
  public final boolean dragFloatRange2(@NotNull String label, @NotNull NativeFloat valueCurrentMin, @NotNull NativeFloat valueCurrentMax, float valueSpeed, float valueMin, float valueMax, @NotNull String format){return dragFloatRange2(getBytes(label), valueCurrentMin.nativeObjectPtr, valueCurrentMax.nativeObjectPtr, valueSpeed, valueMin, valueMax, getBytes(format),(byte[]) null, JImSliderFlags.None);}
  public final boolean dragFloatRange2(@NotNull JImStr label, @NotNull NativeFloat valueCurrentMin, @NotNull NativeFloat valueCurrentMax, float valueSpeed, float valueMin, float valueMax, @NotNull JImStr format){return dragFloatRange2(label.bytes, valueCurrentMin.nativeObjectPtr, valueCurrentMax.nativeObjectPtr, valueSpeed, valueMin, valueMax, format.bytes,(byte[]) null, JImSliderFlags.None);}
  public final boolean dragFloatRange2(@NotNull String label, @NotNull NativeFloat valueCurrentMin, @NotNull NativeFloat valueCurrentMax, float valueSpeed, float valueMin, float valueMax){return dragFloatRange2(getBytes(label), valueCurrentMin.nativeObjectPtr, valueCurrentMax.nativeObjectPtr, valueSpeed, valueMin, valueMax,FLOAT_FMT, (byte[]) null, JImSliderFlags.None);}
  public final boolean dragFloatRange2(@NotNull JImStr label, @NotNull NativeFloat valueCurrentMin, @NotNull NativeFloat valueCurrentMax, float valueSpeed, float valueMin, float valueMax){return dragFloatRange2(label.bytes, valueCurrentMin.nativeObjectPtr, valueCurrentMax.nativeObjectPtr, valueSpeed, valueMin, valueMax,FLOAT_FMT, (byte[]) null, JImSliderFlags.None);}
  public final boolean dragFloatRange2(@NotNull String label, @NotNull NativeFloat valueCurrentMin, @NotNull NativeFloat valueCurrentMax, float valueSpeed, float valueMin){return dragFloatRange2(getBytes(label), valueCurrentMin.nativeObjectPtr, valueCurrentMax.nativeObjectPtr, valueSpeed, valueMin,0, FLOAT_FMT, (byte[]) null, JImSliderFlags.None);}
  public final boolean dragFloatRange2(@NotNull JImStr label, @NotNull NativeFloat valueCurrentMin, @NotNull NativeFloat valueCurrentMax, float valueSpeed, float valueMin){return dragFloatRange2(label.bytes, valueCurrentMin.nativeObjectPtr, valueCurrentMax.nativeObjectPtr, valueSpeed, valueMin,0, FLOAT_FMT, (byte[]) null, JImSliderFlags.None);}
  public final boolean dragFloatRange2(@NotNull String label, @NotNull NativeFloat valueCurrentMin, @NotNull NativeFloat valueCurrentMax, float valueSpeed){return dragFloatRange2(getBytes(label), valueCurrentMin.nativeObjectPtr, valueCurrentMax.nativeObjectPtr, valueSpeed,0, 0, FLOAT_FMT, (byte[]) null, JImSliderFlags.None);}
  public final boolean dragFloatRange2(@NotNull JImStr label, @NotNull NativeFloat valueCurrentMin, @NotNull NativeFloat valueCurrentMax, float valueSpeed){return dragFloatRange2(label.bytes, valueCurrentMin.nativeObjectPtr, valueCurrentMax.nativeObjectPtr, valueSpeed,0, 0, FLOAT_FMT, (byte[]) null, JImSliderFlags.None);}
  public final boolean dragFloatRange2(@NotNull String label, @NotNull NativeFloat valueCurrentMin, @NotNull NativeFloat valueCurrentMax){return dragFloatRange2(getBytes(label), valueCurrentMin.nativeObjectPtr, valueCurrentMax.nativeObjectPtr,1, 0, 0, FLOAT_FMT, (byte[]) null, JImSliderFlags.None);}
  public final boolean dragFloatRange2(@NotNull JImStr label, @NotNull NativeFloat valueCurrentMin, @NotNull NativeFloat valueCurrentMax){return dragFloatRange2(label.bytes, valueCurrentMin.nativeObjectPtr, valueCurrentMax.nativeObjectPtr,1, 0, 0, FLOAT_FMT, (byte[]) null, JImSliderFlags.None);}
  /**If+v_min+%3E%3D+v_max+we+have+no+bound*/
  public final boolean dragInt(@NotNull String label, @NotNull NativeInt value, float valueSpeed, int valueMin, int valueMax, @NotNull String format, @MagicConstant(flagsFromClass = JImSliderFlags.class)int flags){return dragInt(getBytes(label), value.nativeObjectPtr, valueSpeed, valueMin, valueMax, getBytes(format), flags);}
  /**If+v_min+%3E%3D+v_max+we+have+no+bound*/
  public final boolean dragInt(@NotNull JImStr label, @NotNull NativeInt value, float valueSpeed, int valueMin, int valueMax, @NotNull JImStr format, @MagicConstant(flagsFromClass = JImSliderFlags.class)int flags){return dragInt(label.bytes, value.nativeObjectPtr, valueSpeed, valueMin, valueMax, format.bytes, flags);}
  protected static native boolean dragInt(byte[] label, long value, float valueSpeed, int valueMin, int valueMax, byte[] format, @MagicConstant(flagsFromClass = JImSliderFlags.class)int flags);
  /**If+v_min+%3E%3D+v_max+we+have+no+bound*/
  public final boolean dragInt(@NotNull String label, @NotNull NativeInt value, float valueSpeed, int valueMin, int valueMax, @NotNull String format){return dragInt(getBytes(label), value.nativeObjectPtr, valueSpeed, valueMin, valueMax, getBytes(format),JImSliderFlags.None);}
  /**If+v_min+%3E%3D+v_max+we+have+no+bound*/
  public final boolean dragInt(@NotNull JImStr label, @NotNull NativeInt value, float valueSpeed, int valueMin, int valueMax, @NotNull JImStr format){return dragInt(label.bytes, value.nativeObjectPtr, valueSpeed, valueMin, valueMax, format.bytes,JImSliderFlags.None);}
  /**If+v_min+%3E%3D+v_max+we+have+no+bound*/
  public final boolean dragInt(@NotNull String label, @NotNull NativeInt value, float valueSpeed, int valueMin, int valueMax){return dragInt(getBytes(label), value.nativeObjectPtr, valueSpeed, valueMin, valueMax,INT_FMT, JImSliderFlags.None);}
  /**If+v_min+%3E%3D+v_max+we+have+no+bound*/
  public final boolean dragInt(@NotNull JImStr label, @NotNull NativeInt value, float valueSpeed, int valueMin, int valueMax){return dragInt(label.bytes, value.nativeObjectPtr, valueSpeed, valueMin, valueMax,INT_FMT, JImSliderFlags.None);}
  /**If+v_min+%3E%3D+v_max+we+have+no+bound*/
  public final boolean dragInt(@NotNull String label, @NotNull NativeInt value, float valueSpeed, int valueMin){return dragInt(getBytes(label), value.nativeObjectPtr, valueSpeed, valueMin,0, INT_FMT, JImSliderFlags.None);}
  /**If+v_min+%3E%3D+v_max+we+have+no+bound*/
  public final boolean dragInt(@NotNull JImStr label, @NotNull NativeInt value, float valueSpeed, int valueMin){return dragInt(label.bytes, value.nativeObjectPtr, valueSpeed, valueMin,0, INT_FMT, JImSliderFlags.None);}
  /**If+v_min+%3E%3D+v_max+we+have+no+bound*/
  public final boolean dragInt(@NotNull String label, @NotNull NativeInt value, float valueSpeed){return dragInt(getBytes(label), value.nativeObjectPtr, valueSpeed,0, 0, INT_FMT, JImSliderFlags.None);}
  /**If+v_min+%3E%3D+v_max+we+have+no+bound*/
  public final boolean dragInt(@NotNull JImStr label, @NotNull NativeInt value, float valueSpeed){return dragInt(label.bytes, value.nativeObjectPtr, valueSpeed,0, 0, INT_FMT, JImSliderFlags.None);}
  /**If+v_min+%3E%3D+v_max+we+have+no+bound*/
  public final boolean dragInt(@NotNull String label, @NotNull NativeInt value){return dragInt(getBytes(label), value.nativeObjectPtr,1, 0, 0, INT_FMT, JImSliderFlags.None);}
  /**If+v_min+%3E%3D+v_max+we+have+no+bound*/
  public final boolean dragInt(@NotNull JImStr label, @NotNull NativeInt value){return dragInt(label.bytes, value.nativeObjectPtr,1, 0, 0, INT_FMT, JImSliderFlags.None);}
  public final boolean dragIntRange2(@NotNull String label, @NotNull NativeInt valueCurrentMin, @NotNull NativeInt valueCurrentMax, float valueSpeed, int valueMin, int valueMax, @NotNull String format, @NotNull String formatMax, @MagicConstant(flagsFromClass = JImSliderFlags.class)int flags){return dragIntRange2(getBytes(label), valueCurrentMin.nativeObjectPtr, valueCurrentMax.nativeObjectPtr, valueSpeed, valueMin, valueMax, getBytes(format), getBytes(formatMax), flags);}
  public final boolean dragIntRange2(@NotNull JImStr label, @NotNull NativeInt valueCurrentMin, @NotNull NativeInt valueCurrentMax, float valueSpeed, int valueMin, int valueMax, @NotNull JImStr format, @NotNull JImStr formatMax, @MagicConstant(flagsFromClass = JImSliderFlags.class)int flags){return dragIntRange2(label.bytes, valueCurrentMin.nativeObjectPtr, valueCurrentMax.nativeObjectPtr, valueSpeed, valueMin, valueMax, format.bytes, formatMax.bytes, flags);}
  protected static native boolean dragIntRange2(byte[] label, long valueCurrentMin, long valueCurrentMax, float valueSpeed, int valueMin, int valueMax, byte[] format, byte[] formatMax, @MagicConstant(flagsFromClass = JImSliderFlags.class)int flags);
  public final boolean dragIntRange2(@NotNull String label, @NotNull NativeInt valueCurrentMin, @NotNull NativeInt valueCurrentMax, float valueSpeed, int valueMin, int valueMax, @NotNull String format, @NotNull String formatMax){return dragIntRange2(getBytes(label), valueCurrentMin.nativeObjectPtr, valueCurrentMax.nativeObjectPtr, valueSpeed, valueMin, valueMax, getBytes(format), getBytes(formatMax),JImSliderFlags.None);}
  public final boolean dragIntRange2(@NotNull JImStr label, @NotNull NativeInt valueCurrentMin, @NotNull NativeInt valueCurrentMax, float valueSpeed, int valueMin, int valueMax, @NotNull JImStr format, @NotNull JImStr formatMax){return dragIntRange2(label.bytes, valueCurrentMin.nativeObjectPtr, valueCurrentMax.nativeObjectPtr, valueSpeed, valueMin, valueMax, format.bytes, formatMax.bytes,JImSliderFlags.None);}
  public final boolean dragIntRange2(@NotNull String label, @NotNull NativeInt valueCurrentMin, @NotNull NativeInt valueCurrentMax, float valueSpeed, int valueMin, int valueMax, @NotNull String format){return dragIntRange2(getBytes(label), valueCurrentMin.nativeObjectPtr, valueCurrentMax.nativeObjectPtr, valueSpeed, valueMin, valueMax, getBytes(format),INT_FMT, JImSliderFlags.None);}
  public final boolean dragIntRange2(@NotNull JImStr label, @NotNull NativeInt valueCurrentMin, @NotNull NativeInt valueCurrentMax, float valueSpeed, int valueMin, int valueMax, @NotNull JImStr format){return dragIntRange2(label.bytes, valueCurrentMin.nativeObjectPtr, valueCurrentMax.nativeObjectPtr, valueSpeed, valueMin, valueMax, format.bytes,INT_FMT, JImSliderFlags.None);}
  public final boolean dragIntRange2(@NotNull String label, @NotNull NativeInt valueCurrentMin, @NotNull NativeInt valueCurrentMax, float valueSpeed, int valueMin, int valueMax){return dragIntRange2(getBytes(label), valueCurrentMin.nativeObjectPtr, valueCurrentMax.nativeObjectPtr, valueSpeed, valueMin, valueMax,INT_FMT, INT_FMT, JImSliderFlags.None);}
  public final boolean dragIntRange2(@NotNull JImStr label, @NotNull NativeInt valueCurrentMin, @NotNull NativeInt valueCurrentMax, float valueSpeed, int valueMin, int valueMax){return dragIntRange2(label.bytes, valueCurrentMin.nativeObjectPtr, valueCurrentMax.nativeObjectPtr, valueSpeed, valueMin, valueMax,INT_FMT, INT_FMT, JImSliderFlags.None);}
  public final boolean dragIntRange2(@NotNull String label, @NotNull NativeInt valueCurrentMin, @NotNull NativeInt valueCurrentMax, float valueSpeed, int valueMin){return dragIntRange2(getBytes(label), valueCurrentMin.nativeObjectPtr, valueCurrentMax.nativeObjectPtr, valueSpeed, valueMin,0, INT_FMT, INT_FMT, JImSliderFlags.None);}
  public final boolean dragIntRange2(@NotNull JImStr label, @NotNull NativeInt valueCurrentMin, @NotNull NativeInt valueCurrentMax, float valueSpeed, int valueMin){return dragIntRange2(label.bytes, valueCurrentMin.nativeObjectPtr, valueCurrentMax.nativeObjectPtr, valueSpeed, valueMin,0, INT_FMT, INT_FMT, JImSliderFlags.None);}
  public final boolean dragIntRange2(@NotNull String label, @NotNull NativeInt valueCurrentMin, @NotNull NativeInt valueCurrentMax, float valueSpeed){return dragIntRange2(getBytes(label), valueCurrentMin.nativeObjectPtr, valueCurrentMax.nativeObjectPtr, valueSpeed,0, 0, INT_FMT, INT_FMT, JImSliderFlags.None);}
  public final boolean dragIntRange2(@NotNull JImStr label, @NotNull NativeInt valueCurrentMin, @NotNull NativeInt valueCurrentMax, float valueSpeed){return dragIntRange2(label.bytes, valueCurrentMin.nativeObjectPtr, valueCurrentMax.nativeObjectPtr, valueSpeed,0, 0, INT_FMT, INT_FMT, JImSliderFlags.None);}
  public final boolean dragIntRange2(@NotNull String label, @NotNull NativeInt valueCurrentMin, @NotNull NativeInt valueCurrentMax){return dragIntRange2(getBytes(label), valueCurrentMin.nativeObjectPtr, valueCurrentMax.nativeObjectPtr,1, 0, 0, INT_FMT, INT_FMT, JImSliderFlags.None);}
  public final boolean dragIntRange2(@NotNull JImStr label, @NotNull NativeInt valueCurrentMin, @NotNull NativeInt valueCurrentMax){return dragIntRange2(label.bytes, valueCurrentMin.nativeObjectPtr, valueCurrentMax.nativeObjectPtr,1, 0, 0, INT_FMT, INT_FMT, JImSliderFlags.None);}
  public final boolean inputFloat(@NotNull String label, @NotNull NativeFloat value, float step, float stepFast, @NotNull String format, @MagicConstant(flagsFromClass = JImInputTextFlags.class)int flags){return inputFloat(getBytes(label), value.nativeObjectPtr, step, stepFast, getBytes(format), flags);}
  public final boolean inputFloat(@NotNull JImStr label, @NotNull NativeFloat value, float step, float stepFast, @NotNull JImStr format, @MagicConstant(flagsFromClass = JImInputTextFlags.class)int flags){return inputFloat(label.bytes, value.nativeObjectPtr, step, stepFast, format.bytes, flags);}
  protected static native boolean inputFloat(byte[] label, long value, float step, float stepFast, byte[] format, @MagicConstant(flagsFromClass = JImInputTextFlags.class)int flags);
  public final boolean inputFloat(@NotNull String label, @NotNull NativeFloat value, float step, float stepFast, @NotNull String format){return inputFloat(getBytes(label), value.nativeObjectPtr, step, stepFast, getBytes(format),JImInputTextFlags.None);}
  public final boolean inputFloat(@NotNull JImStr label, @NotNull NativeFloat value, float step, float stepFast, @NotNull JImStr format){return inputFloat(label.bytes, value.nativeObjectPtr, step, stepFast, format.bytes,JImInputTextFlags.None);}
  public final boolean inputFloat(@NotNull String label, @NotNull NativeFloat value, float step, float stepFast){return inputFloat(getBytes(label), value.nativeObjectPtr, step, stepFast,FLOAT_FMT, JImInputTextFlags.None);}
  public final boolean inputFloat(@NotNull JImStr label, @NotNull NativeFloat value, float step, float stepFast){return inputFloat(label.bytes, value.nativeObjectPtr, step, stepFast,FLOAT_FMT, JImInputTextFlags.None);}
  public final boolean inputFloat(@NotNull String label, @NotNull NativeFloat value, float step){return inputFloat(getBytes(label), value.nativeObjectPtr, step,0, FLOAT_FMT, JImInputTextFlags.None);}
  public final boolean inputFloat(@NotNull JImStr label, @NotNull NativeFloat value, float step){return inputFloat(label.bytes, value.nativeObjectPtr, step,0, FLOAT_FMT, JImInputTextFlags.None);}
  public final boolean inputFloat(@NotNull String label, @NotNull NativeFloat value){return inputFloat(getBytes(label), value.nativeObjectPtr,0, 0, FLOAT_FMT, JImInputTextFlags.None);}
  public final boolean inputFloat(@NotNull JImStr label, @NotNull NativeFloat value){return inputFloat(label.bytes, value.nativeObjectPtr,0, 0, FLOAT_FMT, JImInputTextFlags.None);}
  public final boolean inputInt(@NotNull String label, @NotNull NativeInt value, int step, int stepFast, @MagicConstant(flagsFromClass = JImInputTextFlags.class)int flags){return inputInt(getBytes(label), value.nativeObjectPtr, step, stepFast, flags);}
  public final boolean inputInt(@NotNull JImStr label, @NotNull NativeInt value, int step, int stepFast, @MagicConstant(flagsFromClass = JImInputTextFlags.class)int flags){return inputInt(label.bytes, value.nativeObjectPtr, step, stepFast, flags);}
  protected static native boolean inputInt(byte[] label, long value, int step, int stepFast, @MagicConstant(flagsFromClass = JImInputTextFlags.class)int flags);
  public final boolean inputInt(@NotNull String label, @NotNull NativeInt value, int step, int stepFast){return inputInt(getBytes(label), value.nativeObjectPtr, step, stepFast,JImInputTextFlags.None);}
  public final boolean inputInt(@NotNull JImStr label, @NotNull NativeInt value, int step, int stepFast){return inputInt(label.bytes, value.nativeObjectPtr, step, stepFast,JImInputTextFlags.None);}
  public final boolean inputInt(@NotNull String label, @NotNull NativeInt value, int step){return inputInt(getBytes(label), value.nativeObjectPtr, step,100, JImInputTextFlags.None);}
  public final boolean inputInt(@NotNull JImStr label, @NotNull NativeInt value, int step){return inputInt(label.bytes, value.nativeObjectPtr, step,100, JImInputTextFlags.None);}
  public final boolean inputInt(@NotNull String label, @NotNull NativeInt value){return inputInt(getBytes(label), value.nativeObjectPtr,1, 100, JImInputTextFlags.None);}
  public final boolean inputInt(@NotNull JImStr label, @NotNull NativeInt value){return inputInt(label.bytes, value.nativeObjectPtr,1, 100, JImInputTextFlags.None);}
  public final boolean inputDouble(@NotNull String label, @NotNull NativeDouble value, double step, double stepFast, @NotNull String format, @MagicConstant(flagsFromClass = JImInputTextFlags.class)int flags){return inputDouble(getBytes(label), value.nativeObjectPtr, step, stepFast, getBytes(format), flags);}
  public final boolean inputDouble(@NotNull JImStr label, @NotNull NativeDouble value, double step, double stepFast, @NotNull JImStr format, @MagicConstant(flagsFromClass = JImInputTextFlags.class)int flags){return inputDouble(label.bytes, value.nativeObjectPtr, step, stepFast, format.bytes, flags);}
  protected static native boolean inputDouble(byte[] label, long value, double step, double stepFast, byte[] format, @MagicConstant(flagsFromClass = JImInputTextFlags.class)int flags);
  public final boolean inputDouble(@NotNull String label, @NotNull NativeDouble value, double step, double stepFast, @NotNull String format){return inputDouble(getBytes(label), value.nativeObjectPtr, step, stepFast, getBytes(format),JImInputTextFlags.None);}
  public final boolean inputDouble(@NotNull JImStr label, @NotNull NativeDouble value, double step, double stepFast, @NotNull JImStr format){return inputDouble(label.bytes, value.nativeObjectPtr, step, stepFast, format.bytes,JImInputTextFlags.None);}
  public final boolean inputDouble(@NotNull String label, @NotNull NativeDouble value, double step, double stepFast){return inputDouble(getBytes(label), value.nativeObjectPtr, step, stepFast,DOUBLE_FMT, JImInputTextFlags.None);}
  public final boolean inputDouble(@NotNull JImStr label, @NotNull NativeDouble value, double step, double stepFast){return inputDouble(label.bytes, value.nativeObjectPtr, step, stepFast,DOUBLE_FMT, JImInputTextFlags.None);}
  public final boolean inputDouble(@NotNull String label, @NotNull NativeDouble value, double step){return inputDouble(getBytes(label), value.nativeObjectPtr, step,0, DOUBLE_FMT, JImInputTextFlags.None);}
  public final boolean inputDouble(@NotNull JImStr label, @NotNull NativeDouble value, double step){return inputDouble(label.bytes, value.nativeObjectPtr, step,0, DOUBLE_FMT, JImInputTextFlags.None);}
  public final boolean inputDouble(@NotNull String label, @NotNull NativeDouble value){return inputDouble(getBytes(label), value.nativeObjectPtr,0, 0, DOUBLE_FMT, JImInputTextFlags.None);}
  public final boolean inputDouble(@NotNull JImStr label, @NotNull NativeDouble value){return inputDouble(label.bytes, value.nativeObjectPtr,0, 0, DOUBLE_FMT, JImInputTextFlags.None);}
  public final boolean inputText(@NotNull String label, @NotNull NativeString value, @MagicConstant(flagsFromClass = JImInputTextFlags.class)int flags){return inputText(getBytes(label), value.nativeObjectPtr, flags);}
  public final boolean inputText(@NotNull JImStr label, @NotNull NativeString value, @MagicConstant(flagsFromClass = JImInputTextFlags.class)int flags){return inputText(label.bytes, value.nativeObjectPtr, flags);}
  protected static native boolean inputText(byte[] label, long value, @MagicConstant(flagsFromClass = JImInputTextFlags.class)int flags);
  public final boolean inputText(@NotNull String label, @NotNull NativeString value){return inputText(getBytes(label), value.nativeObjectPtr,JImInputTextFlags.None);}
  public final boolean inputText(@NotNull JImStr label, @NotNull NativeString value){return inputText(label.bytes, value.nativeObjectPtr,JImInputTextFlags.None);}
  public final boolean inputTextMultiline(@NotNull String label, @NotNull NativeString value, float width, float height, @MagicConstant(flagsFromClass = JImInputTextFlags.class)int flags){return inputTextMultiline(getBytes(label), value.nativeObjectPtr, width, height, flags);}
  public final boolean inputTextMultiline(@NotNull JImStr label, @NotNull NativeString value, float width, float height, @MagicConstant(flagsFromClass = JImInputTextFlags.class)int flags){return inputTextMultiline(label.bytes, value.nativeObjectPtr, width, height, flags);}
  protected static native boolean inputTextMultiline(byte[] label, long value, float width, float height, @MagicConstant(flagsFromClass = JImInputTextFlags.class)int flags);
  public final boolean inputTextMultiline(@NotNull String label, @NotNull NativeString value, float width, float height){return inputTextMultiline(getBytes(label), value.nativeObjectPtr, width, height,JImInputTextFlags.None);}
  public final boolean inputTextMultiline(@NotNull JImStr label, @NotNull NativeString value, float width, float height){return inputTextMultiline(label.bytes, value.nativeObjectPtr, width, height,JImInputTextFlags.None);}
  public final boolean inputTextMultiline(@NotNull String label, @NotNull NativeString value){return inputTextMultiline(getBytes(label), value.nativeObjectPtr,0,0, JImInputTextFlags.None);}
  public final boolean inputTextMultiline(@NotNull JImStr label, @NotNull NativeString value){return inputTextMultiline(label.bytes, value.nativeObjectPtr,0,0, JImInputTextFlags.None);}
  public final boolean inputTextWithHint(@NotNull String label, @NotNull String hint, @NotNull NativeString value, @MagicConstant(flagsFromClass = JImInputTextFlags.class)int flags){return inputTextWithHint(getBytes(label), getBytes(hint), value.nativeObjectPtr, flags);}
  public final boolean inputTextWithHint(@NotNull JImStr label, @NotNull JImStr hint, @NotNull NativeString value, @MagicConstant(flagsFromClass = JImInputTextFlags.class)int flags){return inputTextWithHint(label.bytes, hint.bytes, value.nativeObjectPtr, flags);}
  protected static native boolean inputTextWithHint(byte[] label, byte[] hint, long value, @MagicConstant(flagsFromClass = JImInputTextFlags.class)int flags);
  public final boolean inputTextWithHint(@NotNull String label, @NotNull String hint, @NotNull NativeString value){return inputTextWithHint(getBytes(label), getBytes(hint), value.nativeObjectPtr,JImInputTextFlags.None);}
  public final boolean inputTextWithHint(@NotNull JImStr label, @NotNull JImStr hint, @NotNull NativeString value){return inputTextWithHint(label.bytes, hint.bytes, value.nativeObjectPtr,JImInputTextFlags.None);}
  /**adjust+format+to+decorate+the+value+with+a+prefix+or+a+suffix+for+in-slider+labels+or+unit+display.*/
  public final boolean sliderFloat(@NotNull String label, @NotNull NativeFloat value, float valueMin, float valueMax, @NotNull String format, @MagicConstant(flagsFromClass = JImSliderFlags.class)int flags){return sliderFloat(getBytes(label), value.nativeObjectPtr, valueMin, valueMax, getBytes(format), flags);}
  /**adjust+format+to+decorate+the+value+with+a+prefix+or+a+suffix+for+in-slider+labels+or+unit+display.*/
  public final boolean sliderFloat(@NotNull JImStr label, @NotNull NativeFloat value, float valueMin, float valueMax, @NotNull JImStr format, @MagicConstant(flagsFromClass = JImSliderFlags.class)int flags){return sliderFloat(label.bytes, value.nativeObjectPtr, valueMin, valueMax, format.bytes, flags);}
  protected static native boolean sliderFloat(byte[] label, long value, float valueMin, float valueMax, byte[] format, @MagicConstant(flagsFromClass = JImSliderFlags.class)int flags);
  /**adjust+format+to+decorate+the+value+with+a+prefix+or+a+suffix+for+in-slider+labels+or+unit+display.*/
  public final boolean sliderFloat(@NotNull String label, @NotNull NativeFloat value, float valueMin, float valueMax, @NotNull String format){return sliderFloat(getBytes(label), value.nativeObjectPtr, valueMin, valueMax, getBytes(format),JImSliderFlags.None);}
  /**adjust+format+to+decorate+the+value+with+a+prefix+or+a+suffix+for+in-slider+labels+or+unit+display.*/
  public final boolean sliderFloat(@NotNull JImStr label, @NotNull NativeFloat value, float valueMin, float valueMax, @NotNull JImStr format){return sliderFloat(label.bytes, value.nativeObjectPtr, valueMin, valueMax, format.bytes,JImSliderFlags.None);}
  /**adjust+format+to+decorate+the+value+with+a+prefix+or+a+suffix+for+in-slider+labels+or+unit+display.*/
  public final boolean sliderFloat(@NotNull String label, @NotNull NativeFloat value, float valueMin, float valueMax){return sliderFloat(getBytes(label), value.nativeObjectPtr, valueMin, valueMax,FLOAT_FMT, JImSliderFlags.None);}
  /**adjust+format+to+decorate+the+value+with+a+prefix+or+a+suffix+for+in-slider+labels+or+unit+display.*/
  public final boolean sliderFloat(@NotNull JImStr label, @NotNull NativeFloat value, float valueMin, float valueMax){return sliderFloat(label.bytes, value.nativeObjectPtr, valueMin, valueMax,FLOAT_FMT, JImSliderFlags.None);}
  /**adjust+format+to+decorate+the+value+with+a+prefix+or+a+suffix+for+in-slider+labels+or+unit+display.*/
  public final boolean sliderFloat(@NotNull String label, @NotNull NativeFloat value, float valueMin){return sliderFloat(getBytes(label), value.nativeObjectPtr, valueMin,0, FLOAT_FMT, JImSliderFlags.None);}
  /**adjust+format+to+decorate+the+value+with+a+prefix+or+a+suffix+for+in-slider+labels+or+unit+display.*/
  public final boolean sliderFloat(@NotNull JImStr label, @NotNull NativeFloat value, float valueMin){return sliderFloat(label.bytes, value.nativeObjectPtr, valueMin,0, FLOAT_FMT, JImSliderFlags.None);}
  /**adjust+format+to+decorate+the+value+with+a+prefix+or+a+suffix+for+in-slider+labels+or+unit+display.*/
  public final boolean sliderFloat(@NotNull String label, @NotNull NativeFloat value){return sliderFloat(getBytes(label), value.nativeObjectPtr,0, 0, FLOAT_FMT, JImSliderFlags.None);}
  /**adjust+format+to+decorate+the+value+with+a+prefix+or+a+suffix+for+in-slider+labels+or+unit+display.*/
  public final boolean sliderFloat(@NotNull JImStr label, @NotNull NativeFloat value){return sliderFloat(label.bytes, value.nativeObjectPtr,0, 0, FLOAT_FMT, JImSliderFlags.None);}
  public final boolean sliderAngle(@NotNull String label, @NotNull NativeFloat valueRad, float valueDegreeMin, float valueDegreeMax, @NotNull String format, @MagicConstant(flagsFromClass = JImSliderFlags.class)int flags){return sliderAngle(getBytes(label), valueRad.nativeObjectPtr, valueDegreeMin, valueDegreeMax, getBytes(format), flags);}
  public final boolean sliderAngle(@NotNull JImStr label, @NotNull NativeFloat valueRad, float valueDegreeMin, float valueDegreeMax, @NotNull JImStr format, @MagicConstant(flagsFromClass = JImSliderFlags.class)int flags){return sliderAngle(label.bytes, valueRad.nativeObjectPtr, valueDegreeMin, valueDegreeMax, format.bytes, flags);}
  protected static native boolean sliderAngle(byte[] label, long valueRad, float valueDegreeMin, float valueDegreeMax, byte[] format, @MagicConstant(flagsFromClass = JImSliderFlags.class)int flags);
  public final boolean sliderAngle(@NotNull String label, @NotNull NativeFloat valueRad, float valueDegreeMin, float valueDegreeMax, @NotNull String format){return sliderAngle(getBytes(label), valueRad.nativeObjectPtr, valueDegreeMin, valueDegreeMax, getBytes(format),JImSliderFlags.None);}
  public final boolean sliderAngle(@NotNull JImStr label, @NotNull NativeFloat valueRad, float valueDegreeMin, float valueDegreeMax, @NotNull JImStr format){return sliderAngle(label.bytes, valueRad.nativeObjectPtr, valueDegreeMin, valueDegreeMax, format.bytes,JImSliderFlags.None);}
  public final boolean sliderAngle(@NotNull String label, @NotNull NativeFloat valueRad, float valueDegreeMin, float valueDegreeMax){return sliderAngle(getBytes(label), valueRad.nativeObjectPtr, valueDegreeMin, valueDegreeMax,FLOAT_FMT, JImSliderFlags.None);}
  public final boolean sliderAngle(@NotNull JImStr label, @NotNull NativeFloat valueRad, float valueDegreeMin, float valueDegreeMax){return sliderAngle(label.bytes, valueRad.nativeObjectPtr, valueDegreeMin, valueDegreeMax,FLOAT_FMT, JImSliderFlags.None);}
  public final boolean sliderAngle(@NotNull String label, @NotNull NativeFloat valueRad, float valueDegreeMin){return sliderAngle(getBytes(label), valueRad.nativeObjectPtr, valueDegreeMin,360, FLOAT_FMT, JImSliderFlags.None);}
  public final boolean sliderAngle(@NotNull JImStr label, @NotNull NativeFloat valueRad, float valueDegreeMin){return sliderAngle(label.bytes, valueRad.nativeObjectPtr, valueDegreeMin,360, FLOAT_FMT, JImSliderFlags.None);}
  public final boolean sliderAngle(@NotNull String label, @NotNull NativeFloat valueRad){return sliderAngle(getBytes(label), valueRad.nativeObjectPtr,-360, 360, FLOAT_FMT, JImSliderFlags.None);}
  public final boolean sliderAngle(@NotNull JImStr label, @NotNull NativeFloat valueRad){return sliderAngle(label.bytes, valueRad.nativeObjectPtr,-360, 360, FLOAT_FMT, JImSliderFlags.None);}
  public final boolean sliderInt(@NotNull String label, @NotNull NativeInt value, int valueMin, int valueMax, @NotNull String format, @MagicConstant(flagsFromClass = JImSliderFlags.class)int flags){return sliderInt(getBytes(label), value.nativeObjectPtr, valueMin, valueMax, getBytes(format), flags);}
  public final boolean sliderInt(@NotNull JImStr label, @NotNull NativeInt value, int valueMin, int valueMax, @NotNull JImStr format, @MagicConstant(flagsFromClass = JImSliderFlags.class)int flags){return sliderInt(label.bytes, value.nativeObjectPtr, valueMin, valueMax, format.bytes, flags);}
  protected static native boolean sliderInt(byte[] label, long value, int valueMin, int valueMax, byte[] format, @MagicConstant(flagsFromClass = JImSliderFlags.class)int flags);
  public final boolean sliderInt(@NotNull String label, @NotNull NativeInt value, int valueMin, int valueMax, @NotNull String format){return sliderInt(getBytes(label), value.nativeObjectPtr, valueMin, valueMax, getBytes(format),JImSliderFlags.None);}
  public final boolean sliderInt(@NotNull JImStr label, @NotNull NativeInt value, int valueMin, int valueMax, @NotNull JImStr format){return sliderInt(label.bytes, value.nativeObjectPtr, valueMin, valueMax, format.bytes,JImSliderFlags.None);}
  public final boolean sliderInt(@NotNull String label, @NotNull NativeInt value, int valueMin, int valueMax){return sliderInt(getBytes(label), value.nativeObjectPtr, valueMin, valueMax,INT_FMT, JImSliderFlags.None);}
  public final boolean sliderInt(@NotNull JImStr label, @NotNull NativeInt value, int valueMin, int valueMax){return sliderInt(label.bytes, value.nativeObjectPtr, valueMin, valueMax,INT_FMT, JImSliderFlags.None);}
  public final boolean sliderInt(@NotNull String label, @NotNull NativeInt value, int valueMin){return sliderInt(getBytes(label), value.nativeObjectPtr, valueMin,0, INT_FMT, JImSliderFlags.None);}
  public final boolean sliderInt(@NotNull JImStr label, @NotNull NativeInt value, int valueMin){return sliderInt(label.bytes, value.nativeObjectPtr, valueMin,0, INT_FMT, JImSliderFlags.None);}
  public final boolean sliderInt(@NotNull String label, @NotNull NativeInt value){return sliderInt(getBytes(label), value.nativeObjectPtr,0, 0, INT_FMT, JImSliderFlags.None);}
  public final boolean sliderInt(@NotNull JImStr label, @NotNull NativeInt value){return sliderInt(label.bytes, value.nativeObjectPtr,0, 0, INT_FMT, JImSliderFlags.None);}
  public final boolean vSliderFloat(@NotNull String label, float width, float height, @NotNull NativeFloat value, float valueMin, float valueMax, @NotNull String format, @MagicConstant(flagsFromClass = JImSliderFlags.class)int flags){return vSliderFloat(getBytes(label), width, height, value.nativeObjectPtr, valueMin, valueMax, getBytes(format), flags);}
  public final boolean vSliderFloat(@NotNull JImStr label, float width, float height, @NotNull NativeFloat value, float valueMin, float valueMax, @NotNull JImStr format, @MagicConstant(flagsFromClass = JImSliderFlags.class)int flags){return vSliderFloat(label.bytes, width, height, value.nativeObjectPtr, valueMin, valueMax, format.bytes, flags);}
  protected static native boolean vSliderFloat(byte[] label, float width, float height, long value, float valueMin, float valueMax, byte[] format, @MagicConstant(flagsFromClass = JImSliderFlags.class)int flags);
  public final boolean vSliderFloat(@NotNull String label, float width, float height, @NotNull NativeFloat value, float valueMin, float valueMax, @NotNull String format){return vSliderFloat(getBytes(label), width, height, value.nativeObjectPtr, valueMin, valueMax, getBytes(format),JImSliderFlags.None);}
  public final boolean vSliderFloat(@NotNull JImStr label, float width, float height, @NotNull NativeFloat value, float valueMin, float valueMax, @NotNull JImStr format){return vSliderFloat(label.bytes, width, height, value.nativeObjectPtr, valueMin, valueMax, format.bytes,JImSliderFlags.None);}
  public final boolean vSliderFloat(@NotNull String label, float width, float height, @NotNull NativeFloat value, float valueMin, float valueMax){return vSliderFloat(getBytes(label), width, height, value.nativeObjectPtr, valueMin, valueMax,FLOAT_FMT, JImSliderFlags.None);}
  public final boolean vSliderFloat(@NotNull JImStr label, float width, float height, @NotNull NativeFloat value, float valueMin, float valueMax){return vSliderFloat(label.bytes, width, height, value.nativeObjectPtr, valueMin, valueMax,FLOAT_FMT, JImSliderFlags.None);}
  public final boolean vSliderFloat(@NotNull String label, float width, float height, @NotNull NativeFloat value, float valueMin){return vSliderFloat(getBytes(label), width, height, value.nativeObjectPtr, valueMin,0, FLOAT_FMT, JImSliderFlags.None);}
  public final boolean vSliderFloat(@NotNull JImStr label, float width, float height, @NotNull NativeFloat value, float valueMin){return vSliderFloat(label.bytes, width, height, value.nativeObjectPtr, valueMin,0, FLOAT_FMT, JImSliderFlags.None);}
  public final boolean vSliderFloat(@NotNull String label, float width, float height, @NotNull NativeFloat value){return vSliderFloat(getBytes(label), width, height, value.nativeObjectPtr,0, 0, FLOAT_FMT, JImSliderFlags.None);}
  public final boolean vSliderFloat(@NotNull JImStr label, float width, float height, @NotNull NativeFloat value){return vSliderFloat(label.bytes, width, height, value.nativeObjectPtr,0, 0, FLOAT_FMT, JImSliderFlags.None);}
  public final boolean vSliderInt(@NotNull String label, float width, float height, @NotNull NativeInt value, int valueMin, int valueMax, @NotNull String format, @MagicConstant(flagsFromClass = JImSliderFlags.class)int flags){return vSliderInt(getBytes(label), width, height, value.nativeObjectPtr, valueMin, valueMax, getBytes(format), flags);}
  public final boolean vSliderInt(@NotNull JImStr label, float width, float height, @NotNull NativeInt value, int valueMin, int valueMax, @NotNull JImStr format, @MagicConstant(flagsFromClass = JImSliderFlags.class)int flags){return vSliderInt(label.bytes, width, height, value.nativeObjectPtr, valueMin, valueMax, format.bytes, flags);}
  protected static native boolean vSliderInt(byte[] label, float width, float height, long value, int valueMin, int valueMax, byte[] format, @MagicConstant(flagsFromClass = JImSliderFlags.class)int flags);
  public final boolean vSliderInt(@NotNull String label, float width, float height, @NotNull NativeInt value, int valueMin, int valueMax, @NotNull String format){return vSliderInt(getBytes(label), width, height, value.nativeObjectPtr, valueMin, valueMax, getBytes(format),JImSliderFlags.None);}
  public final boolean vSliderInt(@NotNull JImStr label, float width, float height, @NotNull NativeInt value, int valueMin, int valueMax, @NotNull JImStr format){return vSliderInt(label.bytes, width, height, value.nativeObjectPtr, valueMin, valueMax, format.bytes,JImSliderFlags.None);}
  public final boolean vSliderInt(@NotNull String label, float width, float height, @NotNull NativeInt value, int valueMin, int valueMax){return vSliderInt(getBytes(label), width, height, value.nativeObjectPtr, valueMin, valueMax,INT_FMT, JImSliderFlags.None);}
  public final boolean vSliderInt(@NotNull JImStr label, float width, float height, @NotNull NativeInt value, int valueMin, int valueMax){return vSliderInt(label.bytes, width, height, value.nativeObjectPtr, valueMin, valueMax,INT_FMT, JImSliderFlags.None);}
  public final boolean vSliderInt(@NotNull String label, float width, float height, @NotNull NativeInt value, int valueMin){return vSliderInt(getBytes(label), width, height, value.nativeObjectPtr, valueMin,0, INT_FMT, JImSliderFlags.None);}
  public final boolean vSliderInt(@NotNull JImStr label, float width, float height, @NotNull NativeInt value, int valueMin){return vSliderInt(label.bytes, width, height, value.nativeObjectPtr, valueMin,0, INT_FMT, JImSliderFlags.None);}
  public final boolean vSliderInt(@NotNull String label, float width, float height, @NotNull NativeInt value){return vSliderInt(getBytes(label), width, height, value.nativeObjectPtr,0, 0, INT_FMT, JImSliderFlags.None);}
  public final boolean vSliderInt(@NotNull JImStr label, float width, float height, @NotNull NativeInt value){return vSliderInt(label.bytes, width, height, value.nativeObjectPtr,0, 0, INT_FMT, JImSliderFlags.None);}
  /**helper+variation+to+easily+decorelate+the+id+from+the+displayed+string.+Read+the+FAQ+about+why+and+how+to+use+ID.+to+align+arbitrary+text+at+the+same+level+as+a+TreeNode%28%29+you+can+use+Bullet%28%29.%0A++%22*/
  public final boolean treeNode(@NotNull String label){return treeNode(getBytes(label));}
  /**helper+variation+to+easily+decorelate+the+id+from+the+displayed+string.+Read+the+FAQ+about+why+and+how+to+use+ID.+to+align+arbitrary+text+at+the+same+level+as+a+TreeNode%28%29+you+can+use+Bullet%28%29.%0A++%22*/
  public final boolean treeNode(@NotNull JImStr label){return treeNode(label.bytes);}
  protected static native boolean treeNode(byte[] label);
  public final boolean treeNodeEx(@NotNull String label, @MagicConstant(flagsFromClass = JImTreeNodeFlags.class)int flags){return treeNodeEx(getBytes(label), flags);}
  public final boolean treeNodeEx(@NotNull JImStr label, @MagicConstant(flagsFromClass = JImTreeNodeFlags.class)int flags){return treeNodeEx(label.bytes, flags);}
  protected static native boolean treeNodeEx(byte[] label, @MagicConstant(flagsFromClass = JImTreeNodeFlags.class)int flags);
  public final boolean treeNodeEx(@NotNull String label){return treeNodeEx(getBytes(label),JImTreeNodeFlags.Selected);}
  public final boolean treeNodeEx(@NotNull JImStr label){return treeNodeEx(label.bytes,JImTreeNodeFlags.Selected);}
  /**%7E+Indent%28%29%2BPushId%28%29.+Already+called+by+TreeNode%28%29+when+returning+true%2C+but+you+can+call+TreePush%7CTreePop+yourself+if+desired.%0A++%22*/
  public final void treePush(@NotNull String stringID){treePush(getBytes(stringID));}
  /**%7E+Indent%28%29%2BPushId%28%29.+Already+called+by+TreeNode%28%29+when+returning+true%2C+but+you+can+call+TreePush%7CTreePop+yourself+if+desired.%0A++%22*/
  public final void treePush(@NotNull JImStr stringID){treePush(stringID.bytes);}
  protected static native void treePush(byte[] stringID);
  /**%7E+Unindent%28%29%2BPopId%28%29*/
  public static native void treePop();
  /**horizontal+distance+preceding+label+when+using+TreeNode*%28%29+or+Bullet%28%29+%3D%3D+%28g.FontSize+%2B+style.FramePadding.x*2%29+for+a+regular+unframed+TreeNode*/
  public static native float getTreeNodeToLabelSpacing();
  /**set+next+TreeNode%7CCollapsingHeader+open+state.*/
  public static native void SetNextItemOpen(boolean isOpen, @MagicConstant(valuesFromClass = JImCond.class)int condition);
  /**set+next+TreeNode%7CCollapsingHeader+open+state.*/
  public final void SetNextItemOpen(boolean isOpen){SetNextItemOpen(isOpen,JImCond.Always);}
  /**if+returning+%27true%27+the+header+is+open.+doesn%27t+indent+nor+push+on+ID+stack.+user+doesn%27t+have+to+call+TreePop%28%29.%0A++when+%27p_visible+%21%3D+NULL%27%3A+if+%27*p_visible%3D%3Dtrue%27+display+an+additional+small+close+button+on+upper+right+of+the+header+which+will+set+the+bool+to+false+when+clicked%2C+if+%27*p_visible%3D%3Dfalse%27+don%27t+display+the+header.*/
  public final boolean collapsingHeader(@NotNull String label, @NotNull NativeBool openPtr, @MagicConstant(flagsFromClass = JImTreeNodeFlags.class)int flags){return collapsingHeader(getBytes(label), openPtr.nativeObjectPtr, flags);}
  /**if+returning+%27true%27+the+header+is+open.+doesn%27t+indent+nor+push+on+ID+stack.+user+doesn%27t+have+to+call+TreePop%28%29.%0A++when+%27p_visible+%21%3D+NULL%27%3A+if+%27*p_visible%3D%3Dtrue%27+display+an+additional+small+close+button+on+upper+right+of+the+header+which+will+set+the+bool+to+false+when+clicked%2C+if+%27*p_visible%3D%3Dfalse%27+don%27t+display+the+header.*/
  public final boolean collapsingHeader(@NotNull JImStr label, @NotNull NativeBool openPtr, @MagicConstant(flagsFromClass = JImTreeNodeFlags.class)int flags){return collapsingHeader(label.bytes, openPtr.nativeObjectPtr, flags);}
  protected static native boolean collapsingHeader(byte[] label, long openPtr, @MagicConstant(flagsFromClass = JImTreeNodeFlags.class)int flags);
  /**if+returning+%27true%27+the+header+is+open.+doesn%27t+indent+nor+push+on+ID+stack.+user+doesn%27t+have+to+call+TreePop%28%29.%0A++when+%27p_visible+%21%3D+NULL%27%3A+if+%27*p_visible%3D%3Dtrue%27+display+an+additional+small+close+button+on+upper+right+of+the+header+which+will+set+the+bool+to+false+when+clicked%2C+if+%27*p_visible%3D%3Dfalse%27+don%27t+display+the+header.*/
  public final boolean collapsingHeader(@NotNull String label, @NotNull NativeBool openPtr){return collapsingHeader(getBytes(label), openPtr.nativeObjectPtr,JImTreeNodeFlags.Selected);}
  /**if+returning+%27true%27+the+header+is+open.+doesn%27t+indent+nor+push+on+ID+stack.+user+doesn%27t+have+to+call+TreePop%28%29.%0A++when+%27p_visible+%21%3D+NULL%27%3A+if+%27*p_visible%3D%3Dtrue%27+display+an+additional+small+close+button+on+upper+right+of+the+header+which+will+set+the+bool+to+false+when+clicked%2C+if+%27*p_visible%3D%3Dfalse%27+don%27t+display+the+header.*/
  public final boolean collapsingHeader(@NotNull JImStr label, @NotNull NativeBool openPtr){return collapsingHeader(label.bytes, openPtr.nativeObjectPtr,JImTreeNodeFlags.Selected);}
  /**if+returning+%27true%27+the+header+is+open.+doesn%27t+indent+nor+push+on+ID+stack.+user+doesn%27t+have+to+call+TreePop%28%29.%0A++when+%27p_visible+%21%3D+NULL%27%3A+if+%27*p_visible%3D%3Dtrue%27+display+an+additional+small+close+button+on+upper+right+of+the+header+which+will+set+the+bool+to+false+when+clicked%2C+if+%27*p_visible%3D%3Dfalse%27+don%27t+display+the+header.*/
  public final boolean collapsingHeader(@NotNull String label){return collapsingHeader(getBytes(label),0, JImTreeNodeFlags.Selected);}
  /**if+returning+%27true%27+the+header+is+open.+doesn%27t+indent+nor+push+on+ID+stack.+user+doesn%27t+have+to+call+TreePop%28%29.%0A++when+%27p_visible+%21%3D+NULL%27%3A+if+%27*p_visible%3D%3Dtrue%27+display+an+additional+small+close+button+on+upper+right+of+the+header+which+will+set+the+bool+to+false+when+clicked%2C+if+%27*p_visible%3D%3Dfalse%27+don%27t+display+the+header.*/
  public final boolean collapsingHeader(@NotNull JImStr label){return collapsingHeader(label.bytes,0, JImTreeNodeFlags.Selected);}
  public final boolean colorEdit3(@NotNull String label, @NotNull JImVec4 color, @MagicConstant(flagsFromClass = JImColorEditFlags.class)int flags){return colorEdit3(getBytes(label), color.nativeObjectPtr, flags);}
  public final boolean colorEdit3(@NotNull JImStr label, @NotNull JImVec4 color, @MagicConstant(flagsFromClass = JImColorEditFlags.class)int flags){return colorEdit3(label.bytes, color.nativeObjectPtr, flags);}
  protected static native boolean colorEdit3(byte[] label, long color, @MagicConstant(flagsFromClass = JImColorEditFlags.class)int flags);
  public final boolean colorEdit3(@NotNull String label, @NotNull JImVec4 color){return colorEdit3(getBytes(label), color.nativeObjectPtr,JImColorEditFlags.None);}
  public final boolean colorEdit3(@NotNull JImStr label, @NotNull JImVec4 color){return colorEdit3(label.bytes, color.nativeObjectPtr,JImColorEditFlags.None);}
  public final boolean colorEdit4(@NotNull String label, @NotNull JImVec4 color, @MagicConstant(flagsFromClass = JImColorEditFlags.class)int flags){return colorEdit4(getBytes(label), color.nativeObjectPtr, flags);}
  public final boolean colorEdit4(@NotNull JImStr label, @NotNull JImVec4 color, @MagicConstant(flagsFromClass = JImColorEditFlags.class)int flags){return colorEdit4(label.bytes, color.nativeObjectPtr, flags);}
  protected static native boolean colorEdit4(byte[] label, long color, @MagicConstant(flagsFromClass = JImColorEditFlags.class)int flags);
  public final boolean colorEdit4(@NotNull String label, @NotNull JImVec4 color){return colorEdit4(getBytes(label), color.nativeObjectPtr,JImColorEditFlags.None);}
  public final boolean colorEdit4(@NotNull JImStr label, @NotNull JImVec4 color){return colorEdit4(label.bytes, color.nativeObjectPtr,JImColorEditFlags.None);}
  /**display+a+color+square%7Cbutton%2C+hover+for+details%2C+return+true+when+pressed.*/
  public final boolean colorButton(@NotNull String descriptionID, @NotNull JImVec4 color, @MagicConstant(flagsFromClass = JImColorEditFlags.class)int flags, float width, float height){return colorButton(getBytes(descriptionID), color.nativeObjectPtr, flags, width, height);}
  /**display+a+color+square%7Cbutton%2C+hover+for+details%2C+return+true+when+pressed.*/
  public final boolean colorButton(@NotNull JImStr descriptionID, @NotNull JImVec4 color, @MagicConstant(flagsFromClass = JImColorEditFlags.class)int flags, float width, float height){return colorButton(descriptionID.bytes, color.nativeObjectPtr, flags, width, height);}
  protected static native boolean colorButton(byte[] descriptionID, long color, @MagicConstant(flagsFromClass = JImColorEditFlags.class)int flags, float width, float height);
  /**display+a+color+square%7Cbutton%2C+hover+for+details%2C+return+true+when+pressed.*/
  public final boolean colorButton(@NotNull String descriptionID, @NotNull JImVec4 color, @MagicConstant(flagsFromClass = JImColorEditFlags.class)int flags){return colorButton(getBytes(descriptionID), color.nativeObjectPtr, flags,0,0);}
  /**display+a+color+square%7Cbutton%2C+hover+for+details%2C+return+true+when+pressed.*/
  public final boolean colorButton(@NotNull JImStr descriptionID, @NotNull JImVec4 color, @MagicConstant(flagsFromClass = JImColorEditFlags.class)int flags){return colorButton(descriptionID.bytes, color.nativeObjectPtr, flags,0,0);}
  /**display+a+color+square%7Cbutton%2C+hover+for+details%2C+return+true+when+pressed.*/
  public final boolean colorButton(@NotNull String descriptionID, @NotNull JImVec4 color){return colorButton(getBytes(descriptionID), color.nativeObjectPtr,JImColorEditFlags.None, 0,0);}
  /**display+a+color+square%7Cbutton%2C+hover+for+details%2C+return+true+when+pressed.*/
  public final boolean colorButton(@NotNull JImStr descriptionID, @NotNull JImVec4 color){return colorButton(descriptionID.bytes, color.nativeObjectPtr,JImColorEditFlags.None, 0,0);}
  public final boolean colorPicker3(@NotNull String label, @NotNull JImVec4 color, @MagicConstant(flagsFromClass = JImColorEditFlags.class)int flags){return colorPicker3(getBytes(label), color.nativeObjectPtr, flags);}
  public final boolean colorPicker3(@NotNull JImStr label, @NotNull JImVec4 color, @MagicConstant(flagsFromClass = JImColorEditFlags.class)int flags){return colorPicker3(label.bytes, color.nativeObjectPtr, flags);}
  protected static native boolean colorPicker3(byte[] label, long color, @MagicConstant(flagsFromClass = JImColorEditFlags.class)int flags);
  public final boolean colorPicker3(@NotNull String label, @NotNull JImVec4 color){return colorPicker3(getBytes(label), color.nativeObjectPtr,JImColorEditFlags.None);}
  public final boolean colorPicker3(@NotNull JImStr label, @NotNull JImVec4 color){return colorPicker3(label.bytes, color.nativeObjectPtr,JImColorEditFlags.None);}
  public final boolean colorPicker4(@NotNull String label, @NotNull JImVec4 color, @MagicConstant(flagsFromClass = JImColorEditFlags.class)int flags){return colorPicker4(getBytes(label), color.nativeObjectPtr, flags);}
  public final boolean colorPicker4(@NotNull JImStr label, @NotNull JImVec4 color, @MagicConstant(flagsFromClass = JImColorEditFlags.class)int flags){return colorPicker4(label.bytes, color.nativeObjectPtr, flags);}
  protected static native boolean colorPicker4(byte[] label, long color, @MagicConstant(flagsFromClass = JImColorEditFlags.class)int flags);
  public final boolean colorPicker4(@NotNull String label, @NotNull JImVec4 color){return colorPicker4(getBytes(label), color.nativeObjectPtr,JImColorEditFlags.None);}
  public final boolean colorPicker4(@NotNull JImStr label, @NotNull JImVec4 color){return colorPicker4(label.bytes, color.nativeObjectPtr,JImColorEditFlags.None);}
  /**initialize+current+options+%28generally+on+application+startup%29+if+you+want+to+select+a+default+format%2C+picker+type%2C+etc.+User+will+be+able+to+change+many+settings%2C+unless+you+pass+the+_NoOptions+flag+to+your+calls.*/
  public static native void setColorEditOptions(@MagicConstant(flagsFromClass = JImColorEditFlags.class)int flags);
  /**initialize+current+options+%28generally+on+application+startup%29+if+you+want+to+select+a+default+format%2C+picker+type%2C+etc.+User+will+be+able+to+change+many+settings%2C+unless+you+pass+the+_NoOptions+flag+to+your+calls.*/
  public final void setColorEditOptions(){setColorEditOptions(0);}
  public final boolean selectable0(@NotNull String label, boolean selected, @MagicConstant(flagsFromClass = JImSelectableFlags.class)int flags, float width, float height){return selectable0(getBytes(label), selected, flags, width, height);}
  public final boolean selectable0(@NotNull JImStr label, boolean selected, @MagicConstant(flagsFromClass = JImSelectableFlags.class)int flags, float width, float height){return selectable0(label.bytes, selected, flags, width, height);}
  protected static native boolean selectable0(byte[] label, boolean selected, @MagicConstant(flagsFromClass = JImSelectableFlags.class)int flags, float width, float height);
  public final boolean selectable0(@NotNull String label, boolean selected, @MagicConstant(flagsFromClass = JImSelectableFlags.class)int flags){return selectable0(getBytes(label), selected, flags,0,0);}
  public final boolean selectable0(@NotNull JImStr label, boolean selected, @MagicConstant(flagsFromClass = JImSelectableFlags.class)int flags){return selectable0(label.bytes, selected, flags,0,0);}
  public final boolean selectable0(@NotNull String label, boolean selected){return selectable0(getBytes(label), selected,JImSelectableFlags.None, 0,0);}
  public final boolean selectable0(@NotNull JImStr label, boolean selected){return selectable0(label.bytes, selected,JImSelectableFlags.None, 0,0);}
  public final boolean selectable0(@NotNull String label){return selectable0(getBytes(label),false, JImSelectableFlags.None, 0,0);}
  public final boolean selectable0(@NotNull JImStr label){return selectable0(label.bytes,false, JImSelectableFlags.None, 0,0);}
  /**%22bool+selected%22+carry+the+selection+state+%28read-only%29.+Selectable%28%29+is+clicked+is+returns+true+so+you+can+modify+your+selection+state.+size.x%3D%3D0.0%3A+use+remaining+width%2C+size.x%3E0.0%3A+specify+width.+size.y%3D%3D0.0%3A+use+label+height%2C+size.y%3E0.0%3A+specify+height%0A++%22bool*+p_selected%22+point+to+the+selection+state+%28read-write%29%2C+as+a+convenient+helper.*/
  public final boolean selectable(@NotNull String label, @NotNull NativeBool selected, @MagicConstant(flagsFromClass = JImSelectableFlags.class)int flags, float width, float height){return selectable(getBytes(label), selected.nativeObjectPtr, flags, width, height);}
  /**%22bool+selected%22+carry+the+selection+state+%28read-only%29.+Selectable%28%29+is+clicked+is+returns+true+so+you+can+modify+your+selection+state.+size.x%3D%3D0.0%3A+use+remaining+width%2C+size.x%3E0.0%3A+specify+width.+size.y%3D%3D0.0%3A+use+label+height%2C+size.y%3E0.0%3A+specify+height%0A++%22bool*+p_selected%22+point+to+the+selection+state+%28read-write%29%2C+as+a+convenient+helper.*/
  public final boolean selectable(@NotNull JImStr label, @NotNull NativeBool selected, @MagicConstant(flagsFromClass = JImSelectableFlags.class)int flags, float width, float height){return selectable(label.bytes, selected.nativeObjectPtr, flags, width, height);}
  protected static native boolean selectable(byte[] label, long selected, @MagicConstant(flagsFromClass = JImSelectableFlags.class)int flags, float width, float height);
  /**%22bool+selected%22+carry+the+selection+state+%28read-only%29.+Selectable%28%29+is+clicked+is+returns+true+so+you+can+modify+your+selection+state.+size.x%3D%3D0.0%3A+use+remaining+width%2C+size.x%3E0.0%3A+specify+width.+size.y%3D%3D0.0%3A+use+label+height%2C+size.y%3E0.0%3A+specify+height%0A++%22bool*+p_selected%22+point+to+the+selection+state+%28read-write%29%2C+as+a+convenient+helper.*/
  public final boolean selectable(@NotNull String label, @NotNull NativeBool selected, @MagicConstant(flagsFromClass = JImSelectableFlags.class)int flags){return selectable(getBytes(label), selected.nativeObjectPtr, flags,0,0);}
  /**%22bool+selected%22+carry+the+selection+state+%28read-only%29.+Selectable%28%29+is+clicked+is+returns+true+so+you+can+modify+your+selection+state.+size.x%3D%3D0.0%3A+use+remaining+width%2C+size.x%3E0.0%3A+specify+width.+size.y%3D%3D0.0%3A+use+label+height%2C+size.y%3E0.0%3A+specify+height%0A++%22bool*+p_selected%22+point+to+the+selection+state+%28read-write%29%2C+as+a+convenient+helper.*/
  public final boolean selectable(@NotNull JImStr label, @NotNull NativeBool selected, @MagicConstant(flagsFromClass = JImSelectableFlags.class)int flags){return selectable(label.bytes, selected.nativeObjectPtr, flags,0,0);}
  /**%22bool+selected%22+carry+the+selection+state+%28read-only%29.+Selectable%28%29+is+clicked+is+returns+true+so+you+can+modify+your+selection+state.+size.x%3D%3D0.0%3A+use+remaining+width%2C+size.x%3E0.0%3A+specify+width.+size.y%3D%3D0.0%3A+use+label+height%2C+size.y%3E0.0%3A+specify+height%0A++%22bool*+p_selected%22+point+to+the+selection+state+%28read-write%29%2C+as+a+convenient+helper.*/
  public final boolean selectable(@NotNull String label, @NotNull NativeBool selected){return selectable(getBytes(label), selected.nativeObjectPtr,JImSelectableFlags.None, 0,0);}
  /**%22bool+selected%22+carry+the+selection+state+%28read-only%29.+Selectable%28%29+is+clicked+is+returns+true+so+you+can+modify+your+selection+state.+size.x%3D%3D0.0%3A+use+remaining+width%2C+size.x%3E0.0%3A+specify+width.+size.y%3D%3D0.0%3A+use+label+height%2C+size.y%3E0.0%3A+specify+height%0A++%22bool*+p_selected%22+point+to+the+selection+state+%28read-write%29%2C+as+a+convenient+helper.*/
  public final boolean selectable(@NotNull JImStr label, @NotNull NativeBool selected){return selectable(label.bytes, selected.nativeObjectPtr,JImSelectableFlags.None, 0,0);}
  /**set+a+text-only+tooltip%2C+typically+use+with+ImGui%3A%3AIsItemHovered%28%29.+override+any+previous+call+to+SetTooltip%28%29.*/
  public final void setTooltip(@NotNull String text){setTooltip(getBytes(text));}
  /**set+a+text-only+tooltip%2C+typically+use+with+ImGui%3A%3AIsItemHovered%28%29.+override+any+previous+call+to+SetTooltip%28%29.*/
  public final void setTooltip(@NotNull JImStr text){setTooltip(text.bytes);}
  protected static native void setTooltip(byte[] text);
  /**begin%7Cappend+a+tooltip+window.+to+create+full-featured+tooltip+%28with+any+kind+of+items%29.*/
  public static native void beginTooltip();
  public static native void endTooltip();
  /**create+and+append+to+a+full+screen+menu-bar.*/
  public static native boolean beginMainMenuBar();
  /**only+call+EndMainMenuBar%28%29+if+BeginMainMenuBar%28%29+returns+true%21*/
  public static native void endMainMenuBar();
  /**append+to+menu-bar+of+current+window+%28requires+ImGuiWindowFlags_MenuBar+flag+set+on+parent+window%29.*/
  public static native boolean beginMenuBar();
  /**only+call+EndMenuBar%28%29+if+BeginMenuBar%28%29+returns+true%21*/
  public static native void endMenuBar();
  /**create+a+sub-menu+entry.+only+call+EndMenu%28%29+if+this+returns+true%21*/
  public final boolean beginMenu(@NotNull String label, boolean enabled){return beginMenu(getBytes(label), enabled);}
  /**create+a+sub-menu+entry.+only+call+EndMenu%28%29+if+this+returns+true%21*/
  public final boolean beginMenu(@NotNull JImStr label, boolean enabled){return beginMenu(label.bytes, enabled);}
  protected static native boolean beginMenu(byte[] label, boolean enabled);
  /**create+a+sub-menu+entry.+only+call+EndMenu%28%29+if+this+returns+true%21*/
  public final boolean beginMenu(@NotNull String label){return beginMenu(getBytes(label),true);}
  /**create+a+sub-menu+entry.+only+call+EndMenu%28%29+if+this+returns+true%21*/
  public final boolean beginMenu(@NotNull JImStr label){return beginMenu(label.bytes,true);}
  /**only+call+EndMenu%28%29+if+BeginMenu%28%29+returns+true%21*/
  public static native void endMenu();
  /**return+true+when+activated.%0A++return+true+when+activated+%2B+toggle+%28*p_selected%29+if+p_selected+%21%3D+NULL*/
  public final boolean menuItem(@NotNull String label, @Nullable String shortcut, @NotNull NativeBool selected, boolean enabled){return menuItem(getBytes(label), getBytes(shortcut), selected.nativeObjectPtr, enabled);}
  /**return+true+when+activated.%0A++return+true+when+activated+%2B+toggle+%28*p_selected%29+if+p_selected+%21%3D+NULL*/
  public final boolean menuItem(@NotNull JImStr label, @Nullable JImStr shortcut, @NotNull NativeBool selected, boolean enabled){return menuItem(label.bytes, shortcut.bytes, selected.nativeObjectPtr, enabled);}
  protected static native boolean menuItem(byte[] label, byte[] shortcut, long selected, boolean enabled);
  /**return+true+when+activated.%0A++return+true+when+activated+%2B+toggle+%28*p_selected%29+if+p_selected+%21%3D+NULL*/
  public final boolean menuItem(@NotNull String label, @Nullable String shortcut, @NotNull NativeBool selected){return menuItem(getBytes(label), getBytes(shortcut), selected.nativeObjectPtr,true);}
  /**return+true+when+activated.%0A++return+true+when+activated+%2B+toggle+%28*p_selected%29+if+p_selected+%21%3D+NULL*/
  public final boolean menuItem(@NotNull JImStr label, @Nullable JImStr shortcut, @NotNull NativeBool selected){return menuItem(label.bytes, shortcut.bytes, selected.nativeObjectPtr,true);}
  /**return+true+when+activated.%0A++return+true+when+activated+%2B+toggle+%28*p_selected%29+if+p_selected+%21%3D+NULL*/
  public final boolean menuItem(@NotNull String label, @Nullable String shortcut){return menuItem(getBytes(label), getBytes(shortcut),0, true);}
  /**return+true+when+activated.%0A++return+true+when+activated+%2B+toggle+%28*p_selected%29+if+p_selected+%21%3D+NULL*/
  public final boolean menuItem(@NotNull JImStr label, @Nullable JImStr shortcut){return menuItem(label.bytes, shortcut.bytes,0, true);}
  /**return+true+when+activated.%0A++return+true+when+activated+%2B+toggle+%28*p_selected%29+if+p_selected+%21%3D+NULL*/
  public final boolean menuItem(@NotNull String label){return menuItem(getBytes(label),(byte[]) null, 0, true);}
  /**return+true+when+activated.%0A++return+true+when+activated+%2B+toggle+%28*p_selected%29+if+p_selected+%21%3D+NULL*/
  public final boolean menuItem(@NotNull JImStr label){return menuItem(label.bytes,(byte[]) null, 0, true);}
  /**call+to+mark+popup+as+open+%28don%27t+call+every+frame%21%29.%0A++id+overload+to+facilitate+calling+from+nested+stacks*/
  public final void openPopup(@NotNull String stringID, @MagicConstant(flagsFromClass = JImPopupFlags.class)int flags){openPopup(getBytes(stringID), flags);}
  /**call+to+mark+popup+as+open+%28don%27t+call+every+frame%21%29.%0A++id+overload+to+facilitate+calling+from+nested+stacks*/
  public final void openPopup(@NotNull JImStr stringID, @MagicConstant(flagsFromClass = JImPopupFlags.class)int flags){openPopup(stringID.bytes, flags);}
  protected static native void openPopup(byte[] stringID, @MagicConstant(flagsFromClass = JImPopupFlags.class)int flags);
  /**call+to+mark+popup+as+open+%28don%27t+call+every+frame%21%29.%0A++id+overload+to+facilitate+calling+from+nested+stacks*/
  public final void openPopup(@NotNull String stringID){openPopup(getBytes(stringID),JImPopupFlags.MouseButtonLeft);}
  /**call+to+mark+popup+as+open+%28don%27t+call+every+frame%21%29.%0A++id+overload+to+facilitate+calling+from+nested+stacks*/
  public final void openPopup(@NotNull JImStr stringID){openPopup(stringID.bytes,JImPopupFlags.MouseButtonLeft);}
  /**return+true+if+the+popup+is+open%2C+and+you+can+start+outputting+to+it.*/
  public final boolean beginPopup(@NotNull String stringID, @MagicConstant(flagsFromClass = JImWindowFlags.class)int flags){return beginPopup(getBytes(stringID), flags);}
  /**return+true+if+the+popup+is+open%2C+and+you+can+start+outputting+to+it.*/
  public final boolean beginPopup(@NotNull JImStr stringID, @MagicConstant(flagsFromClass = JImWindowFlags.class)int flags){return beginPopup(stringID.bytes, flags);}
  protected static native boolean beginPopup(byte[] stringID, @MagicConstant(flagsFromClass = JImWindowFlags.class)int flags);
  /**return+true+if+the+popup+is+open%2C+and+you+can+start+outputting+to+it.*/
  public final boolean beginPopup(@NotNull String stringID){return beginPopup(getBytes(stringID),JImWindowFlags.None);}
  /**return+true+if+the+popup+is+open%2C+and+you+can+start+outputting+to+it.*/
  public final boolean beginPopup(@NotNull JImStr stringID){return beginPopup(stringID.bytes,JImWindowFlags.None);}
  /**open%2Bbegin+popup+when+clicked+on+last+item.+Use+str_id%3D%3DNULL+to+associate+the+popup+to+previous+item.+If+you+want+to+use+that+on+a+non-interactive+item+such+as+Text%28%29+you+need+to+pass+in+an+explicit+ID+here.+read+comments+in+.cpp%21*/
  public final boolean beginPopupContextItem(@Nullable String stringID, @MagicConstant(flagsFromClass = JImPopupFlags.class)int flags){return beginPopupContextItem(getBytes(stringID), flags);}
  protected static native boolean beginPopupContextItem(byte[] stringID, @MagicConstant(flagsFromClass = JImPopupFlags.class)int flags);
  /**open%2Bbegin+popup+when+clicked+on+last+item.+Use+str_id%3D%3DNULL+to+associate+the+popup+to+previous+item.+If+you+want+to+use+that+on+a+non-interactive+item+such+as+Text%28%29+you+need+to+pass+in+an+explicit+ID+here.+read+comments+in+.cpp%21*/
  public final boolean beginPopupContextItem(@Nullable String stringID){return beginPopupContextItem(getBytes(stringID),JImPopupFlags.MouseButtonRight);}
  /**open%2Bbegin+popup+when+clicked+on+last+item.+Use+str_id%3D%3DNULL+to+associate+the+popup+to+previous+item.+If+you+want+to+use+that+on+a+non-interactive+item+such+as+Text%28%29+you+need+to+pass+in+an+explicit+ID+here.+read+comments+in+.cpp%21*/
  public final boolean beginPopupContextItem(){return beginPopupContextItem((byte[]) null, JImPopupFlags.MouseButtonRight);}
  /**open%2Bbegin+popup+when+clicked+on+current+window.*/
  public final boolean beginPopupContextWindow(@Nullable String stringID, @MagicConstant(flagsFromClass = JImPopupFlags.class)int flags){return beginPopupContextWindow(getBytes(stringID), flags);}
  protected static native boolean beginPopupContextWindow(byte[] stringID, @MagicConstant(flagsFromClass = JImPopupFlags.class)int flags);
  /**open%2Bbegin+popup+when+clicked+on+current+window.*/
  public final boolean beginPopupContextWindow(@Nullable String stringID){return beginPopupContextWindow(getBytes(stringID),JImPopupFlags.MouseButtonRight);}
  /**open%2Bbegin+popup+when+clicked+on+current+window.*/
  public final boolean beginPopupContextWindow(){return beginPopupContextWindow((byte[]) null, JImPopupFlags.MouseButtonRight);}
  /**open%2Bbegin+popup+when+clicked+in+void+%28where+there+are+no+windows%29.*/
  public final boolean beginPopupContextVoid(@Nullable String stringID, @MagicConstant(flagsFromClass = JImPopupFlags.class)int flags){return beginPopupContextVoid(getBytes(stringID), flags);}
  protected static native boolean beginPopupContextVoid(byte[] stringID, @MagicConstant(flagsFromClass = JImPopupFlags.class)int flags);
  /**open%2Bbegin+popup+when+clicked+in+void+%28where+there+are+no+windows%29.*/
  public final boolean beginPopupContextVoid(@Nullable String stringID){return beginPopupContextVoid(getBytes(stringID),JImPopupFlags.MouseButtonRight);}
  /**open%2Bbegin+popup+when+clicked+in+void+%28where+there+are+no+windows%29.*/
  public final boolean beginPopupContextVoid(){return beginPopupContextVoid((byte[]) null, JImPopupFlags.MouseButtonRight);}
  /**return+true+if+the+modal+is+open%2C+and+you+can+start+outputting+to+it.*/
  public final boolean beginPopupModal(@NotNull String name, @NotNull NativeBool openPtr, @MagicConstant(flagsFromClass = JImWindowFlags.class)int flags){return beginPopupModal(getBytes(name), openPtr.nativeObjectPtr, flags);}
  /**return+true+if+the+modal+is+open%2C+and+you+can+start+outputting+to+it.*/
  public final boolean beginPopupModal(@NotNull JImStr name, @NotNull NativeBool openPtr, @MagicConstant(flagsFromClass = JImWindowFlags.class)int flags){return beginPopupModal(name.bytes, openPtr.nativeObjectPtr, flags);}
  protected static native boolean beginPopupModal(byte[] name, long openPtr, @MagicConstant(flagsFromClass = JImWindowFlags.class)int flags);
  /**return+true+if+the+modal+is+open%2C+and+you+can+start+outputting+to+it.*/
  public final boolean beginPopupModal(@NotNull String name, @NotNull NativeBool openPtr){return beginPopupModal(getBytes(name), openPtr.nativeObjectPtr,JImWindowFlags.None);}
  /**return+true+if+the+modal+is+open%2C+and+you+can+start+outputting+to+it.*/
  public final boolean beginPopupModal(@NotNull JImStr name, @NotNull NativeBool openPtr){return beginPopupModal(name.bytes, openPtr.nativeObjectPtr,JImWindowFlags.None);}
  /**only+call+EndPopup%28%29+if+BeginPopupXXX%28%29+returns+true%21*/
  public static native void endPopup();
  /**helper+to+open+popup+when+clicked+on+last+item.+Default+to+ImGuiPopupFlags_MouseButtonRight+%3D%3D+1.+%28note%3A+actually+triggers+on+the+mouse+_released_+event+to+be+consistent+with+popup+behaviors%29*/
  public final void openPopupOnItemClick(@Nullable String stringID, @MagicConstant(flagsFromClass = JImPopupFlags.class)int flags){openPopupOnItemClick(getBytes(stringID), flags);}
  protected static native void openPopupOnItemClick(byte[] stringID, @MagicConstant(flagsFromClass = JImPopupFlags.class)int flags);
  /**helper+to+open+popup+when+clicked+on+last+item.+Default+to+ImGuiPopupFlags_MouseButtonRight+%3D%3D+1.+%28note%3A+actually+triggers+on+the+mouse+_released_+event+to+be+consistent+with+popup+behaviors%29*/
  public final void openPopupOnItemClick(@Nullable String stringID){openPopupOnItemClick(getBytes(stringID),JImPopupFlags.MouseButtonRight);}
  /**helper+to+open+popup+when+clicked+on+last+item.+Default+to+ImGuiPopupFlags_MouseButtonRight+%3D%3D+1.+%28note%3A+actually+triggers+on+the+mouse+_released_+event+to+be+consistent+with+popup+behaviors%29*/
  public final void openPopupOnItemClick(){openPopupOnItemClick((byte[]) null, JImPopupFlags.MouseButtonRight);}
  /**return+true+if+the+popup+is+open.*/
  public final boolean isPopupOpen(@NotNull String stringID, @MagicConstant(flagsFromClass = JImPopupFlags.class)int flags){return isPopupOpen(getBytes(stringID), flags);}
  /**return+true+if+the+popup+is+open.*/
  public final boolean isPopupOpen(@NotNull JImStr stringID, @MagicConstant(flagsFromClass = JImPopupFlags.class)int flags){return isPopupOpen(stringID.bytes, flags);}
  protected static native boolean isPopupOpen(byte[] stringID, @MagicConstant(flagsFromClass = JImPopupFlags.class)int flags);
  /**return+true+if+the+popup+is+open.*/
  public final boolean isPopupOpen(@NotNull String stringID){return isPopupOpen(getBytes(stringID),JImPopupFlags.MouseButtonRight);}
  /**return+true+if+the+popup+is+open.*/
  public final boolean isPopupOpen(@NotNull JImStr stringID){return isPopupOpen(stringID.bytes,JImPopupFlags.MouseButtonRight);}
  /**manually+close+the+popup+we+have+begin-ed+into.*/
  public static native void closeCurrentPopup();
  public final boolean beginTable(@NotNull String stringID, int columnsCount, @MagicConstant(flagsFromClass = JImTableFlags.class)int flags, float widthouterSize, float heightouterSize, float innerWidth){return beginTable(getBytes(stringID), columnsCount, flags, widthouterSize, heightouterSize, innerWidth);}
  public final boolean beginTable(@NotNull JImStr stringID, int columnsCount, @MagicConstant(flagsFromClass = JImTableFlags.class)int flags, float widthouterSize, float heightouterSize, float innerWidth){return beginTable(stringID.bytes, columnsCount, flags, widthouterSize, heightouterSize, innerWidth);}
  protected static native boolean beginTable(byte[] stringID, int columnsCount, @MagicConstant(flagsFromClass = JImTableFlags.class)int flags, float widthouterSize, float heightouterSize, float innerWidth);
  public final boolean beginTable(@NotNull String stringID, int columnsCount, @MagicConstant(flagsFromClass = JImTableFlags.class)int flags, float widthouterSize, float heightouterSize){return beginTable(getBytes(stringID), columnsCount, flags, widthouterSize, heightouterSize,0);}
  public final boolean beginTable(@NotNull JImStr stringID, int columnsCount, @MagicConstant(flagsFromClass = JImTableFlags.class)int flags, float widthouterSize, float heightouterSize){return beginTable(stringID.bytes, columnsCount, flags, widthouterSize, heightouterSize,0);}
  public final boolean beginTable(@NotNull String stringID, int columnsCount, @MagicConstant(flagsFromClass = JImTableFlags.class)int flags){return beginTable(getBytes(stringID), columnsCount, flags,0,0, 0);}
  public final boolean beginTable(@NotNull JImStr stringID, int columnsCount, @MagicConstant(flagsFromClass = JImTableFlags.class)int flags){return beginTable(stringID.bytes, columnsCount, flags,0,0, 0);}
  public final boolean beginTable(@NotNull String stringID, int columnsCount){return beginTable(getBytes(stringID), columnsCount,JImTableFlags.None, 0,0, 0);}
  public final boolean beginTable(@NotNull JImStr stringID, int columnsCount){return beginTable(stringID.bytes, columnsCount,JImTableFlags.None, 0,0, 0);}
  /**only+call+EndTable%28%29+if+BeginTable%28%29+returns+true%21*/
  public static native void endTable();
  /**append+into+the+first+cell+of+a+new+row.*/
  public static native void tableNextRow(@MagicConstant(flagsFromClass = JImTableRowFlags.class)int flags, float minRowHeight);
  /**append+into+the+first+cell+of+a+new+row.*/
  public final void tableNextRow(@MagicConstant(flagsFromClass = JImTableRowFlags.class)int flags){tableNextRow(flags,0);}
  /**append+into+the+first+cell+of+a+new+row.*/
  public final void tableNextRow(){tableNextRow(JImTableRowFlags.None, 0);}
  /**append+into+the+next+column+%28or+first+column+of+next+row+if+currently+in+last+column%29.+Return+true+when+column+is+visible.*/
  public static native boolean tableNextColumn();
  /**append+into+the+specified+column.+Return+true+when+column+is+visible.*/
  public static native boolean tableSetColumnIndex(int columnN);
  public final void tableSetupColumn(@NotNull String label, @MagicConstant(flagsFromClass = JImTableColumnFlags.class)int flags, float initWidthOrWeight, int userID){tableSetupColumn(getBytes(label), flags, initWidthOrWeight, userID);}
  public final void tableSetupColumn(@NotNull JImStr label, @MagicConstant(flagsFromClass = JImTableColumnFlags.class)int flags, float initWidthOrWeight, int userID){tableSetupColumn(label.bytes, flags, initWidthOrWeight, userID);}
  protected static native void tableSetupColumn(byte[] label, @MagicConstant(flagsFromClass = JImTableColumnFlags.class)int flags, float initWidthOrWeight, int userID);
  public final void tableSetupColumn(@NotNull String label, @MagicConstant(flagsFromClass = JImTableColumnFlags.class)int flags, float initWidthOrWeight){tableSetupColumn(getBytes(label), flags, initWidthOrWeight,0);}
  public final void tableSetupColumn(@NotNull JImStr label, @MagicConstant(flagsFromClass = JImTableColumnFlags.class)int flags, float initWidthOrWeight){tableSetupColumn(label.bytes, flags, initWidthOrWeight,0);}
  public final void tableSetupColumn(@NotNull String label, @MagicConstant(flagsFromClass = JImTableColumnFlags.class)int flags){tableSetupColumn(getBytes(label), flags,-1, 0);}
  public final void tableSetupColumn(@NotNull JImStr label, @MagicConstant(flagsFromClass = JImTableColumnFlags.class)int flags){tableSetupColumn(label.bytes, flags,-1, 0);}
  public final void tableSetupColumn(@NotNull String label){tableSetupColumn(getBytes(label),JImTableColumnFlags.None, -1, 0);}
  public final void tableSetupColumn(@NotNull JImStr label){tableSetupColumn(label.bytes,JImTableColumnFlags.None, -1, 0);}
  /**lock+columns%7Crows+so+they+stay+visible+when+scrolled.*/
  public static native void tableSetupScrollFreeze(int cols, int rows);
  /**submit+all+headers+cells+based+on+data+provided+to+TableSetupColumn%28%29+%2B+submit+context+menu*/
  public static native void tableHeadersRow();
  /**submit+one+header+cell+manually+%28rarely+used%29*/
  public final void tableHeader(@NotNull String label){tableHeader(getBytes(label));}
  /**submit+one+header+cell+manually+%28rarely+used%29*/
  public final void tableHeader(@NotNull JImStr label){tableHeader(label.bytes);}
  protected static native void tableHeader(byte[] label);
  /**return+number+of+columns+%28value+passed+to+BeginTable%29*/
  public static native int tableGetColumnCount();
  /**return+current+column+index.*/
  public static native int tableGetColumnIndex();
  /**return+current+row+index.*/
  public static native int tableGetRowIndex();
  /**return+%22%22+if+column+didn%27t+have+a+name+declared+by+TableSetupColumn%28%29.+Pass+-1+to+use+current+column.*/
  protected static native long tableGetColumnName(int column_n);
  /**return+column+flags+so+you+can+query+their+Enabled%7CVisible%7CSorted%7CHovered+status+flags.+Pass+-1+to+use+current+column.*/
  protected static native int tableGetColumnFlags(int column_n);
  /**change+the+color+of+a+cell%2C+row%2C+or+column.+See+ImGuiTableBgTarget_+flags+for+details.*/
  public static native void tableSetBgColor(@MagicConstant(valuesFromClass = JImTableBgTarget.class)int flags, int u32Color, int column_n);
  /**change+the+color+of+a+cell%2C+row%2C+or+column.+See+ImGuiTableBgTarget_+flags+for+details.*/
  public final void tableSetBgColor(@MagicConstant(valuesFromClass = JImTableBgTarget.class)int flags, int u32Color){tableSetBgColor(flags, u32Color,-1);}
  /**Point+within+RawData%5B%5D*/
  public final void columns(int count, @Nullable String stringID, boolean border){columns(count, getBytes(stringID), border);}
  protected static native void columns(int count, byte[] stringID, boolean border);
  /**Point+within+RawData%5B%5D*/
  public final void columns(int count, @Nullable String stringID){columns(count, getBytes(stringID),true);}
  /**Point+within+RawData%5B%5D*/
  public final void columns(int count){columns(count,(byte[]) null, true);}
  /**Point+within+RawData%5B%5D*/
  public final void columns(){columns(1, (byte[]) null, true);}
  /**next+column%2C+defaults+to+current+row+or+next+row+if+the+current+row+is+finished*/
  public static native void nextColumn();
  /**get+current+column+index*/
  public static native int getColumnIndex();
  /**get+column+width+%28in+pixels%29.+pass+-1+to+use+current+column*/
  public static native float getColumnWidth(int columnIndex);
  /**get+column+width+%28in+pixels%29.+pass+-1+to+use+current+column*/
  public final float getColumnWidth(){return getColumnWidth(-1);}
  /**get+position+of+column+line+%28in+pixels%2C+from+the+left+side+of+the+contents+region%29.+pass+-1+to+use+current+column%2C+otherwise+0..GetColumnsCount%28%29+inclusive.+column+0+is+typically+0.0f*/
  public static native float getColumnOffset(int columnIndex);
  /**get+position+of+column+line+%28in+pixels%2C+from+the+left+side+of+the+contents+region%29.+pass+-1+to+use+current+column%2C+otherwise+0..GetColumnsCount%28%29+inclusive.+column+0+is+typically+0.0f*/
  public final float getColumnOffset(){return getColumnOffset(-1);}
  /**set+column+width+%28in+pixels%29.+pass+-1+to+use+current+column*/
  public static native void setColumnWidth(int columnIndex, float width);
  /**set+position+of+column+line+%28in+pixels%2C+from+the+left+side+of+the+contents+region%29.+pass+-1+to+use+current+column*/
  public static native void setColumnOffset(int columnIndex, float offsetX);
  public static native int getColumnsCount();
  /**create+and+append+into+a+TabBar*/
  public final boolean beginTabBar(@NotNull String stringID, @MagicConstant(flagsFromClass = JImTabBarFlags.class)int flags){return beginTabBar(getBytes(stringID), flags);}
  /**create+and+append+into+a+TabBar*/
  public final boolean beginTabBar(@NotNull JImStr stringID, @MagicConstant(flagsFromClass = JImTabBarFlags.class)int flags){return beginTabBar(stringID.bytes, flags);}
  protected static native boolean beginTabBar(byte[] stringID, @MagicConstant(flagsFromClass = JImTabBarFlags.class)int flags);
  /**create+and+append+into+a+TabBar*/
  public final boolean beginTabBar(@NotNull String stringID){return beginTabBar(getBytes(stringID),JImTabBarFlags.None);}
  /**create+and+append+into+a+TabBar*/
  public final boolean beginTabBar(@NotNull JImStr stringID){return beginTabBar(stringID.bytes,JImTabBarFlags.None);}
  /**only+call+EndTabBar%28%29+if+BeginTabBar%28%29+returns+true%21*/
  public static native void endTabBar();
  /**create+a+Tab.+Returns+true+if+the+Tab+is+selected.*/
  public final boolean beginTabItem(@NotNull String label, @NotNull NativeBool openPtr, @MagicConstant(flagsFromClass = JImTabItemFlags.class)int flags){return beginTabItem(getBytes(label), openPtr.nativeObjectPtr, flags);}
  /**create+a+Tab.+Returns+true+if+the+Tab+is+selected.*/
  public final boolean beginTabItem(@NotNull JImStr label, @NotNull NativeBool openPtr, @MagicConstant(flagsFromClass = JImTabItemFlags.class)int flags){return beginTabItem(label.bytes, openPtr.nativeObjectPtr, flags);}
  protected static native boolean beginTabItem(byte[] label, long openPtr, @MagicConstant(flagsFromClass = JImTabItemFlags.class)int flags);
  /**create+a+Tab.+Returns+true+if+the+Tab+is+selected.*/
  public final boolean beginTabItem(@NotNull String label, @NotNull NativeBool openPtr){return beginTabItem(getBytes(label), openPtr.nativeObjectPtr,JImTabItemFlags.None);}
  /**create+a+Tab.+Returns+true+if+the+Tab+is+selected.*/
  public final boolean beginTabItem(@NotNull JImStr label, @NotNull NativeBool openPtr){return beginTabItem(label.bytes, openPtr.nativeObjectPtr,JImTabItemFlags.None);}
  /**create+a+Tab.+Returns+true+if+the+Tab+is+selected.*/
  public final boolean beginTabItem(@NotNull String label){return beginTabItem(getBytes(label),0, JImTabItemFlags.None);}
  /**create+a+Tab.+Returns+true+if+the+Tab+is+selected.*/
  public final boolean beginTabItem(@NotNull JImStr label){return beginTabItem(label.bytes,0, JImTabItemFlags.None);}
  /**only+call+EndTabItem%28%29+if+BeginTabItem%28%29+returns+true%21*/
  public static native void endTabItem();
  /**create+a+Tab+behaving+like+a+button.+return+true+when+clicked.+cannot+be+selected+in+the+tab+bar.*/
  public final boolean tabItemButton(@NotNull String label, @MagicConstant(flagsFromClass = JImTabItemFlags.class)int flags){return tabItemButton(getBytes(label), flags);}
  /**create+a+Tab+behaving+like+a+button.+return+true+when+clicked.+cannot+be+selected+in+the+tab+bar.*/
  public final boolean tabItemButton(@NotNull JImStr label, @MagicConstant(flagsFromClass = JImTabItemFlags.class)int flags){return tabItemButton(label.bytes, flags);}
  protected static native boolean tabItemButton(byte[] label, @MagicConstant(flagsFromClass = JImTabItemFlags.class)int flags);
  /**create+a+Tab+behaving+like+a+button.+return+true+when+clicked.+cannot+be+selected+in+the+tab+bar.*/
  public final boolean tabItemButton(@NotNull String label){return tabItemButton(getBytes(label),JImTabItemFlags.None);}
  /**create+a+Tab+behaving+like+a+button.+return+true+when+clicked.+cannot+be+selected+in+the+tab+bar.*/
  public final boolean tabItemButton(@NotNull JImStr label){return tabItemButton(label.bytes,JImTabItemFlags.None);}
  /**notify+TabBar+or+Docking+system+of+a+closed+tab%7Cwindow+ahead+%28useful+to+reduce+visual+flicker+on+reorderable+tab+bars%29.+For+tab-bar%3A+call+after+BeginTabBar%28%29+and+before+Tab+submissions.+Otherwise+call+with+a+window+name.*/
  public final void setTabItemClosed(@NotNull String tabOrDockedWindowLabel){setTabItemClosed(getBytes(tabOrDockedWindowLabel));}
  /**notify+TabBar+or+Docking+system+of+a+closed+tab%7Cwindow+ahead+%28useful+to+reduce+visual+flicker+on+reorderable+tab+bars%29.+For+tab-bar%3A+call+after+BeginTabBar%28%29+and+before+Tab+submissions.+Otherwise+call+with+a+window+name.*/
  public final void setTabItemClosed(@NotNull JImStr tabOrDockedWindowLabel){setTabItemClosed(tabOrDockedWindowLabel.bytes);}
  protected static native void setTabItemClosed(byte[] tabOrDockedWindowLabel);
  /**start+logging+to+tty+%28stdout%29*/
  public static native void logToTTY(int maxDepth);
  /**start+logging+to+tty+%28stdout%29*/
  public final void logToTTY(){logToTTY(-1);}
  /**start+logging+to+file*/
  public final void logToFile(int maxDepth, @Nullable String fileName){logToFile(maxDepth, getBytes(fileName));}
  protected static native void logToFile(int maxDepth, byte[] fileName);
  /**start+logging+to+file*/
  public final void logToFile(int maxDepth){logToFile(maxDepth,(byte[]) null);}
  /**start+logging+to+file*/
  public final void logToFile(){logToFile(-1, (byte[]) null);}
  /**start+logging+to+OS+clipboard*/
  public static native void logToClipboard(int maxDepth);
  /**start+logging+to+OS+clipboard*/
  public final void logToClipboard(){logToClipboard(-1);}
  /**stop+logging+%28close+file%2C+etc.%29*/
  public static native void logFinish();
  /**helper+to+display+buttons+for+logging+to+tty%7Cfile%7Cclipboard*/
  public static native void logButtons();
  /**pass+text+data+straight+to+log+%28without+being+displayed%29*/
  public final void logText(@NotNull String text){logText(getBytes(text));}
  /**pass+text+data+straight+to+log+%28without+being+displayed%29*/
  public final void logText(@NotNull JImStr text){logText(text.bytes);}
  protected static native void logText(byte[] text);
  /**Render-level+scissoring.+This+is+passed+down+to+your+render+function+but+not+used+for+CPU-side+coarse+clipping.+Prefer+using+higher-level+ImGui%3A%3APushClipRect%28%29+to+affect+logic+%28hit-testing+and+widget+culling%29*/
  public static native void pushClipRect(float widthClipRectMin, float heightClipRectMin, float widthClipRectMax, float heightClipRectMax, boolean intersectWithCurrentClipRect);
  public static native void popClipRect();
  /**push+width+of+items+for+common+large+%22item%2Blabel%22+widgets.+%3E0.0f%3A+width+in+pixels%2C+%3C0.0f+align+xx+pixels+to+the+right+of+window+%28so+-FLT_MIN+always+align+width+to+the+right+side%29.*/
  public static native void pushItemWidth(float itemWidth);
  public static native void popItemWidth();
  /**set+width+of+the+_next_+common+large+%22item%2Blabel%22+widget.+%3E0.0f%3A+width+in+pixels%2C+%3C0.0f+align+xx+pixels+to+the+right+of+window+%28so+-FLT_MIN+always+align+width+to+the+right+side%29*/
  public static native void setNextItemWidth(float itemWidth);
  /**width+of+item+given+pushed+settings+and+current+cursor+position.+NOT+necessarily+the+width+of+last+item+unlike+most+%27Item%27+functions.*/
  public static native float calcItemWidth();
  /**push+word-wrapping+position+for+Text*%28%29+commands.+%3C+0.0f%3A+no+wrapping%3B+0.0f%3A+wrap+to+end+of+window+%28or+column%29%3B+%3E+0.0f%3A+wrap+at+%27wrap_pos_x%27+position+in+window+local+space*/
  public static native void pushTextWrapPos(float wrapPosX);
  /**push+word-wrapping+position+for+Text*%28%29+commands.+%3C+0.0f%3A+no+wrapping%3B+0.0f%3A+wrap+to+end+of+window+%28or+column%29%3B+%3E+0.0f%3A+wrap+at+%27wrap_pos_x%27+position+in+window+local+space*/
  public final void pushTextWrapPos(){pushTextWrapPos(0);}
  public static native void popTextWrapPos();
  /**%3D%3D+tab+stop+enable.+Allow+focusing+using+TAB%7CShift-TAB%2C+enabled+by+default+but+you+can+disable+it+for+certain+widgets*/
  public static native void pushAllowKeyboardFocus(boolean allowKeyboardFocus);
  public static native void popAllowKeyboardFocus();
  /**in+%27repeat%27+mode%2C+Button*%28%29+functions+return+repeated+true+in+a+typematic+manner+%28using+io.KeyRepeatDelay%7Cio.KeyRepeatRate+setting%29.+Note+that+you+can+call+IsItemActive%28%29+after+any+Button%28%29+to+tell+if+the+button+is+held+in+the+current+frame.*/
  public static native void pushButtonRepeat(boolean repeat);
  /**in+%27repeat%27+mode%2C+Button*%28%29+functions+return+repeated+true+in+a+typematic+manner+%28using+io.KeyRepeatDelay%7Cio.KeyRepeatRate+setting%29.+Note+that+you+can+call+IsItemActive%28%29+after+any+Button%28%29+to+tell+if+the+button+is+held+in+the+current+frame.*/
  public final void pushButtonRepeat(){pushButtonRepeat(false);}
  public static native void popButtonRepeat();
  /**get+current+font+size+%28%3D+height+in+pixels%29+of+current+font+with+current+scale+applied*/
  public static native float getFontSize();
  /**use+NULL+as+a+shortcut+to+push+default+font*/
  public final void pushFont(@NotNull JImFont font){pushFont(font.nativeObjectPtr);}
  protected static native void pushFont(long font);
  public static native void popFont();
  /**modify+a+style+color.+always+use+this+if+you+modify+the+style+after+NewFrame%28%29.*/
  public final void pushStyleColor(@MagicConstant(valuesFromClass = JImStyleColors.class)int index, @NotNull JImVec4 color){pushStyleColor(index, color.nativeObjectPtr);}
  protected static native void pushStyleColor(@MagicConstant(valuesFromClass = JImStyleColors.class)int index, long color);
  public static native void popStyleColor(int count);
  public final void popStyleColor(){popStyleColor(1);}
  protected static native void pushStyleVarImVec2(int styleVar, float valueX, float valueY);
  protected static native void pushStyleVarFloat(int styleVar, float value);
  public static native void popStyleVar(int count);
  public final void popStyleVar(){popStyleVar(1);}
  /**make+last+item+the+default+focused+item+of+a+window.*/
  public static native void setItemDefaultFocus();
  /**focus+keyboard+on+the+next+widget.+Use+positive+%27offset%27+to+access+sub+components+of+a+multiple+component+widget.+Use+-1+to+access+previous+widget.*/
  public static native void setKeyboardFocusHere(int offset);
  /**call+after+CreateContext%28%29+and+before+the+first+call+to+NewFrame%28%29.+NewFrame%28%29+automatically+calls+LoadIniSettingsFromDisk%28io.IniFilename%29.*/
  public final void loadIniSettingsFromDisk(@NotNull String iniFileName){loadIniSettingsFromDisk(getBytes(iniFileName));}
  /**call+after+CreateContext%28%29+and+before+the+first+call+to+NewFrame%28%29.+NewFrame%28%29+automatically+calls+LoadIniSettingsFromDisk%28io.IniFilename%29.*/
  public final void loadIniSettingsFromDisk(@NotNull JImStr iniFileName){loadIniSettingsFromDisk(iniFileName.bytes);}
  protected static native void loadIniSettingsFromDisk(byte[] iniFileName);
  /**this+is+automatically+called+%28if+io.IniFilename+is+not+empty%29+a+few+seconds+after+any+modification+that+should+be+reflected+in+the+.ini+file+%28and+also+by+DestroyContext%29.*/
  public final void saveIniSettingsToDisk(@NotNull String iniFileName){saveIniSettingsToDisk(getBytes(iniFileName));}
  /**this+is+automatically+called+%28if+io.IniFilename+is+not+empty%29+a+few+seconds+after+any+modification+that+should+be+reflected+in+the+.ini+file+%28and+also+by+DestroyContext%29.*/
  public final void saveIniSettingsToDisk(@NotNull JImStr iniFileName){saveIniSettingsToDisk(iniFileName.bytes);}
  protected static native void saveIniSettingsToDisk(byte[] iniFileName);
  /**is+the+last+item+hovered%3F+%28and+usable%2C+aka+not+blocked+by+a+popup%2C+etc.%29.+See+ImGuiHoveredFlags+for+more+options.*/
  public static native boolean isItemHovered(@MagicConstant(flagsFromClass = JImHoveredFlags.class)int flags);
  /**is+the+last+item+hovered%3F+%28and+usable%2C+aka+not+blocked+by+a+popup%2C+etc.%29.+See+ImGuiHoveredFlags+for+more+options.*/
  public final boolean isItemHovered(){return isItemHovered(JImHoveredFlags.None);}
  /**is+the+last+item+active%3F+%28e.g.+button+being+held%2C+text+field+being+edited.+This+will+continuously+return+true+while+holding+mouse+button+on+an+item.+Items+that+don%27t+interact+will+always+return+false%29*/
  public static native boolean isItemActive();
  /**is+the+last+item+focused+for+keyboard%7Cgamepad+navigation%3F*/
  public static native boolean isItemFocused();
  /**is+the+last+item+hovered+and+mouse+clicked+on%3F+%28**%29++%3D%3D+IsMouseClicked%28mouse_button%29+%26%26+IsItemHovered%28%29Important.+%28**%29+this+it+NOT+equivalent+to+the+behavior+of+e.g.+Button%28%29.+Read+comments+in+function+definition.*/
  public static native boolean isItemClicked(int mouseButton);
  /**is+the+last+item+hovered+and+mouse+clicked+on%3F+%28**%29++%3D%3D+IsMouseClicked%28mouse_button%29+%26%26+IsItemHovered%28%29Important.+%28**%29+this+it+NOT+equivalent+to+the+behavior+of+e.g.+Button%28%29.+Read+comments+in+function+definition.*/
  public final boolean isItemClicked(){return isItemClicked(0);}
  /**is+the+last+item+visible%3F+%28items+may+be+out+of+sight+because+of+clipping%7Cscrolling%29*/
  public static native boolean isItemVisible();
  /**was+the+last+item+just+made+inactive+%28item+was+previously+active%29.+Useful+for+Undo%7CRedo+patterns+with+widgets+that+requires+continuous+editing.*/
  public static native boolean isItemDeactivated();
  /**was+the+last+item+just+made+inactive+and+made+a+value+change+when+it+was+active%3F+%28e.g.+Slider%7CDrag+moved%29.+Useful+for+Undo%7CRedo+patterns+with+widgets+that+requires+continuous+editing.+Note+that+you+may+get+false+positives+%28some+widgets+such+as+Combo%28%29%7CListBox%28%29%7CSelectable%28%29+will+return+true+even+when+clicking+an+already+selected+item%29.*/
  public static native boolean isItemDeactivatedAfterEdit();
  /**was+the+last+item+open+state+toggled%3F+set+by+TreeNode%28%29.*/
  public static native boolean IsItemToggledOpen();
  /**is+any+item+hovered%3F*/
  public static native boolean isAnyItemHovered();
  /**is+any+item+active%3F*/
  public static native boolean isAnyItemActive();
  /**is+any+item+focused%3F*/
  public static native boolean isAnyItemFocused();
  /**allow+last+item+to+be+overlapped+by+a+subsequent+item.+sometimes+useful+with+invisible+buttons%2C+selectables%2C+etc.+to+catch+unused+area.*/
  public static native void setItemAllowOverlap();
  /**test+if+rectangle+%28of+given+size%2C+starting+from+cursor+position%29+is+visible+%7C+not+clipped.%0A++test+if+rectangle+%28in+screen+space%29+is+visible+%7C+not+clipped.+to+perform+coarse+clipping+on+user%27s+side.*/
  public static native boolean isRectVisible(float width, float height);
  /**get+global+imgui+time.+incremented+by+io.DeltaTime+every+frame.*/
  public static native float getTime();
  /**get+global+imgui+frame+count.+incremented+by+1+every+frame.*/
  public static native int getFrameCount();
  /**set+scrolling+amount+%5B0+..+GetScrollMaxX%28%29%5D*/
  public static native void setScrollX(float scrollX);
  /**set+scrolling+amount+%5B0+..+GetScrollMaxY%28%29%5D*/
  public static native void setScrollY(float scrollY);
  /**adjust+scrolling+amount+to+make+current+cursor+position+visible.+center_x_ratio%3D0.0%3A+left%2C+0.5%3A+center%2C+1.0%3A+right.+When+using+to+make+a+%22default%7Ccurrent+item%22+visible%2C+consider+using+SetItemDefaultFocus%28%29+instead.*/
  public static native void setScrollHereX(float centerXRatio);
  /**adjust+scrolling+amount+to+make+current+cursor+position+visible.+center_y_ratio%3D0.0%3A+top%2C+0.5%3A+center%2C+1.0%3A+bottom.+When+using+to+make+a+%22default%7Ccurrent+item%22+visible%2C+consider+using+SetItemDefaultFocus%28%29+instead.*/
  public static native void setScrollHereY(float centerYRatio);
  /**adjust+scrolling+amount+to+make+given+position+visible.+Generally+GetCursorStartPos%28%29+%2B+offset+to+compute+a+valid+position.*/
  public static native void setScrollFromPosX(float posX, float centerXRatio);
  /**adjust+scrolling+amount+to+make+given+position+visible.+Generally+GetCursorStartPos%28%29+%2B+offset+to+compute+a+valid+position.*/
  public static native void setScrollFromPosY(float posY, float centerYRatio);
  /**get+scrolling+amount+%5B0+..+GetScrollMaxX%28%29%5D*/
  public static native float getScrollX();
  /**get+scrolling+amount+%5B0+..+GetScrollMaxY%28%29%5D*/
  public static native float getScrollY();
  /**get+maximum+scrolling+amount+%7E%7E+ContentSize.x+-+WindowSize.x+-+DecorationsSize.x*/
  public static native float getScrollMaxX();
  /**get+maximum+scrolling+amount+%7E%7E+ContentSize.y+-+WindowSize.y+-+DecorationsSize.y*/
  public static native float getScrollMaxY();

}