package org.ice1000.jimgui.flag;

import org.ice1000.jimgui.*;
import org.ice1000.jimgui.flag.*;
import org.ice1000.jimgui.cpp.*;
import org.intellij.lang.annotations.*;
import org.jetbrains.annotations.*;
import java.nio.charset.StandardCharsets;

import static org.ice1000.jimgui.util.JImGuiUtil.*;

/**
 * @author ice1000
 * @since undecidable
 */
@SuppressWarnings("ALL")

public interface JImBackendFlags {
  int None = 0;
  /**Backend+Platform+supports+gamepad+and+currently+has+one+connected.*/
  int HasGamepad = 1 << 0;
  /**Backend+Platform+supports+honoring+GetMouseCursor%28%29+value+to+change+the+OS+cursor+shape.*/
  int HasMouseCursors = 1 << 1;
  /**Backend+Platform+supports+io.WantSetMousePos+requests+to+reposition+the+OS+mouse+position+%28only+used+if+ImGuiConfigFlags_NavEnableSetMousePos+is+set%29.*/
  int HasSetMousePos = 1 << 2;
  /**Backend+Renderer+supports+ImDrawCmd%3A%3AVtxOffset.+This+enables+output+of+large+meshes+%2864K%2B+vertices%29+while+still+using+16-bit+indices.*/
  int RendererHasVtxOffset = 1 << 3;
  enum Type implements Flag {
    None(JImBackendFlags.None),
    HasGamepad(JImBackendFlags.HasGamepad),
    HasMouseCursors(JImBackendFlags.HasMouseCursors),
    HasSetMousePos(JImBackendFlags.HasSetMousePos),
    RendererHasVtxOffset(JImBackendFlags.RendererHasVtxOffset),
    ;
    public final int flag;
    Type(int flag) { this.flag = flag; }
    @Override public int get() { return flag; }
  }
}
