package org.ice1000.jimgui;

import org.ice1000.jimgui.*;
import org.ice1000.jimgui.flag.*;
import org.ice1000.jimgui.cpp.*;
import org.intellij.lang.annotations.*;
import org.jetbrains.annotations.*;
import java.nio.charset.StandardCharsets;

import static org.ice1000.jimgui.util.JImGuiUtil.*;

/**
 * @author ice1000
 * @since v0.13
 */
@SuppressWarnings("ALL")

public class JImFileDialogGen {
  /** package-private by design */
  JImFileDialogGen(long nativeObjectPtr) {
    this.nativeObjectPtr = nativeObjectPtr;
  }

  protected long nativeObjectPtr;

  public final boolean display(@NotNull String key, @MagicConstant(flagsFromClass = JImWindowFlags.class)int flags, float widthMin, float heightMin, float widthMax, float heightMax, long nativeObjectPtr){return display(getBytes(key), flags, widthMin, heightMin, widthMax, heightMax, nativeObjectPtr);}
  public final boolean display(@NotNull JImStr key, @MagicConstant(flagsFromClass = JImWindowFlags.class)int flags, float widthMin, float heightMin, float widthMax, float heightMax, long nativeObjectPtr){return display(key.bytes, flags, widthMin, heightMin, widthMax, heightMax, nativeObjectPtr);}
  protected static native boolean display(byte[] key, @MagicConstant(flagsFromClass = JImWindowFlags.class)int flags, float widthMin, float heightMin, float widthMax, float heightMax, long nativeObjectPtr);
  public final boolean display(@NotNull String key, @MagicConstant(flagsFromClass = JImWindowFlags.class)int flags, float widthMin, float heightMin, float widthMax, float heightMax){return display(getBytes(key), flags, widthMin, heightMin, widthMax, heightMax,this.nativeObjectPtr);}
  public final boolean display(@NotNull JImStr key, @MagicConstant(flagsFromClass = JImWindowFlags.class)int flags, float widthMin, float heightMin, float widthMax, float heightMax){return display(key.bytes, flags, widthMin, heightMin, widthMax, heightMax,this.nativeObjectPtr);}
  public final boolean display(@NotNull String key, @MagicConstant(flagsFromClass = JImWindowFlags.class)int flags, float widthMin, float heightMin){return display(getBytes(key), flags, widthMin, heightMin,FLT_MAX, FLT_MAX, this.nativeObjectPtr);}
  public final boolean display(@NotNull JImStr key, @MagicConstant(flagsFromClass = JImWindowFlags.class)int flags, float widthMin, float heightMin){return display(key.bytes, flags, widthMin, heightMin,FLT_MAX, FLT_MAX, this.nativeObjectPtr);}
  public final boolean display(@NotNull String key, @MagicConstant(flagsFromClass = JImWindowFlags.class)int flags){return display(getBytes(key), flags,0, 0, FLT_MAX, FLT_MAX, this.nativeObjectPtr);}
  public final boolean display(@NotNull JImStr key, @MagicConstant(flagsFromClass = JImWindowFlags.class)int flags){return display(key.bytes, flags,0, 0, FLT_MAX, FLT_MAX, this.nativeObjectPtr);}
  public final boolean display(@NotNull String key){return display(getBytes(key),JImWindowFlags.None, 0, 0, FLT_MAX, FLT_MAX, this.nativeObjectPtr);}
  public final boolean display(@NotNull JImStr key){return display(key.bytes,JImWindowFlags.None, 0, 0, FLT_MAX, FLT_MAX, this.nativeObjectPtr);}
  public final void openDialog(@NotNull String key, @NotNull String title, @NotNull String filters, @NotNull String basePath, int maxSelection, long nativeObjectPtr){openDialog(getBytes(key), getBytes(title), getBytes(filters), getBytes(basePath), maxSelection, nativeObjectPtr);}
  public final void openDialog(@NotNull JImStr key, @NotNull JImStr title, @NotNull JImStr filters, @NotNull JImStr basePath, int maxSelection, long nativeObjectPtr){openDialog(key.bytes, title.bytes, filters.bytes, basePath.bytes, maxSelection, nativeObjectPtr);}
  protected static native void openDialog(byte[] key, byte[] title, byte[] filters, byte[] basePath, int maxSelection, long nativeObjectPtr);
  public final void openDialog(@NotNull String key, @NotNull String title, @NotNull String filters, @NotNull String basePath, int maxSelection){openDialog(getBytes(key), getBytes(title), getBytes(filters), getBytes(basePath), maxSelection,this.nativeObjectPtr);}
  public final void openDialog(@NotNull JImStr key, @NotNull JImStr title, @NotNull JImStr filters, @NotNull JImStr basePath, int maxSelection){openDialog(key.bytes, title.bytes, filters.bytes, basePath.bytes, maxSelection,this.nativeObjectPtr);}
  public final void openDialog(@NotNull String key, @NotNull String title, @NotNull String filters, @NotNull String basePath){openDialog(getBytes(key), getBytes(title), getBytes(filters), getBytes(basePath),1, this.nativeObjectPtr);}
  public final void openDialog(@NotNull JImStr key, @NotNull JImStr title, @NotNull JImStr filters, @NotNull JImStr basePath){openDialog(key.bytes, title.bytes, filters.bytes, basePath.bytes,1, this.nativeObjectPtr);}
  public final void openModal(@NotNull String key, @NotNull String title, @NotNull String filters, @NotNull String basePath, int maxSelection, long nativeObjectPtr){openModal(getBytes(key), getBytes(title), getBytes(filters), getBytes(basePath), maxSelection, nativeObjectPtr);}
  public final void openModal(@NotNull JImStr key, @NotNull JImStr title, @NotNull JImStr filters, @NotNull JImStr basePath, int maxSelection, long nativeObjectPtr){openModal(key.bytes, title.bytes, filters.bytes, basePath.bytes, maxSelection, nativeObjectPtr);}
  protected static native void openModal(byte[] key, byte[] title, byte[] filters, byte[] basePath, int maxSelection, long nativeObjectPtr);
  public final void openModal(@NotNull String key, @NotNull String title, @NotNull String filters, @NotNull String basePath, int maxSelection){openModal(getBytes(key), getBytes(title), getBytes(filters), getBytes(basePath), maxSelection,this.nativeObjectPtr);}
  public final void openModal(@NotNull JImStr key, @NotNull JImStr title, @NotNull JImStr filters, @NotNull JImStr basePath, int maxSelection){openModal(key.bytes, title.bytes, filters.bytes, basePath.bytes, maxSelection,this.nativeObjectPtr);}
  public final void openModal(@NotNull String key, @NotNull String title, @NotNull String filters, @NotNull String basePath){openModal(getBytes(key), getBytes(title), getBytes(filters), getBytes(basePath),1, this.nativeObjectPtr);}
  public final void openModal(@NotNull JImStr key, @NotNull JImStr title, @NotNull JImStr filters, @NotNull JImStr basePath){openModal(key.bytes, title.bytes, filters.bytes, basePath.bytes,1, this.nativeObjectPtr);}
  public static native void close(long nativeObjectPtr);
  public final void close(){close(this.nativeObjectPtr);}
  public static native boolean isOk(long nativeObjectPtr);
  public final boolean isOk(){return isOk(this.nativeObjectPtr);}
  public final boolean wasOpenedThisFrame(@NotNull String key, long nativeObjectPtr){return wasOpenedThisFrame(getBytes(key), nativeObjectPtr);}
  public final boolean wasOpenedThisFrame(@NotNull JImStr key, long nativeObjectPtr){return wasOpenedThisFrame(key.bytes, nativeObjectPtr);}
  protected static native boolean wasOpenedThisFrame(byte[] key, long nativeObjectPtr);
  public final boolean wasOpenedThisFrame(@NotNull String key){return wasOpenedThisFrame(getBytes(key),this.nativeObjectPtr);}
  public final boolean wasOpenedThisFrame(@NotNull JImStr key){return wasOpenedThisFrame(key.bytes,this.nativeObjectPtr);}
  public final boolean isOpened(@NotNull String text, long nativeObjectPtr){return isOpened(getBytes(text), nativeObjectPtr);}
  public final boolean isOpened(@NotNull JImStr text, long nativeObjectPtr){return isOpened(text.bytes, nativeObjectPtr);}
  protected static native boolean isOpened(byte[] text, long nativeObjectPtr);
  public final boolean isOpened(@NotNull String text){return isOpened(getBytes(text),this.nativeObjectPtr);}
  public final boolean isOpened(@NotNull JImStr text){return isOpened(text.bytes,this.nativeObjectPtr);}
  public final void setFileStyle(@MagicConstant(flagsFromClass = JImFDStyleFlags.class)int flags, @NotNull String criteria, @NotNull JImVec4 color, @NotNull String icon, long nativeObjectPtr){setFileStyle(flags, getBytes(criteria), color.nativeObjectPtr, getBytes(icon), nativeObjectPtr);}
  public final void setFileStyle(@MagicConstant(flagsFromClass = JImFDStyleFlags.class)int flags, @NotNull JImStr criteria, @NotNull JImVec4 color, @NotNull JImStr icon, long nativeObjectPtr){setFileStyle(flags, criteria.bytes, color.nativeObjectPtr, icon.bytes, nativeObjectPtr);}
  protected static native void setFileStyle(@MagicConstant(flagsFromClass = JImFDStyleFlags.class)int flags, byte[] criteria, long color, byte[] icon, long nativeObjectPtr);
  public final void setFileStyle(@MagicConstant(flagsFromClass = JImFDStyleFlags.class)int flags, @NotNull String criteria, @NotNull JImVec4 color, @NotNull String icon){setFileStyle(flags, getBytes(criteria), color.nativeObjectPtr, getBytes(icon),this.nativeObjectPtr);}
  public final void setFileStyle(@MagicConstant(flagsFromClass = JImFDStyleFlags.class)int flags, @NotNull JImStr criteria, @NotNull JImVec4 color, @NotNull JImStr icon){setFileStyle(flags, criteria.bytes, color.nativeObjectPtr, icon.bytes,this.nativeObjectPtr);}
  public final void getFileStyle(@MagicConstant(flagsFromClass = JImFDStyleFlags.class)int flags, @NotNull String criteria, @NotNull JImVec4 color, @NotNull NativeString icon, long nativeObjectPtr){getFileStyle(flags, getBytes(criteria), color.nativeObjectPtr, icon.nativeObjectPtr, nativeObjectPtr);}
  public final void getFileStyle(@MagicConstant(flagsFromClass = JImFDStyleFlags.class)int flags, @NotNull JImStr criteria, @NotNull JImVec4 color, @NotNull NativeString icon, long nativeObjectPtr){getFileStyle(flags, criteria.bytes, color.nativeObjectPtr, icon.nativeObjectPtr, nativeObjectPtr);}
  protected static native void getFileStyle(@MagicConstant(flagsFromClass = JImFDStyleFlags.class)int flags, byte[] criteria, long color, long icon, long nativeObjectPtr);
  public final void getFileStyle(@MagicConstant(flagsFromClass = JImFDStyleFlags.class)int flags, @NotNull String criteria, @NotNull JImVec4 color, @NotNull NativeString icon){getFileStyle(flags, getBytes(criteria), color.nativeObjectPtr, icon.nativeObjectPtr,this.nativeObjectPtr);}
  public final void getFileStyle(@MagicConstant(flagsFromClass = JImFDStyleFlags.class)int flags, @NotNull JImStr criteria, @NotNull JImVec4 color, @NotNull NativeString icon){getFileStyle(flags, criteria.bytes, color.nativeObjectPtr, icon.nativeObjectPtr,this.nativeObjectPtr);}
  public static native void clearFilesStyle(long nativeObjectPtr);
  public final void clearFilesStyle(){clearFilesStyle(this.nativeObjectPtr);}

}