package org.ice1000.jimgui;

import org.ice1000.jimgui.*;
import org.ice1000.jimgui.flag.*;
import org.ice1000.jimgui.cpp.*;
import org.intellij.lang.annotations.*;
import org.jetbrains.annotations.*;
import java.nio.charset.StandardCharsets;

import static org.ice1000.jimgui.util.JImGuiUtil.*;

/**
 * @author ice1000
 * @since v0.1
 */
@SuppressWarnings("ALL")

public class JImGuiFontGen {
  @Contract(pure = true)
  public static @NotNull JImFont getInstance(@NotNull JImGui owner) {
    return owner.getFont();
  }

  /** package-private by design */
  protected long nativeObjectPtr;

  /** package-private by design */
  JImGuiFontGen(long nativeObjectPtr) {
    this.nativeObjectPtr = nativeObjectPtr;
  }

  /**4+++++%7C%7C+in++%7C%7C++++++++++++%7C%7C+Height+of+characters%7Cline%2C+set+during+loading+%28don%27t+change+after+loading%29%0A++Current%7Cdefault+font+size+%28optional%2C+for+simplified+AddText+overload%29*/
  public float getFontSize(){return getFontSize(nativeObjectPtr);}
  protected static native float getFontSize(long nativeObjectPtr);
  /**4+++++%7C%7C+in++%7C%7C++++++++++++%7C%7C+Height+of+characters%7Cline%2C+set+during+loading+%28don%27t+change+after+loading%29%0A++Current%7Cdefault+font+size+%28optional%2C+for+simplified+AddText+overload%29*/
  public void setFontSize(float newValue) {setFontSize(nativeObjectPtr, newValue);}
  protected static native void setFontSize(long nativeObjectPtr, float newValue);
  public float getScale(){return getScale(nativeObjectPtr);}
  protected static native float getScale(long nativeObjectPtr);
  public void setScale(float newValue) {setScale(nativeObjectPtr, newValue);}
  protected static native void setScale(long nativeObjectPtr, float newValue);
  public float getFallbackAdvanceX(){return getFallbackAdvanceX(nativeObjectPtr);}
  protected static native float getFallbackAdvanceX(long nativeObjectPtr);
  public void setFallbackAdvanceX(float newValue) {setFallbackAdvanceX(nativeObjectPtr, newValue);}
  protected static native void setFallbackAdvanceX(long nativeObjectPtr, float newValue);
  /**2+++++%7C%7C+in++%7C%7C+%7E+1++++++++%7C%7C+Number+of+ImFontConfig+involved+in+creating+this+font.+Bigger+than+1+when+merging+multiple+font+sources+into+one+ImFont.*/
  public short getConfigDataCount(){return getConfigDataCount(nativeObjectPtr);}
  protected static native short getConfigDataCount(long nativeObjectPtr);
  /**2+++++%7C%7C+in++%7C%7C+%7E+1++++++++%7C%7C+Number+of+ImFontConfig+involved+in+creating+this+font.+Bigger+than+1+when+merging+multiple+font+sources+into+one+ImFont.*/
  public void setConfigDataCount(short newValue) {setConfigDataCount(nativeObjectPtr, newValue);}
  protected static native void setConfigDataCount(long nativeObjectPtr, short newValue);
  public float getAscent(){return getAscent(nativeObjectPtr);}
  protected static native float getAscent(long nativeObjectPtr);
  public void setAscent(float newValue) {setAscent(nativeObjectPtr, newValue);}
  protected static native void setAscent(long nativeObjectPtr, float newValue);
  /**4%2B4+++%7C%7C+out+%7C%7C++++++++++++%7C%7C+Ascent%3A+distance+from+top+to+bottom+of+e.g.+%27A%27+%5B0..FontSize%5D*/
  public float getDescent(){return getDescent(nativeObjectPtr);}
  protected static native float getDescent(long nativeObjectPtr);
  /**4%2B4+++%7C%7C+out+%7C%7C++++++++++++%7C%7C+Ascent%3A+distance+from+top+to+bottom+of+e.g.+%27A%27+%5B0..FontSize%5D*/
  public void setDescent(float newValue) {setDescent(nativeObjectPtr, newValue);}
  protected static native void setDescent(long nativeObjectPtr, float newValue);
  /**4+++++%7C%7C+out+%7C%7C++++++++++++%7C%7C+Total+surface+in+pixels+to+get+an+idea+of+the+font+rasterization%7Ctexture+cost+%28not+exact%2C+we+approximate+the+cost+of+padding+between+glyphs%29*/
  public int getMetricsTotalSurface(){return getMetricsTotalSurface(nativeObjectPtr);}
  protected static native int getMetricsTotalSurface(long nativeObjectPtr);
  /**4+++++%7C%7C+out+%7C%7C++++++++++++%7C%7C+Total+surface+in+pixels+to+get+an+idea+of+the+font+rasterization%7Ctexture+cost+%28not+exact%2C+we+approximate+the+cost+of+padding+between+glyphs%29*/
  public void setMetricsTotalSurface(int newValue) {setMetricsTotalSurface(nativeObjectPtr, newValue);}
  protected static native void setMetricsTotalSurface(long nativeObjectPtr, int newValue);
  /**1+++++%7C%7C+out*/
  public boolean isDirtyLookupTables(){return isDirtyLookupTables(this.nativeObjectPtr);}
  public static native boolean isDirtyLookupTables(long nativeObjectPtr);
  /**1+++++%7C%7C+out*/
  public void setDirtyLookupTables(boolean newValue){setDirtyLookupTables(this.nativeObjectPtr,newValue);}
  public static native void setDirtyLookupTables(long nativeObjectPtr, boolean newValue);
  private static native void clearOutputData(long nativeObjectPtr);
  public final void clearOutputData(){clearOutputData(this.nativeObjectPtr);}
  private static native boolean isLoaded(long nativeObjectPtr);
  public final boolean isLoaded(){return isLoaded(this.nativeObjectPtr);}
  private static native long getDebugName(long nativeObjectPtr);
  public final long getDebugName(){return getDebugName(this.nativeObjectPtr);}
  private static native void growIndex(int newSize, long nativeObjectPtr);
  public final void growIndex(int newSize){growIndex(newSize,this.nativeObjectPtr);}
  /**Makes+%27dst%27+character%7Cglyph+points+to+%27src%27+character%7Cglyph.+Currently+needs+to+be+called+AFTER+fonts+have+been+built.*/
  private static native void addRemapChar(int dst, int src, boolean overwriteDst, long nativeObjectPtr);
  /**Makes+%27dst%27+character%7Cglyph+points+to+%27src%27+character%7Cglyph.+Currently+needs+to+be+called+AFTER+fonts+have+been+built.*/
  public final void addRemapChar(int dst, int src, boolean overwriteDst){addRemapChar(dst, src, overwriteDst,this.nativeObjectPtr);}
  /**Makes+%27dst%27+character%7Cglyph+points+to+%27src%27+character%7Cglyph.+Currently+needs+to+be+called+AFTER+fonts+have+been+built.*/
  public final void addRemapChar(int dst, int src){addRemapChar(dst, src,true, this.nativeObjectPtr);}
  private static native void buildLookupTable(long nativeObjectPtr);
  public final void buildLookupTable(){buildLookupTable(this.nativeObjectPtr);}
  private final void renderChar(@NotNull JImDrawList drawList, float size, float posX, float posY, int u32Color, short c, long nativeObjectPtr){renderChar(drawList.nativeObjectPtr, size, posX, posY, u32Color, c, nativeObjectPtr);}
  protected static native void renderChar(long drawList, float size, float posX, float posY, int u32Color, short c, long nativeObjectPtr);
  public final void renderChar(@NotNull JImDrawList drawList, float size, float posX, float posY, int u32Color, short c){renderChar(drawList.nativeObjectPtr, size, posX, posY, u32Color, c,this.nativeObjectPtr);}

}