
package org.ice1000.jimgui;
import org.ice1000.jimgui.cpp.*;
import org.jetbrains.annotations.*;

/**
 * @author ice1000
 * @since v0.1
 */
@SuppressWarnings("ALL")
public final class NativeLong extends Number implements DeallocatableObject, Cloneable {
  /** package-private by design */
  long nativeObjectPtr;
  @Contract public NativeLong() { nativeObjectPtr = allocateNativeObject(); }
  @Contract(pure = true) public NativeLong(long nativeObjectPtr) { this.nativeObjectPtr = nativeObjectPtr; }

  @Override @Contract
  public void deallocateNativeObject() { deallocateNativeObject0(nativeObjectPtr); nativeObjectPtr = 0; }
  @Contract(pure = true) public long accessValue() { return accessValue(nativeObjectPtr); }
  @Contract public void increaseValue(long increment) { increaseValue(nativeObjectPtr, increment); }
  @Contract public void modifyValue(long newValue) { modifyValue(nativeObjectPtr, newValue); }

  @Override @Contract(pure = true) public int intValue() { return (int) accessValue(); }
  @Override @Contract(pure = true) public long longValue() { return (long) accessValue(); }
  @Override @Contract(pure = true) public float floatValue() { return (float) accessValue(); }
  @Override @Contract(pure = true) public double doubleValue() { return (double) accessValue(); }

  private static native long accessValue(long nativeObjectPtr);
  private static native void modifyValue(long nativeObjectPtr, long newValue);
  private static native void increaseValue(long nativeObjectPtr, long increment);
  private static native long allocateNativeObject();
  private static native void deallocateNativeObject0(long nativeObjectPtr);

  @Override @Contract(value = "null -> false", pure = true)
  public boolean equals(@Nullable Object o) {
    return this == o || o instanceof NativeLong && nativeObjectPtr == ((NativeLong) o).nativeObjectPtr;
  }
  @Override @Contract(pure = true)
  public int hashCode() { return Long.hashCode(nativeObjectPtr); }
  @Override public @NotNull String toString() { return String.valueOf(accessValue()); }
  @Override @Contract public @NotNull NativeLong clone() {
    NativeLong newInstance = new NativeLong();
    newInstance.modifyValue(accessValue());
    return newInstance;
  }
}
