package org.ice1000.jimgui.flag;

import org.ice1000.jimgui.*;
import org.ice1000.jimgui.flag.*;
import org.ice1000.jimgui.cpp.*;
import org.intellij.lang.annotations.*;
import org.jetbrains.annotations.*;
import java.nio.charset.StandardCharsets;

import static org.ice1000.jimgui.util.JImGuiUtil.*;

/**
 * @author ice1000
 * @since undecidable
 */
@SuppressWarnings("ALL")

public interface JImComboFlags {
  int None = 0;
  /**Align+the+popup+toward+the+left+by+default*/
  int PopupAlignLeft = 1 << 0;
  /**Max+%7E4+items+visible.+Tip%3A+If+you+want+your+combo+popup+to+be+a+specific+size+you+can+use+SetNextWindowSizeConstraints%28%29+prior+to+calling+BeginCombo%28%29*/
  int HeightSmall = 1 << 1;
  /**Max+%7E8+items+visible+%28default%29*/
  int HeightRegular = 1 << 2;
  /**Max+%7E20+items+visible*/
  int HeightLarge = 1 << 3;
  /**As+many+fitting+items+as+possible*/
  int HeightLargest = 1 << 4;
  /**Display+on+the+preview+box+without+the+square+arrow+button*/
  int NoArrowButton = 1 << 5;
  /**Display+only+a+square+arrow+button*/
  int NoPreview = 1 << 6;
  enum Type implements Flag {
    None(JImComboFlags.None),
    PopupAlignLeft(JImComboFlags.PopupAlignLeft),
    HeightSmall(JImComboFlags.HeightSmall),
    HeightRegular(JImComboFlags.HeightRegular),
    HeightLarge(JImComboFlags.HeightLarge),
    HeightLargest(JImComboFlags.HeightLargest),
    NoArrowButton(JImComboFlags.NoArrowButton),
    NoPreview(JImComboFlags.NoPreview),
    ;
    public final int flag;
    Type(int flag) { this.flag = flag; }
    @Override public int get() { return flag; }
  }
}
