package org.ice1000.jimgui.flag;

import org.ice1000.jimgui.*;
import org.ice1000.jimgui.flag.*;
import org.ice1000.jimgui.cpp.*;
import org.intellij.lang.annotations.*;
import org.jetbrains.annotations.*;
import java.nio.charset.StandardCharsets;

import static org.ice1000.jimgui.util.JImGuiUtil.*;

/**
 * @author ice1000
 * @since undecidable
 */
@SuppressWarnings("ALL")

public interface JImFocusedFlags {
  int None = 0;
  /**Return+true+if+any+children+of+the+window+is+focused*/
  int ChildWindows = 1 << 0;
  /**Test+from+root+window+%28top+most+parent+of+the+current+hierarchy%29*/
  int RootWindow = 1 << 1;
  /**Return+true+if+any+window+is+focused.+Important%3A+If+you+are+trying+to+tell+how+to+dispatch+your+low-level+inputs%2C+do+NOT+use+this.+Use+%27io.WantCaptureMouse%27+instead%21+Please+read+the+FAQ%21*/
  int AnyWindow = 1 << 2;
  /**Do+not+consider+popup+hierarchy+%28do+not+treat+popup+emitter+as+parent+of+popup%29+%28when+used+with+_ChildWindows+or+_RootWindow%29*/
  int NoPopupHierarchy = 1 << 2;
  int RootAndChildWindows = RootWindow | ChildWindows;
  enum Type implements Flag {
    None(JImFocusedFlags.None),
    ChildWindows(JImFocusedFlags.ChildWindows),
    RootWindow(JImFocusedFlags.RootWindow),
    AnyWindow(JImFocusedFlags.AnyWindow),
    NoPopupHierarchy(JImFocusedFlags.NoPopupHierarchy),
    RootAndChildWindows(JImFocusedFlags.RootAndChildWindows),
    ;
    public final int flag;
    Type(int flag) { this.flag = flag; }
    @Override public int get() { return flag; }
  }
}
