package org.ice1000.jimgui.flag;

import org.ice1000.jimgui.*;
import org.ice1000.jimgui.flag.*;
import org.ice1000.jimgui.cpp.*;
import org.intellij.lang.annotations.*;
import org.jetbrains.annotations.*;
import java.nio.charset.StandardCharsets;

import static org.ice1000.jimgui.util.JImGuiUtil.*;

/**
 * @author ice1000
 * @since undecidable
 */
@SuppressWarnings("ALL")

public interface JImTableColumnFlags {
  int None = 0;
  /**Default+as+a+hidden%7Cdisabled+column.*/
  int DefaultHide = 1 << 0;
  /**Default+as+a+sorting+column.*/
  int DefaultSort = 1 << 1;
  /**Column+will+stretch.+Preferable+with+horizontal+scrolling+disabled+%28default+if+table+sizing+policy+is+_SizingStretchSame+or+_SizingStretchProp%29.*/
  int WidthStretch = 1 << 2;
  /**Column+will+not+stretch.+Preferable+with+horizontal+scrolling+enabled+%28default+if+table+sizing+policy+is+_SizingFixedFit+and+table+is+resizable%29.*/
  int WidthFixed = 1 << 3;
  /**Disable+manual+resizing.*/
  int NoResize = 1 << 5;
  /**Disable+manual+reordering+this+column%2C+this+will+also+prevent+other+columns+from+crossing+over+this+column.*/
  int NoReorder = 1 << 6;
  /**Disable+ability+to+hide%7Cdisable+this+column.*/
  int NoHide = 1 << 7;
  /**Disable+clipping+for+this+column+%28all+NoClip+columns+will+render+in+a+same+draw+command%29.*/
  int NoClip = 1 << 8;
  /**Disable+ability+to+sort+on+this+field+%28even+if+ImGuiTableFlags_Sortable+is+set+on+the+table%29.*/
  int NoSort = 1 << 9;
  /**Disable+ability+to+sort+in+the+ascending+direction.*/
  int NoSortAscending = 1 << 10;
  /**Disable+ability+to+sort+in+the+descending+direction.*/
  int NoSortDescending = 1 << 11;
  /**Disable+header+text+width+contribution+to+automatic+column+width.*/
  int NoHeaderWidth = 1 << 12;
  /**Make+the+initial+sort+direction+Ascending+when+first+sorting+on+this+column+%28default%29.*/
  int PreferSortAscending = 1 << 13;
  /**Make+the+initial+sort+direction+Descending+when+first+sorting+on+this+column.*/
  int PreferSortDescending = 1 << 14;
  /**Use+current+Indent+value+when+entering+cell+%28default+for+column+0%29.*/
  int IndentEnable = 1 << 15;
  /**Ignore+current+Indent+value+when+entering+cell+%28default+for+columns+%3E+0%29.+Indentation+changes+_within_+the+cell+will+still+be+honored.*/
  int IndentDisable = 1 << 16;
  /**Status%3A+is+enabled+%3D%3D+not+hidden+by+user%7Capi+%28referred+to+as+%22Hide%22+in+_DefaultHide+and+_NoHide%29+flags.*/
  int IsEnabled = 1 << 20;
  /**Status%3A+is+visible+%3D%3D+is+enabled+AND+not+clipped+by+scrolling.*/
  int IsVisible = 1 << 21;
  /**Status%3A+is+currently+part+of+the+sort+specs*/
  int IsSorted = 1 << 22;
  /**Status%3A+is+hovered+by+mouse*/
  int IsHovered = 1 << 23;
  int WidthMask = WidthStretch | WidthFixed;
  int IndentMask = IndentEnable | IndentDisable;
  int StatusMask = IsEnabled | IsVisible | IsSorted | IsHovered;
  int NoDirectResize = 1 << 30;
  enum Type implements Flag {
    None(JImTableColumnFlags.None),
    DefaultHide(JImTableColumnFlags.DefaultHide),
    DefaultSort(JImTableColumnFlags.DefaultSort),
    WidthStretch(JImTableColumnFlags.WidthStretch),
    WidthFixed(JImTableColumnFlags.WidthFixed),
    NoResize(JImTableColumnFlags.NoResize),
    NoReorder(JImTableColumnFlags.NoReorder),
    NoHide(JImTableColumnFlags.NoHide),
    NoClip(JImTableColumnFlags.NoClip),
    NoSort(JImTableColumnFlags.NoSort),
    NoSortAscending(JImTableColumnFlags.NoSortAscending),
    NoSortDescending(JImTableColumnFlags.NoSortDescending),
    NoHeaderWidth(JImTableColumnFlags.NoHeaderWidth),
    PreferSortAscending(JImTableColumnFlags.PreferSortAscending),
    PreferSortDescending(JImTableColumnFlags.PreferSortDescending),
    IndentEnable(JImTableColumnFlags.IndentEnable),
    IndentDisable(JImTableColumnFlags.IndentDisable),
    IsEnabled(JImTableColumnFlags.IsEnabled),
    IsVisible(JImTableColumnFlags.IsVisible),
    IsSorted(JImTableColumnFlags.IsSorted),
    IsHovered(JImTableColumnFlags.IsHovered),
    WidthMask(JImTableColumnFlags.WidthMask),
    IndentMask(JImTableColumnFlags.IndentMask),
    StatusMask(JImTableColumnFlags.StatusMask),
    NoDirectResize(JImTableColumnFlags.NoDirectResize),
    ;
    public final int flag;
    Type(int flag) { this.flag = flag; }
    @Override public int get() { return flag; }
  }
}
