package org.ice1000.jimgui.flag;

import org.ice1000.jimgui.*;
import org.ice1000.jimgui.flag.*;
import org.ice1000.jimgui.cpp.*;
import org.intellij.lang.annotations.*;
import org.jetbrains.annotations.*;
import java.nio.charset.StandardCharsets;

import static org.ice1000.jimgui.util.JImGuiUtil.*;

/**
 * @author ice1000
 * @since undecidable
 */
@SuppressWarnings("ALL")

public interface JImWindowFlags {
  int None = 0;
  /**Disable+title-bar*/
  int NoTitleBar = 1 << 0;
  /**Disable+user+resizing+with+the+lower-right+grip*/
  int NoResize = 1 << 1;
  /**Disable+user+moving+the+window*/
  int NoMove = 1 << 2;
  /**Disable+scrollbars+%28window+can+still+scroll+with+mouse+or+programmatically%29*/
  int NoScrollbar = 1 << 3;
  /**Disable+user+vertically+scrolling+with+mouse+wheel.+On+child+window%2C+mouse+wheel+will+be+forwarded+to+the+parent+unless+NoScrollbar+is+also+set.*/
  int NoScrollWithMouse = 1 << 4;
  /**Disable+user+collapsing+window+by+double-clicking+on+it.+Also+referred+to+as+Window+Menu+Button+%28e.g.+within+a+docking+node%29.*/
  int NoCollapse = 1 << 5;
  /**Resize+every+window+to+its+content+every+frame*/
  int AlwaysAutoResize = 1 << 6;
  /**Disable+drawing+background+color+%28WindowBg%2C+etc.%29+and+outside+border.+Similar+as+using+SetNextWindowBgAlpha%280.0f%29.*/
  int NoBackground = 1 << 7;
  /**Never+load%7Csave+settings+in+.ini+file*/
  int NoSavedSettings = 1 << 8;
  /**Disable+catching+mouse%2C+hovering+test+with+pass+through.*/
  int NoMouseInputs = 1 << 9;
  /**Has+a+menu-bar*/
  int MenuBar = 1 << 10;
  /**Allow+horizontal+scrollbar+to+appear+%28off+by+default%29.+You+may+use+SetNextWindowContentSize%28ImVec2%28width%2C0.0f%29%29%3B+prior+to+calling+Begin%28%29+to+specify+width.+Read+code+in+imgui_demo+in+the+%22Horizontal+Scrolling%22+section.*/
  int HorizontalScrollbar = 1 << 11;
  /**Disable+taking+focus+when+transitioning+from+hidden+to+visible+state*/
  int NoFocusOnAppearing = 1 << 12;
  /**Disable+bringing+window+to+front+when+taking+focus+%28e.g.+clicking+on+it+or+programmatically+giving+it+focus%29*/
  int NoBringToFrontOnFocus = 1 << 13;
  /**Always+show+vertical+scrollbar+%28even+if+ContentSize.y+%3C+Size.y%29*/
  int AlwaysVerticalScrollbar = 1 << 14;
  /**Always+show+horizontal+scrollbar+%28even+if+ContentSize.x+%3C+Size.x%29*/
  int AlwaysHorizontalScrollbar = 1<< 15;
  /**Ensure+child+windows+without+border+uses+style.WindowPadding+%28ignored+by+default+for+non-bordered+child+windows%2C+because+more+convenient%29*/
  int AlwaysUseWindowPadding = 1 << 16;
  /**No+gamepad%7Ckeyboard+navigation+within+the+window*/
  int NoNavInputs = 1 << 18;
  /**No+focusing+toward+this+window+with+gamepad%7Ckeyboard+navigation+%28e.g.+skipped+by+CTRL%2BTAB%29*/
  int NoNavFocus = 1 << 19;
  /**Display+a+dot+next+to+the+title.+When+used+in+a+tab%7Cdocking+context%2C+tab+is+selected+when+clicking+the+X+%2B+closure+is+not+assumed+%28will+wait+for+user+to+stop+submitting+the+tab%29.+Otherwise+closure+is+assumed+when+pressing+the+X%2C+so+if+you+keep+submitting+the+tab+may+reappear+at+end+of+tab+bar.*/
  int UnsavedDocument = 1 << 20;
  int NoNav = NoNavInputs | NoNavFocus;
  int NoDecoration = NoTitleBar | NoResize | NoScrollbar | NoCollapse;
  int NoInputs = NoMouseInputs | NoNavInputs | NoNavFocus;
  /**%5BBETA%5D+On+child+window%3A+allow+gamepad%7Ckeyboard+navigation+to+cross+over+parent+border+to+this+child+or+between+sibling+child+windows.*/
  int NavFlattened = 1 << 23;
  /**Don%27t+use%21+For+internal+use+by+BeginChild%28%29*/
  int ChildWindow = 1 << 24;
  /**Don%27t+use%21+For+internal+use+by+BeginTooltip%28%29*/
  int Tooltip = 1 << 25;
  /**Don%27t+use%21+For+internal+use+by+BeginPopup%28%29*/
  int Popup = 1 << 26;
  /**Don%27t+use%21+For+internal+use+by+BeginPopupModal%28%29*/
  int Modal = 1 << 27;
  /**Don%27t+use%21+For+internal+use+by+BeginMenu%28%29*/
  int ChildMenu = 1 << 28;
  enum Type implements Flag {
    None(JImWindowFlags.None),
    NoTitleBar(JImWindowFlags.NoTitleBar),
    NoResize(JImWindowFlags.NoResize),
    NoMove(JImWindowFlags.NoMove),
    NoScrollbar(JImWindowFlags.NoScrollbar),
    NoScrollWithMouse(JImWindowFlags.NoScrollWithMouse),
    NoCollapse(JImWindowFlags.NoCollapse),
    AlwaysAutoResize(JImWindowFlags.AlwaysAutoResize),
    NoBackground(JImWindowFlags.NoBackground),
    NoSavedSettings(JImWindowFlags.NoSavedSettings),
    NoMouseInputs(JImWindowFlags.NoMouseInputs),
    MenuBar(JImWindowFlags.MenuBar),
    HorizontalScrollbar(JImWindowFlags.HorizontalScrollbar),
    NoFocusOnAppearing(JImWindowFlags.NoFocusOnAppearing),
    NoBringToFrontOnFocus(JImWindowFlags.NoBringToFrontOnFocus),
    AlwaysVerticalScrollbar(JImWindowFlags.AlwaysVerticalScrollbar),
    AlwaysHorizontalScrollbar(JImWindowFlags.AlwaysHorizontalScrollbar),
    AlwaysUseWindowPadding(JImWindowFlags.AlwaysUseWindowPadding),
    NoNavInputs(JImWindowFlags.NoNavInputs),
    NoNavFocus(JImWindowFlags.NoNavFocus),
    UnsavedDocument(JImWindowFlags.UnsavedDocument),
    NoNav(JImWindowFlags.NoNav),
    NoDecoration(JImWindowFlags.NoDecoration),
    NoInputs(JImWindowFlags.NoInputs),
    NavFlattened(JImWindowFlags.NavFlattened),
    ChildWindow(JImWindowFlags.ChildWindow),
    Tooltip(JImWindowFlags.Tooltip),
    Popup(JImWindowFlags.Popup),
    Modal(JImWindowFlags.Modal),
    ChildMenu(JImWindowFlags.ChildMenu),
    ;
    public final int flag;
    Type(int flag) { this.flag = flag; }
    @Override public int get() { return flag; }
  }
}
