/*
 * Decompiled with CFR 0.152.
 */
package org.ice1000.jimgui;

import org.ice1000.jimgui.cpp.DeallocatableObject;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NativeInt
extends Number
implements DeallocatableObject,
Cloneable {
    long nativeObjectPtr;

    @Contract
    public NativeInt() {
        this.nativeObjectPtr = NativeInt.allocateNativeObject();
    }

    @Contract(pure=true)
    public NativeInt(long nativeObjectPtr) {
        this.nativeObjectPtr = nativeObjectPtr;
    }

    @Override
    @Contract
    public void deallocateNativeObject() {
        NativeInt.deallocateNativeObject0(this.nativeObjectPtr);
        this.nativeObjectPtr = 0L;
    }

    @Contract(pure=true)
    public int accessValue() {
        return NativeInt.accessValue(this.nativeObjectPtr);
    }

    @Contract
    public void increaseValue(int increment) {
        NativeInt.increaseValue(this.nativeObjectPtr, increment);
    }

    @Contract
    public void modifyValue(int newValue) {
        NativeInt.modifyValue(this.nativeObjectPtr, newValue);
    }

    @Override
    @Contract(pure=true)
    public int intValue() {
        return this.accessValue();
    }

    @Override
    @Contract(pure=true)
    public long longValue() {
        return this.accessValue();
    }

    @Override
    @Contract(pure=true)
    public float floatValue() {
        return this.accessValue();
    }

    @Override
    @Contract(pure=true)
    public double doubleValue() {
        return this.accessValue();
    }

    private static native int accessValue(long var0);

    private static native void modifyValue(long var0, int var2);

    private static native void increaseValue(long var0, int var2);

    private static native long allocateNativeObject();

    private static native void deallocateNativeObject0(long var0);

    @Contract(value="null -> false", pure=true)
    public boolean equals(@Nullable Object o) {
        return this == o || o instanceof NativeInt && this.nativeObjectPtr == ((NativeInt)o).nativeObjectPtr;
    }

    @Contract(pure=true)
    public int hashCode() {
        return Long.hashCode(this.nativeObjectPtr);
    }

    @NotNull
    public String toString() {
        return String.valueOf(this.accessValue());
    }

    @Contract
    @NotNull
    public NativeInt clone() {
        NativeInt newInstance = new NativeInt();
        newInstance.modifyValue(this.accessValue());
        return newInstance;
    }
}

