package org.ice1000.jimgui.flag;

import org.ice1000.jimgui.*;
import org.ice1000.jimgui.flag.*;
import org.ice1000.jimgui.cpp.*;
import org.intellij.lang.annotations.*;
import org.jetbrains.annotations.*;
import java.nio.charset.StandardCharsets;

import static org.ice1000.jimgui.util.JImGuiUtil.*;

/**
 * @author ice1000
 * @since undecidable
 */
@SuppressWarnings("ALL")

public interface JImConfigFlags {
  int None = 0;
  /**Master+keyboard+navigation+enable+flag.+NewFrame%28%29+will+automatically+fill+io.NavInputs%5B%5D+based+on+io.KeysDown%5B%5D.*/
  int NavEnableKeyboard = 1 << 0;
  /**Master+gamepad+navigation+enable+flag.+This+is+mostly+to+instruct+your+imgui+backend+to+fill+io.NavInputs%5B%5D.+Backend+also+needs+to+set+ImGuiBackendFlags_HasGamepad.*/
  int NavEnableGamepad = 1 << 1;
  /**Instruct+navigation+to+move+the+mouse+cursor.+May+be+useful+on+TV%7Cconsole+systems+where+moving+a+virtual+mouse+is+awkward.+Will+update+io.MousePos+and+set+io.WantSetMousePos%3Dtrue.+If+enabled+you+MUST+honor+io.WantSetMousePos+requests+in+your+backend%2C+otherwise+ImGui+will+react+as+if+the+mouse+is+jumping+around+back+and+forth.*/
  int NavEnableSetMousePos = 1 << 2;
  /**Instruct+navigation+to+not+set+the+io.WantCaptureKeyboard+flag+when+io.NavActive+is+set.*/
  int NavNoCaptureKeyboard = 1 << 3;
  /**Instruct+imgui+to+clear+mouse+position%7Cbuttons+in+NewFrame%28%29.+This+allows+ignoring+the+mouse+information+set+by+the+backend.*/
  int NoMouse = 1 << 4;
  /**Instruct+backend+to+not+alter+mouse+cursor+shape+and+visibility.+Use+if+the+backend+cursor+changes+are+interfering+with+yours+and+you+don%27t+want+to+use+SetMouseCursor%28%29+to+change+mouse+cursor.+You+may+want+to+honor+requests+from+imgui+by+reading+GetMouseCursor%28%29+yourself+instead.*/
  int NoMouseCursorChange = 1 << 5;
  /**Application+is+SRGB-aware.*/
  int IsSRGB = 1 << 20;
  /**Application+is+using+a+touch+screen+instead+of+a+mouse.*/
  int IsTouchScreen = 1 << 21;
  enum Type implements Flag {
    None(JImConfigFlags.None),
    NavEnableKeyboard(JImConfigFlags.NavEnableKeyboard),
    NavEnableGamepad(JImConfigFlags.NavEnableGamepad),
    NavEnableSetMousePos(JImConfigFlags.NavEnableSetMousePos),
    NavNoCaptureKeyboard(JImConfigFlags.NavNoCaptureKeyboard),
    NoMouse(JImConfigFlags.NoMouse),
    NoMouseCursorChange(JImConfigFlags.NoMouseCursorChange),
    IsSRGB(JImConfigFlags.IsSRGB),
    IsTouchScreen(JImConfigFlags.IsTouchScreen),
    ;
    public final int flag;
    Type(int flag) { this.flag = flag; }
    @Override public int get() { return flag; }
  }
}
